/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.utils;

import at.tugraz.genome.lda.exception.LMException;
import at.tugraz.genome.lda.utils.LevenbergMarquardtOptimizer;
import at.tugraz.genome.util.FloatMatrix;

public class LMLogDecayThreeVariables
extends LevenbergMarquardtOptimizer {
    private float[][] values_;
    private float[][] observations_;

    public LMLogDecayThreeVariables(float[][] xValues, float[] observations, FloatMatrix parameters) {
        this.values_ = xValues;
        this.observations_ = new float[observations.length][1];
        for (int i = 0; i != observations.length; ++i) {
            this.observations_[i][0] = observations[i];
        }
        if (parameters != null) {
            this.resultParams_ = parameters;
        }
    }

    @Override
    protected FloatMatrix calculateEquationResults(float[][] values, FloatMatrix paramsVector) {
        float[][] results = new float[values.length][1];
        for (int i = 0; i != values.length; ++i) {
            float equationResult = paramsVector.A[0][0] * (float)Math.log(values[i][0] * paramsVector.A[1][0]);
            equationResult += (float)((double)paramsVector.A[2][0] * Math.exp(paramsVector.A[4][0] * values[i][0] - paramsVector.A[3][0] * values[i][1]));
            equationResult += paramsVector.A[5][0] * values[i][2];
            results[i][0] = equationResult += paramsVector.A[6][0];
        }
        return new FloatMatrix(results);
    }

    @Override
    protected FloatMatrix calculateJacobianMatrix(float[][] values, float[][] parameters) {
        float[][] jacobian = new float[values.length][7];
        for (int i = 0; i != values.length; ++i) {
            jacobian[i][0] = (float)Math.log(values[i][0] * parameters[1][0]);
            jacobian[i][1] = parameters[0][0] / parameters[1][0];
            jacobian[i][2] = (float)Math.exp(parameters[4][0] * values[i][0] * values[i][1] - parameters[3][0] * values[i][1]);
            jacobian[i][3] = -1.0f * parameters[2][0] * values[i][1] * (float)Math.exp(parameters[4][0] * values[i][0] - parameters[3][0] * values[i][1]);
            jacobian[i][4] = parameters[2][0] * values[i][0] * (float)Math.exp(parameters[4][0] * values[i][0] - parameters[3][0] * values[i][1]);
            jacobian[i][5] = values[i][2];
            jacobian[i][6] = 1.0f;
        }
        return new FloatMatrix(jacobian);
    }

    @Override
    protected float[][] getValues() {
        return this.values_;
    }

    @Override
    protected float[][] getObservations() {
        return this.observations_;
    }

    @Override
    public void fit() throws LMException {
        float[][] parameters = null;
        if (this.values_.length < 7) {
            throw new LMException("There are too less observations for a model fit!");
        }
        if (this.resultParams_ == null) {
            parameters = new float[7][1];
            parameters[0][0] = 0.5f;
            parameters[1][0] = 100.0f;
            parameters[2][0] = 10.0f;
            parameters[3][0] = 0.3f;
            parameters[4][0] = 0.001f;
            parameters[5][0] = -1.0f;
            parameters[6][0] = 1.0f;
        } else {
            parameters = this.resultParams_.A;
        }
        this.fit(parameters);
    }

    @Override
    public float calculateFitValue(float[] input) throws LMException {
        if (input.length != 3) {
            throw new LMException("The input must consist of two variables");
        }
        float[][] values = new float[1][3];
        values[0][0] = input[0];
        values[0][1] = input[1];
        values[0][2] = input[2];
        float result = this.calculateEquationResults((float[][])values, (FloatMatrix)this.resultParams_).A[0][0];
        return result;
    }

    @Override
    protected float getLambdaStartValue() {
        return 5.0f;
    }

    @Override
    protected float getLambdaMultiplierStartValue() {
        return 1.5f;
    }
}

