/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.verifier;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.swing.RuleDefinitionInterface;
import at.tugraz.genome.lda.swing.rdi.FragmentFormulaTextField;
import at.tugraz.genome.lda.swing.rdi.FragmentNameTextField;
import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class FragmentVerifier {
    private JTextField myTextField_;
    private RuleDefinitionInterface rdiObject_;
    private String fragRuleNameString_;
    private String fragRuleFormulaString_;
    private String fragRuleChargeString_;
    private String fragRuleMsLevelString_;
    private short mandatory_;
    int type_;
    int headOrChain_;
    int position_;
    public static int TYPE_NAME = 0;
    public static int TYPE_FORMULA = 1;
    public static int TYPE_CHARGE = 2;
    public static int TYPE_MSLEVEL = 3;

    public FragmentVerifier(RuleDefinitionInterface rdiObject, int type, int headOrChain) {
        this.type_ = type;
        this.createTextFieldVariable();
        this.rdiObject_ = rdiObject;
        this.headOrChain_ = headOrChain;
    }

    public void createTextFieldVariable() {
        this.myTextField_ = this.type_ == TYPE_NAME ? new FragmentNameTextField() : (this.type_ == TYPE_FORMULA ? new FragmentFormulaTextField() : new JTextField(20));
    }

    public JTextField getTextField() {
        return this.myTextField_;
    }

    public void checkFragment() {
        if (this.rdiObject_.errorMessageNeeded_) {
            this.rdiObject_.errorMessageNeeded_ = false;
            if (this.headOrChain_ == 1) {
                this.fragRuleNameString_ = this.rdiObject_.getHeadFragmentVector().elementAt(this.position_).getName();
                this.fragRuleFormulaString_ = this.rdiObject_.getHeadRuleFormulas()[this.position_].getText();
                this.fragRuleChargeString_ = this.rdiObject_.getHeadRuleCharges()[this.position_].getText();
                this.fragRuleMsLevelString_ = this.rdiObject_.getHeadRuleMSLevels()[this.position_].getText();
                short s = this.mandatory_ = this.rdiObject_.getHeadFragmentMandatories()[this.position_] ? (short)1 : 0;
            }
            if (this.headOrChain_ == 2) {
                this.fragRuleNameString_ = this.rdiObject_.getChainFragmentVector().elementAt(this.position_).getName();
                this.fragRuleFormulaString_ = this.rdiObject_.getChainRuleFormulas()[this.position_].getText();
                this.fragRuleChargeString_ = this.rdiObject_.getChainRuleCharges()[this.position_].getText();
                this.fragRuleMsLevelString_ = this.rdiObject_.getChainRuleMSLevels()[this.position_].getText();
                this.mandatory_ = this.rdiObject_.getChainFragmentMandatories()[this.position_] ? (short)1 : 0;
            }
            this.checkMsLevel(true);
            if (!this.fragRuleFormulaString_.equals("")) {
                try {
                    FragmentRuleVO ruleVO = null;
                    if (this.type_ == 1) {
                        ruleVO = this.rdiObject_.checkFragment(this.fragRuleNameString_, this.fragRuleFormulaString_, 0, 0, this.mandatory_, 1, this.headOrChain_);
                    }
                    if (!this.fragRuleChargeString_.equals("")) {
                        if (this.type_ == 2) {
                            ruleVO = this.rdiObject_.checkFragment(this.fragRuleNameString_, this.fragRuleFormulaString_, Integer.parseInt(this.fragRuleChargeString_), 0, this.mandatory_, 2, this.headOrChain_);
                        }
                        if (!this.fragRuleMsLevelString_.equals("") && this.type_ == 3) {
                            this.checkMsLevel(true);
                            ruleVO = this.rdiObject_.checkFragment(this.fragRuleNameString_, this.fragRuleFormulaString_, Integer.parseInt(this.fragRuleChargeString_), Integer.parseInt(this.fragRuleMsLevelString_), this.mandatory_, 3, this.headOrChain_);
                        }
                    }
                    if (ruleVO != null) {
                        this.rdiObject_.updateRuleVO(ruleVO, this.headOrChain_);
                    }
                }
                catch (RulesException e1) {
                    this.myTextField_.requestFocus();
                    JOptionPane.showMessageDialog(this.rdiObject_.topSplitPane_, e1.getMessage() + " The last accepted value remains in the textfile.");
                    this.myTextField_.setBackground(Color.PINK);
                }
                catch (NumberFormatException e2) {
                    this.myTextField_.setBackground(Color.PINK);
                    JOptionPane.showMessageDialog(this.rdiObject_.topSplitPane_, "Not a number! The last accepted value remains in the textfile.");
                    this.myTextField_.requestFocus();
                }
            } else {
                this.myTextField_.requestFocus();
                JOptionPane.showMessageDialog(this.rdiObject_.topSplitPane_, "An empty field cannot be saved! The last accepted value remains in the textfile.");
                this.myTextField_.setBackground(Color.PINK);
            }
        }
    }

    public void checkFragmentOnlySuccess() {
        block11: {
            if (!this.checkMsLevel(false)) {
                this.rdiObject_.errorMessageNeeded_ = true;
            } else {
                this.myTextField_.setBackground(Color.WHITE);
            }
            if (!this.fragRuleFormulaString_.equals("")) {
                try {
                    FragmentRuleVO ruleVO = null;
                    if (this.type_ == 1) {
                        ruleVO = this.rdiObject_.checkFragment(this.fragRuleNameString_, this.fragRuleFormulaString_, 0, 0, this.mandatory_, 1, this.headOrChain_);
                    }
                    if (this.fragRuleChargeString_.equals("")) break block11;
                    if (this.type_ == 2) {
                        ruleVO = this.rdiObject_.checkFragment(this.fragRuleNameString_, this.fragRuleFormulaString_, Integer.parseInt(this.fragRuleChargeString_), 0, this.mandatory_, 2, this.headOrChain_);
                    }
                    if (!this.fragRuleMsLevelString_.equals("") && this.type_ == 3) {
                        ruleVO = this.rdiObject_.checkFragment(this.fragRuleNameString_, this.fragRuleFormulaString_, Integer.parseInt(this.fragRuleChargeString_), Integer.parseInt(this.fragRuleMsLevelString_), this.mandatory_, 3, this.headOrChain_);
                    }
                    if (ruleVO != null) {
                        this.rdiObject_.updateRuleVO(ruleVO, this.headOrChain_);
                    }
                }
                catch (RulesException e1) {
                    this.rdiObject_.errorMessageNeeded_ = true;
                }
                catch (NumberFormatException e2) {
                    this.rdiObject_.errorMessageNeeded_ = true;
                }
            } else {
                this.rdiObject_.errorMessageNeeded_ = true;
            }
        }
    }

    public boolean checkMsLevel(boolean errormessage) {
        if (this.fragRuleMsLevelString_.equals("")) {
            if (errormessage) {
                this.myTextField_.requestFocus();
                JOptionPane.showMessageDialog(this.rdiObject_.topSplitPane_, "This ms level is not possible.");
                this.fragRuleMsLevelString_ = "2";
                this.myTextField_.setBackground(Color.PINK);
            }
            return false;
        }
        if (!this.fragRuleMsLevelString_.equals("2")) {
            if (errormessage) {
                this.myTextField_.requestFocus();
                JOptionPane.showMessageDialog(this.rdiObject_.topSplitPane_, "This ms level is not possible.");
                this.fragRuleMsLevelString_ = "2";
                this.myTextField_.setBackground(Color.PINK);
            }
            return false;
        }
        return true;
    }

    public void refreshFirstTime(int position) {
        this.position_ = position;
        if (this.headOrChain_ == 1) {
            this.fragRuleNameString_ = this.rdiObject_.getHeadFragmentVector().elementAt(position).getName();
            this.fragRuleFormulaString_ = this.rdiObject_.getHeadRuleFormulas()[position].getText();
            this.fragRuleChargeString_ = this.rdiObject_.getHeadRuleCharges()[position].getText();
            this.fragRuleMsLevelString_ = this.rdiObject_.getHeadRuleMSLevels()[position].getText();
            short s = this.mandatory_ = this.rdiObject_.getHeadFragmentMandatories()[position] ? (short)1 : 0;
        }
        if (this.headOrChain_ == 2) {
            this.fragRuleNameString_ = this.rdiObject_.getChainFragmentVector().elementAt(position).getName();
            this.fragRuleFormulaString_ = this.rdiObject_.getChainRuleFormulas()[position].getText();
            this.fragRuleChargeString_ = this.rdiObject_.getChainRuleCharges()[position].getText();
            this.fragRuleMsLevelString_ = this.rdiObject_.getChainRuleMSLevels()[position].getText();
            this.mandatory_ = this.rdiObject_.getChainFragmentMandatories()[position] ? (short)1 : 0;
        }
    }

    public void refresh(int position) {
        this.position_ = position;
        if (this.headOrChain_ == 1) {
            if (this.rdiObject_.getHeadFragmentVector().elementAt(position).getName() != null && this.rdiObject_.getHeadFragmentVector().elementAt(position).getName().length() > 0) {
                this.fragRuleNameString_ = this.rdiObject_.getHeadFragmentVector().elementAt(position).getName();
            }
            if (FragmentVerifier.checkFragmentFormulaInput(this.rdiObject_.getHeadRuleFormulas()[position])) {
                this.fragRuleFormulaString_ = this.rdiObject_.getHeadRuleFormulas()[position].getText();
            }
            if (this.rdiObject_.getHeadRuleCharges()[position].getText() != null && this.rdiObject_.getHeadRuleCharges()[position].getText().length() > 0) {
                this.fragRuleChargeString_ = this.rdiObject_.getHeadRuleCharges()[position].getText();
            }
            if (this.rdiObject_.getHeadRuleMSLevels()[position].getText() != null && this.rdiObject_.getHeadRuleMSLevels()[position].getText().length() > 0) {
                this.fragRuleMsLevelString_ = this.rdiObject_.getHeadRuleMSLevels()[position].getText();
            }
            short s = this.mandatory_ = this.rdiObject_.getHeadFragmentMandatories()[position] ? (short)1 : 0;
        }
        if (this.headOrChain_ == 2) {
            if (this.rdiObject_.getChainFragmentVector().elementAt(position).getName() != null && this.rdiObject_.getChainFragmentVector().elementAt(position).getName().length() > 0) {
                this.fragRuleNameString_ = this.rdiObject_.getChainFragmentVector().elementAt(position).getName();
            }
            if (FragmentVerifier.checkFragmentFormulaInput(this.rdiObject_.getChainRuleFormulas()[position])) {
                this.fragRuleFormulaString_ = this.rdiObject_.getChainRuleFormulas()[position].getText();
            }
            if (this.rdiObject_.getChainRuleCharges()[position].getText() != null && this.rdiObject_.getChainRuleCharges()[position].getText().length() > 0) {
                this.fragRuleChargeString_ = this.rdiObject_.getChainRuleCharges()[position].getText();
            }
            if (this.rdiObject_.getChainRuleMSLevels()[position].getText() != null && this.rdiObject_.getChainRuleMSLevels()[position].getText().length() > 0) {
                this.fragRuleMsLevelString_ = this.rdiObject_.getChainRuleMSLevels()[position].getText();
            }
            this.mandatory_ = this.rdiObject_.getChainFragmentMandatories()[position] ? (short)1 : 0;
        }
        this.checkFragmentOnlySuccess();
        if (this.checkMsLevel(false)) {
            this.rdiObject_.paintNewSpectra(false);
        }
    }

    public static boolean checkFragmentNameInput(JTextField field) {
        boolean ok = true;
        if (field == null || field.getText() == null || field.getText().length() == 0) {
            return false;
        }
        String text = field.getText().trim();
        if (text.indexOf(" ") != -1) {
            new WarningMessage(new JFrame(), "Error", "A rule name must not contain any empty spaces");
            text.replaceAll(" ", "");
            field.setText(text);
        }
        if (text.length() == 0) {
            return false;
        }
        if (text.indexOf("=") != -1) {
            new WarningMessage(new JFrame(), "Error", "A rule name must not contain any \"=\" signs");
            text.replaceAll("=", "");
            field.setText(text);
        }
        if (text.length() == 0) {
            return false;
        }
        return ok;
    }

    public static boolean checkFragmentFormulaInput(JTextField field) {
        boolean ok = true;
        if (field == null || field.getText() == null || field.getText().length() == 0) {
            return false;
        }
        String text = field.getText().trim();
        if (text.indexOf(" ") != -1) {
            new WarningMessage(new JFrame(), "Error", "A rule formula must not contain any empty spaces");
            return false;
        }
        if (text.length() == 0) {
            return false;
        }
        if (text.indexOf("=") != -1) {
            new WarningMessage(new JFrame(), "Error", "A rule formula must not contain any \"=\" signs");
            return false;
        }
        if (text.length() == 0) {
            return false;
        }
        return ok;
    }
}

