/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.verifier;

import at.tugraz.genome.lda.WarningMessage;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class IntegerVerifier
extends InputVerifier {
    private boolean mandatory_;

    public IntegerVerifier() {
        this(false);
    }

    public IntegerVerifier(boolean mandatory) {
        this.mandatory_ = mandatory;
    }

    @Override
    public boolean verify(JComponent input) {
        String text = ((JTextField)input).getText();
        if (text.contains(",")) {
            text = text.replaceAll(",", ".");
            ((JTextField)input).setText(text);
        }
        if (text != null && text.length() > 0) {
            try {
                int number = Integer.parseInt(text);
                return this.performOtherChecks(number);
            }
            catch (NumberFormatException nfx) {
                new WarningMessage(new JFrame(), "Error", "The entered value must be integer format");
                return false;
            }
        }
        if (this.mandatory_) {
            new WarningMessage(new JFrame(), "Error", "A value must be entered");
            return false;
        }
        return true;
    }

    protected boolean performOtherChecks(int number) {
        return true;
    }
}

