/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public class DoubleBondPositionVO
implements Comparable<DoubleBondPositionVO> {
    Vector<FattyAcidVO> chainCombination_;
    float expectedRetentionTime_;
    int accuracy_;
    String molecularSpecies_;
    boolean isAssigned_;

    public DoubleBondPositionVO(Vector<FattyAcidVO> chainCombination, float expectedRetentionTime) {
        this(chainCombination, expectedRetentionTime, 0, null);
    }

    public DoubleBondPositionVO(Vector<FattyAcidVO> chainCombination, float expectedRetentionTime, int accuracy, String molecularSpecies) {
        this(chainCombination, expectedRetentionTime, accuracy, molecularSpecies, false);
    }

    public DoubleBondPositionVO(Vector<FattyAcidVO> chainCombination, float expectedRetentionTime, int accuracy, String molecularSpecies, boolean isAssigned) {
        this.chainCombination_ = chainCombination;
        this.expectedRetentionTime_ = expectedRetentionTime;
        this.accuracy_ = accuracy;
        this.molecularSpecies_ = molecularSpecies;
        this.isAssigned_ = isAssigned;
    }

    public DoubleBondPositionVO(DoubleBondPositionVO that) {
        this(DoubleBondPositionVO.getDeepCopyOfChainCombination(that.getChainCombination()), that.getExpectedRetentionTime(), that.getAccuracy(), that.getMolecularSpecies(), that.getIsAssigned());
    }

    private static Vector<FattyAcidVO> getDeepCopyOfChainCombination(Vector<FattyAcidVO> chainCombination) {
        Vector<FattyAcidVO> newChainCombination = new Vector<FattyAcidVO>();
        for (FattyAcidVO fattyAcid : chainCombination) {
            newChainCombination.add(new FattyAcidVO(fattyAcid));
        }
        return newChainCombination;
    }

    @Override
    public int compareTo(DoubleBondPositionVO anotherVO) {
        int speciesComp;
        int defaultReturnValue = 0;
        int accuracyComp = -Integer.compare(this.getAccuracy(), anotherVO.getAccuracy());
        if (accuracyComp != 0) {
            return accuracyComp;
        }
        if (this.getMolecularSpecies() != null && anotherVO.getMolecularSpecies() != null && (speciesComp = this.getMolecularSpecies().compareTo(anotherVO.getMolecularSpecies())) != 0) {
            return speciesComp;
        }
        int timeComp = Float.compare(this.getExpectedRetentionTime(), anotherVO.getExpectedRetentionTime());
        if (timeComp != 0) {
            return timeComp;
        }
        Vector<Integer> pattern = this.getPositionAssignmentPattern();
        Vector<Integer> anotherPattern = anotherVO.getPositionAssignmentPattern();
        int numberAssigned = 0;
        int anotherNumberAssigned = 0;
        int sum = 0;
        int anotherSum = 0;
        for (int j = 0; j < pattern.size(); ++j) {
            if (pattern.get(j) == -1) {
                ++numberAssigned;
            } else {
                sum += pattern.get(j).intValue();
            }
            if (anotherPattern.get(j) == -1) {
                ++anotherNumberAssigned;
                continue;
            }
            anotherSum += anotherPattern.get(j).intValue();
        }
        if (numberAssigned != anotherNumberAssigned) {
            return Integer.compare(numberAssigned, anotherNumberAssigned);
        }
        if (numberAssigned != anotherNumberAssigned) {
            return Integer.compare(sum, anotherSum);
        }
        return defaultReturnValue;
    }

    public String getDoubleBondPositionsHumanReadable() {
        return this.getDoubleBondPositionsHumanReadable(2);
    }

    public String getDoubleBondPositionsHumanReadable(int snLevel) {
        boolean chainPositionsFixed = false;
        if (snLevel == 2) {
            chainPositionsFixed = this.areChainPositionsFixed();
        }
        String doubleBondPositionsHumanReadable = null;
        try {
            doubleBondPositionsHumanReadable = StaticUtils.getHumanReadableCombiName(this.getChainCombination(), Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), chainPositionsFixed);
        }
        catch (LipidCombinameEncodingException lcx) {
            lcx.printStackTrace();
        }
        return doubleBondPositionsHumanReadable;
    }

    public boolean areChainPositionsFixed() {
        String[] individualChains;
        if (this.molecularSpecies_ != null && this.molecularSpecies_.contains("/") && (individualChains = this.molecularSpecies_.split("/")).length > 1) {
            if (this.areDoubleBondPositionsAssignedForAllChains()) {
                return true;
            }
            HashSet<String> set = new HashSet<String>(Arrays.asList(individualChains));
            Object[] uniqueChains = set.toArray();
            if (individualChains.length == uniqueChains.length) {
                return true;
            }
        }
        return false;
    }

    public boolean areDoubleBondPositionsAssignedForAllChains() {
        for (FattyAcidVO fattyAcid : this.chainCombination_) {
            if (fattyAcid.getOmegaPosition() >= 0) continue;
            return false;
        }
        return true;
    }

    public Vector<Integer> getPositionAssignmentPattern() {
        Vector<Integer> pattern = new Vector<Integer>();
        for (FattyAcidVO fattyAcid : this.chainCombination_) {
            pattern.add(fattyAcid.getOmegaPosition());
        }
        return pattern;
    }

    public Vector<Boolean> getPermutationPattern() {
        Vector<Boolean> pattern = new Vector<Boolean>();
        for (int i = 0; i < this.chainCombination_.size(); ++i) {
            FattyAcidVO fattyAcid1 = this.chainCombination_.get(i);
            pattern.add(i, false);
            for (FattyAcidVO fattyAcid2 : this.chainCombination_) {
                if (fattyAcid1 == fattyAcid2 || fattyAcid1.getcAtoms() != fattyAcid2.getcAtoms() || fattyAcid1.getDoubleBonds() != fattyAcid2.getDoubleBonds() || fattyAcid1.getOhNumber() != fattyAcid2.getOhNumber()) continue;
                pattern.setElementAt(true, i);
            }
        }
        return pattern;
    }

    public String getEncoded() {
        return StaticUtils.encodeLipidCombi(this.chainCombination_);
    }

    public String getEncodedDetailed(boolean includePrefix, boolean includeOmegaPosition) {
        Vector<String> chainIds = new Vector<String>();
        for (FattyAcidVO chain : this.chainCombination_) {
            chainIds.add(chain.getChainIdDetailed(includePrefix, includeOmegaPosition));
        }
        return StaticUtils.encodeLipidCombiFromIds(chainIds);
    }

    public int getNumberOfCarbons() {
        int num = 0;
        for (FattyAcidVO fa : this.chainCombination_) {
            num += fa.getcAtoms();
        }
        return num;
    }

    public int getNumberOfDoubleBonds() {
        int num = 0;
        for (FattyAcidVO fa : this.chainCombination_) {
            num += fa.getDoubleBonds();
        }
        return num;
    }

    public int getNumberOfOH() {
        int num = 0;
        for (FattyAcidVO fa : this.chainCombination_) {
            num += fa.getOhNumber();
        }
        return num == 0 ? -1 : num;
    }

    public void setIsAssigned(boolean isAssigned) {
        this.isAssigned_ = isAssigned;
    }

    public boolean getIsAssigned() {
        return this.isAssigned_;
    }

    public void setMolecularSpecies(String molecularSpecies) {
        this.molecularSpecies_ = molecularSpecies;
    }

    public String getMolecularSpecies() {
        return this.molecularSpecies_;
    }

    public void setExpectedRetentionTime(float expectedRetentionTime) {
        this.expectedRetentionTime_ = expectedRetentionTime;
    }

    public float getExpectedRetentionTime() {
        return this.expectedRetentionTime_;
    }

    public void setChainCombination(Vector<FattyAcidVO> chainCombination) {
        this.chainCombination_ = chainCombination;
    }

    public Vector<FattyAcidVO> getChainCombination() {
        return this.chainCombination_;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy_ = accuracy;
    }

    public int getAccuracy() {
        return this.accuracy_;
    }
}

