/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.Hashtable;
import java.util.LinkedHashMap;

public class IsotopicLabelVO {
    protected String labelId_;
    protected Hashtable<String, Integer> labelElements_;
    protected Float rrtShift_;
    protected LinkedHashMap<String, Integer> prefixes_;
    protected int omegaPosition_;

    public IsotopicLabelVO(String labelId, Hashtable<String, Integer> labelElements, LinkedHashMap<String, Integer> prefixes) {
        this.labelId_ = labelId;
        this.labelElements_ = labelElements;
        this.prefixes_ = prefixes;
        this.rrtShift_ = null;
        this.omegaPosition_ = -1;
    }

    public IsotopicLabelVO(String labelId, int omegaPosition, Hashtable<String, Integer> labelElements, float rrtShift, LinkedHashMap<String, Integer> prefixes) {
        this(labelId, labelElements, prefixes);
        this.omegaPosition_ = omegaPosition;
        this.rrtShift_ = Float.valueOf(rrtShift);
    }

    public IsotopicLabelVO(IsotopicLabelVO vo) {
        this.labelId_ = vo.labelId_;
        this.labelElements_ = vo.labelElements_;
        this.prefixes_ = vo.prefixes_;
        this.rrtShift_ = vo.getRrtShift();
        this.omegaPosition_ = vo.omegaPosition_;
    }

    public String getLabelId() {
        return this.labelId_;
    }

    public void setLabelId(String labelId) {
        this.labelId_ = labelId;
    }

    public Hashtable<String, Integer> getLabelElements() {
        return this.labelElements_;
    }

    public void setLabelElements(Hashtable<String, Integer> labelElements) {
        this.labelElements_ = labelElements;
    }

    public Float getRrtShift() {
        return this.rrtShift_;
    }

    public void setRtShift(Float rrtShift) {
        this.rrtShift_ = rrtShift;
    }

    public int getOmegaPosition() {
        return this.omegaPosition_;
    }

    public void setOmegaPosition_(int omegaPosition) {
        this.omegaPosition_ = omegaPosition;
    }

    public LinkedHashMap<String, Integer> getPrefixes() {
        return this.prefixes_;
    }

    public boolean isEqual(IsotopicLabelVO other) {
        if (!this.labelId_.contentEquals(other.labelId_)) {
            return false;
        }
        if (this.labelElements_.size() != other.labelElements_.size()) {
            return false;
        }
        for (String element : this.labelElements_.keySet()) {
            if (!other.labelElements_.containsKey(element)) {
                return false;
            }
            if (this.labelElements_.get(element).intValue() == other.labelElements_.get(element).intValue()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.labelId_ + ": n-" + String.valueOf(this.omegaPosition_) + "; " + StaticUtils.getFormulaInHillNotation_PlusFirst(this.labelElements_, true) + "; RT: " + this.rrtShift_.toString() + "; " + this.prefixes_.keySet();
    }
}

