/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import java.util.Collections;
import java.util.Vector;

public class QuantVO
implements Comparable<QuantVO> {
    protected String analyteClass_;
    protected String prefixOrName_;
    protected int carbons_;
    protected int dbs_;
    protected int oh_;
    protected String analyteFormula_;
    protected double analyteMass_;
    protected int charge_;
    protected String modName_;
    protected String modFormula_;
    protected float retTime_;
    protected float isobaricRetTime_;
    protected float usedMinusTime_;
    protected float isobaricMinusTime_;
    protected float usedPlusTime_;
    protected float isobaricPlusTime_;
    protected Vector<Double> mustMatchProbabs_;
    protected Vector<Double> probabs_;
    protected int negStartValue_;
    protected Vector<QuantVO> isobaricSpecies_;
    protected boolean quantifiedByOtherIsobar_;
    private Vector<DoubleBondPositionVO> infoForOmegaAssignment_;
    protected String oxState_;

    public QuantVO(String analyteClass, String analyteName, int dbs, int ohNumber, String analyteFormula, double analyteMass, int charge, String modName, String modFormula, float retTime, float usedMinusTime, float usedPlusTime, Vector<Double> mustMatchProbabs, Vector<Double> probabs, int negativeStartValue, String oxState) throws HydroxylationEncodingException {
        this.analyteClass_ = analyteClass;
        this.dbs_ = dbs;
        Object[] prefixAndC = this.splitInCarbonNumberAndPrefix(this.analyteClass_, analyteName);
        this.prefixOrName_ = (String)prefixAndC[0];
        this.carbons_ = (Integer)prefixAndC[1];
        this.oh_ = ohNumber;
        if (this.oh_ > 0) {
            Settings.getLcbHydroxyEncoding().getEncodedPrefix((short)this.oh_);
        }
        this.analyteFormula_ = analyteFormula;
        this.analyteMass_ = analyteMass;
        this.charge_ = charge;
        this.modName_ = modName;
        this.modFormula_ = modFormula;
        this.isobaricRetTime_ = this.retTime_ = retTime;
        this.isobaricMinusTime_ = this.usedMinusTime_ = usedMinusTime;
        this.isobaricPlusTime_ = this.usedPlusTime_ = usedPlusTime;
        this.mustMatchProbabs_ = mustMatchProbabs;
        this.probabs_ = probabs;
        this.negStartValue_ = negativeStartValue;
        this.isobaricSpecies_ = new Vector();
        this.quantifiedByOtherIsobar_ = false;
        this.infoForOmegaAssignment_ = new Vector();
        this.oxState_ = oxState;
    }

    public boolean hasInfoForOmegaAssignment() {
        return !this.infoForOmegaAssignment_.isEmpty();
    }

    public Vector<DoubleBondPositionVO> getInfoForOmegaAssignment() {
        return this.infoForOmegaAssignment_;
    }

    public String getAnalyteClass() {
        return this.analyteClass_;
    }

    public String getAnalyteName() {
        try {
            return this.prefixOrName_ + (this.oh_ > 0 ? Settings.getLcbHydroxyEncoding().getEncodedPrefix((short)this.oh_) : "") + (this.carbons_ >= 0 ? String.valueOf(this.carbons_) : "");
        }
        catch (HydroxylationEncodingException hydroxylationEncodingException) {
            return null;
        }
    }

    public int getCarbons() {
        return this.carbons_;
    }

    public int getDbs() {
        return this.dbs_;
    }

    public int getOhNumber() {
        return this.oh_;
    }

    public String getOxState() {
        return this.oxState_;
    }

    public String getAnalyteFormula() {
        return this.analyteFormula_;
    }

    public double getAnalyteMass() {
        return this.analyteMass_;
    }

    public int getCharge() {
        return this.charge_;
    }

    public String getModName() {
        return this.modName_;
    }

    public String getModFormula() {
        return this.modFormula_;
    }

    public float getRetTime() {
        return this.retTime_;
    }

    public void setRetTime(float rt) {
        this.retTime_ = rt;
    }

    public float getUsedMinusTime() {
        return this.usedMinusTime_;
    }

    public float getUsedPlusTime() {
        return this.usedPlusTime_;
    }

    public Vector<Double> getMustMatchProbabs() {
        if (LipidomicsConstants.removeIfDistriDoesNotFit()) {
            return this.mustMatchProbabs_;
        }
        return new Vector<Double>();
    }

    public Vector<Double> getProbabs() {
        return this.probabs_;
    }

    public int getNegativeStartValue() {
        return this.negStartValue_;
    }

    public String getIdString() {
        return StaticUtils.generateLipidNameString(this.getAnalyteName(), (Integer)this.dbs_, -1, this.oxState_);
    }

    public void addInfoForOmegaAssignment(DoubleBondPositionVO labeledSpeciesVO) {
        this.infoForOmegaAssignment_.add(labeledSpeciesVO);
    }

    public void addIsobaricSpecies(QuantVO isobar) {
        boolean alreadyThere = false;
        for (QuantVO quant : this.isobaricSpecies_) {
            if (!isobar.equals(quant)) continue;
            alreadyThere = true;
            break;
        }
        if (!alreadyThere) {
            this.isobaricSpecies_.add(isobar);
            if (this.retTime_ > 0.0f) {
                float startTime = this.retTime_ - this.usedMinusTime_;
                float stopTime = this.retTime_ + this.usedPlusTime_;
                for (QuantVO vo : this.isobaricSpecies_) {
                    if (vo.retTime_ > 0.0f) {
                        if (vo.retTime_ - vo.usedMinusTime_ < startTime) {
                            startTime = vo.retTime_ - vo.usedMinusTime_;
                        }
                        if (!(vo.retTime_ + vo.usedPlusTime_ > stopTime)) continue;
                        stopTime = vo.retTime_ + vo.usedPlusTime_;
                        continue;
                    }
                    startTime = -1.0f;
                    stopTime = -1.0f;
                    break;
                }
                if (startTime > 0.0f && stopTime > 0.0f) {
                    this.isobaricRetTime_ = -1.0f;
                    this.isobaricPlusTime_ = -1.0f;
                    this.isobaricMinusTime_ = -1.0f;
                } else {
                    this.isobaricRetTime_ = (startTime + stopTime) / 2.0f;
                    this.isobaricMinusTime_ -= startTime;
                    this.isobaricPlusTime_ = this.isobaricRetTime_ - stopTime;
                }
            }
        }
        Collections.sort(this.isobaricSpecies_);
    }

    public boolean isQuantifiedByOtherIsobar() {
        return this.quantifiedByOtherIsobar_;
    }

    public void setQuantifiedByOtherIsobar(boolean quantifiedByOtherIsobar) {
        this.quantifiedByOtherIsobar_ = quantifiedByOtherIsobar;
    }

    public boolean hasOtherIsobars() {
        return this.isobaricSpecies_.size() > 0;
    }

    public Vector<QuantVO> getOtherIsobaricSpecies() {
        return this.isobaricSpecies_;
    }

    public void removeOtherIsobaricSpecies() {
        this.isobaricSpecies_.clear();
    }

    public float getIsobaricRetTime_() {
        return this.isobaricRetTime_;
    }

    public float getIsobaricMinusTime_() {
        return this.isobaricMinusTime_;
    }

    public float getIsobaricPlusTime_() {
        return this.isobaricPlusTime_;
    }

    protected Object[] splitInCarbonNumberAndPrefix(String analyteClass, String analyteName) {
        int splitChar;
        Object[] prefixAndC = new Object[2];
        int cs = -1;
        char[] chars = analyteName.toCharArray();
        for (splitChar = chars.length; splitChar > 0 && Character.isDigit(chars[splitChar - 1]); --splitChar) {
        }
        String prefix = analyteName.substring(0, splitChar);
        if (splitChar < chars.length) {
            cs = Integer.parseInt(analyteName.substring(splitChar));
        }
        prefixAndC[0] = prefix;
        prefixAndC[1] = cs;
        return prefixAndC;
    }

    @Override
    public int compareTo(QuantVO otherQuantVO) {
        int ret = (this.getAnalyteFormula() + this.getModFormula()).compareTo(otherQuantVO.getAnalyteFormula() + otherQuantVO.getModFormula());
        return ret;
    }
}

