/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.analysis.exception.CalculationNotPossibleException;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class ResultCompGroupVO
extends ResultCompVO {
    private Hashtable<String, ResultCompVO> oneGroup_;
    private Vector<Double> sumGroupMeans_;
    private Vector<Double> sumGroupSds_;
    private Vector<Double> sumTotalMeans_;
    private Vector<Double> sumTotalSds_;
    private Vector<Double> sumPercentualMeans_;
    private Vector<Double> sumPercentualSds_;

    public ResultCompGroupVO(Hashtable<String, ResultCompVO> oneGroup) {
        this.oneGroup_ = oneGroup;
        this.usedIsotpes_ = 0;
        this.dilutionFactor_ = 1.0;
        for (ResultCompVO compVO : this.oneGroup_.values()) {
            this.type_ = compVO.type_;
            if (this.usedIsotpes_ == 0) {
                this.usedIsotpes_ = compVO.getUsedIsotpes();
            }
            if (compVO.getUsedIsotpes() < this.usedIsotpes_) {
                this.usedIsotpes_ = compVO.getUsedIsotpes();
            }
            if (compVO.dilutionFactor_ == null) continue;
            this.dilutionFactor_ = compVO.dilutionFactor_;
        }
        this.sumGroupMeans_ = null;
        this.sumGroupSds_ = null;
        this.sumTotalMeans_ = null;
        this.sumTotalSds_ = null;
        this.sumPercentualMeans_ = null;
        this.sumPercentualSds_ = null;
    }

    @Override
    public double getOriginalArea(int maxIsotope) {
        return this.getMeanValue(this.extractOriginalAreas(maxIsotope));
    }

    public double getOriginalAreaSD(int maxIsotope) {
        return Calculator.stddeviation(this.extractOriginalAreas(maxIsotope));
    }

    public double getOriginalAreaSE(int maxIsotope) {
        return this.getSE(this.extractOriginalAreas(maxIsotope));
    }

    private double getSE(Vector<Double> values) {
        return Calculator.stddeviation(values) / Math.sqrt(values.size());
    }

    private Vector<Double> extractOriginalAreas(int maxIsotope) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getOriginalArea(maxIsotope);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getStandardizedArea(int maxIsotope, int standMethod, int esStandMethod, boolean dilutionFactor) {
        return this.getMeanValue(this.extractStandardizedAreas(maxIsotope, standMethod, esStandMethod, dilutionFactor));
    }

    public double getStandardizedAreaSD(int maxIsotope, int standMethod, int esStandMethod, boolean dilutionFactor) {
        return Calculator.stddeviation(this.extractStandardizedAreas(maxIsotope, standMethod, esStandMethod, dilutionFactor));
    }

    public double getStandardizedAreaSE(int maxIsotope, int standMethod, int esStandMethod, boolean dilutionFactor) {
        return this.getSE(this.extractStandardizedAreas(maxIsotope, standMethod, esStandMethod, dilutionFactor));
    }

    private Vector<Double> extractStandardizedAreas(int maxIsotope, int standMethod, int esStandMethod, boolean dilutionFactor) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getStandardizedArea(maxIsotope, standMethod, esStandMethod, dilutionFactor);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getRelativeValue(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        if (settingVO.getType().equalsIgnoreCase("relative to measured class amount") || settingVO.getType().equalsIgnoreCase("relative to total amount")) {
            return super.getRelativeValue(maxIsotope, settingVO);
        }
        return this.getMeanValue(this.extractRelativeValues(maxIsotope, settingVO));
    }

    public double getRelativeValueSD(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        return this.getAreaSD(maxIsotope, settingVO) / (Double)((ArrayList)this.relativeMedianAreas_.get("Sum composition")).get(maxIsotope);
    }

    public double getRelativeValueSE(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        Vector<Double> values = this.extractRelativeValues(maxIsotope, settingVO);
        double stdev = this.getRelativeValueSD(maxIsotope, settingVO);
        return stdev / Math.sqrt(values.size());
    }

    private Vector<Double> extractRelativeValues(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRelativeValue(maxIsotope, settingVO);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getAmountInEndVolume(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractAmountInEndVolumes(maxIsotope, standMethod));
    }

    public double getAmountInEndVolumeSD(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractAmountInEndVolumes(maxIsotope, standMethod));
    }

    public double getAmountInEndVolumeSE(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractAmountInEndVolumes(maxIsotope, standMethod));
    }

    private Vector<Double> extractAmountInEndVolumes(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getAmountInEndVolume(maxIsotope, standMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getConcentrationInEndVolume(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractConcentrationInEndVolumes(maxIsotope, standMethod));
    }

    public double getConcentrationInEndVolumeSD(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractConcentrationInEndVolumes(maxIsotope, standMethod));
    }

    public double getConcentrationInEndVolumeSE(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractConcentrationInEndVolumes(maxIsotope, standMethod));
    }

    private Vector<Double> extractConcentrationInEndVolumes(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getConcentrationInEndVolume(maxIsotope, standMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getWeightInEndVolume(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractWeightInEndVolumes(maxIsotope, standMethod));
    }

    public double getWeightInEndVolumeSD(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractWeightInEndVolumes(maxIsotope, standMethod));
    }

    public double getWeightInEndVolumeSE(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractWeightInEndVolumes(maxIsotope, standMethod));
    }

    private Vector<Double> extractWeightInEndVolumes(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getWeightInEndVolume(maxIsotope, standMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getAmountInProbeVolume(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractAmountInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    public double getAmountInProbeVolumeSD(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractAmountInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    public double getAmountInProbeVolumeSE(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractAmountInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    private Vector<Double> extractAmountInProbeVolumes(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getAmountInProbeVolume(maxIsotope, standMethod, esStandMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getConcentrationInProbeVolume(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractConcentrationInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    public double getConcentrationInProbeVolumeSD(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractConcentrationInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    public double getConcentrationInProbeVolumeSE(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractConcentrationInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    private Vector<Double> extractConcentrationInProbeVolumes(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getConcentrationInProbeVolume(maxIsotope, standMethod, esStandMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getWeightInProbeVolume(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractWeightInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    public double getWeightInProbeVolumeSD(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractWeightInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    public double getWeightInProbeVolumeSE(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractWeightInProbeVolumes(maxIsotope, standMethod, esStandMethod));
    }

    private Vector<Double> extractWeightInProbeVolumes(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getWeightInProbeVolume(maxIsotope, standMethod, esStandMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getAnalyteInRelationToProtein(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractAnalyteInRelationToProteins(maxIsotope, standMethod, esStandMethod, useAU));
    }

    public double getAnalyteInRelationToProteinSD(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractAnalyteInRelationToProteins(maxIsotope, standMethod, esStandMethod, useAU));
    }

    public double getAnalyteInRelationToProteinSE(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        return this.getSE(this.extractAnalyteInRelationToProteins(maxIsotope, standMethod, esStandMethod, useAU));
    }

    private Vector<Double> extractAnalyteInRelationToProteins(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getAnalyteInRelationToProtein(maxIsotope, standMethod, esStandMethod, useAU);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getAnalyteInRelationToSampleWeight(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractAnalyteInRelationToSampleWeights(maxIsotope, standMethod, esStandMethod));
    }

    public double getAnalyteInRelationToSampleWeightSD(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractAnalyteInRelationToSampleWeights(maxIsotope, standMethod, esStandMethod));
    }

    public double getAnalyteInRelationToSampleWeightSE(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractAnalyteInRelationToSampleWeights(maxIsotope, standMethod, esStandMethod));
    }

    private Vector<Double> extractAnalyteInRelationToSampleWeights(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getAnalyteInRelationToSampleWeight(maxIsotope, standMethod, esStandMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getAnalyteInRelationToNeutralLipidContent(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractAnalyteInRelationToNeutralLipidContents(maxIsotope, standMethod, esStandMethod, useAU));
    }

    public double getAnalyteInRelationToNeutralLipidContentSD(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractAnalyteInRelationToNeutralLipidContents(maxIsotope, standMethod, esStandMethod, useAU));
    }

    public double getAnalyteInRelationToNeutralLipidContentSE(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        return this.getSE(this.extractAnalyteInRelationToNeutralLipidContents(maxIsotope, standMethod, esStandMethod, useAU));
    }

    private Vector<Double> extractAnalyteInRelationToNeutralLipidContents(int maxIsotope, int standMethod, int esStandMethod, boolean useAU) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getAnalyteInRelationToNeutralLipidContent(maxIsotope, standMethod, esStandMethod, useAU);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getAnalyteInRelationToMeasuredNeutralLipidContent(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractAnalyteInRelationToMeasuredNeutralLipidContents(maxIsotope, standMethod, esStandMethod));
    }

    public double getAnalyteInRelationToMeasuredNeutralLipidContentSD(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractAnalyteInRelationToMeasuredNeutralLipidContents(maxIsotope, standMethod, esStandMethod));
    }

    public double getAnalyteInRelationToMeasuredNeutralLipidContentSE(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractAnalyteInRelationToMeasuredNeutralLipidContents(maxIsotope, standMethod, esStandMethod));
    }

    private Vector<Double> extractAnalyteInRelationToMeasuredNeutralLipidContents(int maxIsotope, int standMethod, int esStandMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getAnalyteInRelationToMeasuredNeutralLipidContent(maxIsotope, standMethod, esStandMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getRatioToHighestPeak(int maxIsotope) {
        return this.getMeanValue(this.extractRatioToHighestPeak(maxIsotope));
    }

    public double getRatioToHighestPeakSD(int maxIsotope) {
        return Calculator.stddeviation(this.extractRatioToHighestPeak(maxIsotope));
    }

    public double getRatioToHighestPeakSE(int maxIsotope) {
        return this.getSE(this.extractRatioToHighestPeak(maxIsotope));
    }

    private Vector<Double> extractRatioToHighestPeak(int maxIsotope) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRatioToHighestPeak(maxIsotope);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getRatioToTotalIntensity(int maxIsotope) {
        double analyteInt = this.getMeanValue(this.extractRatioToTotalIntensity(maxIsotope));
        return analyteInt / this.sumGroupMeans_.get(maxIsotope);
    }

    public double getRatioToTotalIntensitySD(int maxIsotope) {
        Vector<Double> values = this.extractRatioToTotalIntensity(maxIsotope);
        double analyteStdev = Calculator.stddeviation(values);
        return analyteStdev;
    }

    public double getRatioToTotalIntensitySE(int maxIsotope) {
        Vector<Double> values = this.extractRatioToTotalIntensity(maxIsotope);
        double stdev = this.getRatioToTotalIntensitySD(maxIsotope);
        return stdev / Math.sqrt(values.size());
    }

    @Override
    public double getRatioToOverallGroupsIntensity(int maxIsotope) {
        double analyteInt = this.getMeanValue(this.extractRatioToOverallGroupsIntensity(maxIsotope));
        return analyteInt / this.sumTotalMeans_.get(maxIsotope);
    }

    public double getRatioToOverallGroupsIntensitySD(int maxIsotope) {
        Vector<Double> values = this.extractRatioToOverallGroupsIntensity(maxIsotope);
        double analyteStdev = Calculator.stddeviation(values);
        return analyteStdev;
    }

    public double getRatioToOverallGroupsIntensitySE(int maxIsotope) {
        Vector<Double> values = this.extractRatioToOverallGroupsIntensity(maxIsotope);
        double stdev = this.getRatioToOverallGroupsIntensitySD(maxIsotope);
        return stdev / Math.sqrt(values.size());
    }

    public double getMeanOfRatioToTotalIntensity(int maxIsotope) {
        return this.getMeanValue(this.extractRatioToTotalIntensity(maxIsotope));
    }

    public double getSDOfRatioToTotalIntensity(int maxIsotope) {
        return Calculator.stddeviation(this.extractRatioToTotalIntensity(maxIsotope));
    }

    private Vector<Double> extractRatioToTotalIntensity(int maxIsotope) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRatioToTotalIntensity(maxIsotope);
            if (this.type_ == 3) {
                value = groupVO.getOriginalArea(maxIsotope);
            }
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public double getRelativeToMeasuredNeutralLipidContent(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        return this.getMeanValue(this.extractRelativeToMeasuredNeutralLipidContent(maxIsotope, standMethod, esMethod));
    }

    public double getRelativeToMeasuredNeutralLipidContentSD(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        return Calculator.stddeviation(this.extractRelativeToMeasuredNeutralLipidContent(maxIsotope, standMethod, esMethod));
    }

    public double getRelativeToMeasuredNeutralLipidContentSE(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        return this.getSE(this.extractRelativeToMeasuredNeutralLipidContent(maxIsotope, standMethod, esMethod));
    }

    private Vector<Double> extractRelativeToMeasuredNeutralLipidContent(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRelativeToMeasuredNeutralLipidContent(maxIsotope, standMethod, esMethod);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    public double getAreaSD(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        double area = 0.0;
        if (settingVO.isPercent()) {
            area = this.getRatioToPercentualValueSD(maxIsotope, settingVO);
        } else if (settingVO.getType().equalsIgnoreCase("relative value")) {
            area = this.getStandardizedAreaSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.considerDilution());
        } else if (settingVO.getType().equalsIgnoreCase("relative to base peak")) {
            area = this.getRatioToHighestPeakSD(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to measured class amount")) {
            area = this.getRatioToTotalIntensitySD(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to highest total peak")) {
            area = this.getRatioToHighestFoundPeakSD(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to total amount")) {
            area = this.getRatioToOverallGroupsIntensitySD(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("amount end-volume")) {
            area = this.getAmountInEndVolumeSD(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("conc. end-volume")) {
            area = this.getConcentrationInEndVolumeSD(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("weight end-volume")) {
            area = this.getWeightInEndVolumeSD(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("amount sample-volume")) {
            area = this.getAmountInProbeVolumeSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("conc. sample-volume")) {
            area = this.getConcentrationInProbeVolumeSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("weight sample-volume")) {
            area = this.getWeightInProbeVolumeSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("relative to sample weight")) {
            area = this.getAnalyteInRelationToSampleWeightSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("relation to protein content")) {
            area = this.getAnalyteInRelationToProteinSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.isAu());
        } else if (settingVO.getType().equalsIgnoreCase("relation to neutral lipid content")) {
            area = this.getAnalyteInRelationToNeutralLipidContentSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.isAu());
        } else if (settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
            area = this.getAnalyteInRelationToMeasuredNeutralLipidContentSD(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("percentual value")) {
            area = this.getRatioToPercentualValueSD(maxIsotope, settingVO);
        }
        if (area > 0.0 && !Double.isInfinite(area) && !Double.isNaN(area)) {
            if (settingVO.getType().equalsIgnoreCase("conc. end-volume") || settingVO.getType().equalsIgnoreCase("conc. sample-volume") || settingVO.getType().equalsIgnoreCase("relative to sample weight") || settingVO.getType().equalsIgnoreCase("relation to protein content") || settingVO.getType().equalsIgnoreCase("relation to neutral lipid content") || settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
                area = StaticUtils.getValueDividedByUnit(area, settingVO.getDivisorMagnitude());
            }
            return area;
        }
        return area;
    }

    public double getAreaSE(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        double area = 0.0;
        if (settingVO.isPercent()) {
            area = this.getRatioToPercentualValueSE(maxIsotope, settingVO);
        } else if (settingVO.getType().equalsIgnoreCase("relative value")) {
            area = this.getStandardizedAreaSE(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.considerDilution());
        } else if (settingVO.getType().equalsIgnoreCase("relative to base peak")) {
            area = this.getRatioToHighestPeakSE(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to measured class amount")) {
            area = this.getRatioToTotalIntensitySE(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to highest total peak")) {
            area = this.getRatioToHighestFoundPeakSE(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to total amount")) {
            area = this.getRatioToOverallGroupsIntensitySE(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("amount end-volume")) {
            area = this.getAmountInEndVolumeSE(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("conc. end-volume")) {
            area = this.getConcentrationInEndVolumeSE(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("amount sample-volume")) {
            area = this.getAmountInProbeVolumeSE(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("conc. sample-volume")) {
            area = this.getConcentrationInProbeVolumeSE(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("relative to sample weight")) {
            area = this.getAnalyteInRelationToSampleWeightSE(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("relation to protein content")) {
            area = this.getAnalyteInRelationToProteinSE(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.isAu());
        } else if (settingVO.getType().equalsIgnoreCase("relation to neutral lipid content")) {
            area = this.getAnalyteInRelationToNeutralLipidContentSE(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.isAu());
        } else if (settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
            area = this.getAnalyteInRelationToMeasuredNeutralLipidContentSE(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("percentual value")) {
            area = this.getRatioToPercentualValueSE(maxIsotope, settingVO);
        }
        if (area > 0.0 && !Double.isInfinite(area) && !Double.isNaN(area)) {
            if (settingVO.getType().equalsIgnoreCase("conc. end-volume") || settingVO.getType().equalsIgnoreCase("conc. sample-volume") || settingVO.getType().equalsIgnoreCase("relative to sample weight") || settingVO.getType().equalsIgnoreCase("relation to protein content") || settingVO.getType().equalsIgnoreCase("relation to neutral lipid content") || settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
                area = StaticUtils.getValueDividedByUnit(area, settingVO.getDivisorMagnitude());
            }
            return area;
        }
        return area;
    }

    @Override
    public double getRelativeToMedian(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        return this.getMeanValue(this.extractRelativeToMedian(maxIsotope, settingVO));
    }

    public double getRelativeToMedianSD(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        return Calculator.stddeviation(this.extractRelativeToMedian(maxIsotope, settingVO));
    }

    public double getRelativeToMedianSE(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        return this.getSE(this.extractRelativeToMedian(maxIsotope, settingVO));
    }

    private Vector<Double> extractRelativeToMedian(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRelativeToMedian(maxIsotope, settingVO);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public void addRelativeMedianArea(ArrayList<Double> relativeMedianArea) {
        super.addRelativeMedianArea(relativeMedianArea);
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            groupVO.addRelativeMedianArea(relativeMedianArea);
        }
    }

    @Override
    public double getRetentionTime(String modName) {
        Vector<Double> values = this.extractRetentionTimes(modName);
        if (values.size() > 0) {
            return this.getMeanValue(this.extractRetentionTimes(modName));
        }
        return -1.0;
    }

    public double getRetentionTimeSD(String modName) {
        Vector<Double> values = this.extractRetentionTimes(modName);
        if (values.size() > 0) {
            return Calculator.stddeviation(this.extractRetentionTimes(modName));
        }
        return -1.0;
    }

    private Vector<Double> extractRetentionTimes(String modName) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRetentionTime(modName);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    private double getMeanValue(Vector<Double> areas) {
        double mean = Calculator.mean(areas);
        if (!Double.isNaN(mean) && !Double.isInfinite(mean)) {
            return mean;
        }
        return 0.0;
    }

    @Override
    public boolean getMoreThanOnePeak(int maxIsotope) {
        return false;
    }

    @Override
    public double getRatioToHighestFoundPeak(int maxIsotope) {
        return this.getMeanValue(this.extractRatioToHighestFoundPeak(maxIsotope));
    }

    public double getRatioToHighestFoundPeakSD(int maxIsotope) {
        return Calculator.stddeviation(this.extractRatioToHighestFoundPeak(maxIsotope));
    }

    public double getRatioToHighestFoundPeakSE(int maxIsotope) {
        return this.getSE(this.extractRatioToHighestFoundPeak(maxIsotope));
    }

    private Vector<Double> extractRatioToHighestFoundPeak(int maxIsotope) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRatioToHighestFoundPeak(maxIsotope);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    public double getMeanRatioToOverallGroupsIntensity(int maxIsotope) {
        return this.getMeanValue(this.extractRatioToOverallGroupsIntensity(maxIsotope));
    }

    public double getSDRatioToOverallGroupsIntensity(int maxIsotope) {
        return Calculator.stddeviation(this.extractRatioToOverallGroupsIntensity(maxIsotope));
    }

    private Vector<Double> extractRatioToOverallGroupsIntensity(int maxIsotope) {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRatioToOverallGroupsIntensity(maxIsotope);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    public Hashtable<String, ResultCompVO> getGroupingPartners() {
        return this.oneGroup_;
    }

    public void setSumGroupMeans(Vector<Double> sumGroupMeans) {
        this.sumGroupMeans_ = sumGroupMeans;
    }

    public void setSumGroupSds(Vector<Double> sumGroupSds) {
        this.sumGroupSds_ = sumGroupSds;
    }

    public void setSumTotalMeans(Vector<Double> sumTotalMeans) {
        this.sumTotalMeans_ = sumTotalMeans;
    }

    public void setSumTotalSds(Vector<Double> sumTotalSds) {
        this.sumTotalSds_ = sumTotalSds;
    }

    @Override
    public double getRatioToPercentualValue(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        double analyteInt = this.getMeanValue(this.extractRatioToPercentualValue(maxIsotope, settingVO));
        return analyteInt;
    }

    public double getRatioToPercentualValueSD(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        Vector<Double> values = this.extractRatioToPercentualValue(maxIsotope, settingVO);
        double analyteStdev = Calculator.stddeviation(values);
        return analyteStdev;
    }

    public double getRatioToPercentualValueSE(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        Vector<Double> values = this.extractRatioToPercentualValue(maxIsotope, settingVO);
        double stdev = this.getRatioToPercentualValueSD(maxIsotope, settingVO);
        return stdev / Math.sqrt(values.size());
    }

    private Vector<Double> extractRatioToPercentualValue(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        Vector<Double> values = new Vector<Double>();
        for (ResultCompVO groupVO : this.oneGroup_.values()) {
            double value = groupVO.getRatioToPercentualValue(maxIsotope, settingVO);
            if (!(value > 0.0)) continue;
            values.add(value);
        }
        return values;
    }

    public void setSumPercentualMeans(Vector<Double> sumGroupMeans) {
        this.sumPercentualMeans_ = sumGroupMeans;
    }

    public void setSumPercentualSds(Vector<Double> sumPercentualSds) {
        this.sumPercentualSds_ = sumPercentualSds;
    }

    @Override
    public boolean hasAllModsFound() {
        return true;
    }
}

