/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.analysis.exception.CalculationNotPossibleException;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import at.tugraz.genome.lda.vos.VolumeConcVO;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class ResultCompVO {
    public static final int NO_STANDARD_CORRECTION = 0;
    public static final int STANDARD_CORRECTION_INTERNAL = 1;
    public static final int STANDARD_CORRECTION_MEDIAN = 2;
    public static final int ANALYTE_TYPE = 0;
    public static final int INTERNAL_STANDARD_TYPE = 1;
    public static final int EXTERNAL_STANDARD_TYPE = 2;
    public static final int CLASS_TYPE = 3;
    private ResultAreaVO resultMolecule_;
    protected int type_;
    protected Vector<Double> mass_;
    protected Hashtable<String, Double> retentionTime_;
    protected boolean allModsFound_;
    private Vector<Double> originalArea_;
    private Vector<Double> correctionFactorInternalIS_;
    private Vector<Double> correctionFactorMedianIS_;
    private Hashtable<Integer, Vector<Double>> correctionFactorSingleIS_;
    protected Hashtable<String, ArrayList<Double>> relativeMedianAreas_ = new Hashtable();
    public static final String SUM_COMPOSITION = "Sum composition";
    private Vector<Double> areaISInternalComparison_;
    private Vector<Double> areaISMedianComparison_;
    private Hashtable<Integer, Vector<Double>> areaISSingleComparison_;
    protected Double dilutionFactor_;
    protected Vector<Double> correctionFactorESNoISCorrInternal_;
    protected Vector<Double> correctionFactorESNoISCorrMedian_;
    private Hashtable<Integer, Vector<Double>> correctionFactorESNoISCorrSingle_;
    protected Vector<Double> correctionFactorESISInternalCorrInternal_;
    protected Vector<Double> correctionFactorESISInternalCorrMedian_;
    private Hashtable<Integer, Vector<Double>> correctionFactorESISInternalCorrSingle_;
    protected Vector<Double> correctionFactorESISMedianCorrInternal_;
    protected Vector<Double> correctionFactorESISMedianCorrMedian_;
    private Hashtable<Integer, Vector<Double>> correctionFactorESISMedianCorrSingle_;
    private Hashtable<Integer, Vector<Double>> correctionFactorESISSingleCorrInternal_;
    private Hashtable<Integer, Vector<Double>> correctionFactorInternalESISSingleCorrMedian_;
    private Hashtable<Integer, Hashtable<Integer, Vector<Double>>> correctionFactorESISSingleCorrSingle_;
    protected Vector<Double> areaESNoISCorrInternalComparison_;
    protected Vector<Double> areaESNoISCorrMedianComparison_;
    private Hashtable<Integer, Vector<Double>> areaESNoISCorrSingleComparison_;
    protected Vector<Double> areaESISInternalCorrInternalComparison_;
    protected Vector<Double> areaESISInternalCorrMedianComparison_;
    private Hashtable<Integer, Vector<Double>> areaESISInternalCorrSingleComparison_;
    protected Vector<Double> areaESISMedianCorrInternalComparison_;
    protected Vector<Double> areaESISMedianCorrMedianComparison_;
    private Hashtable<Integer, Vector<Double>> areaESISMedianCorrSingleComparison_;
    private Hashtable<Integer, Vector<Double>> areaESISSingleCorrInternalComparison_;
    private Hashtable<Integer, Vector<Double>> areaESISSingleCorrMedianComparison_;
    private Hashtable<Integer, Hashtable<Integer, Vector<Double>>> areaESISSingleCorrSingleComparison_;
    protected Double relativeValue_;
    protected int usedIsotpes_;
    protected String absoluteFilePath_;
    protected Hashtable<Integer, VolumeConcVO> isAmounts_;
    protected Hashtable<Integer, VolumeConcVO> esAmounts_;
    protected Double esStandardVolumeInternalCorr_;
    protected Double esStandardConcentrationInternalCorr_;
    protected Double esStandardVolumeMedianCorr_;
    protected Double esStandardConcentrationMedianCorr_;
    protected Hashtable<Integer, Double> esStandardVolumeSingleCorr_;
    protected Hashtable<Integer, Double> esStandardConcentrationSingleCorr_;
    protected Double endVolume_;
    protected Double probeVolume_;
    protected Double sampleWeight_;
    protected Double proteinConcentration_;
    protected Double neutralLipidConcentration_;
    protected Vector<Double> measuredNeutralLipidConcentration_;
    protected Vector<Double> highestGroupIntensity_;
    protected Vector<Double> totalGroupIntensity_;
    protected Vector<Double> totalGroupMass_;
    protected Vector<Double> highestFoundIntensity_;
    protected Vector<Double> totalFoundIntensity_;
    protected Vector<Double> sumValueForPercentage_;
    protected Vector<Hashtable<String, Boolean>> moreThanOnePeak_ = new Vector();
    protected boolean hasAbs_;
    protected boolean existsInFile_;
    protected boolean isNullInFile_;

    public ResultCompVO(int type, int usedIsotopes, Vector<Double> originalArea) {
        this.setConstructorValues(true, false, type, usedIsotopes, originalArea);
    }

    public ResultCompVO(ResultAreaVO resultMolecule, boolean existsInFile, boolean isNullInFile, int type, Vector<Double> mass, Hashtable<String, Double> retentionTime, String absoluteFilePath, int usedIsotopes, boolean allModsFound, Vector<Double> originalArea, Vector<Double> correctionFactorInternalIS, Vector<Double> correctionFactorMedianIS, Hashtable<Integer, Vector<Double>> correctionFactorSingleIS, Vector<Double> areaISInternalComparision, Vector<Double> areaISMedianComparison, Hashtable<Integer, Vector<Double>> areaISSingleComparison, Vector<Double> correctionFactorESNoISCorrInternal, Vector<Double> correctionFactorESNoISCorrMedian, Hashtable<Integer, Vector<Double>> correctionFactorESNoISCorrSingle, Vector<Double> correctionFactorESISInternalCorrInternal, Vector<Double> correctionFactorESISInternalCorrMedian, Hashtable<Integer, Vector<Double>> correctionFactorESISInternalCorrSingle, Vector<Double> correctionFactorESISMedianCorrInternal, Vector<Double> correctionFactorESISMedianCorrMedian, Hashtable<Integer, Vector<Double>> correctionFactorESISMedianCorrSingle, Hashtable<Integer, Vector<Double>> correctionFactorESISSingleCorrInternal, Hashtable<Integer, Vector<Double>> correctionFactorInternalESISSingleCorrMedian, Hashtable<Integer, Hashtable<Integer, Vector<Double>>> correctionFactorESISSingleCorrSingle, Vector<Double> areaESNoISCorrInternalComparison, Vector<Double> areaESNoISCorrMedianComparison, Hashtable<Integer, Vector<Double>> areaESNoISCorrSingleComparison, Vector<Double> areaESISInternalCorrInternalComparison, Vector<Double> areaESISInternalCorrMedianComparison, Hashtable<Integer, Vector<Double>> areaESISInternalCorrSingleComparison, Vector<Double> areaESISMedianCorrInternalComparison, Vector<Double> areaESISMedianCorrMedianComparison, Hashtable<Integer, Vector<Double>> areaESISMedianCorrSingleComparison, Hashtable<Integer, Vector<Double>> areaESISSingleCorrInternalComparison, Hashtable<Integer, Vector<Double>> areaESISSingleCorrMedianComparison, Hashtable<Integer, Hashtable<Integer, Vector<Double>>> areaESISSingleCorrSingleComparison, Hashtable<Integer, VolumeConcVO> isAmount, Double dilutionFactor, Hashtable<Integer, VolumeConcVO> esAmount, Double esStandardVolumeInternalCorr, Double esStandardConcentrationInternalCorr, Double esStandardVolumeMedianCorr, Double esStandardConcentrationMedianCorr, Hashtable<Integer, Double> esStandardVolumeSingleCorr, Hashtable<Integer, Double> esStandardConcentrationSingleCorr, Double endVolume, Double probeVolume, Double sampleWeight, Double proteinConcentration, Double neutralLipidConcentration, Vector<Hashtable<String, Boolean>> moreThanOnePeak, boolean hasAbs) {
        this.setConstructorValues(resultMolecule, existsInFile, isNullInFile, type, mass, retentionTime, absoluteFilePath, usedIsotopes, allModsFound, originalArea, correctionFactorInternalIS, correctionFactorMedianIS, correctionFactorSingleIS, areaISInternalComparision, areaISMedianComparison, areaISSingleComparison, correctionFactorESNoISCorrInternal, correctionFactorESNoISCorrMedian, correctionFactorESNoISCorrSingle, correctionFactorESISInternalCorrInternal, correctionFactorESISInternalCorrMedian, correctionFactorESISInternalCorrSingle, correctionFactorESISMedianCorrInternal, correctionFactorESISMedianCorrMedian, correctionFactorESISMedianCorrSingle, correctionFactorESISSingleCorrInternal, correctionFactorInternalESISSingleCorrMedian, correctionFactorESISSingleCorrSingle, areaESNoISCorrInternalComparison, areaESNoISCorrMedianComparison, areaESNoISCorrSingleComparison, areaESISInternalCorrInternalComparison, areaESISInternalCorrMedianComparison, areaESISInternalCorrSingleComparison, areaESISMedianCorrInternalComparison, areaESISMedianCorrMedianComparison, areaESISMedianCorrSingleComparison, areaESISSingleCorrInternalComparison, areaESISSingleCorrMedianComparison, areaESISSingleCorrSingleComparison, isAmount, dilutionFactor, esAmount, esStandardVolumeInternalCorr, esStandardConcentrationInternalCorr, esStandardVolumeMedianCorr, esStandardConcentrationMedianCorr, esStandardVolumeSingleCorr, esStandardConcentrationSingleCorr, endVolume, probeVolume, sampleWeight, proteinConcentration, neutralLipidConcentration, moreThanOnePeak, hasAbs);
    }

    protected void setConstructorValues(boolean existsInFile, boolean isNullInFile, int type, int usedIsotopes, Vector<Double> originalArea) {
        this.existsInFile_ = existsInFile;
        this.isNullInFile_ = isNullInFile;
        this.type_ = type;
        this.usedIsotpes_ = usedIsotopes;
        this.originalArea_ = originalArea;
    }

    protected void setConstructorValues(ResultAreaVO resultMolecule, boolean existsInFile, boolean isNullInFile, int type, Vector<Double> mass, Hashtable<String, Double> retentionTime, String absoluteFilePath, int usedIsotopes, boolean allModsFound, Vector<Double> originalArea, Vector<Double> correctionFactorInternalIS, Vector<Double> correctionFactorMedianIS, Hashtable<Integer, Vector<Double>> correctionFactorSingleIS, Vector<Double> areaISInternalComparision, Vector<Double> areaISMedianComparison, Hashtable<Integer, Vector<Double>> areaISSingleComparison, Vector<Double> correctionFactorESNoISCorrInternal, Vector<Double> correctionFactorESNoISCorrMedian, Hashtable<Integer, Vector<Double>> correctionFactorESNoISCorrSingle, Vector<Double> correctionFactorESISInternalCorrInternal, Vector<Double> correctionFactorESISInternalCorrMedian, Hashtable<Integer, Vector<Double>> correctionFactorESISInternalCorrSingle, Vector<Double> correctionFactorESISMedianCorrInternal, Vector<Double> correctionFactorESISMedianCorrMedian, Hashtable<Integer, Vector<Double>> correctionFactorESISMedianCorrSingle, Hashtable<Integer, Vector<Double>> correctionFactorESISSingleCorrInternal, Hashtable<Integer, Vector<Double>> correctionFactorInternalESISSingleCorrMedian, Hashtable<Integer, Hashtable<Integer, Vector<Double>>> correctionFactorESISSingleCorrSingle, Vector<Double> areaESNoISCorrInternalComparison, Vector<Double> areaESNoISCorrMedianComparison, Hashtable<Integer, Vector<Double>> areaESNoISCorrSingleComparison, Vector<Double> areaESISInternalCorrInternalComparison, Vector<Double> areaESISInternalCorrMedianComparison, Hashtable<Integer, Vector<Double>> areaESISInternalCorrSingleComparison, Vector<Double> areaESISMedianCorrInternalComparison, Vector<Double> areaESISMedianCorrMedianComparison, Hashtable<Integer, Vector<Double>> areaESISMedianCorrSingleComparison, Hashtable<Integer, Vector<Double>> areaESISSingleCorrInternalComparison, Hashtable<Integer, Vector<Double>> areaESISSingleCorrMedianComparison, Hashtable<Integer, Hashtable<Integer, Vector<Double>>> areaESISSingleCorrSingleComparison, Hashtable<Integer, VolumeConcVO> isAmount, Double dilutionFactor, Hashtable<Integer, VolumeConcVO> esAmount, Double esStandardVolumeInternalCorr, Double esStandardConcentrationInternalCorr, Double esStandardVolumeMedianCorr, Double esStandardConcentrationMedianCorr, Hashtable<Integer, Double> esStandardVolumeSingleCorr, Hashtable<Integer, Double> esStandardConcentrationSingleCorr, Double endVolume, Double probeVolume, Double sampleWeight, Double proteinConcentration, Double neutralLipidConcentration, Vector<Hashtable<String, Boolean>> moreThanOnePeak, boolean hasAbs) {
        this.setConstructorValues(existsInFile, isNullInFile, type, usedIsotopes, originalArea);
        this.resultMolecule_ = resultMolecule;
        this.mass_ = mass;
        if (this.mass_ == null) {
            this.mass_ = new Vector();
            for (int i = 0; i != this.usedIsotpes_; ++i) {
                this.mass_.add(0.0);
            }
        }
        this.retentionTime_ = retentionTime;
        this.allModsFound_ = allModsFound;
        this.absoluteFilePath_ = absoluteFilePath;
        this.correctionFactorInternalIS_ = correctionFactorInternalIS;
        this.correctionFactorMedianIS_ = correctionFactorMedianIS;
        this.correctionFactorSingleIS_ = correctionFactorSingleIS;
        this.areaISInternalComparison_ = areaISInternalComparision;
        this.areaISMedianComparison_ = areaISMedianComparison;
        this.areaISSingleComparison_ = areaISSingleComparison;
        this.highestGroupIntensity_ = null;
        this.totalGroupIntensity_ = null;
        this.totalGroupMass_ = null;
        this.correctionFactorESNoISCorrInternal_ = correctionFactorESNoISCorrInternal;
        this.correctionFactorESNoISCorrMedian_ = correctionFactorESNoISCorrMedian;
        this.correctionFactorESNoISCorrSingle_ = correctionFactorESNoISCorrSingle;
        this.correctionFactorESISInternalCorrInternal_ = correctionFactorESISInternalCorrInternal;
        this.correctionFactorESISInternalCorrMedian_ = correctionFactorESISInternalCorrMedian;
        this.correctionFactorESISInternalCorrSingle_ = correctionFactorESISInternalCorrSingle;
        this.correctionFactorESISMedianCorrInternal_ = correctionFactorESISMedianCorrInternal;
        this.correctionFactorESISMedianCorrMedian_ = correctionFactorESISMedianCorrMedian;
        this.correctionFactorESISMedianCorrSingle_ = correctionFactorESISMedianCorrSingle;
        this.correctionFactorESISSingleCorrInternal_ = correctionFactorESISSingleCorrInternal;
        this.correctionFactorInternalESISSingleCorrMedian_ = correctionFactorInternalESISSingleCorrMedian;
        this.correctionFactorESISSingleCorrSingle_ = correctionFactorESISSingleCorrSingle;
        this.areaESNoISCorrInternalComparison_ = areaESNoISCorrInternalComparison;
        this.areaESNoISCorrMedianComparison_ = areaESNoISCorrMedianComparison;
        this.areaESNoISCorrSingleComparison_ = areaESNoISCorrSingleComparison;
        this.areaESISInternalCorrInternalComparison_ = areaESISInternalCorrInternalComparison;
        this.areaESISInternalCorrMedianComparison_ = areaESISInternalCorrMedianComparison;
        this.areaESISInternalCorrSingleComparison_ = areaESISInternalCorrSingleComparison;
        this.areaESISMedianCorrInternalComparison_ = areaESISMedianCorrInternalComparison;
        this.areaESISMedianCorrMedianComparison_ = areaESISMedianCorrMedianComparison;
        this.areaESISMedianCorrSingleComparison_ = areaESISMedianCorrSingleComparison;
        this.areaESISSingleCorrInternalComparison_ = areaESISSingleCorrInternalComparison;
        this.areaESISSingleCorrMedianComparison_ = areaESISSingleCorrMedianComparison;
        this.areaESISSingleCorrSingleComparison_ = areaESISSingleCorrSingleComparison;
        this.dilutionFactor_ = dilutionFactor;
        this.isAmounts_ = isAmount;
        this.esAmounts_ = esAmount;
        this.esStandardVolumeInternalCorr_ = esStandardVolumeInternalCorr;
        this.esStandardConcentrationInternalCorr_ = esStandardConcentrationInternalCorr;
        this.esStandardVolumeMedianCorr_ = esStandardVolumeMedianCorr;
        this.esStandardConcentrationMedianCorr_ = esStandardConcentrationMedianCorr;
        this.esStandardVolumeSingleCorr_ = esStandardVolumeSingleCorr;
        this.esStandardConcentrationSingleCorr_ = esStandardConcentrationSingleCorr;
        this.endVolume_ = endVolume;
        this.probeVolume_ = probeVolume;
        this.sampleWeight_ = sampleWeight;
        this.proteinConcentration_ = proteinConcentration;
        this.neutralLipidConcentration_ = neutralLipidConcentration;
        this.moreThanOnePeak_ = moreThanOnePeak;
        this.hasAbs_ = hasAbs;
    }

    public ResultCompVO() {
        this(null, false, false, 0, null, new Hashtable<String, Double>(), "", 0, false, new Vector<Double>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Hashtable<Integer, Vector<Double>>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Hashtable<Integer, Vector<Double>>>(), new Hashtable<Integer, VolumeConcVO>(), null, new Hashtable<Integer, VolumeConcVO>(), null, null, null, null, null, null, null, null, null, null, null, new Vector<Hashtable<String, Boolean>>(), false);
    }

    public ResultAreaVO getResultMolecule() {
        return this.resultMolecule_;
    }

    public int getType() {
        return this.type_;
    }

    public double getOriginalArea(int maxIsotope) {
        if (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0) {
            return 0.0;
        }
        return this.originalArea_.get(maxIsotope);
    }

    public double getStandardizedArea(int maxIsotope, int standMethod, int esStandMethod, boolean dilutionFactor) {
        return this.getStandardizedArea(null, maxIsotope, standMethod, esStandMethod, dilutionFactor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getStandardizedArea(Double area, int maxIsotope, int standMethod, int esStandMethod, boolean dilutionFactor) {
        if (area == null && maxIsotope >= this.usedIsotpes_ || maxIsotope < 0) {
            return 0.0;
        }
        Double value = area;
        if (value == null) {
            value = this.getOriginalArea(maxIsotope);
        }
        if (dilutionFactor && this.dilutionFactor_ != null) {
            value = value * this.dilutionFactor_;
        }
        if (standMethod == 0) {
            if (esStandMethod == 1) {
                value = value * this.correctionFactorESNoISCorrInternal_.get(maxIsotope);
            } else if (esStandMethod == 2) {
                value = value * this.correctionFactorESNoISCorrMedian_.get(maxIsotope);
            } else if (esStandMethod > 0) {
                value = value * this.correctionFactorESNoISCorrSingle_.get(esStandMethod).get(maxIsotope);
            }
        } else if (standMethod == 1) {
            value = value * this.correctionFactorInternalIS_.get(maxIsotope);
            if (esStandMethod == 1) {
                value = value * this.correctionFactorESISInternalCorrInternal_.get(maxIsotope);
            } else if (esStandMethod == 2) {
                value = value * this.correctionFactorESISInternalCorrMedian_.get(maxIsotope);
            } else if (esStandMethod > 0) {
                value = value * this.correctionFactorESISInternalCorrSingle_.get(esStandMethod).get(maxIsotope);
            }
        } else if (standMethod == 2) {
            value = value * this.correctionFactorMedianIS_.get(maxIsotope);
            if (esStandMethod == 1) {
                value = value * this.correctionFactorESISMedianCorrInternal_.get(maxIsotope);
            } else if (esStandMethod == 2) {
                value = value * this.correctionFactorESISMedianCorrMedian_.get(maxIsotope);
            } else if (esStandMethod > 0) {
                value = value * this.correctionFactorESISMedianCorrSingle_.get(esStandMethod).get(maxIsotope);
            }
        } else {
            if (this.correctionFactorSingleIS_ == null || !this.correctionFactorSingleIS_.containsKey(standMethod)) return 0.0;
            value = value * this.correctionFactorSingleIS_.get(standMethod).get(maxIsotope);
            if (esStandMethod == 1) {
                value = value * this.correctionFactorESISSingleCorrInternal_.get(standMethod).get(maxIsotope);
            } else if (esStandMethod == 2) {
                value = value * this.correctionFactorInternalESISSingleCorrMedian_.get(standMethod).get(maxIsotope);
            } else if (esStandMethod > 0) {
                if (!this.correctionFactorESISSingleCorrSingle_.containsKey(standMethod) || !this.correctionFactorESISSingleCorrSingle_.get(standMethod).containsKey(esStandMethod)) return 0.0;
                value = value * this.correctionFactorESISSingleCorrSingle_.get(standMethod).get(esStandMethod).get(maxIsotope);
            }
        }
        if (!(value > 0.0) || value.isInfinite() || value.isNaN()) return 0.0;
        return value;
    }

    public double getRelativeValue(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        return this.getRelativeValue(maxIsotope, settingVO, SUM_COMPOSITION, 1.0);
    }

    public double getRelativeValue(int maxIsotope, ResultDisplaySettingsVO settingVO, String molecularSpecies, double molecularSpeciesContribution) {
        if (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0) {
            return -1.0;
        }
        Double standardizedArea = null;
        try {
            standardizedArea = this.getArea(maxIsotope, settingVO) * molecularSpeciesContribution;
        }
        catch (CalculationNotPossibleException e) {
            e.printStackTrace();
        }
        Double relativeMedianArea = this.relativeMedianAreas_.get(molecularSpecies).get(maxIsotope);
        return standardizedArea / relativeMedianArea;
    }

    public void addRelativeMedianArea(String molecularSpecies, ArrayList<Double> relativeMedianArea) {
        this.relativeMedianAreas_.put(molecularSpecies, relativeMedianArea);
    }

    public void addRelativeMedianArea(ArrayList<Double> relativeMedianArea) {
        this.addRelativeMedianArea(SUM_COMPOSITION, relativeMedianArea);
    }

    public int getUsedIsotpes() {
        return this.usedIsotpes_;
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath_;
    }

    public double getRelativeToMedian(int maxIsotope, ResultDisplaySettingsVO settingVO) {
        return this.getRelativeToMedian(null, maxIsotope, settingVO);
    }

    private double getRelativeToMedian(Double area, int maxIsotope, ResultDisplaySettingsVO settingVO) {
        if (area == null && (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0)) {
            return 0.0;
        }
        Double standardizedArea = this.getStandardizedArea(area, maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.considerDilution());
        if (standardizedArea > 0.0) {
            double standardArea = this.getStandardArea(settingVO, maxIsotope);
            return standardizedArea / standardArea;
        }
        return 0.0;
    }

    private double getCorrectionFactor(ResultDisplaySettingsVO settingVO, int maxIsotope) {
        ResultDisplaySettingsVO esAreaSet = new ResultDisplaySettingsVO(settingVO.getType(), 0, settingVO.getESStandMethod(), false, true);
        ResultDisplaySettingsVO isAreaSet = new ResultDisplaySettingsVO(settingVO.getType(), settingVO.getISStandMethod(), 0, false, true);
        double correctionFactor = this.getStandardArea(esAreaSet, maxIsotope) / this.getStandardArea(isAreaSet, maxIsotope);
        return correctionFactor;
    }

    private double getStandardArea(ResultDisplaySettingsVO settingVO, int maxIsotope) {
        Double standardArea = 1.0;
        if (settingVO.getISStandMethod() != 0 && settingVO.getESStandMethod() != 0) {
            standardArea = settingVO.getISStandMethod() == 1 ? (settingVO.getESStandMethod() == 1 ? this.areaESISInternalCorrInternalComparison_.get(maxIsotope) : (settingVO.getESStandMethod() == 2 ? this.areaESISInternalCorrMedianComparison_.get(maxIsotope) : this.areaESISInternalCorrSingleComparison_.get(settingVO.getESStandMethod()).get(maxIsotope))) : (settingVO.getISStandMethod() == 2 ? (settingVO.getESStandMethod() == 1 ? this.areaESISMedianCorrInternalComparison_.get(maxIsotope) : (settingVO.getESStandMethod() == 2 ? this.areaESISMedianCorrMedianComparison_.get(maxIsotope) : this.areaESISMedianCorrSingleComparison_.get(settingVO.getESStandMethod()).get(maxIsotope))) : (settingVO.getESStandMethod() == 1 ? this.areaESISSingleCorrInternalComparison_.get(settingVO.getISStandMethod()).get(maxIsotope) : (settingVO.getESStandMethod() == 2 ? this.areaESISSingleCorrMedianComparison_.get(settingVO.getISStandMethod()).get(maxIsotope) : this.areaESISSingleCorrSingleComparison_.get(settingVO.getISStandMethod()).get(settingVO.getESStandMethod()).get(maxIsotope))));
        } else if (settingVO.getISStandMethod() != 0) {
            standardArea = settingVO.getISStandMethod() == 1 ? this.areaISInternalComparison_.get(maxIsotope) : (settingVO.getISStandMethod() == 2 ? this.areaISMedianComparison_.get(maxIsotope) : this.areaISSingleComparison_.get(settingVO.getISStandMethod()).get(maxIsotope));
        } else if (settingVO.getESStandMethod() != 0) {
            standardArea = settingVO.getESStandMethod() == 1 ? this.areaESNoISCorrInternalComparison_.get(maxIsotope) : (settingVO.getESStandMethod() == 2 ? this.areaESNoISCorrMedianComparison_.get(maxIsotope) : this.areaESNoISCorrSingleComparison_.get(settingVO.getESStandMethod()).get(maxIsotope));
        }
        if (settingVO.getESStandMethod() != 0 && !settingVO.considerDilution()) {
            standardArea = standardArea / this.dilutionFactor_;
        }
        return standardArea;
    }

    public double getAmountInEndVolume(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        return this.getAmountInEndVolume(null, maxIsotope, standMethod);
    }

    private double getAmountInEndVolume(Double area, int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        if (area == null && (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0)) {
            return 0.0;
        }
        if (standMethod == 0) {
            throw new CalculationNotPossibleException("For the calculation of the amount of the probe in the end volume an internal standard has to be used");
        }
        double amountStandard = this.getAmountISStandard(standMethod);
        double amount = 0.0;
        ResultDisplaySettingsVO settingVO = new ResultDisplaySettingsVO(null, standMethod, 0, false, false);
        amount = amountStandard * this.getRelativeToMedian(area, maxIsotope, settingVO);
        return amount;
    }

    public double getConcentrationInEndVolume(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        if (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0) {
            return 0.0;
        }
        double amountInEndVolume = this.getAmountInEndVolume(maxIsotope, standMethod);
        if (this.endVolume_ == null) {
            throw new CalculationNotPossibleException("For the calculation of the concentration of the probe in the end volume, the end volume has to be known");
        }
        return amountInEndVolume / this.endVolume_;
    }

    public double getWeightInEndVolume(int maxIsotope, int standMethod) throws CalculationNotPossibleException {
        if (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0) {
            return 0.0;
        }
        double amountInEndVolume = this.getAmountInEndVolume(maxIsotope, standMethod);
        if (this.endVolume_ == null) {
            throw new CalculationNotPossibleException("For the calculation of the concentration of the probe in the end volume, the end volume has to be known");
        }
        return amountInEndVolume * this.getMass(maxIsotope);
    }

    public double getAmountInProbeVolume(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        return this.getAmountInProbeVolume(null, maxIsotope, standMethod, esMethod);
    }

    public double getAmountInProbeVolume(Double area, int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        if (area == null && (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0)) {
            return 0.0;
        }
        if (standMethod == 0 && esMethod == 0) {
            throw new CalculationNotPossibleException("For the calculation of absolute values the external or the internal standard must be respected; best both of them");
        }
        double amountInProbeVolume = 0.0;
        if (standMethod != 0 && esMethod != 0) {
            double amountStandard = this.getAmountISStandard(standMethod);
            ResultDisplaySettingsVO settingVO = new ResultDisplaySettingsVO(null, standMethod, esMethod, true, false);
            if (standMethod > 2 && esMethod != 0) {
                amountStandard *= this.isAmounts_.get(1).getAmount() / this.isAmounts_.get(settingVO.getISStandMethod()).getAmount();
            }
            double correctiveFactor = this.getCorrectionFactor(settingVO, maxIsotope);
            amountInProbeVolume = amountStandard * correctiveFactor * this.getRelativeToMedian(area, maxIsotope, settingVO) * this.dilutionFactor_;
        } else if (standMethod == 0 && esMethod != 0) {
            Double relationAreaProbeToES = 1.0;
            Double value = this.getStandardizedArea(area, maxIsotope, 0, esMethod, true);
            relationAreaProbeToES = esMethod == 1 ? Double.valueOf(value / this.areaESNoISCorrInternalComparison_.get(maxIsotope)) : (esMethod == 2 ? Double.valueOf(value / this.areaESNoISCorrMedianComparison_.get(maxIsotope)) : Double.valueOf(value / this.areaESNoISCorrSingleComparison_.get(esMethod).get(maxIsotope)));
            double amountESProbeVolume = this.getAmountESStandard(esMethod);
            amountInProbeVolume = amountESProbeVolume * relationAreaProbeToES;
        } else if (standMethod != 0 && esMethod == 0) {
            amountInProbeVolume = this.getAmountInEndVolume(area, maxIsotope, standMethod) * this.dilutionFactor_;
        }
        return amountInProbeVolume;
    }

    public double getConcentrationInProbeVolume(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        if (this.probeVolume_ == null) {
            throw new CalculationNotPossibleException("For the calculation of the concentration of the probe in the probe volume, the probe volume has to be known");
        }
        double amountInProbeVolume = this.getAmountInProbeVolume(maxIsotope, standMethod, esMethod);
        return amountInProbeVolume / this.probeVolume_;
    }

    public double getWeightInProbeVolume(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        double amountInProbeVolume = this.getAmountInProbeVolume(maxIsotope, standMethod, esMethod);
        return amountInProbeVolume * this.getMass(maxIsotope);
    }

    public double getAnalyteInRelationToProtein(int maxIsotope, int standMethod, int esMethod, boolean useAU) throws CalculationNotPossibleException {
        double amountInProbeVolume = 0.0;
        amountInProbeVolume = (standMethod != 0 || esMethod != 0) && !useAU ? this.getAmountInProbeVolume(maxIsotope, standMethod, esMethod) : this.getStandardizedArea(maxIsotope, standMethod, esMethod, true);
        return amountInProbeVolume / this.getProteinAmount();
    }

    public double getAnalyteInRelationToNeutralLipidContent(int maxIsotope, int standMethod, int esMethod, boolean useAU) throws CalculationNotPossibleException {
        double amountInProbeVolume = 0.0;
        amountInProbeVolume = (standMethod != 0 || esMethod != 0) && !useAU ? this.getAmountInProbeVolume(maxIsotope, standMethod, esMethod) : this.getStandardizedArea(maxIsotope, standMethod, esMethod, true);
        return amountInProbeVolume / this.getNeutralLipidAmount();
    }

    public double getAnalyteInRelationToSampleWeight(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        double amountInProbeVolume = this.getAmountInProbeVolume(maxIsotope, standMethod, esMethod);
        return amountInProbeVolume / this.getRelativeSampleWeightValue();
    }

    private double getRelativeSampleWeightValue() {
        return this.sampleWeight_;
    }

    private double getProteinAmount() throws CalculationNotPossibleException {
        if (this.probeVolume_ == null) {
            throw new CalculationNotPossibleException("For the calculation of the relation to the protein, the probe volume has to be known");
        }
        if (this.proteinConcentration_ == null) {
            throw new CalculationNotPossibleException("For the calculation of the relation to the protein, the protein concentration has to be known");
        }
        return this.probeVolume_ * this.proteinConcentration_;
    }

    private double getNeutralLipidAmount() throws CalculationNotPossibleException {
        if (this.probeVolume_ == null) {
            throw new CalculationNotPossibleException("For the calculation of the relation to the protein, the probe volume has to be known");
        }
        if (this.neutralLipidConcentration_ == null) {
            throw new CalculationNotPossibleException("For the calculation of the relation to the neutral lipid contents, the neutral lipid contents has to be known");
        }
        return this.probeVolume_ * this.neutralLipidConcentration_;
    }

    private double getAmountISStandard(int method) throws CalculationNotPossibleException {
        if (this.hasAbs_) {
            VolumeConcVO concVO = this.isAmounts_.get(method);
            if (concVO.getVolume() == null) {
                throw new CalculationNotPossibleException("For the calculation of the amount of the probe in the volume of the internal standard has to be entered");
            }
            if (concVO.getConcentration() == null) {
                throw new CalculationNotPossibleException("For the calculation of the amount of the probe in the concentration of the internal standard has to be entered");
            }
            return concVO.getAmount();
        }
        return 1.0;
    }

    private double getAmountESStandard(int method) throws CalculationNotPossibleException {
        if (this.hasAbs_) {
            VolumeConcVO concVO = this.esAmounts_.get(method);
            if (concVO.getVolume() == null) {
                throw new CalculationNotPossibleException("For the calculation of the amount of the probe in the volume of the internal standard has to be entered");
            }
            if (concVO.getConcentration() == null) {
                throw new CalculationNotPossibleException("For the calculation of the amount of the probe in the concentration of the internal standard has to be entered");
            }
            return concVO.getAmount();
        }
        return 1.0;
    }

    public double getArea(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        double area = 0.0;
        if (settingVO.isPercent()) {
            area = this.getRatioToPercentualValue(maxIsotope, settingVO);
        } else if (settingVO.getType().equalsIgnoreCase("relative value")) {
            area = this.getStandardizedArea(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.considerDilution());
        } else if (settingVO.getType().equalsIgnoreCase("relative to base peak")) {
            area = this.getRatioToHighestPeak(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to measured class amount")) {
            area = this.getRatioToTotalIntensity(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to highest total peak")) {
            area = this.getRatioToHighestFoundPeak(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("relative to total amount")) {
            area = this.getRatioToOverallGroupsIntensity(maxIsotope);
        } else if (settingVO.getType().equalsIgnoreCase("amount end-volume")) {
            area = this.getAmountInEndVolume(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("conc. end-volume")) {
            area = this.getConcentrationInEndVolume(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("weight end-volume")) {
            area = this.getWeightInEndVolume(maxIsotope, settingVO.getISStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("amount sample-volume")) {
            area = this.getAmountInProbeVolume(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("conc. sample-volume")) {
            area = this.getConcentrationInProbeVolume(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("weight sample-volume")) {
            area = this.getWeightInProbeVolume(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("relative to sample weight")) {
            area = this.getAnalyteInRelationToSampleWeight(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("relation to protein content")) {
            area = this.getAnalyteInRelationToProtein(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.isAu());
        } else if (settingVO.getType().equalsIgnoreCase("relation to neutral lipid content")) {
            area = this.getAnalyteInRelationToNeutralLipidContent(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod(), settingVO.isAu());
        } else if (settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
            area = this.getAnalyteInRelationToMeasuredNeutralLipidContent(maxIsotope, settingVO.getISStandMethod(), settingVO.getESStandMethod());
        } else if (settingVO.getType().equalsIgnoreCase("percentual value")) {
            area = this.getRatioToPercentualValue(maxIsotope, settingVO);
        }
        if (area > 0.0 && !Double.isInfinite(area) && !Double.isNaN(area)) {
            if (settingVO.getType().equalsIgnoreCase("conc. end-volume") || settingVO.getType().equalsIgnoreCase("conc. sample-volume") || settingVO.getType().equalsIgnoreCase("relative to sample weight") || settingVO.getType().equalsIgnoreCase("relation to protein content") || settingVO.getType().equalsIgnoreCase("relation to neutral lipid content") || settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
                area = StaticUtils.getValueDividedByUnit(area, settingVO.getDivisorMagnitude());
            }
            return area;
        }
        return 0.0;
    }

    public double getRatioToHighestPeak(int maxIsotope) {
        if (this.highestGroupIntensity_ != null && maxIsotope >= 0 && this.highestGroupIntensity_.get(maxIsotope) > 0.0) {
            return this.originalArea_.get(maxIsotope) / this.highestGroupIntensity_.get(maxIsotope);
        }
        return 0.0;
    }

    public double getRatioToTotalIntensity(int maxIsotope) {
        if (this.totalGroupIntensity_ != null && maxIsotope >= 0 && this.totalGroupIntensity_.get(maxIsotope) > 0.0) {
            return this.originalArea_.get(this.getAvailableIsotopeNr(maxIsotope)) / this.totalGroupIntensity_.get(maxIsotope);
        }
        return 0.0;
    }

    public double getAnalyteInRelationToMeasuredNeutralLipidContent(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        if (this.totalGroupMass_ != null && maxIsotope >= 0 && this.totalGroupMass_.size() > 0) {
            double amount = this.getAmountInProbeVolume(maxIsotope, standMethod, esMethod);
            double totalAmountGramm = this.getAmountInProbeVolume(this.totalGroupMass_.get(maxIsotope), maxIsotope, standMethod, esMethod);
            return amount / totalAmountGramm;
        }
        return 0.0;
    }

    public double getRelativeToMeasuredNeutralLipidContent(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        return this.getAnalyteInRelationToMeasuredNeutralLipidContent(maxIsotope, standMethod, esMethod) * this.mass_.get(maxIsotope);
    }

    public int getAvailableIsotopeNr(int desiredIsotopeNr) {
        int isotopesToTake = desiredIsotopeNr;
        if (isotopesToTake > this.usedIsotpes_ - 1) {
            isotopesToTake = this.usedIsotpes_ - 1;
        }
        return isotopesToTake;
    }

    public double getMass(int maxIsotope) {
        if (maxIsotope < 0 || this.isEmptyObject()) {
            return 0.0;
        }
        return this.mass_.get(maxIsotope);
    }

    public double getRetentionTime(String modName) {
        double value = -1.0;
        if (this.retentionTime_.containsKey(modName)) {
            value = this.retentionTime_.get(modName);
        }
        return value;
    }

    public void setHighestGroupIntensity(Vector<Double> highestGroupIntensity) {
        this.highestGroupIntensity_ = highestGroupIntensity;
    }

    public void setTotalGroupIntensity(Vector<Double> totalGroupIntensity) {
        this.totalGroupIntensity_ = totalGroupIntensity;
    }

    public void setTotalGroupMass(Vector<Double> totalGroupMass) {
        this.totalGroupMass_ = totalGroupMass;
    }

    public double getTotalGroupMass(int maxIsotope, int standMethod, int esMethod) throws CalculationNotPossibleException {
        return this.getAmountInProbeVolume(this.totalGroupMass_.get(maxIsotope), maxIsotope, standMethod, esMethod);
    }

    public boolean getMoreThanOnePeak(int maxIsotope) {
        if (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0) {
            return false;
        }
        boolean moreThanOnePeak = false;
        for (boolean more : this.moreThanOnePeak_.get(maxIsotope).values()) {
            if (!more) continue;
            moreThanOnePeak = more;
        }
        return moreThanOnePeak;
    }

    public boolean getMoreThanOnePeak(int maxIsotope, String modName) {
        if (maxIsotope >= this.usedIsotpes_ || maxIsotope < 0) {
            return false;
        }
        Hashtable<String, Boolean> hash = this.moreThanOnePeak_.get(maxIsotope);
        if (hash.containsKey(modName)) {
            return hash.get(modName);
        }
        return false;
    }

    public void setHighestFoundIntensity(Vector<Double> highestFoundIntensity) {
        this.highestFoundIntensity_ = highestFoundIntensity;
    }

    public void setTotalFoundIntensity(Vector<Double> totalFoundIntensity) {
        this.totalFoundIntensity_ = totalFoundIntensity;
    }

    public double getRatioToHighestFoundPeak(int maxIsotope) {
        if (this.highestFoundIntensity_ != null && maxIsotope >= 0 && this.highestFoundIntensity_.get(maxIsotope) > 0.0) {
            return this.originalArea_.get(maxIsotope) / this.highestFoundIntensity_.get(maxIsotope);
        }
        return 0.0;
    }

    public double getRatioToOverallGroupsIntensity(int maxIsotope) {
        if (this.totalFoundIntensity_ != null && maxIsotope >= 0 && this.totalFoundIntensity_.get(maxIsotope) > 0.0) {
            return this.originalArea_.get(this.getAvailableIsotopeNr(maxIsotope)) / this.totalFoundIntensity_.get(maxIsotope);
        }
        return 0.0;
    }

    public double getRatioToPercentualValue(int maxIsotope, ResultDisplaySettingsVO settingVO) throws CalculationNotPossibleException {
        if (this.sumValueForPercentage_ != null && maxIsotope >= 0 && this.sumValueForPercentage_.get(maxIsotope) > 0.0) {
            double area = this.originalArea_.get(this.getAvailableIsotopeNr(maxIsotope));
            if (this.type_ != 3) {
                ResultDisplaySettingsVO newSetting = new ResultDisplaySettingsVO(settingVO);
                newSetting.setPercent(false);
                area = this.getArea(maxIsotope, newSetting);
            }
            return area / this.sumValueForPercentage_.get(maxIsotope);
        }
        return 0.0;
    }

    public void setSumValueForPercentage(Vector<Double> sumValueForPercentage) {
        this.sumValueForPercentage_ = sumValueForPercentage;
    }

    public boolean isEmptyObject() {
        return this.retentionTime_.size() == 0;
    }

    public boolean containsMod(String modName) {
        if (this.isEmptyObject() && this.existsInFile()) {
            return true;
        }
        return this.retentionTime_.containsKey(modName);
    }

    public boolean existsInFile() {
        if (this.isEmptyObject()) {
            return this.existsInFile_ || this.isNullInFile_;
        }
        return true;
    }

    public boolean hasAllModsFound() {
        return this.allModsFound_;
    }
}

