/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.xml.AddScan;
import at.tugraz.genome.lda.xml.XMLSpectraReader;
import at.tugraz.genome.maspectras.quantification.CgException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractXMLSpectraReader
implements XMLSpectraReader {
    public static final String FILE_TYPE_MZ_XML = "mzXML";
    public static final String FILE_TYPE_MZ_ML = "mzML";
    XMLStreamReader reader_;
    AddScan[] adders_;
    private boolean parseMsMs_;
    private InputStream inStream_;
    private int multiplicationFactorForInt_ = 1000;
    public static final int ONE_MILLION = 1000000;
    private int lowestMz_ = 1000000 * this.multiplicationFactorForInt_;
    private int highestMz_ = 0;
    private Range maxRange_ = null;
    protected int currentPolarity_ = 0;
    private boolean polaritySwitching_ = false;

    public AbstractXMLSpectraReader(AddScan[] callbacks, boolean parseMsMs) {
        this.adders_ = callbacks;
        this.generateMzThresholds();
        this.parseMsMs_ = parseMsMs;
    }

    public AbstractXMLSpectraReader(AddScan[] callbacks, boolean parseMsMs, int multiplicationFactorForInt) {
        this(callbacks, parseMsMs);
        this.multiplicationFactorForInt_ = multiplicationFactorForInt;
        this.lowestMz_ = 1000000 * this.multiplicationFactorForInt_;
    }

    @Override
    public void ReadFile(String fileName) throws CgException {
        this.ReadFile(fileName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void ReadFile(String fileName, boolean readOnlyRequiredInfoForMultiThreading) throws CgException {
        block18: {
            boolean foundTagRun = false;
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isNamespaceAware", true);
                factory.setProperty("javax.xml.stream.isCoalescing", true);
                File XMLFile = new File(fileName);
                if (XMLFile.exists()) {
                    this.inStream_ = new FileInputStream(XMLFile);
                } else {
                    XMLFile = new File(fileName + ".gz");
                    if (!XMLFile.exists()) {
                        throw new CgException(String.format("The file %s does not exist!", fileName));
                    }
                    this.inStream_ = new GZIPInputStream(new FileInputStream(XMLFile));
                }
                this.reader_ = factory.createXMLStreamReader(this.inStream_);
                int eventType = this.reader_.getEventType();
                while (this.reader_.hasNext()) {
                    switch (eventType) {
                        case 7: {
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 1: {
                            if (!this.reader_.getLocalName().equalsIgnoreCase(this.getTagRun())) break;
                            foundTagRun = true;
                            this.readMsRun(readOnlyRequiredInfoForMultiThreading);
                            break;
                        }
                    }
                    eventType = this.reader_.next();
                }
                if (foundTagRun) break block18;
                throw new CgException(String.format("The file %s does not contain the required tag <%s> and could therefore not be read by %s.", fileName, this.getTagRun(), this.getClass().getName()));
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    throw new CgException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (!foundTagRun) {
                        throw new CgException(String.format("The file %s does not contain the required tag <%s> and could therefore not be read by %s.", fileName, this.getTagRun(), this.getClass().getName()));
                    }
                    try {
                        this.inStream_.close();
                        this.reader_ = null;
                        throw throwable;
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
        try {
            this.inStream_.close();
            this.reader_ = null;
            return;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return;
        }
    }

    public String getRequiredAttribute(XMLStreamReader reader, String attribute) {
        String attributeValue = reader.getAttributeValue(null, attribute);
        if (attributeValue == null) {
            throw new IllegalStateException(String.format("Tag %s must provide the attribute `%s`(Line %s)", reader.getLocalName(), attribute, reader.getLocation().getLineNumber()));
        }
        return attributeValue;
    }

    protected void setCurrentGlobalMaxima(float lowMz, float highMz) {
        int currentLowMz = Math.round(lowMz * (float)this.getMultiplicationFactorForInt());
        int currentHighMz = Math.round(highMz * (float)this.getMultiplicationFactorForInt());
        if (currentLowMz < this.getLowestMz()) {
            this.setLowestMz(currentLowMz);
        }
        if (currentHighMz > this.getHighestMz()) {
            this.setHighestMz(currentHighMz);
        }
    }

    protected static byte[] decompressZLIB(byte[] decoded) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(decoded);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(decoded.length);){
            byte[] buf = new byte[1024];
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            decoded = bos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return decoded;
    }

    private void generateMzThresholds() {
        float lowest = Float.MAX_VALUE;
        float highest = 0.0f;
        for (int i = 0; i != this.adders_.length; ++i) {
            AddScan adder = this.adders_[i];
            if (adder.getLowerThreshold() < lowest) {
                lowest = adder.getLowerThreshold();
            }
            if (!(adder.getUpperThreshold() > highest)) continue;
            highest = adder.getUpperThreshold();
        }
        this.maxRange_ = new Range(lowest, highest);
    }

    protected String getPrecursorMzString(Vector<String> precursorMzs) {
        if (precursorMzs.size() == 1) {
            return precursorMzs.get(0);
        }
        StringBuilder bd = new StringBuilder();
        for (int i = 0; i != precursorMzs.size(); ++i) {
            bd.append(precursorMzs.get(i));
            if (i == precursorMzs.size() - 1) continue;
            bd.append(" ");
        }
        return bd.toString();
    }

    protected abstract void readMsRun(boolean var1) throws CgException;

    protected abstract void readOnlyRequiredInfoForMultiThreading() throws CgException;

    public abstract String getTagRun();

    protected Range getMaxRange() {
        return this.maxRange_;
    }

    @Override
    public void setAdders(AddScan[] adders) {
        this.adders_ = adders;
    }

    protected boolean getParseMsMs() {
        return this.parseMsMs_;
    }

    protected int getMultiplicationFactorForInt() {
        return this.multiplicationFactorForInt_;
    }

    protected void setHighestMz(int highestMz) {
        this.highestMz_ = highestMz;
    }

    @Override
    public int getHighestMz() {
        return this.highestMz_;
    }

    protected void setLowestMz(int lowestMz) {
        this.lowestMz_ = lowestMz;
    }

    @Override
    public int getLowestMz() {
        return this.lowestMz_;
    }

    protected void setPolaritySwitching(boolean polaritySwitching) {
        this.polaritySwitching_ = polaritySwitching;
    }

    @Override
    public boolean usesPolaritySwitching() {
        return this.polaritySwitching_;
    }

    @Override
    public void setLowerThreshold(float lowerThreshold) {
    }

    @Override
    public void setUpperThreshold(float upperThreshold) {
    }
}

