/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import java.io.File;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModConfigParser {
    private Hashtable<String, Hashtable<String, Integer>> modifications_;
    private File modConfigFile_;

    public ModConfigParser(String modConfigPath_) {
        this.modConfigFile_ = new File(modConfigPath_);
    }

    public void parse() {
        this.modifications_ = new Hashtable();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.modConfigFile_);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("modification");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String symbol = node.getAttributes().getNamedItem("symbol").getNodeValue();
                Hashtable<String, Integer> elements = new Hashtable<String, Integer>();
                NodeList subNodeList = node.getChildNodes();
                for (int i2 = 0; i2 < subNodeList.getLength(); ++i2) {
                    Node subNode = subNodeList.item(i2);
                    if (!subNode.hasAttributes()) continue;
                    String element = subNode.getAttributes().getNamedItem("name").getNodeValue();
                    int amount = Integer.parseInt(subNode.getTextContent());
                    elements.put(element, amount);
                }
                this.modifications_.put(symbol, elements);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable<String, Integer> getElements(String modification) throws Exception {
        if (this.modifications_.containsKey(modification)) {
            return this.modifications_.get(modification);
        }
        throw new Exception("The modification " + modification + " is listed in the fattyAcidChains file but not in the modconfig.xml file! Will continue withouth it...");
    }
}

