/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.xml.AbstractXMLSpectraReader;
import at.tugraz.genome.lda.xml.AddScan;
import at.tugraz.genome.maspectras.quantification.CgBase64;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgScan;
import at.tugraz.genome.maspectras.quantification.CgScanHeader;
import at.tugraz.genome.maspectras.quantification.MsMsScan;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;

public class MzMLReader
extends AbstractXMLSpectraReader {
    private CgScanHeader myHeader_;
    private static final String TAG_RUN = "run";
    private static final String TAG_SPECTRUM_LIST = "spectrumList";
    private static final String TAG_SPECTRUM = "spectrum";
    private static final String TAG_CV_PARAM = "cvParam";
    private static final String TAG_SCAN_LIST = "scanList";
    private static final String TAG_PRECURSOR_LIST = "precursorList";
    private static final String TAG_BINARY_DATA_ARRAY_LIST = "binaryDataArrayList";
    private static final String TAG_BINARY_DATA_ARRAY = "binaryDataArray";
    private static final String TAG_BINARY = "binary";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_COUNT = "count";
    private static final String ATTRIBUTE_INDEX = "index";
    private static final String ATTRIBUTE_DEFAULT_ARRAY_LENGTH = "defaultArrayLength";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_UNIT_NAME = "unitName";
    private static final String ENTRY_MS_LEVEL = "ms level";
    private static final String ENTRY_LOWEST_OBSERVED_MZ = "lowest observed m/z";
    private static final String ENTRY_HIGHEST_OBSERVED_MZ = "highest observed m/z";
    private static final String ENTRY_POSITIVE_SCAN = "positive scan";
    private static final String ENTRY_NEGATIVE_SCAN = "negative scan";
    private static final String ENTRY_SCAN_START_TIME = "scan start time";
    private static final String ENTRY_64_BIT_FLOAT = "64-bit float";
    private static final String ENTRY_32_BIT_FLOAT = "32-bit float";
    private static final String ENTRY_NO_COMPRESSION = "no compression";
    private static final String ENTRY_ZLIB_COMPRESSION = "zlib compression";
    private static final String ENTRY_MZ_ARRAY = "m/z array";
    private static final String ENTRY_INTENSITY_ARRAY = "intensity array";
    private static final String ENTRY_BASE_PEAK_MZ = "base peak m/z";
    private static final String ENTRY_BASE_PEAK_INTENSITY = "base peak intensity";
    private static final String ENTRY_TOTAL_ION_CURRENT = "total ion current";
    private static final String ENTRY_MINUTE = "minute";
    private static final String ENTRY_SELECTED_ION_MZ = "selected ion m/z";

    public MzMLReader(AddScan[] callbacks, boolean parseMsMs) {
        super(callbacks, parseMsMs);
    }

    public MzMLReader(AddScan[] callbacks, boolean parseMsMs, int multiplicationFactorForInt) {
        super(callbacks, parseMsMs, multiplicationFactorForInt);
    }

    @Override
    public String getTagRun() {
        return TAG_RUN;
    }

    @Override
    protected void readMsRun(boolean readOnlyRequiredInfoForMultiThreading) throws CgException {
        String parentFileName = "";
        try {
            while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_RUN)) {
                    parentFileName = this.getRequiredAttribute(this.reader_, ATTRIBUTE_ID);
                    this.reader_.next();
                    continue;
                }
                if (this.isStartElement(TAG_SPECTRUM_LIST)) {
                    int scanCount = Integer.parseInt(this.getRequiredAttribute(this.reader_, ATTRIBUTE_COUNT));
                    this.informAdders(readOnlyRequiredInfoForMultiThreading, parentFileName, scanCount);
                    this.readSpectrumList(readOnlyRequiredInfoForMultiThreading);
                    continue;
                }
                if (this.isEndElement(this.getTagRun())) {
                    return;
                }
                this.reader_.next();
            }
        }
        catch (Exception ex) {
            throw new CgException(ex.getMessage());
        }
    }

    private void readSpectrumList(boolean readOnlyRequiredInfoForMultiThreading) throws CgException {
        AddScanHelper helper = new AddScanHelper();
        Precursor precursor = new Precursor();
        try {
            while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_SPECTRUM)) {
                    if (readOnlyRequiredInfoForMultiThreading) {
                        this.readOnlyRequiredInfoForMultiThreading();
                        continue;
                    }
                    this.readSpectrum(helper, precursor);
                    continue;
                }
                if (this.isEndElement(TAG_SPECTRUM_LIST)) {
                    return;
                }
                this.reader_.next();
            }
        }
        catch (Exception ex) {
            throw new CgException(ex.getMessage());
        }
    }

    @Override
    protected void readOnlyRequiredInfoForMultiThreading() throws CgException {
        SpectrumParams params = new SpectrumParams();
        boolean spectrumTagFound = false;
        try {
            while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_SPECTRUM)) {
                    params.setSpectrumIndex(Integer.parseInt(this.getRequiredAttribute(this.reader_, ATTRIBUTE_INDEX)) + 1);
                    params.setPeaksCount(Integer.parseInt(this.getRequiredAttribute(this.reader_, ATTRIBUTE_DEFAULT_ARRAY_LENGTH)));
                    spectrumTagFound = true;
                    this.reader_.next();
                    continue;
                }
                if (spectrumTagFound && this.isStartElement(TAG_CV_PARAM)) {
                    this.parseSpectrumCVParamsOverview(params);
                    this.reader_.next();
                    continue;
                }
                if (spectrumTagFound && this.isStartElement(TAG_BINARY_DATA_ARRAY)) {
                    boolean foundMzBorders = params.isFoundMzBorders();
                    this.evaluateScan(params);
                    if (params.getMsLevel() == 1) {
                        float[] maxima;
                        if (!foundMzBorders && params.getPeaksCount() > 0 && !Arrays.equals(maxima = this.getMaximaFromBinaryDataArray(), new float[]{Float.MAX_VALUE, 0.0f})) {
                            params.setLowMz(maxima[0]);
                            params.setHighMz(maxima[1]);
                            params.setLowMzFound(true);
                            params.setHighMzFound(true);
                        }
                        this.setCurrentGlobalMaxima(params.getLowMz(), params.getHighMz());
                    }
                    this.reader_.next();
                    continue;
                }
                if (this.isEndElement(TAG_SPECTRUM)) {
                    if (params.getPolarity() == 0) {
                        throw new CgException(String.format("The polarity at spectrum index %s could not be found.", params.getSpectrumIndex()));
                    }
                    this.setPolaritySwitching(this.checkPolaritySwitching(params.getPolarity()));
                    return;
                }
                this.reader_.next();
            }
        }
        catch (Exception ex) {
            throw new CgException(ex.getMessage());
        }
    }

    private int parseIntegerValue(String entry, String attribute) throws IOException {
        String value = this.reader_.getAttributeValue(null, attribute);
        if (!value.equals("")) {
            return Integer.parseInt(value);
        }
        throw new IOException(String.format("A value for a '%s' entry is missing!", entry));
    }

    private float parseFloatValue(String entry, String attribute) throws IOException {
        String value = this.reader_.getAttributeValue(null, attribute);
        if (!value.equals("")) {
            return Float.parseFloat(value);
        }
        throw new IOException(String.format("A value for a '%s' entry is missing!", entry));
    }

    private float[] getMaximaFromBinaryDataArray() throws CgException {
        float[] maxima = new float[]{Float.MAX_VALUE, 0.0f};
        String precision = null;
        String compression = null;
        try {
            while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_CV_PARAM)) {
                    switch (this.getRequiredAttribute(this.reader_, ATTRIBUTE_NAME)) {
                        case "64-bit float": {
                            precision = ENTRY_64_BIT_FLOAT;
                            break;
                        }
                        case "32-bit float": {
                            precision = ENTRY_32_BIT_FLOAT;
                            break;
                        }
                        case "no compression": {
                            compression = ENTRY_NO_COMPRESSION;
                            break;
                        }
                        case "zlib compression": {
                            compression = ENTRY_ZLIB_COMPRESSION;
                            break;
                        }
                        case "m/z array": {
                            break;
                        }
                        case "intensity array": {
                            return maxima;
                        }
                    }
                    this.reader_.next();
                    continue;
                }
                if (this.isStartElement(TAG_BINARY)) {
                    if (this.reader_.next() != 4) {
                        return maxima;
                    }
                    String binaryString = this.reader_.getText().trim();
                    float[] floatArray = precision == ENTRY_64_BIT_FLOAT ? this.decode64(binaryString, compression) : this.decode32(binaryString, compression);
                    maxima[0] = floatArray[0];
                    maxima[1] = floatArray[floatArray.length - 1];
                    this.reader_.next();
                    continue;
                }
                if (this.isEndElement(TAG_BINARY_DATA_ARRAY)) {
                    return maxima;
                }
                this.reader_.next();
            }
        }
        catch (Exception ex) {
            throw new CgException(ex.getMessage());
        }
        return maxima;
    }

    private float[] decode64(String binary, String compression) {
        CgBase64 cgb = new CgBase64();
        byte[] decoded = cgb.decode(binary);
        if (compression == ENTRY_ZLIB_COMPRESSION) {
            decoded = MzMLReader.decompressZLIB(decoded);
        }
        DoubleBuffer doubleBuf = ByteBuffer.wrap(decoded).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        double[] doubleArray = new double[decoded.length / 8];
        doubleBuf.get(doubleArray);
        float[] floatArray = new float[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            floatArray[i] = (float)doubleArray[i];
        }
        return floatArray;
    }

    private float[] decode32(String binary, String compression) {
        CgBase64 cgb = new CgBase64();
        byte[] decoded = cgb.decode(binary);
        if (compression == ENTRY_ZLIB_COMPRESSION) {
            decoded = MzMLReader.decompressZLIB(decoded);
        }
        FloatBuffer floatBuf = ByteBuffer.wrap(decoded).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        float[] floatArray = new float[decoded.length / 4];
        floatBuf.get(floatArray);
        return floatArray;
    }

    private float[] decodeBinaryArray(String precision, String binaryString, String compression) {
        float[] binaryArray = new float[]{};
        binaryArray = precision == ENTRY_64_BIT_FLOAT ? this.decode64(binaryString, compression) : this.decode32(binaryString, compression);
        return binaryArray;
    }

    private boolean checkPolaritySwitching(int polarity) {
        if (this.currentPolarity_ == 0) {
            this.currentPolarity_ = polarity;
        } else if (this.currentPolarity_ != polarity) {
            return true;
        }
        return false;
    }

    private void informAdders(boolean readOnlyRequiredInfoForMultiThreading, String parentFileName, int scanCount) throws CgException {
        this.myHeader_ = new CgScanHeader();
        this.myHeader_.highestMSLevel = 1;
        this.myHeader_.ScanCount = scanCount;
        if (this.adders_ != null && this.adders_.length > 0) {
            for (AddScan adder : this.adders_) {
                adder.AddHeader(this.myHeader_);
                adder.addParentFileName(parentFileName);
            }
        } else if (!readOnlyRequiredInfoForMultiThreading) {
            throw new CgException("No adder for header and scans defined.");
        }
    }

    protected float convertTimeFormat(String time, String unit) {
        float timeInSeconds = unit.equals(ENTRY_MINUTE) ? Float.parseFloat(time) * 60.0f : Float.parseFloat(time);
        return timeInSeconds;
    }

    private boolean isStartElement(String localName) {
        return this.isElement(1, localName);
    }

    private boolean isEndElement(String localName) {
        return this.isElement(2, localName);
    }

    private boolean isElement(int eventType, String localName) {
        return this.reader_.getEventType() == eventType && this.reader_.getLocalName().equalsIgnoreCase(localName);
    }

    protected void readSpectrum(AddScanHelper helper, Precursor precursor) throws CgException {
        SpectrumParams params = new SpectrumParams();
        CgScan sc = null;
        Vector<Float> scanStartTimes = new Vector<Float>();
        boolean spectrumTagFound = false;
        try {
            while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_SPECTRUM)) {
                    this.parseSpectrum(params);
                    spectrumTagFound = true;
                    continue;
                }
                if (spectrumTagFound && this.isStartElement(TAG_SCAN_LIST)) {
                    this.parseScanList(scanStartTimes, params);
                    continue;
                }
                if (spectrumTagFound && this.isStartElement(TAG_PRECURSOR_LIST)) {
                    this.parsePrecursorList(precursor, params.getMsLevel());
                    continue;
                }
                if (spectrumTagFound && this.isStartElement(TAG_BINARY_DATA_ARRAY_LIST)) {
                    this.evaluateScan(params);
                    if (params.getMsLevel() == 1) {
                        this.readMS1BinaryDataArray(sc, params, precursor, scanStartTimes);
                        continue;
                    }
                    if (this.myHeader_.hasMS1Scans || LipidomicsConstants.isShotgun() <= 0 || precursor.getPrecursorMzFloat() >= 0.0f) {
                        // empty if block
                    }
                    this.readMSnBinaryDataArray(params, precursor, scanStartTimes, helper);
                    this.reader_.next();
                    continue;
                }
                if (this.isEndElement(TAG_SPECTRUM)) {
                    if (params.getPolarity() == 0) {
                        throw new CgException(String.format("The polarity at spectrum index %s could not be found.", params.getSpectrumIndex()));
                    }
                    this.setPolaritySwitching(this.checkPolaritySwitching(params.getPolarity()));
                    helper.init(this.adders_);
                    return;
                }
                this.reader_.next();
            }
        }
        catch (Exception ex) {
            throw new CgException(ex.getMessage());
        }
    }

    private void readMSnBinaryDataArray(SpectrumParams params, Precursor precursor, Vector<Float> scanStartTimes, AddScanHelper helper) throws CgException {
        helper.init(this.adders_);
        if (helper.getScans().size() > 0) {
            if (this.getParseMsMs()) {
                int j;
                MsMsScan msmsSc = new MsMsScan(params.getPeaksCount(), params.getSpectrumIndex(), params.getMsLevel(), scanStartTimes.get(0).floatValue(), params.getLowMz(), params.getHighMz(), params.getBasePeakMz(), params.getBasePeakIntensity(), params.getTotalIonCurrent(), this.getPrecursorMzString(precursor.getPrecursorMz()), 0.0f, params.getPolarity());
                Vector<CgScan> qualifiedBaseScans = new Vector<CgScan>();
                Vector<Range> qualifiedRanges = new Vector<Range>();
                Vector<CgScan> ms2Scans = new Vector<CgScan>();
                for (j = 0; j != helper.getScans().size(); ++j) {
                    float precMz;
                    Range range = helper.getRanges().get(j);
                    if (!range.insideRange(Float.valueOf(precMz = msmsSc.getMs1PrecursorMz()).floatValue())) continue;
                    qualifiedBaseScans.add(helper.getScans().get(j));
                    qualifiedRanges.add(range);
                    ms2Scans.add(new MsMsScan(msmsSc));
                }
                if (qualifiedBaseScans.size() > 0) {
                    this.readPeaks(ms2Scans, qualifiedRanges, true, params);
                    for (j = 0; j != qualifiedBaseScans.size(); ++j) {
                        ((CgScan)qualifiedBaseScans.get(j)).AddSubscan(ms2Scans.get(j));
                    }
                    if (params.getMsLevel() > this.myHeader_.highestMSLevel) {
                        this.myHeader_.highestMSLevel = params.getMsLevel();
                    }
                }
            } else {
                for (CgScan scBase : helper.getScans()) {
                    scBase.AddSubscanNumber(params.getSpectrumIndex());
                }
            }
        } else {
            throw new CgException("No base scan for subscan.");
        }
    }

    private void readMS1BinaryDataArray(CgScan sc, SpectrumParams params, Precursor precursor, Vector<Float> scanStartTimes) throws CgException {
        sc = new CgScan(0, params.getSpectrumIndex() + 1, params.getMsLevel(), scanStartTimes.get(0).floatValue(), params.getLowMz(), params.getHighMz(), params.getBasePeakMz(), params.getBasePeakIntensity(), params.getTotalIonCurrent(), params.getPolarity());
        if (this.adders_ != null && this.adders_.length > 0) {
            AddScanHelper helper = new AddScanHelper();
            helper.init(this.adders_, sc);
            this.readPeaks(helper.getScans(), helper.getRanges(), false, params);
            for (int j = 0; j != this.adders_.length; ++j) {
                AddScan adder = this.adders_[j];
                sc = helper.getScans().get(j);
                this.setCurrentGlobalMaxima(sc.LowMz, sc.HighMz);
                adder.AddScan(sc);
            }
        } else {
            throw new CgException("No adder for Header and Scans defined.");
        }
    }

    private void parseSpectrum(SpectrumParams params) throws CgException {
        params.setSpectrumIndex(Integer.parseInt(this.getRequiredAttribute(this.reader_, ATTRIBUTE_INDEX)) + 1);
        params.setPeaksCount(Integer.parseInt(this.getRequiredAttribute(this.reader_, ATTRIBUTE_DEFAULT_ARRAY_LENGTH)));
        try {
            while (this.reader_.hasNext()) {
                if (this.reader_.next() != 1) continue;
                if (this.reader_.getLocalName().equalsIgnoreCase(TAG_CV_PARAM)) {
                    this.parseSpectrumCVParams(params);
                    continue;
                }
                return;
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new CgException(ex.getMessage());
        }
    }

    private void parseSpectrumCVParams(SpectrumParams params) throws IOException {
        switch (this.getRequiredAttribute(this.reader_, ATTRIBUTE_NAME)) {
            case "ms level": {
                params.setMsLevel(this.parseIntegerValue(ENTRY_MS_LEVEL, ATTRIBUTE_VALUE));
                break;
            }
            case "positive scan": {
                params.setPolarity(1);
                break;
            }
            case "negative scan": {
                params.setPolarity(2);
                break;
            }
            case "base peak m/z": {
                params.setBasePeakMz(this.parseFloatValue(ENTRY_BASE_PEAK_MZ, ATTRIBUTE_VALUE));
                break;
            }
            case "base peak intensity": {
                params.setBasePeakIntensity(this.parseFloatValue(ENTRY_BASE_PEAK_INTENSITY, ATTRIBUTE_VALUE));
                break;
            }
            case "total ion current": {
                params.setTotalIonCurrent(this.parseFloatValue(ENTRY_TOTAL_ION_CURRENT, ATTRIBUTE_VALUE));
                break;
            }
            case "lowest observed m/z": {
                params.setLowMz(this.parseFloatValue(ENTRY_LOWEST_OBSERVED_MZ, ATTRIBUTE_VALUE));
                params.setLowMzFound(true);
                break;
            }
            case "highest observed m/z": {
                params.setHighMz(this.parseFloatValue(ENTRY_HIGHEST_OBSERVED_MZ, ATTRIBUTE_VALUE));
                params.setHighMzFound(true);
                break;
            }
        }
    }

    private void parseSpectrumCVParamsOverview(SpectrumParams params) throws IOException {
        switch (this.getRequiredAttribute(this.reader_, ATTRIBUTE_NAME)) {
            case "ms level": {
                params.setMsLevel(this.parseIntegerValue(ENTRY_MS_LEVEL, ATTRIBUTE_VALUE));
                break;
            }
            case "positive scan": {
                params.setPolarity(1);
                break;
            }
            case "negative scan": {
                params.setPolarity(2);
                break;
            }
            case "lowest observed m/z": {
                params.setLowMz(this.parseFloatValue(ENTRY_LOWEST_OBSERVED_MZ, ATTRIBUTE_VALUE));
                params.setLowMzFound(true);
                break;
            }
            case "highest observed m/z": {
                params.setHighMz(this.parseFloatValue(ENTRY_HIGHEST_OBSERVED_MZ, ATTRIBUTE_VALUE));
                params.setHighMzFound(true);
                break;
            }
            case "scan start time": {
                if (params.getSpectrumIndex() == 0) {
                    this.myHeader_.StartTime = this.convertTimeFormat(this.reader_.getAttributeValue(null, ATTRIBUTE_VALUE), this.reader_.getAttributeValue(null, ATTRIBUTE_UNIT_NAME));
                    break;
                }
                if (params.getSpectrumIndex() != this.myHeader_.ScanCount - 1) break;
                this.myHeader_.EndTime = this.convertTimeFormat(this.reader_.getAttributeValue(null, ATTRIBUTE_VALUE), this.reader_.getAttributeValue(null, ATTRIBUTE_UNIT_NAME));
                break;
            }
        }
    }

    private void parseScanList(Vector<Float> scanStartTimes, SpectrumParams params) throws CgException {
        try {
            while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_CV_PARAM) && this.getRequiredAttribute(this.reader_, ATTRIBUTE_NAME).equals(ENTRY_SCAN_START_TIME)) {
                    float scanStartTime = this.convertTimeFormat(this.reader_.getAttributeValue(null, ATTRIBUTE_VALUE), this.reader_.getAttributeValue(null, ATTRIBUTE_UNIT_NAME));
                    scanStartTimes.add(Float.valueOf(scanStartTime));
                    if (params.getSpectrumIndex() == 0) {
                        this.myHeader_.StartTime = scanStartTime;
                    } else if (params.getSpectrumIndex() == this.myHeader_.ScanCount - 1) {
                        this.myHeader_.EndTime = scanStartTime;
                    }
                    this.reader_.next();
                    continue;
                }
                if (this.isEndElement(TAG_SCAN_LIST)) {
                    return;
                }
                this.reader_.next();
            }
        }
        catch (XMLStreamException ex) {
            throw new CgException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePrecursorList(Precursor precursor, int msLevel) throws CgException {
        if (msLevel < 3) {
            precursor.setPrecursorMz(new Vector<String>());
        } else if (precursor.getLastMsLevel() >= msLevel) {
            for (int i = precursor.getLastMsLevel() + 1; i > msLevel; --i) {
                precursor.removeLastPrecursorMz();
            }
        }
        precursor.setLastMsLevel(msLevel);
        try {
            block9: while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_CV_PARAM)) {
                    switch (this.getRequiredAttribute(this.reader_, ATTRIBUTE_NAME)) {
                        case "selected ion m/z": {
                            precursor.addPrecursorMz(this.reader_.getAttributeValue(null, ATTRIBUTE_VALUE));
                            precursor.setPrecursorMzFloat(this.parseFloatValue(ENTRY_SELECTED_ION_MZ, ATTRIBUTE_VALUE));
                            this.reader_.next();
                            continue block9;
                        }
                    }
                    this.reader_.next();
                    continue;
                }
                if (this.isEndElement(TAG_PRECURSOR_LIST)) {
                    return;
                }
                this.reader_.next();
            }
            return;
        }
        catch (IOException | XMLStreamException ex) {
            throw new CgException(ex.getMessage());
        }
    }

    private void evaluateScan(SpectrumParams params) {
        if (params.getMsLevel() == 1) {
            if (!params.isFoundMzBorders() && !this.myHeader_.hasMS1Scans) {
                this.setLowestMz(1000000000);
                this.setHighestMz(0);
            }
            this.myHeader_.hasMS1Scans = true;
        }
        if (params.getPolarity() != 0) {
            if (this.currentPolarity_ == 0) {
                this.currentPolarity_ = params.getPolarity();
            } else if (this.currentPolarity_ != params.getPolarity()) {
                this.setPolaritySwitching(true);
            }
        }
    }

    protected void readPeaks(Vector<CgScan> scans, Vector<Range> ranges, boolean msms, SpectrumParams params) throws CgException {
        float[] mzValueArray = new float[]{};
        float[] intensityValueArray = new float[]{};
        boolean mzValueArrayFound = false;
        boolean intensityValueArrayFound = false;
        String precision = null;
        String compression = null;
        String valueType = "";
        Hashtable mzValueHash = new Hashtable();
        Hashtable intensityValueHash = new Hashtable();
        for (int k = 0; k != scans.size(); ++k) {
            mzValueHash.put(k, new Vector());
            intensityValueHash.put(k, new Vector());
        }
        try {
            while (this.reader_.hasNext()) {
                if (this.isStartElement(TAG_CV_PARAM)) {
                    switch (this.getRequiredAttribute(this.reader_, ATTRIBUTE_NAME)) {
                        case "64-bit float": {
                            precision = ENTRY_64_BIT_FLOAT;
                            break;
                        }
                        case "32-bit float": {
                            precision = ENTRY_32_BIT_FLOAT;
                            break;
                        }
                        case "no compression": {
                            compression = ENTRY_NO_COMPRESSION;
                            break;
                        }
                        case "zlib compression": {
                            compression = ENTRY_ZLIB_COMPRESSION;
                            break;
                        }
                        case "m/z array": {
                            valueType = ENTRY_MZ_ARRAY;
                            break;
                        }
                        case "intensity array": {
                            valueType = ENTRY_INTENSITY_ARRAY;
                            break;
                        }
                    }
                } else if (this.isStartElement(TAG_BINARY) && valueType == ENTRY_MZ_ARRAY) {
                    if (this.reader_.next() != 4) {
                        return;
                    }
                    mzValueArray = this.decodeBinaryArray(precision, this.reader_.getText().trim(), compression);
                    mzValueArrayFound = true;
                } else if (this.isStartElement(TAG_BINARY) && valueType == ENTRY_INTENSITY_ARRAY) {
                    if (this.reader_.next() != 4) {
                        return;
                    }
                    intensityValueArray = this.decodeBinaryArray(precision, this.reader_.getText().trim(), compression);
                    intensityValueArrayFound = true;
                } else if (this.isEndElement(TAG_BINARY_DATA_ARRAY_LIST)) {
                    if (mzValueArrayFound && intensityValueArrayFound) {
                        for (int i = 0; i < params.getPeaksCount(); ++i) {
                            float mzValue = mzValueArray[i];
                            float intensityValue = intensityValueArray[i];
                            if (!msms && scans.size() > 1 && (mzValue < this.getMaxRange().getStart() || this.getMaxRange().getStop() <= mzValue)) continue;
                            for (int k = 0; k != scans.size(); ++k) {
                                if (!msms && (!(ranges.get(k).getStart() <= mzValue) || !(mzValue < ranges.get(k).getStop()))) continue;
                                ((Vector)mzValueHash.get(k)).add(Float.valueOf(mzValue));
                                ((Vector)intensityValueHash.get(k)).add(Float.valueOf(intensityValue));
                            }
                        }
                        for (int k = 0; k != scans.size(); ++k) {
                            CgScan scan = scans.get(k);
                            scan.PeaksCount = ((Vector)mzValueHash.get(k)).size();
                            scan.Scan = new float[scan.PeaksCount][2];
                            for (int i = 0; i != scan.PeaksCount; ++i) {
                                scan.Scan[i][0] = ((Float)((Vector)mzValueHash.get(k)).get(i)).floatValue();
                                scan.Scan[i][1] = ((Float)((Vector)intensityValueHash.get(k)).get(i)).floatValue();
                            }
                            if (scan.PeaksCount <= 0 || params.isFoundMzBorders()) continue;
                            scan.LowMz = mzValueArray[0];
                            scan.HighMz = mzValueArray[mzValueArray.length - 1];
                        }
                    }
                    return;
                }
                this.reader_.next();
            }
        }
        catch (Exception ex) {
            throw new CgException(ex.getMessage());
        }
    }

    private class Precursor {
        Vector<String> precursorMz_ = new Vector();
        private int lastMsLevel_ = 0;
        float precursorMzFloat_ = -1.0f;

        private Precursor() {
        }

        public Vector<String> getPrecursorMz() {
            return this.precursorMz_;
        }

        public void addPrecursorMz(String precursorMz) {
            this.precursorMz_.add(precursorMz);
        }

        public void setPrecursorMz(Vector<String> precursorMz) {
            this.precursorMz_ = precursorMz;
        }

        public void removeLastPrecursorMz() {
            this.precursorMz_.remove(this.precursorMz_.size() - 1);
        }

        public float getPrecursorMzFloat() {
            return this.precursorMzFloat_;
        }

        public void setPrecursorMzFloat(float precursorMzFloat) {
            this.precursorMzFloat_ = precursorMzFloat;
        }

        public int getLastMsLevel() {
            return this.lastMsLevel_;
        }

        public void setLastMsLevel(int lastMsLevel) {
            this.lastMsLevel_ = lastMsLevel;
        }
    }

    private class AddScanHelper {
        Vector<CgScan> scans_ = null;
        Vector<Range> ranges_ = null;

        private AddScanHelper() {
        }

        public void init(AddScan[] adders) {
            if (this.scans_ == null) {
                this.scans_ = new Vector();
                this.ranges_ = new Vector();
                for (AddScan adder : adders) {
                    if (adder.getLastBaseScan() == null) continue;
                    this.scans_.add(adder.getLastBaseScan());
                    this.ranges_.add(new Range(adder.getLowerThreshold(), adder.getUpperThreshold()));
                }
            }
        }

        public void init(AddScan[] adders, CgScan sc) {
            this.scans_ = new Vector();
            this.ranges_ = new Vector();
            for (AddScan adder : adders) {
                if (adders.length == 1) {
                    this.scans_.add(sc);
                } else {
                    this.scans_.add(new CgScan(sc));
                }
                this.ranges_.add(new Range(adder.getLowerThreshold(), adder.getUpperThreshold()));
            }
        }

        public Vector<CgScan> getScans() {
            return this.scans_;
        }

        public Vector<Range> getRanges() {
            return this.ranges_;
        }
    }

    private class SpectrumParams {
        int spectrumIndex_ = -1;
        int peaksCount_ = 0;
        int msLevel_ = 0;
        int polarity_ = 0;
        float basePeakMz_ = 0.0f;
        float basePeakIntensity_ = 0.0f;
        float totalIonCurrent_ = 0.0f;
        float lowMz_ = Float.MAX_VALUE;
        float highMz_ = 0.0f;
        boolean lowMzFound_ = false;
        boolean highMzFound_ = false;

        private SpectrumParams() {
        }

        public int getSpectrumIndex() {
            return this.spectrumIndex_;
        }

        public void setSpectrumIndex(int spectrumIndex) {
            this.spectrumIndex_ = spectrumIndex;
        }

        public int getPeaksCount() {
            return this.peaksCount_;
        }

        public void setPeaksCount(int peaksCount) {
            this.peaksCount_ = peaksCount;
        }

        public int getMsLevel() {
            return this.msLevel_;
        }

        public void setMsLevel(int msLevel) {
            this.msLevel_ = msLevel;
        }

        public int getPolarity() {
            return this.polarity_;
        }

        public void setPolarity(int polarity) {
            this.polarity_ = polarity;
        }

        public float getBasePeakMz() {
            return this.basePeakMz_;
        }

        public void setBasePeakMz(float basePeakMz) {
            this.basePeakMz_ = basePeakMz;
        }

        public float getBasePeakIntensity() {
            return this.basePeakIntensity_;
        }

        public void setBasePeakIntensity(float basePeakIntensity) {
            this.basePeakIntensity_ = basePeakIntensity;
        }

        public float getTotalIonCurrent() {
            return this.totalIonCurrent_;
        }

        public void setTotalIonCurrent(float totalIonCurrent) {
            this.totalIonCurrent_ = totalIonCurrent;
        }

        public float getLowMz() {
            return this.lowMz_;
        }

        public void setLowMz(float lowMz) {
            this.lowMz_ = lowMz;
        }

        public float getHighMz() {
            return this.highMz_;
        }

        public void setHighMz(float highMz) {
            this.highMz_ = highMz;
        }

        public void setLowMzFound(boolean lowMzFound) {
            this.lowMzFound_ = lowMzFound;
        }

        public void setHighMzFound(boolean highMzFound) {
            this.highMzFound_ = highMzFound;
        }

        public boolean isFoundMzBorders() {
            return this.highMzFound_ && this.lowMzFound_;
        }
    }
}

