/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.CV;
import de.isas.mztab2.model.IndexedElement;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class CvSerializer
extends StdSerializer<CV> {
    private static final Logger log = LoggerFactory.getLogger(CvSerializer.class);

    public CvSerializer() {
        this(null);
    }

    public CvSerializer(Class<CV> t) {
        super(t);
    }

    public void serializeWithType(CV value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(CV cv, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (cv != null) {
            Serializers.checkIndexedElement((IndexedElement)cv);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), CV.Properties.label.getPropertyName(), cv, cv.getLabel());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), CV.Properties.uri.getPropertyName(), cv, cv.getUri());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), CV.Properties.version.getPropertyName(), cv, cv.getVersion());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), CV.Properties.fullName.getPropertyName(), cv, cv.getFullName());
        } else {
            log.debug(CV.class.getSimpleName() + " is null!");
        }
    }
}

