/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Instrument;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class InstrumentSerializer
extends StdSerializer<Instrument> {
    private static final Logger log = LoggerFactory.getLogger(InstrumentSerializer.class);

    public InstrumentSerializer() {
        this(null);
    }

    public InstrumentSerializer(Class<Instrument> t) {
        super(t);
    }

    public void serializeWithType(Instrument value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(Instrument instrument, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (instrument != null) {
            Serializers.checkIndexedElement((IndexedElement)instrument);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Instrument.Properties.name.getPropertyName(), instrument, instrument.getName());
            Serializers.addLineWithPropertyParameters(jg, Section.Metadata.getPrefix(), Instrument.Properties.source.getPropertyName(), instrument, Arrays.asList(instrument.getSource()));
            if (instrument.getAnalyzer() != null) {
                Serializers.addSubElementStrings(jg, Section.Metadata.getPrefix(), instrument, Instrument.Properties.analyzer.getPropertyName(), instrument.getAnalyzer(), false);
            }
            if (instrument.getDetector() != null) {
                Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), Instrument.Properties.detector.getPropertyName(), instrument, instrument.getDetector());
            }
        } else {
            log.debug(Instrument.class.getSimpleName() + " is null!");
        }
    }
}

