/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class MsRunSerializer
extends StdSerializer<MsRun> {
    private static final Logger log = LoggerFactory.getLogger(MsRunSerializer.class);

    public MsRunSerializer() {
        this(null);
    }

    public MsRunSerializer(Class<MsRun> t) {
        super(t);
    }

    public void serializeWithType(MsRun value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(MsRun msRun, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (msRun != null) {
            Serializers.checkIndexedElement((IndexedElement)msRun);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), MsRun.Properties.name.getPropertyName(), msRun, msRun.getName());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), MsRun.Properties.location.getPropertyName(), msRun, msRun.getLocation());
            if (msRun.getInstrumentRef() != null) {
                Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), MsRun.Properties.instrumentRef.getPropertyName(), msRun, Metadata.Properties.instrument.getPropertyName() + "[" + msRun.getInstrumentRef().getId() + "]");
            }
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), MsRun.Properties.hash.getPropertyName(), msRun, msRun.getHash());
            Serializers.addSubElementParameter(jg, Section.Metadata.getPrefix(), msRun, MsRun.Properties.hashMethod.getPropertyName(), msRun.getHashMethod());
            Serializers.addSubElementParameter(jg, Section.Metadata.getPrefix(), msRun, MsRun.Properties.format.getPropertyName(), msRun.getFormat());
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), msRun, MsRun.Properties.fragmentationMethod.getPropertyName(), msRun.getFragmentationMethod(), false);
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), msRun, MsRun.Properties.scanPolarity.getPropertyName(), msRun.getScanPolarity(), false);
            Serializers.addSubElementParameter(jg, Section.Metadata.getPrefix(), msRun, MsRun.Properties.idFormat.getPropertyName(), msRun.getIdFormat());
        } else {
            log.debug(MsRun.class.getSimpleName() + " is null!");
        }
    }
}

