/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.Publication;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class PublicationSerializer
extends StdSerializer<Publication> {
    private static final Logger log = LoggerFactory.getLogger(PublicationSerializer.class);

    public PublicationSerializer() {
        this(null);
    }

    public PublicationSerializer(Class<Publication> t) {
        super(t);
    }

    public void serializeWithType(Publication value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(Publication publication, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (publication != null) {
            Serializers.checkIndexedElement((IndexedElement)publication);
            Serializers.addLine(jg, Section.Metadata.getPrefix(), Metadata.Properties.publication + "[" + publication.getId() + "]", Optional.ofNullable(publication.getPublicationItems()).orElse(Collections.emptyList()).stream().map(pitem -> pitem.getType().getValue() + ":" + pitem.getAccession()).collect(Collectors.joining("|", "", "")));
        } else {
            log.debug(Publication.class.getSimpleName() + " is null!");
        }
    }
}

