/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.io.serialization.ElementNameMappingException;
import de.isas.mztab2.io.serialization.ParameterConverter;
import de.isas.mztab2.io.serialization.UriConverter;
import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.StudyVariable;
import de.isas.mztab2.model.Uri;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.MetadataElement;
import uk.ac.ebi.pride.jmztab2.model.MetadataProperty;

public class Serializers {
    private static final Logger log = LoggerFactory.getLogger(Serializers.class);

    public static String getReference(Object element, Integer idx) {
        StringBuilder sb = new StringBuilder();
        sb.append(Serializers.getElementName(element).orElseThrow(() -> new IllegalArgumentException("No mzTab element name mapping available for " + element.getClass().getName())));
        return sb.toString();
    }

    public static String printAbundanceAssay(Assay a) {
        StringBuilder sb = new StringBuilder();
        return sb.append("abundance_assay[").append(a.getId()).append("]").toString();
    }

    public static String printAbundanceStudyVar(StudyVariable sv) {
        StringBuilder sb = new StringBuilder();
        return sb.append("abundance_study_variable[").append(sv.getId()).append("]").toString();
    }

    public static String printAbundanceCoeffVarStudyVar(StudyVariable sv) {
        StringBuilder sb = new StringBuilder();
        return sb.append("abundance_coeffvar_study_variable[").append(sv.getId()).append("]").toString();
    }

    public static String printOptColumnMapping(OptColumnMapping ocm) {
        StringBuilder sb = new StringBuilder();
        log.debug("Identifier={}; OptColumnMapping: {}", (Object)ocm.getIdentifier(), (Object)ocm);
        if ("global".equals(ocm.getIdentifier()) || ocm.getIdentifier().startsWith("global")) {
            sb.append("opt_");
            sb.append(ocm.getIdentifier());
            if (ocm.getParam() != null) {
                sb.append("_cv_").append(ocm.getParam().getCvAccession()).append("_").append(ocm.getParam().getName().replaceAll(" ", "_"));
            }
        } else {
            log.debug("OptColumnMapping: {}", (Object)ocm);
            sb.append(ocm.getIdentifier());
        }
        log.debug("asString: {}", (Object)sb.toString());
        return sb.toString();
    }

    public static <T extends IndexedElement> void addIndexedLine(JsonGenerator jg, SerializerProvider sp, String prefix, Object element, T indexedElement) {
        Serializers.addIndexedLine(jg, sp, prefix, element, Arrays.asList(indexedElement));
    }

    public static <T extends IndexedElement> void addIndexedLine(JsonGenerator jg, SerializerProvider sp, String prefix, Object element, List<T> indexedElementList) {
        Optional<List<T>> iel = Optional.ofNullable(indexedElementList);
        if (!iel.isPresent() || indexedElementList.isEmpty()) {
            log.debug("Skipping null or empty indexed element list values for {}", Serializers.getElementName(element));
            return;
        }
        try {
            jg.writeStartArray();
            jg.writeString(prefix);
            jg.writeString(Serializers.getElementName(element).orElseThrow(() -> new ElementNameMappingException("unknown", element)));
            jg.writeString(indexedElementList.stream().map(indexedElement -> {
                if (indexedElement instanceof Parameter) {
                    return new ParameterConverter().convert((Parameter)indexedElement);
                }
                if (indexedElement instanceof Uri) {
                    return new UriConverter().convert((Uri)indexedElement);
                }
                throw new IllegalArgumentException("Serialization of type " + indexedElement.getClass() + " currently not supported!");
            }).collect(Collectors.joining("|")));
            jg.writeEndArray();
        }
        catch (IOException ex) {
            log.error("Caught IO Exception while trying to write indexed line:", (Throwable)ex);
        }
    }

    public static void addLineWithParameters(JsonGenerator jg, String prefix, Object element, List<Parameter> parameterList) {
        if (parameterList == null || parameterList.isEmpty()) {
            log.debug("Skipping null or empty parameter list values for " + Serializers.getElementName(element));
            return;
        }
        try {
            jg.writeStartArray();
            jg.writeString(prefix);
            jg.writeString(Serializers.getElementName(element).orElseThrow(() -> new ElementNameMappingException("unknown", element)));
            jg.writeString(parameterList.stream().map(parameter -> new ParameterConverter().convert((Parameter)parameter)).collect(Collectors.joining("|")));
            jg.writeEndArray();
        }
        catch (IOException ex) {
            log.error("Caught IO Exception while trying to write line with parameters:", (Throwable)ex);
        }
    }

    public static void addLineWithPropertyParameters(JsonGenerator jg, String prefix, String propertyName, Object element, List<Parameter> value) {
        if (value == null || value.isEmpty()) {
            log.debug("Skipping null or empty values for {}", Serializers.getElementName(element));
            return;
        }
        Serializers.addLineWithProperty(jg, prefix, propertyName, element, value.stream().map(parameter -> new ParameterConverter().convert((Parameter)parameter)).collect(Collectors.joining("|")));
    }

    public static void addLineWithMetadataProperty(JsonGenerator jg, String prefix, MetadataProperty property, Object element, Object ... value) {
        Serializers.addLineWithProperty(jg, prefix, property.getName(), element, value);
    }

    public static void addLineWithNullProperty(JsonGenerator jg, String prefix, String propertyName, Object element) {
        try {
            jg.writeStartArray();
            jg.writeString(prefix);
            String key = Serializers.getElementName(element).orElseThrow(() -> new ElementNameMappingException(propertyName, element));
            if (propertyName == null) {
                jg.writeString(key);
            } else {
                jg.writeString(key + "-" + propertyName);
            }
            jg.writeString("null");
            jg.writeEndArray();
        }
        catch (IOException ex) {
            log.error("Caught exception while trying to write line with null property:", (Throwable)ex);
        }
    }

    public static void addLineWithProperty(JsonGenerator jg, String prefix, String propertyName, Object element, Object ... value) {
        if (value == null || value.length == 0) {
            log.debug("Skipping null or empty values for {}", Serializers.getElementName(element));
            return;
        }
        if (value.length == 1 && value[0] == null) {
            log.debug("Skipping empty value for {}", Serializers.getElementName(element));
            return;
        }
        try {
            jg.writeStartArray();
            jg.writeString(prefix);
            String key = Serializers.getElementName(element).orElseThrow(() -> new ElementNameMappingException(propertyName, element));
            if (propertyName == null) {
                jg.writeString(key);
            } else {
                jg.writeString(key + "-" + propertyName);
            }
            for (Object o : value) {
                jg.writeObject(o);
            }
            jg.writeEndArray();
        }
        catch (IOException ex) {
            log.error("Caught IO exception while trying to write line with property:", (Throwable)ex);
        }
    }

    public static void addLine(JsonGenerator jg, String prefix, Object element, Object ... value) {
        Serializers.addLineWithProperty(jg, prefix, null, element, value);
    }

    public static Optional<String> getElementName(Object element) {
        if (element instanceof String) {
            return Optional.of((String)element);
        }
        if (element instanceof MetadataElement) {
            return Optional.ofNullable(((MetadataElement)((Object)element)).getName());
        }
        JacksonXmlRootElement rootElement = element.getClass().getAnnotation(JacksonXmlRootElement.class);
        if (rootElement != null) {
            String underscoreName = Serializers.camelCaseToUnderscoreLowerCase(rootElement.localName());
            if (element instanceof IndexedElement) {
                Integer id = Optional.ofNullable(((IndexedElement)element).getId()).orElseThrow(() -> new NullPointerException("Field 'id' must not be null for element '" + underscoreName + "'!"));
                return Optional.of(underscoreName + "[" + id + "]");
            }
            return Optional.ofNullable(underscoreName);
        }
        return Optional.empty();
    }

    public static List<String> getPropertyNames(Object element) {
        return Arrays.asList((JsonProperty[])element.getClass().getAnnotationsByType(JsonProperty.class)).stream().map(jsonProperty -> jsonProperty.value()).collect(Collectors.toList());
    }

    public static Map<String, Object> asMap(Object element) {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.convertValue(element, Map.class);
    }

    public static String camelCaseToUnderscoreLowerCase(String camelCase) {
        Matcher m = Pattern.compile("(?<=[a-z])[A-Z]").matcher(camelCase);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + m.group().toLowerCase());
        }
        m.appendTail(sb);
        return sb.toString().toLowerCase();
    }

    public static void addSubElementStrings(JsonGenerator jg, String prefix, Object element, String subElementName, List<?> subElements, boolean oneLine) {
        if (Serializers.checkForNull(element, subElements, subElementName)) {
            return;
        }
        Serializers.getElementName(element).ifPresent(elementName -> {
            if (oneLine) {
                Serializers.addLine(jg, prefix, elementName + "-" + subElementName, subElements.stream().map(t -> t.toString()).collect(Collectors.joining("|")));
            } else {
                IntStream.range(0, subElements.size()).forEachOrdered(i -> Serializers.addLine(jg, prefix, elementName + "-" + subElementName + "[" + (i + 1) + "]", subElements.get(i)));
            }
        });
    }

    public static void addSubElementParameter(JsonGenerator jg, String prefix, Object element, String subElementName, Parameter subElement) {
        if (subElement == null) {
            String elementName = Serializers.getElementName(element).orElse("undefined");
            log.debug("''{}-{}'' is null or empty!", new Object[]{elementName, subElementName});
            return;
        }
        Serializers.addSubElementStrings(jg, prefix, element, subElementName, Arrays.asList(new ParameterConverter().convert(subElement)), true);
    }

    public static void addSubElementParameters(JsonGenerator jg, String prefix, Object element, String subElementName, List<Parameter> subElements, boolean oneLine) {
        if (Serializers.checkForNull(element, subElements, subElementName)) {
            return;
        }
        Serializers.addSubElementStrings(jg, prefix, element, subElementName, subElements.stream().map(parameter -> {
            try {
                return new ParameterConverter().convert((Parameter)parameter);
            }
            catch (IllegalArgumentException npe) {
                log.debug("parameter is null for {}", (Object)subElementName);
                return "null";
            }
        }).collect(Collectors.toList()), oneLine);
    }

    public static boolean checkForNull(Object element, List<?> subElements, String subElementName) {
        String elementName = Serializers.getElementName(element).orElse("undefined");
        if (subElements == null || subElements.isEmpty()) {
            log.debug("''{}-{}'' is null or empty!", new Object[]{elementName, subElementName});
            return true;
        }
        return false;
    }

    public static void writeString(String columnName, JsonGenerator jg, String value) throws IOException {
        if (value == null) {
            jg.writeNullField(columnName);
        } else {
            jg.writeStringField(columnName, value);
        }
    }

    public static void writeString(IMZTabColumn column, JsonGenerator jg, String value) throws IOException {
        Serializers.writeString(column.getHeader(), jg, value);
    }

    public static void writeObject(String columnName, JsonGenerator jg, SerializerProvider sp, Object value) throws IOException {
        if (value == null) {
            jg.writeNullField(columnName);
        } else if (value instanceof Parameter) {
            jg.writeStringField(columnName, new ParameterConverter().convert((Parameter)value));
        } else if (value instanceof String) {
            jg.writeStringField(columnName, (String)value);
        } else {
            throw new IllegalArgumentException("Serialization of objects of type " + value.getClass() + " currently not supported!");
        }
    }

    public static void writeObject(IMZTabColumn column, JsonGenerator jg, SerializerProvider sp, Object value) throws IOException {
        Serializers.writeObject(column.getHeader(), jg, sp, value);
    }

    public static void writeAsNumberArray(IMZTabColumn column, JsonGenerator jg, List<? extends Number> elements) {
        Serializers.writeAsNumberArray(column.getHeader(), jg, elements);
    }

    public static void writeAsNumberArray(String columnName, JsonGenerator jg, List<? extends Number> elements) {
        try {
            if (elements == null) {
                jg.writeNullField(columnName);
            } else {
                String arrayElements = elements.stream().map(number -> {
                    if (number == null) {
                        return "null";
                    }
                    if (number instanceof Short) {
                        return "" + number.shortValue();
                    }
                    if (number instanceof Integer) {
                        return "" + number.intValue();
                    }
                    if (number instanceof Long) {
                        return "" + number.longValue();
                    }
                    if (number instanceof Float) {
                        return "" + number.floatValue();
                    }
                    return "" + number.doubleValue();
                }).collect(Collectors.joining("|"));
                if (arrayElements.isEmpty()) {
                    jg.writeNullField(columnName);
                } else {
                    jg.writeStringField(columnName, arrayElements);
                }
            }
        }
        catch (IOException ex) {
            log.error("Caught IO exception while trying to write as number array: ", (Throwable)ex);
        }
    }

    public static void writeAsStringArray(IMZTabColumn column, JsonGenerator jg, List<String> elements) {
        Serializers.writeAsStringArray(column.getHeader(), jg, elements);
    }

    public static void writeAsStringArray(JsonGenerator jg, List<String> elements) {
        try {
            if (elements == null) {
                jg.writeNull();
            } else {
                String arrayElements = elements.stream().map(t -> {
                    if (t == null) {
                        return "null";
                    }
                    return t;
                }).collect(Collectors.joining("|"));
                if (arrayElements.isEmpty()) {
                    jg.writeNull();
                } else {
                    jg.writeString(arrayElements);
                }
            }
        }
        catch (IOException ex) {
            log.error("Error while trying to write as string array:", (Throwable)ex);
        }
    }

    public static void writeAsStringArray(String columnName, JsonGenerator jg, List<String> elements) {
        try {
            if (elements == null) {
                jg.writeNullField(columnName);
            } else {
                String arrayElements = elements.stream().map(t -> {
                    if (t == null) {
                        return "null";
                    }
                    return t;
                }).collect(Collectors.joining("|"));
                if (arrayElements.isEmpty()) {
                    jg.writeNullField(columnName);
                } else {
                    jg.writeStringField(columnName, arrayElements);
                }
            }
        }
        catch (IOException ex) {
            log.error("Error while trying to write as string array: ", (Throwable)ex);
        }
    }

    public static void writeNumber(String columnName, JsonGenerator jg, Integer value) throws IOException {
        if (value == null) {
            jg.writeNullField(columnName);
        } else {
            jg.writeNumberField(columnName, value.intValue());
        }
    }

    public static void writeNumber(IMZTabColumn column, JsonGenerator jg, Integer value) throws IOException {
        Serializers.writeNumber(column.getHeader(), jg, value);
    }

    public static void writeNumber(String columnName, JsonGenerator jg, Double value) throws IOException {
        if (value == null) {
            jg.writeNullField(columnName);
        } else if (value.equals(Double.NaN)) {
            jg.writeStringField(columnName, "NaN");
        } else if (value.equals(Double.POSITIVE_INFINITY)) {
            jg.writeStringField(columnName, "INF");
        } else {
            jg.writeNumberField(columnName, value.doubleValue());
        }
    }

    public static void writeNumber(IMZTabColumn column, JsonGenerator jg, Double value) throws IOException {
        Serializers.writeNumber(column.getHeader(), jg, value);
    }

    public static void writeNumber(JsonGenerator jg, Integer value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else {
            jg.writeNumber(value.intValue());
        }
    }

    public static void writeNumber(JsonGenerator jg, Double value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else {
            jg.writeNumber(value.doubleValue());
        }
    }

    public static void writeOptColumnMappings(List<OptColumnMapping> optColumnMappings, JsonGenerator jg, SerializerProvider sp) throws IOException {
        for (OptColumnMapping ocm : Optional.ofNullable(optColumnMappings).orElse(Collections.emptyList())) {
            if (ocm.getParam() != null) {
                Serializers.writeObject(Serializers.printOptColumnMapping(ocm), jg, sp, (Object)(ocm.getValue() == null ? (ocm.getParam().getValue() == null || ocm.getParam().getValue().isEmpty() ? "null" : ocm.getParam().getValue()) : ocm.getValue()));
                continue;
            }
            Serializers.writeObject(Serializers.printOptColumnMapping(ocm), jg, sp, (Object)(ocm.getValue() == null ? "null" : ocm.getValue()));
        }
    }

    public static void writeIndexedDoubles(String prefix, JsonGenerator jg, List<Double> values) {
        IntStream.range(0, values.size()).forEachOrdered(i -> {
            try {
                Serializers.writeNumber(prefix + "[" + (i + 1) + "]", jg, (Double)values.get(i));
            }
            catch (IOException ex) {
                log.error("Caught IO exception while trying to write indexed doubles:", (Throwable)ex);
            }
        });
    }

    public static void checkIndexedElement(IndexedElement element) {
        Integer id = Optional.ofNullable(element.getId()).orElseThrow(() -> new ValidationException("'id' field of " + element.toString() + " must not be null!"));
        if (id < 1) {
            throw new ValidationException("'id' field of " + element.toString() + " must have a value greater to equal to 1!");
        }
    }
}

