/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.validators;

import de.isas.mztab2.io.validators.RefiningValidator;
import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.Metadata;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class AssayValidator
implements RefiningValidator<Metadata> {
    @Override
    public List<MZTabError> validateRefine(Metadata metadata, MZTabParserContext parserContext) {
        SortedMap<Integer, Assay> assayMap = parserContext.getAssayMap();
        LinkedList<MZTabError> errorList = new LinkedList<MZTabError>();
        if (assayMap.isEmpty()) {
            errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.assay + ""}));
        }
        for (Integer id : assayMap.keySet()) {
            if (((Assay)assayMap.get(id)).getMsRunRef() != null && !((Assay)assayMap.get(id)).getMsRunRef().isEmpty()) continue;
            errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.assay + "[" + id + "]-" + Assay.Properties.msRunRef}));
        }
        return errorList;
    }
}

