/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.SmallMoleculeEvidence;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.ISmallMoleculeEvidenceColumn;
import uk.ac.ebi.pride.jmztab2.model.MZBoolean;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.OptionColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeEvidenceColumn;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabDataLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;
import uk.ac.ebi.pride.jmztab2.utils.parser.PositionMapping;

public class SMELineParser
extends MZTabDataLineParser<SmallMoleculeEvidence> {
    private SmallMoleculeEvidence smallMoleculeEvidence;

    public SMELineParser(MZTabParserContext context, MZTabColumnFactory factory, PositionMapping positionMapping, Metadata metadata, MZTabErrorList errorList) {
        super(context, factory, positionMapping, metadata, errorList);
    }

    @Override
    protected int checkData() {
        int physicalPosition;
        this.smallMoleculeEvidence = new SmallMoleculeEvidence();
        for (physicalPosition = 1; physicalPosition < this.items.length; ++physicalPosition) {
            String logicalPosition = this.positionMapping.get(physicalPosition);
            IMZTabColumn column = (IMZTabColumn)this.factory.getColumnMapping().get(logicalPosition);
            if (column == null) continue;
            String columnName = column.getName();
            String target = this.items[physicalPosition];
            if (column instanceof ISmallMoleculeEvidenceColumn) {
                SmallMoleculeEvidenceColumn.Stable stableColumn = SmallMoleculeEvidenceColumn.Stable.forName(columnName);
                switch (stableColumn) {
                    case ADDUCT_ION: {
                        this.smallMoleculeEvidence.adductIon(this.checkString(column, target));
                        break;
                    }
                    case CHARGE: {
                        this.smallMoleculeEvidence.charge(this.checkInteger(column, this.checkData(column, target, false)));
                        break;
                    }
                    case CHEMICAL_FORMULA: {
                        this.smallMoleculeEvidence.chemicalFormula(this.checkString(column, target));
                        break;
                    }
                    case CHEMICAL_NAME: {
                        this.smallMoleculeEvidence.chemicalName(this.checkString(column, target));
                        break;
                    }
                    case DATABASE_IDENTIFIER: {
                        this.smallMoleculeEvidence.databaseIdentifier(this.checkString(column, target, true));
                        break;
                    }
                    case DERIVATIZED_FORM: {
                        this.smallMoleculeEvidence.derivatizedForm(this.checkParameter(column, target, true));
                        break;
                    }
                    case EVIDENCE_INPUT_ID: {
                        this.smallMoleculeEvidence.evidenceInputId(this.checkString(column, target, false));
                        break;
                    }
                    case EXP_MASS_TO_CHARGE: {
                        this.smallMoleculeEvidence.expMassToCharge(this.checkDouble(column, target, false));
                        break;
                    }
                    case IDENTIFICATION_METHOD: {
                        this.smallMoleculeEvidence.identificationMethod(this.checkParameter(column, target, false));
                        break;
                    }
                    case INCHI: {
                        this.smallMoleculeEvidence.inchi(this.checkString(column, target));
                        break;
                    }
                    case MS_LEVEL: {
                        this.smallMoleculeEvidence.msLevel(this.checkParameter(column, target, false));
                        break;
                    }
                    case RANK: {
                        this.smallMoleculeEvidence.rank(this.checkInteger(column, target, false));
                        break;
                    }
                    case SME_ID: {
                        this.smallMoleculeEvidence.smeId(this.checkInteger(column, target, false));
                        break;
                    }
                    case SMILES: {
                        this.smallMoleculeEvidence.smiles(this.checkString(column, target));
                        break;
                    }
                    case SPECTRA_REF: {
                        this.smallMoleculeEvidence.spectraRef(this.checkSpectraRef(this.context, column, target, false));
                        break;
                    }
                    case THEORETICAL_MASS_TO_CHARGE: {
                        this.smallMoleculeEvidence.theoreticalMassToCharge(this.checkDouble(column, target, false));
                        break;
                    }
                    case URI: {
                        this.smallMoleculeEvidence.uri(this.checkURI(column, target));
                    }
                }
                continue;
            }
            if (column instanceof OptionColumn) {
                if (!columnName.startsWith("opt_")) continue;
                Class<?> dataType = column.getDataType();
                OptColumnMapping optColMapping = new OptColumnMapping();
                optColMapping.identifier(columnName.substring("opt_".length()));
                if (dataType.equals(String.class)) {
                    optColMapping.value(this.checkString(column, target));
                } else if (dataType.equals(Double.class)) {
                    optColMapping.value(Double.toString(this.checkDouble(column, target)));
                } else if (dataType.equals(MZBoolean.class)) {
                    optColMapping.value(Boolean.toString(this.checkMZBoolean(column, target).toBoolean()));
                }
                this.smallMoleculeEvidence.addOptItem(optColMapping);
                continue;
            }
            if (!column.getName().equals(SmallMoleculeEvidence.Properties.idConfidenceMeasure.getPropertyName())) continue;
            this.smallMoleculeEvidence.addIdConfidenceMeasureItem(this.checkDouble(column, target));
        }
        return physicalPosition;
    }

    @Override
    public SmallMoleculeEvidence getRecord() {
        if (this.smallMoleculeEvidence == null) {
            this.smallMoleculeEvidence = new SmallMoleculeEvidence();
        }
        return this.smallMoleculeEvidence;
    }
}

