/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.SmallMoleculeSummary;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.jmztab2.model.AbundanceColumn;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.ISmallMoleculeColumn;
import uk.ac.ebi.pride.jmztab2.model.MZBoolean;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.OptionColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeColumn;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorList;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabErrorOverflowException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabDataLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;
import uk.ac.ebi.pride.jmztab2.utils.parser.PositionMapping;

public class SMLLineParser
extends MZTabDataLineParser<SmallMoleculeSummary> {
    private SmallMoleculeSummary smallMoleculeSummary;

    public SMLLineParser(MZTabParserContext context, MZTabColumnFactory factory, PositionMapping positionMapping, Metadata metadata, MZTabErrorList errorList) {
        super(context, factory, positionMapping, metadata, errorList);
    }

    @Override
    protected int checkData() {
        int physicalPosition;
        this.smallMoleculeSummary = new SmallMoleculeSummary();
        for (physicalPosition = 1; physicalPosition < this.items.length; ++physicalPosition) {
            String logicalPosition = this.positionMapping.get(physicalPosition);
            IMZTabColumn column = (IMZTabColumn)this.factory.getColumnMapping().get(logicalPosition);
            if (column == null) continue;
            String columnName = column.getName();
            String target = this.items[physicalPosition];
            if (column instanceof ISmallMoleculeColumn) {
                SmallMoleculeColumn.Stable stableColumn = SmallMoleculeColumn.Stable.forName(columnName);
                switch (stableColumn) {
                    case ADDUCT_IONS: {
                        List<String> adductIons = this.checkStringList(column, target, '|');
                        this.checkRegexMatches(this.errorList, this.lineNumber, SmallMoleculeSummary.Properties.adductIons, "^\\[\\d*M([+-][\\w\\d]+)*\\]\\d*[+-]$", adductIons);
                        this.smallMoleculeSummary.adductIons(adductIons);
                        break;
                    }
                    case BEST_ID_CONFIDENCE_MEASURE: {
                        this.smallMoleculeSummary.bestIdConfidenceMeasure(this.checkParameter(column, target, true));
                        break;
                    }
                    case BEST_ID_CONFIDENCE_VALUE: {
                        this.smallMoleculeSummary.bestIdConfidenceValue(this.checkDouble(column, target));
                        break;
                    }
                    case CHEMICAL_FORMULA: {
                        this.smallMoleculeSummary.chemicalFormula(this.checkStringList(column, target, '|'));
                        break;
                    }
                    case CHEMICAL_NAME: {
                        this.smallMoleculeSummary.chemicalName(this.checkStringList(column, target, '|'));
                        break;
                    }
                    case DATABASE_IDENTIFIER: {
                        this.smallMoleculeSummary.databaseIdentifier(this.checkStringList(column, target, '|'));
                        break;
                    }
                    case INCHI: {
                        this.smallMoleculeSummary.inchi(this.checkStringList(column, target, '|'));
                        break;
                    }
                    case RELIABILITY: {
                        this.smallMoleculeSummary.reliability(this.checkString(column, target, false));
                        break;
                    }
                    case SMF_ID_REFS: {
                        this.smallMoleculeSummary.smfIdRefs(this.checkIntegerList(column, target, '|'));
                        break;
                    }
                    case SMILES: {
                        this.smallMoleculeSummary.smiles(this.checkSmiles(column, target));
                        break;
                    }
                    case SML_ID: {
                        this.smallMoleculeSummary.smlId(this.checkInteger(column, target, false));
                        break;
                    }
                    case THEOR_NEUTRAL_MASS: {
                        this.smallMoleculeSummary.theoreticalNeutralMass(this.checkDoubleList(column, target));
                        break;
                    }
                    case URI: {
                        this.smallMoleculeSummary.uri(this.checkStringList(column, target, '|'));
                    }
                }
                continue;
            }
            if (column instanceof AbundanceColumn) {
                if (columnName.startsWith(SmallMoleculeSummary.Properties.abundanceAssay.getPropertyName())) {
                    this.smallMoleculeSummary.addAbundanceAssayItem(this.checkDouble(column, target));
                    continue;
                }
                if (columnName.startsWith(SmallMoleculeSummary.Properties.abundanceStudyVariable.getPropertyName())) {
                    this.smallMoleculeSummary.addAbundanceStudyVariableItem(this.checkDouble(column, target));
                    continue;
                }
                if (!columnName.startsWith(SmallMoleculeSummary.Properties.abundanceVariationStudyVariable.getPropertyName())) continue;
                this.smallMoleculeSummary.addAbundanceVariationStudyVariableItem(this.checkDouble(column, target));
                continue;
            }
            if (!(column instanceof OptionColumn) || !columnName.startsWith("opt_")) continue;
            Class<?> dataType = column.getDataType();
            OptColumnMapping optColMapping = new OptColumnMapping();
            optColMapping.identifier(columnName.substring("opt_".length()));
            if (dataType.equals(String.class)) {
                optColMapping.value(this.checkString(column, target));
            } else if (dataType.equals(Double.class)) {
                optColMapping.value(Double.toString(this.checkDouble(column, target)));
            } else if (dataType.equals(MZBoolean.class)) {
                optColMapping.value(Boolean.toString(this.checkMZBoolean(column, target).toBoolean()));
            }
            this.smallMoleculeSummary.addOptItem(optColMapping);
        }
        this.checkItemNumbers(this.errorList, this.lineNumber, this.smallMoleculeSummary.getDatabaseIdentifier(), SmallMoleculeSummary.Properties.databaseIdentifier, this.smallMoleculeSummary.getChemicalFormula(), SmallMoleculeSummary.Properties.chemicalFormula);
        this.checkItemNumbers(this.errorList, this.lineNumber, this.smallMoleculeSummary.getDatabaseIdentifier(), SmallMoleculeSummary.Properties.databaseIdentifier, this.smallMoleculeSummary.getSmiles(), SmallMoleculeSummary.Properties.smiles);
        this.checkItemNumbers(this.errorList, this.lineNumber, this.smallMoleculeSummary.getDatabaseIdentifier(), SmallMoleculeSummary.Properties.databaseIdentifier, this.smallMoleculeSummary.getInchi(), SmallMoleculeSummary.Properties.inchi);
        this.checkItemNumbers(this.errorList, this.lineNumber, this.smallMoleculeSummary.getDatabaseIdentifier(), SmallMoleculeSummary.Properties.databaseIdentifier, this.smallMoleculeSummary.getChemicalName(), SmallMoleculeSummary.Properties.chemicalName);
        this.checkItemNumbers(this.errorList, this.lineNumber, this.smallMoleculeSummary.getDatabaseIdentifier(), SmallMoleculeSummary.Properties.databaseIdentifier, this.smallMoleculeSummary.getUri(), SmallMoleculeSummary.Properties.uri);
        this.checkItemNumbers(this.errorList, this.lineNumber, this.smallMoleculeSummary.getDatabaseIdentifier(), SmallMoleculeSummary.Properties.databaseIdentifier, this.smallMoleculeSummary.getTheoreticalNeutralMass(), SmallMoleculeSummary.Properties.theoreticalNeutralMass);
        return physicalPosition;
    }

    protected void checkRegexMatches(MZTabErrorList errorList, int lineNumber, SmallMoleculeSummary.Properties elementProperty, String regularExpression, List<String> elements) {
        if (!elements.isEmpty()) {
            Pattern p = Pattern.compile(regularExpression);
            for (int i = 0; i < elements.size(); ++i) {
                Matcher m;
                String element = elements.get(i);
                if ("null".equals(element) || (m = p.matcher(element)).matches()) continue;
                errorList.add(new MZTabError(FormatErrorType.RegexMismatch, lineNumber, new String[]{elementProperty.getPropertyName(), element, "" + (i + 1), regularExpression}));
            }
        }
    }

    protected void checkItemNumbers(MZTabErrorList errorList, int lineNumber, List<?> reference, SmallMoleculeSummary.Properties referenceProperty, List<?> toCheck, SmallMoleculeSummary.Properties toCheckProperty) throws MZTabErrorOverflowException {
        if (!toCheck.isEmpty() && reference.size() != toCheck.size()) {
            errorList.add(new MZTabError(LogicalErrorType.ItemNumberMismatch, lineNumber, new String[]{toCheckProperty.getPropertyName(), "" + toCheck.size(), referenceProperty.getPropertyName(), "" + reference.size()}));
        }
    }

    @Override
    public SmallMoleculeSummary getRecord() {
        if (this.smallMoleculeSummary == null) {
            this.smallMoleculeSummary = new SmallMoleculeSummary();
        }
        return this.smallMoleculeSummary;
    }
}

