/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.compression;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jogamp.java3d.utils.compression.CommandStream;
import org.jogamp.java3d.utils.compression.HuffmanNode;

class HuffmanTable {
    private static final int MAX_TAG_LENGTH = 6;
    private HuffmanNode[] positions;
    private HuffmanNode[] normals;
    private HuffmanNode[] colors = new HuffmanNode[544];

    HuffmanTable() {
        this.positions = new HuffmanNode[544];
        this.normals = new HuffmanNode[112];
    }

    private final int getPositionIndex(int len, int shift, boolean absolute) {
        return (absolute ? 1 : 0) * 272 + len * 16 + shift;
    }

    private final int getNormalIndex(int length, int shift, boolean absolute) {
        return (absolute ? 1 : 0) * 56 + length * 7 + shift;
    }

    private final int getColorIndex(int length, int shift, boolean absolute) {
        return this.getPositionIndex(length, shift, absolute);
    }

    void addPositionEntry(int length, int shift, boolean absolute) {
        this.addEntry(this.positions, this.getPositionIndex(length, shift, absolute), length, shift, absolute);
    }

    HuffmanNode getPositionEntry(int length, int shift, boolean absolute) {
        return this.getEntry(this.positions, this.getPositionIndex(length, shift, absolute));
    }

    void addColorEntry(int length, int shift, boolean absolute) {
        this.addEntry(this.colors, this.getColorIndex(length, shift, absolute), length, shift, absolute);
    }

    HuffmanNode getColorEntry(int length, int shift, boolean absolute) {
        return this.getEntry(this.colors, this.getColorIndex(length, shift, absolute));
    }

    void addNormalEntry(int length, int shift, boolean absolute) {
        this.addEntry(this.normals, this.getNormalIndex(length, shift, absolute), length, shift, absolute);
    }

    HuffmanNode getNormalEntry(int length, int shift, boolean absolute) {
        return this.getEntry(this.normals, this.getNormalIndex(length, shift, absolute));
    }

    private void addEntry(HuffmanNode[] table, int index, int length, int shift, boolean absolute) {
        if (table[index] == null) {
            table[index] = new HuffmanNode(length, shift, absolute);
        } else if (table[index].cleared()) {
            table[index].set(length, shift, absolute);
        }
        table[index].addCount();
    }

    private HuffmanNode getEntry(HuffmanNode[] table, int index) {
        HuffmanNode t = table[index];
        while (t.merged()) {
            t = t.getMergeNode();
        }
        return t;
    }

    private void getEntries(HuffmanNode[] table, Collection c) {
        int i = 0;
        while (i < table.length) {
            if (table[i] != null && !table[i].cleared() && table[i].hasCount() && !table[i].merged()) {
                c.add(table[i]);
            }
            ++i;
        }
    }

    void clear() {
        int i = 0;
        while (i < this.positions.length) {
            if (this.positions[i] != null) {
                this.positions[i].clear();
            }
            ++i;
        }
        i = 0;
        while (i < this.colors.length) {
            if (this.colors[i] != null) {
                this.colors[i].clear();
            }
            ++i;
        }
        i = 0;
        while (i < this.normals.length) {
            if (this.normals[i] != null) {
                this.normals[i].clear();
            }
            ++i;
        }
    }

    void computeTags() {
        LinkedList nodeList = new LinkedList();
        this.getEntries(this.positions, nodeList);
        this.computeTags(nodeList, 3);
        nodeList.clear();
        this.getEntries(this.colors, nodeList);
        this.computeTags(nodeList, 3);
        nodeList.clear();
        this.getEntries(this.normals, nodeList);
        this.computeTags(nodeList, 2);
    }

    private void computeTags(LinkedList nodes, int minComponentCount) {
        if (nodes.isEmpty()) {
            return;
        }
        while (true) {
            Collections.sort(nodes, HuffmanNode.frequencyComparator);
            HuffmanNode node0 = (HuffmanNode)nodes.removeFirst();
            while (nodes.size() > 0) {
                HuffmanNode node1 = (HuffmanNode)nodes.removeFirst();
                HuffmanNode node2 = new HuffmanNode();
                node2.addChildren(node0, node1);
                this.addNodeInOrder(nodes, node2, HuffmanNode.frequencyComparator);
                node0 = (HuffmanNode)nodes.removeFirst();
            }
            node0.collectLeaves(0, 0, nodes);
            Collections.sort(nodes, HuffmanNode.tagLengthComparator);
            if (((HuffmanNode)nodes.getFirst()).tagLength <= 6) break;
            this.merge(nodes);
        }
        this.expand(nodes, minComponentCount);
    }

    private void merge(LinkedList nodes) {
        ListIterator<HuffmanNode> i = nodes.listIterator(0);
        boolean index = false;
        while (i.hasNext()) {
            HuffmanNode node0 = (HuffmanNode)i.next();
            if (node0.unmergeable()) continue;
            i.remove();
            while (i.hasNext()) {
                HuffmanNode node1 = (HuffmanNode)i.next();
                if (!node0.mergeInto(node1)) continue;
                i.remove();
                while (i.hasNext()) {
                    HuffmanNode node2 = (HuffmanNode)i.next();
                    if (!node1.tokenEquals(node2)) continue;
                    node1.mergeInto(node2);
                    return;
                }
                i.add(node1);
                return;
            }
            node0.setUnmergeable();
            i.add(node0);
            i = nodes.listIterator(0);
        }
    }

    private void expand(LinkedList nodes, int minComponentCount) {
        for (HuffmanNode n : nodes) {
            while (n.tagLength + minComponentCount * (n.dataLength - n.shift) < 6) {
                n.incrementLength();
            }
        }
    }

    private void addNodeInOrder(LinkedList l, HuffmanNode node, Comparator c) {
        ListIterator<HuffmanNode> i = l.listIterator(0);
        while (i.hasNext()) {
            HuffmanNode n = (HuffmanNode)i.next();
            if (c.compare(n, node) <= 0) continue;
            n = (HuffmanNode)i.previous();
            break;
        }
        i.add(node);
    }

    void outputCommands(CommandStream output) {
        LinkedList nodeList = new LinkedList();
        this.getEntries(this.positions, nodeList);
        this.outputCommands(nodeList, output, 0);
        nodeList.clear();
        this.getEntries(this.colors, nodeList);
        this.outputCommands(nodeList, output, 1);
        nodeList.clear();
        this.getEntries(this.normals, nodeList);
        this.outputCommands(nodeList, output, 2);
    }

    private void outputCommands(Collection nodes, CommandStream output, int tableId) {
        for (HuffmanNode n : nodes) {
            int addressRange = 1 << n.tagLength | n.tag;
            int dataLength = n.dataLength == 16 ? 0 : n.dataLength;
            int command = 0x10 | tableId << 1 | addressRange >> 6;
            long body = (addressRange & 0x3F) << 9 | dataLength << 5 | (n.absolute ? 16 : 0) | n.shift;
            output.addCommand(command, 8, body, 15);
        }
    }

    void print(String header, Collection nodes) {
        System.out.println(String.valueOf(header) + "\nentries: " + nodes.size() + "\n");
        for (HuffmanNode n : nodes) {
            System.out.println(String.valueOf(n.toString()) + "\n");
        }
    }

    void print() {
        LinkedList nodeList = new LinkedList();
        this.getEntries(this.positions, nodeList);
        Collections.sort(nodeList, HuffmanNode.frequencyComparator);
        this.print("\nposition tokens and tags", nodeList);
        nodeList.clear();
        this.getEntries(this.colors, nodeList);
        Collections.sort(nodeList, HuffmanNode.frequencyComparator);
        this.print("\ncolor tokens and tags", nodeList);
        nodeList.clear();
        this.getEntries(this.normals, nodeList);
        Collections.sort(nodeList, HuffmanNode.frequencyComparator);
        this.print("\nnormal tokens and tags", nodeList);
    }
}

