/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Basic;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Tuple2f;

class Numerics {
    Numerics() {
    }

    static double max3(double a, double b, double c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    static double min3(double a, double b, double c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    static boolean lt(double a, double eps) {
        return a < -eps;
    }

    static boolean le(double a, double eps) {
        return a <= eps;
    }

    static boolean ge(double a, double eps) {
        return !(a <= -eps);
    }

    static boolean eq(double a, double eps) {
        return a <= eps && !(a < -eps);
    }

    static boolean gt(double a, double eps) {
        return !(a <= eps);
    }

    static double baseLength(Tuple2f u, Tuple2f v) {
        double x = v.x - u.x;
        double y = v.y - u.y;
        return Math.abs(x) + Math.abs(y);
    }

    static double sideLength(Tuple2f u, Tuple2f v) {
        double x = v.x - u.x;
        double y = v.y - u.y;
        return x * x + y * y;
    }

    static boolean inBetween(int i1, int i2, int i3) {
        return i1 <= i3 && i3 <= i2;
    }

    static boolean strictlyInBetween(int i1, int i2, int i3) {
        return i1 < i3 && i3 < i2;
    }

    static double stableDet2D(Triangulator triRef, int i, int j, int k) {
        double det;
        if (i == j || i == k || j == k) {
            det = 0.0;
        } else {
            Point2f numericsHP = triRef.points[i];
            Point2f numericsHQ = triRef.points[j];
            Point2f numericsHR = triRef.points[k];
            det = i < j ? (j < k ? Basic.det2D((Tuple2f)numericsHP, (Tuple2f)numericsHQ, (Tuple2f)numericsHR) : (i < k ? -Basic.det2D((Tuple2f)numericsHP, (Tuple2f)numericsHR, (Tuple2f)numericsHQ) : Basic.det2D((Tuple2f)numericsHR, (Tuple2f)numericsHP, (Tuple2f)numericsHQ))) : (i < k ? -Basic.det2D((Tuple2f)numericsHQ, (Tuple2f)numericsHP, (Tuple2f)numericsHR) : (j < k ? Basic.det2D((Tuple2f)numericsHQ, (Tuple2f)numericsHR, (Tuple2f)numericsHP) : -Basic.det2D((Tuple2f)numericsHR, (Tuple2f)numericsHQ, (Tuple2f)numericsHP)));
        }
        return det;
    }

    static int orientation(Triangulator triRef, int i, int j, int k) {
        double numericsHDet = Numerics.stableDet2D(triRef, i, j, k);
        int ori = Numerics.lt(numericsHDet, triRef.epsilon) ? -1 : (Numerics.gt(numericsHDet, triRef.epsilon) ? 1 : 0);
        return ori;
    }

    static boolean isInCone(Triangulator triRef, int i, int j, int k, int l, boolean convex) {
        boolean flag = true;
        if (convex) {
            if (i != j) {
                int numericsHOri1 = Numerics.orientation(triRef, i, j, l);
                if (numericsHOri1 < 0) {
                    flag = false;
                } else if (numericsHOri1 == 0) {
                    if (i < j) {
                        if (!Numerics.inBetween(i, j, l)) {
                            flag = false;
                        }
                    } else if (!Numerics.inBetween(j, i, l)) {
                        flag = false;
                    }
                }
            }
            if (j != k && flag) {
                int numericsHOri2 = Numerics.orientation(triRef, j, k, l);
                if (numericsHOri2 < 0) {
                    flag = false;
                } else if (numericsHOri2 == 0) {
                    if (j < k) {
                        if (!Numerics.inBetween(j, k, l)) {
                            flag = false;
                        }
                    } else if (!Numerics.inBetween(k, j, l)) {
                        flag = false;
                    }
                }
            }
        } else {
            int numericsHOri2;
            int numericsHOri1 = Numerics.orientation(triRef, i, j, l);
            if (numericsHOri1 <= 0 && (numericsHOri2 = Numerics.orientation(triRef, j, k, l)) < 0) {
                flag = false;
            }
        }
        return flag;
    }

    static int isConvexAngle(Triangulator triRef, int i, int j, int k, int ind) {
        int angle;
        if (i == j) {
            if (j == k) {
                return 1;
            }
            return 1;
        }
        if (j == k) {
            return -1;
        }
        int numericsHOri1 = Numerics.orientation(triRef, i, j, k);
        if (numericsHOri1 > 0) {
            angle = 1;
        } else if (numericsHOri1 < 0) {
            angle = -1;
        } else {
            Point2f numericsHP = new Point2f();
            Point2f numericsHQ = new Point2f();
            Basic.vectorSub2D((Tuple2f)triRef.points[i], (Tuple2f)triRef.points[j], (Tuple2f)numericsHP);
            Basic.vectorSub2D((Tuple2f)triRef.points[k], (Tuple2f)triRef.points[j], (Tuple2f)numericsHQ);
            double numericsHDot = Basic.dotProduct2D((Tuple2f)numericsHP, (Tuple2f)numericsHQ);
            angle = numericsHDot < 0.0 ? 0 : Numerics.spikeAngle(triRef, i, j, k, ind);
        }
        return angle;
    }

    static boolean pntInTriangle(Triangulator triRef, int i1, int i2, int i3, int i4) {
        boolean inside = false;
        int numericsHOri1 = Numerics.orientation(triRef, i2, i3, i4);
        if (numericsHOri1 >= 0 && (numericsHOri1 = Numerics.orientation(triRef, i1, i2, i4)) >= 0 && (numericsHOri1 = Numerics.orientation(triRef, i3, i1, i4)) >= 0) {
            inside = true;
        }
        return inside;
    }

    static boolean vtxInTriangle(Triangulator triRef, int i1, int i2, int i3, int i4, int[] type) {
        boolean inside = false;
        int numericsHOri1 = Numerics.orientation(triRef, i2, i3, i4);
        if (numericsHOri1 >= 0) {
            numericsHOri1 = Numerics.orientation(triRef, i1, i2, i4);
            if (numericsHOri1 > 0) {
                numericsHOri1 = Numerics.orientation(triRef, i3, i1, i4);
                if (numericsHOri1 > 0) {
                    inside = true;
                    type[0] = 0;
                } else if (numericsHOri1 == 0) {
                    inside = true;
                    type[0] = 1;
                }
            } else if (numericsHOri1 == 0) {
                numericsHOri1 = Numerics.orientation(triRef, i3, i1, i4);
                if (numericsHOri1 > 0) {
                    inside = true;
                    type[0] = 2;
                } else if (numericsHOri1 == 0) {
                    inside = true;
                    type[0] = 3;
                }
            }
        }
        return inside;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean segIntersect(Triangulator triRef, int i1, int i2, int i3, int i4, int i5) {
        if (i1 == i2 || i3 == i4) {
            return false;
        }
        if (i1 == i3 && i2 == i4) {
            return true;
        }
        if (i3 == i5 || i4 == i5) {
            ++triRef.identCntr;
        }
        int ori3 = Numerics.orientation(triRef, i1, i2, i3);
        int ori4 = Numerics.orientation(triRef, i1, i2, i4);
        if (ori3 == 1 && ori4 == 1 || ori3 == -1 && ori4 == -1) {
            return false;
        }
        if (ori3 == 0) {
            if (Numerics.strictlyInBetween(i1, i2, i3)) {
                return true;
            }
            if (ori4 != 0) return false;
            if (Numerics.strictlyInBetween(i1, i2, i4)) {
                return true;
            }
        } else if (ori4 == 0) {
            return Numerics.strictlyInBetween(i1, i2, i4);
        }
        int ori1 = Numerics.orientation(triRef, i3, i4, i1);
        int ori2 = Numerics.orientation(triRef, i3, i4, i2);
        return (ori1 > 0 || ori2 > 0) && (ori1 < 0 || ori2 < 0);
    }

    static double getRatio(Triangulator triRef, int i, int j, int k) {
        Point2f p = triRef.points[i];
        Point2f q = triRef.points[j];
        Point2f r = triRef.points[k];
        double a = Numerics.baseLength((Tuple2f)p, (Tuple2f)q);
        double b = Numerics.baseLength((Tuple2f)p, (Tuple2f)r);
        double c = Numerics.baseLength((Tuple2f)r, (Tuple2f)q);
        double base = Numerics.max3(a, b, c);
        if (10.0 * a < Math.min(b, c)) {
            return 0.1;
        }
        double area = Numerics.stableDet2D(triRef, i, j, k);
        if (Numerics.lt(area, triRef.epsilon)) {
            area = -area;
        } else if (!Numerics.gt(area, triRef.epsilon)) {
            if (base > a) {
                return 0.1;
            }
            return Double.MAX_VALUE;
        }
        double ratio = base * base / area;
        if (ratio < 10.0) {
            return ratio;
        }
        if (a < base) {
            return 0.1;
        }
        return ratio;
    }

    static int spikeAngle(Triangulator triRef, int i, int j, int k, int ind) {
        int ind2 = ind;
        int i2 = triRef.fetchData(ind2);
        int ind1 = triRef.fetchPrevData(ind2);
        int i1 = triRef.fetchData(ind1);
        int ind3 = triRef.fetchNextData(ind2);
        int i3 = triRef.fetchData(ind3);
        return Numerics.recSpikeAngle(triRef, i, j, k, ind1, ind3);
    }

    static int recSpikeAngle(Triangulator triRef, int i1, int i2, int i3, int ind1, int ind3) {
        if (ind1 == ind3) {
            return -2;
        }
        if (i1 != i3) {
            int ii2;
            int ii1;
            if (i1 < i2) {
                ii1 = i1;
                ii2 = i2;
            } else {
                ii1 = i2;
                ii2 = i1;
            }
            if (Numerics.inBetween(ii1, ii2, i3)) {
                i2 = i3;
                ind3 = triRef.fetchNextData(ind3);
                i3 = triRef.fetchData(ind3);
                if (ind1 == ind3) {
                    return 2;
                }
                int ori = Numerics.orientation(triRef, i1, i2, i3);
                if (ori > 0) {
                    return 2;
                }
                if (ori < 0) {
                    return -2;
                }
                return Numerics.recSpikeAngle(triRef, i1, i2, i3, ind1, ind3);
            }
            i2 = i1;
            ind1 = triRef.fetchPrevData(ind1);
            i1 = triRef.fetchData(ind1);
            if (ind1 == ind3) {
                return 2;
            }
            int ori = Numerics.orientation(triRef, i1, i2, i3);
            if (ori > 0) {
                return 2;
            }
            if (ori < 0) {
                return -2;
            }
            return Numerics.recSpikeAngle(triRef, i1, i2, i3, ind1, ind3);
        }
        int i0 = i2;
        i2 = i1;
        ind1 = triRef.fetchPrevData(ind1);
        i1 = triRef.fetchData(ind1);
        if (ind1 == ind3) {
            return 2;
        }
        ind3 = triRef.fetchNextData(ind3);
        i3 = triRef.fetchData(ind3);
        if (ind1 == ind3) {
            return 2;
        }
        int ori = Numerics.orientation(triRef, i1, i2, i3);
        if (ori > 0) {
            int ori2;
            int ori1 = Numerics.orientation(triRef, i1, i2, i0);
            if (ori1 > 0 && (ori2 = Numerics.orientation(triRef, i2, i3, i0)) > 0) {
                return -2;
            }
            return 2;
        }
        if (ori < 0) {
            int ori2;
            int ori1 = Numerics.orientation(triRef, i2, i1, i0);
            if (ori1 > 0 && (ori2 = Numerics.orientation(triRef, i3, i2, i0)) > 0) {
                return 2;
            }
            return -2;
        }
        Point2f pq = new Point2f();
        Basic.vectorSub2D((Tuple2f)triRef.points[i1], (Tuple2f)triRef.points[i2], (Tuple2f)pq);
        Point2f pr = new Point2f();
        Basic.vectorSub2D((Tuple2f)triRef.points[i3], (Tuple2f)triRef.points[i2], (Tuple2f)pr);
        double dot = Basic.dotProduct2D((Tuple2f)pq, (Tuple2f)pr);
        if (dot < 0.0) {
            ori = Numerics.orientation(triRef, i2, i1, i0);
            if (ori > 0) {
                return 2;
            }
            return -2;
        }
        return Numerics.recSpikeAngle(triRef, i1, i2, i3, ind1, ind3);
    }

    static double angle(Triangulator triRef, Point2f p, Point2f p1, Point2f p2) {
        double angle;
        int sign = Basic.signEps(Basic.det2D((Tuple2f)p2, (Tuple2f)p, (Tuple2f)p1), triRef.epsilon);
        if (sign == 0) {
            return 0.0;
        }
        Point2f v1 = new Point2f();
        Point2f v2 = new Point2f();
        Basic.vectorSub2D((Tuple2f)p1, (Tuple2f)p, (Tuple2f)v1);
        Basic.vectorSub2D((Tuple2f)p2, (Tuple2f)p, (Tuple2f)v2);
        double angle1 = Math.atan2(v1.y, v1.x);
        double angle2 = Math.atan2(v2.y, v2.x);
        if (angle1 < 0.0) {
            angle1 += Math.PI * 2;
        }
        if (angle2 < 0.0) {
            angle2 += Math.PI * 2;
        }
        if ((angle = angle1 - angle2) > Math.PI) {
            angle = Math.PI * 2 - angle;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        if (sign == 1) {
            if (angle < 0.0) {
                return -angle;
            }
            return angle;
        }
        if (angle > 0.0) {
            return -angle;
        }
        return angle;
    }
}

