/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.CompressedGeometry;
import org.jogamp.java3d.CompressedGeometryHeader;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.GeometryState;
import org.jogamp.vecmath.Point3d;

public class CompressedGeometryState
extends GeometryState {
    private byte[] bytes;
    private boolean isByReference;
    private CompressedGeometryHeader header;

    public CompressedGeometryState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeBoolean(((CompressedGeometry)this.node).isByReference());
        int size = ((CompressedGeometry)this.node).getByteCount();
        out.writeInt(size);
        this.bytes = new byte[size];
        ((CompressedGeometry)this.node).getCompressedGeometry(this.bytes);
        out.write(this.bytes);
        this.header = new CompressedGeometryHeader();
        ((CompressedGeometry)this.node).getCompressedGeometryHeader(this.header);
        this.writeCompressedGeometryHeader(out);
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.isByReference = in.readBoolean();
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
        this.header = new CompressedGeometryHeader();
        this.readCompressedGeometryHeader(in);
    }

    private void writeCompressedGeometryHeader(DataOutput out) throws IOException {
        out.writeInt(this.header.majorVersionNumber);
        out.writeInt(this.header.minorVersionNumber);
        out.writeInt(this.header.minorMinorVersionNumber);
        out.writeInt(this.header.bufferType);
        out.writeInt(this.header.bufferDataPresent);
        out.writeInt(this.header.size);
        out.writeInt(this.header.start);
        if (this.header.lowerBound == null) {
            this.control.writePoint3d(out, new Point3d(-1.0, -1.0, -1.0));
        } else {
            this.control.writePoint3d(out, this.header.lowerBound);
        }
        if (this.header.upperBound == null) {
            this.control.writePoint3d(out, new Point3d(1.0, 1.0, 1.0));
        } else {
            this.control.writePoint3d(out, this.header.upperBound);
        }
    }

    private void readCompressedGeometryHeader(DataInput in) throws IOException {
        this.header.majorVersionNumber = in.readInt();
        this.header.minorVersionNumber = in.readInt();
        this.header.minorMinorVersionNumber = in.readInt();
        this.header.bufferType = in.readInt();
        this.header.bufferDataPresent = in.readInt();
        this.header.size = in.readInt();
        this.header.start = in.readInt();
        this.header.lowerBound = this.control.readPoint3d(in);
        if (this.header.lowerBound.x == -1.0 && this.header.lowerBound.y == -1.0 && this.header.lowerBound.z == -1.0) {
            this.header.lowerBound = null;
        }
        this.header.upperBound = this.control.readPoint3d(in);
        if (this.header.upperBound.x == 1.0 && this.header.upperBound.y == 1.0 && this.header.upperBound.z == 1.0) {
            this.header.upperBound = null;
        }
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{CompressedGeometryHeader.class, this.bytes.getClass(), Boolean.TYPE}, new Object[]{this.header, this.bytes, new Boolean(this.isByReference)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new CompressedGeometry(this.header, this.bytes, this.isByReference);
    }
}

