/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.StringTokenizer;
import java.util.Vector;
import jlk.FloatingLicenseAddHostDelegate;
import jlk.HashString;

public class FloatingLicense
extends Thread {
    private static boolean DO_BROADCAST = true;
    private static boolean DO_MULTICAST = true;
    private static final String BROADCAST_ADDRESS = "255.255.255.255";
    private static final String MULTICAST_ADDRESS = "224.0.0.1";
    private static final int MULTICAST_HOPS = 1;
    private static final int QUERY_TRIES = 3;
    private static final long QUERY_INTERVAL = 333L;
    private static final long WAIT_FURTHER = 3000L;
    private static final long POLL_INTERVAL = 5000L;
    private static String myApp = "";
    private static String myHost = "";
    int threadPort = -1;
    MulticastSocket threadMcastSock = null;
    static /* synthetic */ Class class$0;

    FloatingLicense(int aPort, MulticastSocket aSock) {
        this.threadPort = aPort;
        this.threadMcastSock = aSock;
    }

    public void run() {
        DatagramSocket thread_bcast_sock = null;
        if (this.threadMcastSock == null) {
            do {
                try {
                    thread_bcast_sock = new DatagramSocket(this.threadPort);
                }
                catch (Exception e) {
                    thread_bcast_sock = null;
                    try {
                        FloatingLicense.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } while (thread_bcast_sock == null);
        }
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[254];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    if (this.threadMcastSock == null) {
                        thread_bcast_sock.receive(packet);
                    } else {
                        this.threadMcastSock.receive(packet);
                    }
                    String query_string = new String(packet.getData(), 0, packet.getLength());
                    StringTokenizer st = new StringTokenizer(query_string);
                    String sender_appname = st.nextToken();
                    int sender_id = Integer.parseInt(st.nextToken());
                    String sender_hostname = st.nextToken();
                    int sender_port = Integer.parseInt(st.nextToken());
                    if (sender_id < 0 || sender_port < 0) continue;
                    String reply_string = String.valueOf(myApp) + " " + (sender_id + 17) + " " + myHost + " " + this.threadPort;
                    byte[] reply_msg = reply_string.getBytes();
                    DatagramPacket reply_packet = new DatagramPacket(reply_msg, reply_msg.length, InetAddress.getByName(sender_hostname), sender_port);
                    if (this.threadMcastSock == null) {
                        thread_bcast_sock.send(reply_packet);
                        continue;
                    }
                    this.threadMcastSock.send(reply_packet);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static int getCurrentUsers(String applicationName, int maxUsers, FloatingLicenseAddHostDelegate anAddHostDelegate) throws IllegalArgumentException, IOException {
        int len;
        if (!DO_BROADCAST && !DO_MULTICAST) {
            throw new IllegalArgumentException("!DO_BROADCAST && !DO_MULTICAST");
        }
        if (applicationName == null || (len = applicationName.length()) < 1) {
            throw new IllegalArgumentException("applicationName");
        }
        if (maxUsers < 1) {
            throw new IllegalArgumentException("maxUsers");
        }
        int i = 0;
        myApp = "";
        while (i < len) {
            char c = applicationName.charAt(i);
            myApp = String.valueOf(myApp) + (Character.isWhitespace(c) ? (char)'_' : (char)c);
            ++i;
        }
        int[] thread_port = HashString.hashString(myApp);
        InetAddress addr = InetAddress.getLocalHost();
        myHost = addr.getHostName();
        DatagramSocket bcast_snd_sock = null;
        if (DO_BROADCAST) {
            bcast_snd_sock = new DatagramSocket();
        }
        MulticastSocket mcast_snd_sock = null;
        if (DO_MULTICAST) {
            mcast_snd_sock = new MulticastSocket();
        }
        DatagramSocket rcv_sock = new DatagramSocket();
        rcv_sock.setSoTimeout(1);
        int rcv_port = rcv_sock.getLocalPort();
        long msec_now = System.currentTimeMillis();
        long sec_now = msec_now / 1000L;
        long query_id = sec_now % 16000L + msec_now % 16000L;
        String query_string = String.valueOf(myApp) + " " + query_id + " " + myHost + " " + rcv_port;
        byte[] query_msg = query_string.getBytes();
        long msec_next_try = msec_now;
        long msec_further = 0L;
        int next_try = 0;
        int next_port_index = 0;
        Vector<String> hostnames = new Vector<String>(maxUsers);
        int users = 0;
        DatagramPacket[] broadcast_packet = new DatagramPacket[3];
        DatagramPacket[] multicast_packet = new DatagramPacket[3];
        while (true) {
            msec_now = System.currentTimeMillis();
            if (next_try < 3 && msec_now >= msec_next_try) {
                if (DO_BROADCAST && broadcast_packet[next_port_index] == null) {
                    broadcast_packet[next_port_index] = new DatagramPacket(query_msg, query_msg.length, InetAddress.getByName(BROADCAST_ADDRESS), thread_port[next_port_index]);
                }
                if (DO_MULTICAST && multicast_packet[next_port_index] == null) {
                    multicast_packet[next_port_index] = new DatagramPacket(query_msg, query_msg.length, InetAddress.getByName(MULTICAST_ADDRESS), thread_port[next_port_index] + 1);
                }
                if (DO_BROADCAST && DO_MULTICAST) {
                    try {
                        bcast_snd_sock.send(broadcast_packet[next_port_index]);
                    }
                    catch (Exception e) {
                        System.err.println("can't send broadcast_packet, relying on multicast_packet");
                    }
                    mcast_snd_sock.send(multicast_packet[next_port_index]);
                } else if (DO_BROADCAST) {
                    bcast_snd_sock.send(broadcast_packet[next_port_index]);
                } else {
                    mcast_snd_sock.send(multicast_packet[next_port_index]);
                }
                if (++next_port_index > 2) {
                    next_port_index = 0;
                    ++next_try;
                }
                msec_now = System.currentTimeMillis();
                if (next_try < 3) {
                    msec_next_try = msec_now;
                    msec_next_try += 333L;
                } else {
                    msec_further = msec_now + 3000L;
                }
            }
            if (next_try >= 3 && msec_now >= msec_further) break;
            try {
                byte[] reply_buf = new byte[254];
                DatagramPacket reply_packet = new DatagramPacket(reply_buf, reply_buf.length);
                rcv_sock.receive(reply_packet);
                String reply = new String(reply_packet.getData(), 0, reply_packet.getLength());
                StringTokenizer st = new StringTokenizer(reply);
                String ret_appname = st.nextToken();
                int ret_id = Integer.parseInt(st.nextToken());
                String ret_hostname = st.nextToken();
                int ret_port = Integer.parseInt(st.nextToken());
                if ((long)ret_id != query_id + 17L) continue;
                if (!ret_appname.equals(myApp)) {
                    System.err.println(String.valueOf(myApp) + ": warning: '" + ret_appname + "' on host " + ret_hostname + " also uses port " + ret_port);
                    continue;
                }
                if (ret_hostname.equals(myHost)) continue;
                int count = hostnames.size();
                i = 0;
                while (i < count) {
                    if (((String)hostnames.elementAt(i)).equals(ret_hostname)) break;
                    ++i;
                }
                if (i != count) continue;
                hostnames.addElement(ret_hostname);
                try {
                    if (anAddHostDelegate != null) {
                        anAddHostDelegate.addHost(ret_hostname);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (++users >= maxUsers) {
                    if (DO_BROADCAST) {
                        bcast_snd_sock.close();
                    }
                    if (DO_MULTICAST) {
                        mcast_snd_sock.close();
                    }
                    rcv_sock.close();
                    return users;
                }
                if (next_try < 3) continue;
                msec_now = System.currentTimeMillis();
                msec_further = msec_now + 3000L;
            }
            catch (Exception reply_buf) {}
        }
        if (DO_BROADCAST) {
            bcast_snd_sock.close();
        }
        if (DO_MULTICAST) {
            mcast_snd_sock.close();
        }
        rcv_sock.close();
        if (DO_MULTICAST) {
            InetAddress group = InetAddress.getByName(MULTICAST_ADDRESS);
            i = 0;
            while (i < 3) {
                MulticastSocket mcast_sock = new MulticastSocket(thread_port[i] + 1);
                mcast_sock.joinGroup(group);
                FloatingLicense thread = new FloatingLicense(thread_port[i] + 1, mcast_sock);
                thread.setDaemon(true);
                int p = thread.getPriority();
                if (p < 10) {
                    thread.setPriority(p + 1);
                }
                thread.start();
                ++i;
            }
        }
        if (DO_BROADCAST) {
            i = 0;
            while (i < 3) {
                FloatingLicense thread = new FloatingLicense(thread_port[i], null);
                thread.setDaemon(true);
                int p = thread.getPriority();
                if (p < 10) {
                    thread.setPriority(p + 1);
                }
                thread.start();
                ++i;
            }
        }
        return users;
    }
}

