/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import jlk.HashString;
import jlk.LicenseHandler;

public class HostID {
    public static final int BY_DATE_OF_JAVA_HOME = 0;
    public static final int BY_PATH_OF_JAVA_HOME = 1;
    public static final int BY_DATE_OF_USER_DIR = 2;
    public static final int BY_PATH_OF_USER_DIR = 3;
    public static final int BY_DATE_OF_USER_HOME = 4;
    public static final int BY_PATH_OF_USER_HOME = 5;
    public static final int BY_AUTOCREATION_IN_LICENSE_FOLDER = 6;
    public static final int BY_MAC_ADDRESS = 7;
    private static String hostIDSubfolder = ".lh";
    private static String hostIDFile = ".lhf";

    public static String encodeHostID(int aHostID) {
        if (aHostID < 1 || aHostID > 1023) {
            return "AA0000";
        }
        int lo4 = aHostID & 0xF;
        int hi4 = aHostID >>> 6 & 0xF;
        int lo3 = aHostID & 7;
        int lm3 = aHostID >>> 3 & 7;
        int hm3 = aHostID >>> 4 & 7;
        int hi3 = aHostID >>> 7 & 7;
        String string = "";
        string = String.valueOf(string) + (char)(65 + lo4);
        string = String.valueOf(string) + (char)(90 - hi4);
        string = String.valueOf(string) + (char)(57 - lo3);
        string = String.valueOf(string) + (char)(48 + lm3);
        string = String.valueOf(string) + (char)(48 + hm3);
        string = String.valueOf(string) + (char)(57 - hi3);
        return string;
    }

    public static int decodeHostID(String aString) throws NumberFormatException {
        if (aString.length() != 6) {
            throw new NumberFormatException("illegal HostID");
        }
        int lo4 = aString.charAt(0) - 65;
        int hi4 = 90 - aString.charAt(1);
        int lo3 = 57 - aString.charAt(2);
        int lm3 = aString.charAt(3) - 48;
        int hm3 = aString.charAt(4) - 48;
        int hi3 = 57 - aString.charAt(5);
        int val = lo3 + (lm3 << 3) + (hi4 << 6);
        if (lo4 != (val & 0xF) || hm3 != (val >>> 4 & 7) || hi3 != (val >>> 7 & 7)) {
            throw new NumberFormatException("illegal HostID");
        }
        return val;
    }

    public static int obtainHostID(int how) {
        Class<?> cls = null;
        Method meth = null;
        int[] values = null;
        if (how == 7) {
            try {
                cls = Class.forName("at.tugraz.genome.utils.JUProxy");
                Class[] signature = new Class[]{};
                meth = cls.getMethod("getMACAddress", signature);
                Object jUtil = cls.newInstance();
                Object[] params = new Object[]{};
                values = (int[])meth.invoke(jUtil, params);
            }
            catch (Exception ex) {
                how = 0;
            }
        }
        try {
            switch (how) {
                case 0: {
                    File file = new File(System.getProperty("java.home"));
                    return (int)(HostID.fileCreationTimeOf(file) / 1000L % 1023L) + 1;
                }
                case 1: {
                    values = HashString.hashString(System.getProperty("java.home"));
                    return (values[0] + values[1] + values[2]) % 1023 + 1;
                }
                case 2: {
                    File file = new File(System.getProperty("user.dir"));
                    return (int)(HostID.fileCreationTimeOf(file) / 1000L % 1023L) + 1;
                }
                case 3: {
                    values = HashString.hashString(System.getProperty("user.dir"));
                    return (values[0] + values[1] + values[2]) % 1023 + 1;
                }
                case 4: {
                    File file = new File(System.getProperty("user.home"));
                    return (int)(HostID.fileCreationTimeOf(file) / 1000L % 1023L) + 1;
                }
                case 5: {
                    values = HashString.hashString(System.getProperty("user.home"));
                    return (values[0] + values[1] + values[2]) % 1023 + 1;
                }
                case 6: {
                    File subfolder = new File(LicenseHandler.getLicenseFolder(), hostIDSubfolder);
                    File file = new File(subfolder, hostIDFile);
                    if (!file.exists()) {
                        subfolder.mkdirs();
                        RandomAccessFile raf = new RandomAccessFile(file, "rw");
                        int ts = (int)(System.currentTimeMillis() / 1000L % 1023L) + 1;
                        raf.writeChars(HostID.encodeHostID(ts));
                        raf.writeChar(10);
                        raf.close();
                    }
                    int ts = (int)((HostID.fileCreationTimeOf(file) / 1000L + HostID.fileCreationTimeOf(subfolder) / 1000L) % 1023L) + 1;
                    return ts;
                }
                case 7: {
                    return (int)((values[0] + values[1] + values[2]) % 1023 + true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static long fileCreationTimeOf(File aPath) throws IOException {
        long timeval = 0L;
        try {
            timeval = aPath.lastModified();
        }
        catch (Exception e) {
            timeval = 0L;
        }
        if (timeval < 900000000000L) {
            throw new IOException();
        }
        return timeval;
    }
}

