/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.io.File;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import jlk.AlertDialog;
import jlk.ExpDate;
import jlk.FloatingDialog;
import jlk.FloatingLicense;
import jlk.HashString;
import jlk.HostID;
import jlk.LicenseDef;
import jlk.LicenseDialog;
import jlk.LicenseHandlerExitDelegate;
import jlk.LicenseMatrix;
import jlk.RandomGenerator;
import jlk.RegisterDialog;

public class LicenseHandler {
    public static int PERMISSION_NO = 0;
    public static int PERMISSION_DEMO = -1;
    public static int PERMISSION_YES = -2;
    public static int PERMISSION_LICENSE_EXPIRED = 1;
    public static int permissionOfModule0 = PERMISSION_NO;
    public static int permissionOfModule1 = PERMISSION_NO;
    public static int permissionOfModule2 = PERMISSION_NO;
    public static int permissionOfModule3 = PERMISSION_NO;
    public static int permissionOfModule4 = PERMISSION_NO;
    public static int permissionOfModule5 = PERMISSION_NO;
    private static int pdiff = -3;
    private static ImageIcon logo16x16_ = null;
    private static String demoLicenseString;
    private static String userName;
    private static LicenseDef licenseDef;
    private static File licenseFolder;
    private static String licenseSubfolder;
    private static String licenseFile;
    private static String licenseCheckSubfolder;
    private static String licenseCheckFile;
    private static boolean canRegister;
    private static boolean canUseUI;
    private static boolean canDoDemo;
    private static boolean useRoamingProfile;
    private static String appName;
    private static LicenseHandlerExitDelegate exitDelegate;
    private static String[] moduleNames;
    private static Vector forbiddenKeyMD5Hashes;
    private static int moduleCount;
    private static String[] mlModeString;
    private static int reqVersionAtLeast;
    private static int maxUsers;
    private static boolean maxUsersChecked;
    private static int hostID;
    private static boolean demoLicenseUsed;
    private static ResourceBundle b;

    static {
        RandomGenerator rg = new RandomGenerator();
        PERMISSION_NO = (int)(rg.get() * 100000.0) + 1;
        while ((PERMISSION_DEMO = (int)(rg.get() * 100000.0) + 1) == PERMISSION_NO) {
        }
        pdiff = (int)(rg.get() * 100000.0) + 1;
        PERMISSION_YES = PERMISSION_NO + PERMISSION_DEMO + pdiff;
        permissionOfModule0 = PERMISSION_NO;
        permissionOfModule1 = PERMISSION_NO;
        permissionOfModule2 = PERMISSION_NO;
        permissionOfModule3 = PERMISSION_NO;
        permissionOfModule4 = PERMISSION_NO;
        permissionOfModule5 = PERMISSION_NO;
        demoLicenseString = null;
        userName = null;
        licenseDef = new LicenseDef();
        licenseFolder = null;
        licenseSubfolder = ".l";
        licenseFile = ".lf";
        licenseCheckSubfolder = ".lc";
        licenseCheckFile = ".lcf";
        canRegister = false;
        canUseUI = true;
        canDoDemo = true;
        useRoamingProfile = true;
        appName = "";
        exitDelegate = null;
        moduleNames = new String[6];
        moduleCount = 0;
        mlModeString = new String[4];
        reqVersionAtLeast = 0;
        maxUsers = 0;
        maxUsersChecked = false;
        hostID = -1;
        demoLicenseUsed = true;
        b = ResourceBundle.getBundle("jlk.LicenseStrings", Locale.getDefault());
        LicenseHandler.mlModeString[0] = b.getString("MODE_NO");
        LicenseHandler.mlModeString[1] = b.getString("MODE_YES");
        LicenseHandler.mlModeString[2] = b.getString("MODE_FREE");
        LicenseHandler.mlModeString[3] = b.getString("MODE_DEMO");
    }

    static ResourceBundle getLicenseStrings() {
        return b;
    }

    private static boolean licenseStringIsValid(String aString) {
        try {
            LicenseDef ld = new LicenseDef();
            ld.decode(aString);
            ld.getMaxUsers();
            ld.getHostID();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (forbiddenKeyMD5Hashes != null) {
            Iterator it = forbiddenKeyMD5Hashes.iterator();
            while (it.hasNext()) {
                Object forbidden = it.next();
                String hash = HashString.generateMD5Hash(aString);
                if (!hash.equals(forbidden)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean nameIsEmpty(String aName) {
        int len = aName.length();
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(aName.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean expDateDidExpire(ExpDate ed) {
        Calendar now = Calendar.getInstance();
        GregorianCalendar given = new GregorianCalendar(ed.year(), ed.month() - 1, ed.day());
        return now.after(given);
    }

    private static Vector readLicenseStringAndUserName() {
        try {
            char c;
            File subfolder = new File(licenseFolder, licenseSubfolder);
            File file = new File(subfolder, licenseFile);
            File check_subfolder = new File(licenseFolder, licenseCheckSubfolder);
            File check_file = new File(check_subfolder, licenseCheckFile);
            Vector<String> v = new Vector<String>(2);
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            String string = "";
            while ((c = raf.readChar()) != '\n') {
                string = String.valueOf(string) + c;
            }
            try {
                string = LicenseDef.unscrambleLicenseString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            v.addElement(string);
            string = "";
            while ((c = raf.readChar()) != '\n') {
                string = String.valueOf(string) + c;
            }
            v.addElement(string);
            raf.close();
            raf = new RandomAccessFile(check_file, "r");
            string = "";
            while ((c = raf.readChar()) != '\n') {
                string = String.valueOf(string) + c;
            }
            raf.close();
            int stored_ts = HostID.decodeHostID(string);
            int ts = (int)((HostID.fileCreationTimeOf(file) / 1000L + HostID.fileCreationTimeOf(subfolder) / 1000L) % 1023L) + 1;
            if (useRoamingProfile) {
                if (ts == stored_ts) {
                    return v;
                }
            } else {
                return v;
            }
            String[] options = new String[]{b.getString("OK")};
            JFrame frame = new JFrame();
            frame.setIconImage(logo16x16_.getImage());
            AlertDialog.runModalDialog(frame, appName, b.getString("CHECK_ERR"), 2, options);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean writeLicenseStringAndUserName(File currentLicenseFolder, String aString, String aName) {
        if (currentLicenseFolder != null) {
            licenseFolder = currentLicenseFolder;
        }
        try {
            File subfolder = new File(licenseFolder, licenseSubfolder);
            File file = new File(subfolder, licenseFile);
            File check_subfolder = new File(licenseFolder, licenseCheckSubfolder);
            File check_file = new File(check_subfolder, licenseCheckFile);
            subfolder.mkdirs();
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            try {
                aString = LicenseDef.scrambleLicenseString(aString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            raf.writeChars(aString);
            raf.writeChar(10);
            raf.writeChars(aName);
            raf.writeChar(10);
            raf.close();
            int ts = (int)((HostID.fileCreationTimeOf(file) / 1000L + HostID.fileCreationTimeOf(subfolder) / 1000L) % 1023L) + 1;
            check_subfolder.mkdirs();
            raf = new RandomAccessFile(check_file, "rw");
            raf.writeChars(HostID.encodeHostID(ts));
            raf.writeChar(10);
            raf.close();
            return true;
        }
        catch (Exception e) {
            JFrame frame = new JFrame();
            frame.setIconImage(logo16x16_.getImage());
            Object[] args = new Object[]{e.toString()};
            String[] options = new String[]{b.getString("OK")};
            AlertDialog.runModalDialog(frame, appName, MessageFormat.format(b.getString("WRITE_ERR"), args), 2, options);
            return false;
        }
    }

    private static boolean runLicenseDialog() {
        JFrame frame = new JFrame();
        frame.setIconImage(logo16x16_.getImage());
        LicenseDialog ld = new LicenseDialog(frame);
        ld.setTitle(appName);
        if (demoLicenseUsed) {
            ld.setUserID(b.getString("SERIAL_DEMO"));
        } else {
            ld.setUserID(licenseDef.getUserID());
        }
        if (demoLicenseUsed) {
            ld.setOwner(b.getString("OWNER_DEMO"));
        } else {
            ld.setOwner(userName != null ? userName : "");
        }
        if (demoLicenseUsed) {
            ld.setType(b.getString("TYPE_DEMO"));
        } else if (maxUsers > 0) {
            if (maxUsers == 101) {
                ld.setType(b.getString("TYPE_MAX_USERS_NA"));
            } else if (maxUsers == 1) {
                ld.setType(b.getString("TYPE_MAX_USERS_1"));
            } else {
                Object[] args = new Object[]{new Integer(maxUsers)};
                ld.setType(MessageFormat.format(b.getString("TYPE_MAX_USERS_X"), args));
            }
        } else {
            ld.setType(b.getString("TYPE_SINGLE"));
        }
        ld.setHostID(HostID.encodeHostID(hostID));
        String[] module = new String[moduleCount];
        String[] licensed = new String[moduleCount];
        String[] expires = new String[moduleCount];
        int i = 0;
        while (i < moduleCount) {
            module[i] = moduleNames[i];
            licensed[i] = mlModeString[licenseDef.getMode(i)];
            int edi = licenseDef.getExpDateIndex(i);
            expires[i] = edi < 0 ? "-" : licenseDef.getExpDate(edi).toString();
            ++i;
        }
        ld.setModules(module, licensed, expires);
        ld.runModal();
        boolean oked = ld.wasOKed();
        ld.dispose();
        return oked;
    }

    private static Vector runRegisterDialog() {
        JFrame frame = new JFrame();
        frame.setIconImage(logo16x16_.getImage());
        RegisterDialog rd = new RegisterDialog(frame);
        rd.setTitle(appName);
        rd.setKey("");
        rd.setName("");
        while (true) {
            rd.runModal();
            if (rd.wasCancelled()) {
                rd.dispose();
                return null;
            }
            String key = "";
            String name = "";
            boolean key_error = true;
            int host_id = -2;
            try {
                key = rd.getKey().substring(0, 39);
                name = rd.getName();
                LicenseDef ld = new LicenseDef();
                ld.decode(key);
                ld.getMaxUsers();
                host_id = ld.getHostID();
                key_error = false;
            }
            catch (Exception e) {
                key_error = true;
            }
            key_error = key_error || !LicenseHandler.licenseStringIsValid(key);
            String err_msg = null;
            if (key_error) {
                err_msg = b.getString("REGISTER_KEY_ERR");
            } else if (host_id != 0 && host_id != hostID) {
                Object[] args = new String[]{HostID.encodeHostID(host_id), HostID.encodeHostID(hostID)};
                err_msg = MessageFormat.format(b.getString("HOST_ID_ERR"), args);
            } else if (LicenseHandler.nameIsEmpty(name)) {
                err_msg = b.getString("REGISTER_NAME_ERR");
            }
            if (err_msg == null) {
                LicenseHandler.writeLicenseStringAndUserName(null, key, name);
                Vector<String> v = new Vector<String>(2);
                v.addElement(key);
                v.addElement(name);
                rd.dispose();
                return v;
            }
            String[] options = new String[]{b.getString("OK")};
            AlertDialog.runModalDialog(frame, appName, err_msg, 2, options);
        }
    }

    private static boolean checkFloatingPermission(int aMaxUsersValue) {
        int users = -1;
        String err_msg = "unknown error";
        FloatingDialog fd = null;
        if (canUseUI) {
            fd = new FloatingDialog();
            fd.setTitle(appName);
            fd.runNonModal();
        }
        try {
            users = FloatingLicense.getCurrentUsers(appName, aMaxUsersValue, fd);
        }
        catch (Exception e) {
            users = -1;
            err_msg = e.toString();
        }
        if (users < 0 || users >= aMaxUsersValue) {
            boolean quit;
            if (fd != null) {
                String msg;
                if (users < 0) {
                    Object[] args = new Object[]{err_msg};
                    msg = MessageFormat.format(b.getString("NETWORK_ERR"), args);
                } else if (aMaxUsersValue == 1) {
                    msg = b.getString("NETWORK_MAX_USERS_1");
                } else {
                    Object[] args = new Object[]{new Integer(aMaxUsersValue)};
                    msg = MessageFormat.format(b.getString("NETWORK_MAX_USERS_X"), args);
                }
                fd.runModal(msg);
                quit = fd.wasCancelled();
                fd.setVisible(false);
                fd.dispose();
            } else {
                quit = true;
            }
            if (quit) {
                try {
                    if (exitDelegate != null) {
                        exitDelegate.exitApplication();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            } else {
                return false;
            }
        }
        if (fd != null) {
            fd.setVisible(false);
            fd.dispose();
        }
        return true;
    }

    public static boolean isRegistrationEnabled() {
        return canRegister;
    }

    public static void setUIEnabled(boolean whether) {
        canUseUI = whether;
    }

    public static boolean isUIEnabled() {
        return canUseUI;
    }

    public static void setDemoModeEnabled(boolean whether) {
        canDoDemo = whether;
    }

    public static boolean isDemoModeEnabled() {
        return canDoDemo;
    }

    public static void setUseRoamingProfileEnabled(boolean useIt) {
        useRoamingProfile = useIt;
    }

    public static boolean isUseRoamingProfileEnabled() {
        return useRoamingProfile;
    }

    public static void setApplicationIcon(ImageIcon image) {
        if (image != null) {
            logo16x16_ = image;
        }
    }

    public static void setAppName(String aString) {
        if (aString != null) {
            appName = aString;
        }
    }

    public static String getAppName() {
        return appName;
    }

    public static File getLicenseFolder() {
        return licenseFolder;
    }

    public static void setExitDelegate(LicenseHandlerExitDelegate anExitDelegate) {
        exitDelegate = anExitDelegate;
    }

    public static LicenseHandlerExitDelegate getExitDelegate() {
        return exitDelegate;
    }

    public static void setRequiredVersion(int reqVersion) {
        reqVersionAtLeast = reqVersion;
    }

    public static void setModuleNames(String[] arrayOfModuleNames) {
        if (arrayOfModuleNames != null) {
            moduleCount = arrayOfModuleNames.length <= 6 ? arrayOfModuleNames.length : 6;
            int i = 0;
            while (i < moduleCount) {
                LicenseHandler.moduleNames[i] = new String(arrayOfModuleNames[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 6) {
                try {
                    String name = b.getString("MODULE_" + i);
                    if (name.length() <= 0) break;
                    LicenseHandler.moduleNames[i] = name;
                }
                catch (Exception e) {
                    break;
                }
                ++i;
            }
            moduleCount = i;
        }
    }

    public static void setForbiddenKeyMD5Hashes(Vector hashes) {
        forbiddenKeyMD5Hashes = hashes;
    }

    public static void setLicenseArray(LicenseMatrix license_definition) {
        licenseDef.setLicenseArray(license_definition);
    }

    public static void setDemoLicenseString(String license) {
        demoLicenseString = license;
    }

    public static void checkLicenseInFolder(File aFolder) {
        LicenseHandler.checkLicense(aFolder, null, null);
    }

    public static void checkLicenseString(String aLicenseString) {
        LicenseHandler.checkLicense(null, aLicenseString, null);
    }

    public static void checkLicenseStringAndUserName(String aLicenseString, String aUserName) {
        LicenseHandler.checkLicense(null, aLicenseString, aUserName);
    }

    public static void checkLicense(File aFolder, String aLicenseString, String aUserName) {
        boolean do_demo = false;
        String string = null;
        String name = null;
        licenseFolder = aFolder;
        canRegister = licenseFolder != null;
        hostID = HostID.obtainHostID(7);
        if (aLicenseString != null) {
            if (LicenseHandler.licenseStringIsValid(aLicenseString)) {
                string = aLicenseString;
                name = aUserName;
            } else {
                do_demo = true;
            }
        } else {
            Vector v = LicenseHandler.readLicenseStringAndUserName();
            if (v == null) {
                do_demo = true;
            } else {
                string = (String)v.elementAt(0);
                name = (String)v.elementAt(1);
                if (!LicenseHandler.licenseStringIsValid(string) || LicenseHandler.nameIsEmpty(name)) {
                    v = LicenseHandler.runRegisterDialog();
                    if (v == null) {
                        do_demo = true;
                    } else {
                        string = (String)v.elementAt(0);
                        name = (String)v.elementAt(1);
                    }
                }
            }
        }
        if (!do_demo) {
            try {
                int host_id = -2;
                LicenseDef ld = new LicenseDef();
                ld.decode(string);
                maxUsers = ld.getMaxUsers();
                host_id = ld.getHostID();
                if (maxUsers != 0 && maxUsers != 101) {
                    if (LicenseHandler.checkFloatingPermission(maxUsers)) {
                        maxUsersChecked = true;
                    } else {
                        do_demo = true;
                    }
                }
            }
            catch (Exception e) {
                do_demo = true;
            }
        }
        userName = do_demo || name == null ? null : new String(name);
        try {
            licenseDef.decode(do_demo ? demoLicenseString : string);
        }
        catch (NumberFormatException ex) {
            System.out.println("Invalid License String");
        }
        demoLicenseUsed = do_demo;
        LicenseHandler.checkBasicPermission();
        if (LicenseHandler.permissionOfModule(0) == PERMISSION_DEMO) {
            String[] stringArray;
            if (canRegister) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = b.getString("DEMO_DEMO");
                stringArray = stringArray2;
                stringArray2[1] = b.getString("DEMO_REGISTER");
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = b.getString("DEMO_DEMO");
            }
            String[] options = stringArray;
            JFrame frame = new JFrame();
            frame.setIconImage(logo16x16_.getImage());
            if (AlertDialog.runModalDialog(frame, appName, b.getString("DEMO_MSG"), 1, options) == 1) {
                LicenseHandler.showRegisterDialog();
            }
        }
    }

    private static void checkBasicPermission() {
        int permissionOfModule_0 = LicenseHandler.permissionOfModule(0);
        while (permissionOfModule_0 == PERMISSION_NO || permissionOfModule_0 == PERMISSION_LICENSE_EXPIRED) {
            if (!canUseUI) {
                try {
                    if (exitDelegate != null) {
                        exitDelegate.exitApplication();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            }
            String r = b.getString("BASIC_REGISTER");
            String d = b.getString("BASIC_DEMO");
            String q = b.getString("BASIC_QUIT");
            String[] options = canRegister && canDoDemo ? new String[]{r, d, q} : (canRegister ? new String[]{r, q} : (canDoDemo ? new String[]{d, q} : new String[]{q}));
            int result = -1234;
            JFrame frame = new JFrame();
            frame.setIconImage(logo16x16_.getImage());
            if (permissionOfModule_0 == PERMISSION_NO) {
                result = AlertDialog.runModalDialog(frame, appName, String.valueOf(b.getString("BASIC_ERR")) + b.getString("BASIC_PROC_ID") + " " + HostID.encodeHostID(hostID), 2, options);
            } else if (permissionOfModule_0 == PERMISSION_LICENSE_EXPIRED) {
                String message_ = String.valueOf(b.getString("BASIC_LICENSE_EXPIRED1")) + " " + licenseDef.getExpDate(moduleCount - 1) + b.getString("BASIC_LICENSE_EXPIRED2") + b.getString("BASIC_PROC_ID") + " " + HostID.encodeHostID(hostID);
                result = AlertDialog.runModalDialog(frame, appName, message_, 2, options);
            }
            if (result >= 0 && result < options.length) {
                if (options[result].equals(r)) {
                    LicenseHandler.showRegisterDialog();
                    permissionOfModule_0 = LicenseHandler.permissionOfModule(0);
                    continue;
                }
                if (options[result].equals(d)) {
                    if (canRegister) {
                        try {
                            File subfolder = new File(licenseFolder, licenseSubfolder);
                            File file = new File(subfolder, licenseFile);
                            File check_subfolder = new File(licenseFolder, licenseCheckSubfolder);
                            File check_file = new File(check_subfolder, licenseCheckFile);
                            file.delete();
                            check_file.delete();
                            subfolder.delete();
                            check_subfolder.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    userName = null;
                    licenseDef.decode(demoLicenseString);
                    demoLicenseUsed = true;
                    permissionOfModule_0 = PERMISSION_DEMO;
                    continue;
                }
            }
            try {
                if (exitDelegate != null) {
                    exitDelegate.exitApplication();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
        permissionOfModule0 = LicenseHandler.permissionOfModule(0);
        permissionOfModule1 = LicenseHandler.permissionOfModule(1);
        permissionOfModule2 = LicenseHandler.permissionOfModule(2);
        permissionOfModule3 = LicenseHandler.permissionOfModule(3);
        permissionOfModule4 = LicenseHandler.permissionOfModule(4);
        permissionOfModule5 = LicenseHandler.permissionOfModule(5);
    }

    public static int permissionOfModule(int moduleNumber) {
        try {
            if (moduleNumber < 0 || moduleNumber >= moduleCount) {
                return PERMISSION_NO;
            }
            if (licenseDef == null || licenseDef.getVersion() < reqVersionAtLeast) {
                return PERMISSION_NO;
            }
            int i = licenseDef.getExpDateIndex(moduleNumber);
            if (i >= 0 && LicenseHandler.expDateDidExpire(licenseDef.getExpDate(i))) {
                return PERMISSION_LICENSE_EXPIRED;
            }
            if (PERMISSION_YES != PERMISSION_NO + PERMISSION_DEMO + pdiff) {
                return PERMISSION_NO;
            }
            switch (licenseDef.getMode(moduleNumber)) {
                case 1: 
                case 2: {
                    return PERMISSION_YES;
                }
                case 3: {
                    if (!canDoDemo) break;
                    return PERMISSION_DEMO;
                }
            }
            return PERMISSION_NO;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return PERMISSION_NO;
        }
    }

    public static boolean showLicenseDialog() {
        if (!canUseUI) {
            return false;
        }
        boolean changed = false;
        while (!LicenseHandler.runLicenseDialog()) {
            if (!LicenseHandler.showRegisterDialog()) break;
            changed = true;
        }
        return changed;
    }

    public static boolean showRegisterDialog() {
        Vector v;
        block7: {
            if (!canUseUI || !canRegister) {
                return false;
            }
            try {
                v = LicenseHandler.runRegisterDialog();
                if (v != null) break block7;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        licenseDef.decode((String)v.elementAt(0));
        userName = (String)v.elementAt(1);
        maxUsers = licenseDef.getMaxUsers();
        demoLicenseUsed = false;
        if (maxUsers != 0 && maxUsers != 101 && !maxUsersChecked) {
            if (LicenseHandler.checkFloatingPermission(maxUsers)) {
                maxUsersChecked = true;
            } else {
                userName = null;
                licenseDef.decode(demoLicenseString);
                demoLicenseUsed = true;
            }
        }
        LicenseHandler.checkBasicPermission();
        return true;
    }
}

