/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome;

import at.tugraz.genome.lda.alex123.RdbOutputWriter;
import at.tugraz.genome.lda.alex123.RdbParser;
import at.tugraz.genome.lda.analysis.ComparativeAnalysis;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.QuantVO;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;

public class AlexRtGrouper {
    private String dir_;
    private double groupingTime_;

    public AlexRtGrouper(String dir, double groupingTime) {
        this.dir_ = dir;
        this.groupingTime_ = groupingTime;
    }

    public void groupTheEntries() throws Exception {
        Hashtable<String, File> avoidDuplicates = new Hashtable<String, File>();
        Vector<File> resultFiles = new Vector<File>();
        File resultsDir = new File(this.dir_);
        if (resultsDir.exists() && resultsDir.isDirectory()) {
            File[] resultFileCandidates = resultsDir.listFiles();
            for (int i = 0; i != resultFileCandidates.length; ++i) {
                String fileName;
                String suffix;
                if (!resultFileCandidates[i].isFile() || avoidDuplicates.containsKey(resultFileCandidates[i].getAbsolutePath()) || !(suffix = (fileName = StaticUtils.extractFileName(resultFileCandidates[i].getAbsolutePath())).substring(fileName.lastIndexOf(".") + 1)).equalsIgnoreCase("xls") && !suffix.equalsIgnoreCase("xlsx")) continue;
                avoidDuplicates.put(resultFileCandidates[i].getAbsolutePath(), resultFileCandidates[i]);
                resultFiles.add(resultFileCandidates[i]);
            }
            resultFiles = AlexRtGrouper.sortFilesByName(resultFiles);
            ComparativeAnalysis analysisModule = new ComparativeAnalysis(resultFiles, "IS", "Ex-IS", null, null, -1, null, null, null, this.groupingTime_);
            analysisModule.parseInput();
            analysisModule.calculateStatistics();
            RdbOutputWriter rdbWriter = new RdbOutputWriter("IS", "Ex-IS");
            for (String exp : analysisModule.getExpNamesInSequence()) {
                File excelFile = analysisModule.getFullFilePath(exp);
                String alexFile = this.getAlexFileNameFromExcelFile(excelFile);
                File file = new File(alexFile);
                System.out.println("Rt-grouping: " + file.getName());
                LinkedHashMap<String, Integer> classSequence = null;
                Hashtable<String, Vector<String>> analyteSequence = null;
                Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> targetLists = null;
                if (file.exists() && file.isFile()) {
                    RdbParser parser = new RdbParser(alexFile);
                    parser.parse();
                    classSequence = parser.getClassSequence();
                    targetLists = parser.getTargetlistInfo();
                    analyteSequence = parser.getAnalyteSequence();
                }
                Vector<String> excelFiles = new Vector<String>();
                excelFiles.add(excelFile.getAbsolutePath());
                rdbWriter.write(alexFile, analysisModule, classSequence, analyteSequence, null, null, targetLists, excelFiles);
            }
        }
    }

    private String getAlexFileNameFromExcelFile(File excelFile) {
        return excelFile.getAbsolutePath().substring(0, excelFile.getAbsolutePath().lastIndexOf(".")) + ".tab";
    }

    private static Vector<File> sortFilesByName(Vector<File> filesToSort) {
        Vector<File> newOrder = new Vector<File>(filesToSort.size());
        Hashtable<String, File> hash = new Hashtable<String, File>();
        for (File file : filesToSort) {
            hash.put(file.getAbsolutePath(), file);
        }
        Vector pathVect = new Vector(hash.keySet());
        Collections.sort(pathVect);
        for (String path : pathVect) {
            newOrder.add((File)hash.get(path));
        }
        return newOrder;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            if (args.length != 0) {
                System.out.println("ERROR: you must provide 2 arguements! You provided just: " + args.length);
                System.out.println();
            }
            AlexRtGrouper.printUsage();
            return;
        }
        File dir = new File(args[0]);
        if (!dir.exists()) {
            System.out.println("ERROR: The directory \"" + dir.getAbsolutePath() + "\" does not exist!");
            System.out.println();
            return;
        }
        if (dir.isFile()) {
            System.out.println("The directory \"" + dir.getAbsolutePath() + "\" is a file! Only directories are allowed!");
            System.out.println();
            return;
        }
        double groupingRt = -1.0;
        try {
            groupingRt = Double.parseDouble(args[1].replace(",", "."));
        }
        catch (NumberFormatException nfx) {
            System.out.println("grouping retention time is not double format");
            System.out.println();
            return;
        }
        if (groupingRt <= 0.0) {
            System.out.println("ERROR: Only rt grouping times > 0 are allowed!");
            System.out.println();
            return;
        }
        AlexRtGrouper grouper = new AlexRtGrouper(dir.getAbsolutePath(), groupingRt);
        try {
            grouper.groupTheEntries();
            System.out.println("Finished");
        }
        catch (Exception e) {
            System.out.println("ERROR:");
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("\nAlex123 Rt-grouper for LDA files:");
        System.out.println();
        System.out.println("AlexRtGrouper $dirToGroupingFiles $groupingTimeInMinutes");
    }
}

