/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

class MRSWLock {
    static boolean debug = false;
    private int readCount = 0;
    private boolean write = false;
    private int writeRequested = 0;
    private int lockRequested = 0;

    MRSWLock() {
    }

    final synchronized void readLock() {
        ++this.lockRequested;
        while (this.write || this.writeRequested > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.lockRequested;
        ++this.readCount;
    }

    final synchronized void readUnlock() {
        if (this.readCount > 0) {
            --this.readCount;
        } else if (debug) {
            System.err.println("ReadWriteLock.java : Problem! readCount is >= 0.");
        }
        if (this.lockRequested > 0) {
            this.notifyAll();
        }
    }

    final synchronized void writeLock() {
        ++this.lockRequested;
        ++this.writeRequested;
        while (this.readCount > 0 || this.write) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.write = true;
        --this.lockRequested;
        --this.writeRequested;
    }

    final synchronized void writeUnlock() {
        this.write = false;
        if (this.lockRequested > 0) {
            this.notifyAll();
        }
    }
}

