/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.io.InputStream;
import java.net.URL;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.SoundException;
import org.jogamp.java3d.VirtualUniverse;

class MediaContainerRetained
extends NodeComponentRetained {
    boolean cached = true;
    URL url = null;
    String urlString = null;
    InputStream inputStream = null;

    MediaContainerRetained() {
    }

    void setCacheEnable(boolean state) {
        this.cached = state;
    }

    boolean getCacheEnable() {
        return this.cached;
    }

    void setURLObject(URL url) {
        this.setURLObject(url, true);
    }

    void setURLObject(URL url, boolean forceLoad) {
        if (url != null) {
            if (this.urlString != null || this.inputStream != null) {
                throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
            }
            try {
                InputStream stream = url.openStream();
                stream.close();
            }
            catch (Exception e) {
                throw new SoundException(J3dI18N.getString("MediaContainer0"));
            }
        }
        this.url = url;
        if (forceLoad) {
            this.dispatchMessage();
        }
    }

    void setURLString(String path) {
        this.setURLString(path, true);
    }

    void setURLString(String path, boolean forceLoad) {
        if (path != null) {
            if (this.url != null || this.inputStream != null) {
                throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
            }
            try {
                URL url = new URL(path);
                InputStream stream = url.openStream();
                stream.close();
            }
            catch (Exception e) {
                throw new SoundException(J3dI18N.getString("MediaContainer0"));
            }
        }
        this.urlString = path;
        if (forceLoad) {
            this.dispatchMessage();
        }
    }

    void setInputStream(InputStream stream) {
        this.setInputStream(stream, true);
    }

    void setInputStream(InputStream stream, boolean forceLoad) {
        if (stream != null && (this.url != null || this.urlString != null)) {
            throw new IllegalArgumentException(J3dI18N.getString("MediaContainer5"));
        }
        this.inputStream = stream;
        if (forceLoad) {
            this.dispatchMessage();
        }
    }

    String getURLString() {
        return this.urlString;
    }

    URL getURLObject() {
        return this.url;
    }

    InputStream getInputStream() {
        return this.inputStream;
    }

    void dispatchMessage() {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 2;
        createMessage.type = 51;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(1);
        createMessage.args[2] = new Integer(this.users.size());
        createMessage.args[3] = this.users;
        VirtualUniverse.mc.processMessage(createMessage);
    }
}

