/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.VirtualUniverse;

class PointAttributesRetained
extends NodeComponentRetained {
    static final int POINT_SIZE_CHANGED = 1;
    static final int POINT_AA_CHANGED = 2;
    float pointSize = 1.0f;
    boolean pointAntialiasing = false;

    PointAttributesRetained() {
    }

    final void initPointSize(float pointSize) {
        this.pointSize = pointSize;
    }

    final void setPointSize(float pointSize) {
        this.initPointSize(pointSize);
        this.sendMessage(1, new Float(pointSize));
    }

    final float getPointSize() {
        return this.pointSize;
    }

    final void initPointAntialiasingEnable(boolean state) {
        this.pointAntialiasing = state;
    }

    final void setPointAntialiasingEnable(boolean state) {
        this.initPointAntialiasingEnable(state);
        this.sendMessage(2, state ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getPointAntialiasingEnable() {
        return this.pointAntialiasing;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                PointAttributesRetained mirrorPa = new PointAttributesRetained();
                mirrorPa.set(this);
                mirrorPa.source = this.source;
                this.mirror = mirrorPa;
            }
        } else {
            ((PointAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context ctx) {
        Pipeline.getPipeline().updatePointAttributes(ctx, this.pointSize, this.pointAntialiasing);
    }

    @Override
    synchronized void initMirrorObject() {
        ((PointAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        PointAttributesRetained mirrorPa = (PointAttributesRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorPa.pointSize = ((Float)value).floatValue();
        } else if ((component & 2) != 0) {
            mirrorPa.pointAntialiasing = (Boolean)value;
        }
    }

    boolean equivalent(PointAttributesRetained pr) {
        return pr != null && pr.pointSize == this.pointSize && pr.pointAntialiasing == this.pointAntialiasing;
    }

    protected void set(PointAttributesRetained pr) {
        super.set(pr);
        this.pointSize = pr.pointSize;
        this.pointAntialiasing = pr.pointAntialiasing;
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 8;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 8;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1 || bit == 3) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }
}

