/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;

class PointLightRetained
extends LightRetained {
    static final int POSITION_CHANGED = 128;
    static final int ATTENUATION_CHANGED = 256;
    static final int LAST_POINTLIGHT_DEFINED_BIT = 256;
    Point3f attenuation = new Point3f(1.0f, 0.0f, 0.0f);
    Point3f position = new Point3f();
    Point3f xformPosition = new Point3f();
    double localToVworldScale;
    float linearAttenuationInEc;
    float quadraticAttenuationInEc;

    PointLightRetained() {
        this.nodeType = 7;
        this.lightType = 3;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void initPosition(Point3f position) {
        this.position.set((Tuple3f)position);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position, this.position);
        }
    }

    void setPosition(Point3f position) {
        this.initPosition(position);
        this.sendMessage(128, new Point3f(position));
    }

    void initPosition(float x, float y, float z) {
        this.position.x = x;
        this.position.y = y;
        this.position.z = z;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.position, this.position);
        }
    }

    void setPosition(float x, float y, float z) {
        this.setPosition(new Point3f(x, y, z));
    }

    void getPosition(Point3f position) {
        position.set((Tuple3f)this.position);
        if (this.staticTransform != null) {
            Transform3D invTransform = this.staticTransform.getInvTransform();
            invTransform.transform(position, position);
        }
    }

    void initAttenuation(Point3f attenuation) {
        this.attenuation.set((Tuple3f)attenuation);
    }

    void setAttenuation(Point3f attenuation) {
        this.initAttenuation(attenuation);
        this.sendMessage(256, new Point3f(attenuation));
    }

    void initAttenuation(float constant, float linear, float quadratic) {
        this.attenuation.x = constant;
        this.attenuation.y = linear;
        this.attenuation.z = quadratic;
    }

    void setAttenuation(float constant, float linear, float quadratic) {
        this.setAttenuation(new Point3f(constant, linear, quadratic));
    }

    void getAttenuation(Point3f attenuation) {
        attenuation.set((Tuple3f)this.attenuation);
    }

    @Override
    void update(Context ctx, int lightSlot, double scale) {
        this.validateAttenuationInEc(scale);
        Pipeline.getPipeline().updatePointLight(ctx, lightSlot, this.color.x, this.color.y, this.color.z, this.attenuation.x, this.linearAttenuationInEc, this.quadraticAttenuationInEc, this.xformPosition.x, this.xformPosition.y, this.xformPosition.z);
    }

    @Override
    void setLive(SetLiveState s) {
        super.setLive(s);
        J3dMessage createMessage = super.initMessage(9);
        Object[] objs = (Object[])createMessage.args[4];
        objs[7] = new Point3f(this.position);
        objs[8] = new Point3f(this.attenuation);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void doSetLive(SetLiveState s) {
        super.setLive(s);
    }

    @Override
    J3dMessage initMessage(int num) {
        J3dMessage createMessage = super.initMessage(num);
        Object[] objs = (Object[])createMessage.args[4];
        objs[7] = new Point3f(this.position);
        objs[8] = new Point3f(this.attenuation);
        return createMessage;
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        int numLgts = (Integer)objs[2];
        LightRetained[] mLgts = (LightRetained[])objs[3];
        if ((component & 0x80) != 0) {
            for (int i = 0; i < numLgts; ++i) {
                if (!(mLgts[i] instanceof PointLightRetained)) continue;
                PointLightRetained ml = (PointLightRetained)mLgts[i];
                Transform3D mlLastLocalToVworld = ml.getLastLocalToVworld();
                ml.position = (Point3f)objs[4];
                mlLastLocalToVworld.transform(ml.position, ml.xformPosition);
                ml.localToVworldScale = mlLastLocalToVworld.getDistanceScale();
            }
        } else if ((component & 0x100) != 0) {
            for (int i = 0; i < numLgts; ++i) {
                if (!(mLgts[i] instanceof PointLightRetained)) continue;
                PointLightRetained ml = (PointLightRetained)mLgts[i];
                ml.attenuation.set((Tuple3f)((Point3f)objs[4]));
            }
        } else if ((component & 0x20) != 0) {
            for (int i = 0; i < numLgts; ++i) {
                if (!(mLgts[i] instanceof PointLightRetained)) continue;
                PointLightRetained ml = (PointLightRetained)this.mirrorLights[i];
                ml.position = (Point3f)((Object[])objs[4])[7];
                ml.attenuation.set((Tuple3f)((Point3f)((Object[])objs[4])[8]));
                Transform3D mlLastLocalToVworld = ml.getLastLocalToVworld();
                mlLastLocalToVworld.transform(ml.position, ml.xformPosition);
                ml.localToVworldScale = mlLastLocalToVworld.getDistanceScale();
            }
        }
        super.updateMirrorObject(objs);
    }

    void validateAttenuationInEc(double vworldToCoexistenceScale) {
        double localToEcScale = this.localToVworldScale * vworldToCoexistenceScale;
        this.linearAttenuationInEc = (float)((double)this.attenuation.y / localToEcScale);
        this.quadraticAttenuationInEc = (float)((double)this.attenuation.z / (localToEcScale * localToEcScale));
    }

    @Override
    protected Object clone() {
        PointLightRetained pr = (PointLightRetained)super.clone();
        pr.attenuation = new Point3f(this.attenuation);
        pr.position = new Point3f(this.position);
        pr.xformPosition = new Point3f();
        return pr;
    }

    @Override
    void updateTransformChange() {
        super.updateTransformChange();
        Transform3D lastLocalToVworld = this.getLastLocalToVworld();
        lastLocalToVworld.transform(this.position, this.xformPosition);
        this.localToVworldScale = lastLocalToVworld.getDistanceScale();
        this.validateAttenuationInEc(0.0861328125);
    }

    @Override
    void sendMessage(int attrMask, Object attr) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.universe = this.universe;
        createMessage.type = 19;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        createMessage.args[3] = this.mirrorLights.clone();
        createMessage.args[4] = attr;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        xform.transform.transform(this.position, this.position);
    }
}

