/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.SheetVisibility;

public class Sheet {
    private final ReadableWorkbook workbook;
    private final int index;
    private final String id;
    private final String name;
    private final SheetVisibility visibility;

    Sheet(ReadableWorkbook workbook, int index, String id, String name, SheetVisibility visibility) {
        this.workbook = workbook;
        this.index = index;
        this.id = id;
        this.name = name;
        this.visibility = visibility;
    }

    public int getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SheetVisibility getVisibility() {
        return this.visibility;
    }

    public Stream<Row> openStream() throws IOException {
        return this.workbook.openStream(this);
    }

    public List<Row> read() throws IOException {
        try (Stream<Row> stream = this.openStream();){
            List<Row> list = stream.collect(Collectors.toList());
            return list;
        }
    }
}

