package at.tugraz.genome.dbutilities;

import java.util.*;
import java.io.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
	private static ConnectionManager myConnectionManager;

	private static Properties properties;

	public static ConnectionManager getInstance() {
		if (myConnectionManager == null)
			myConnectionManager = new ConnectionManager();
		return (myConnectionManager);
	}

	public Properties getJNDIProperties() {
		Log log = LogFactory.getLog(this.getClass());
		log.debug("Get InitialContext");
		if (properties == null) {
			properties = new Properties();
			try {
				log.debug("Prop ###null### try to read file:"
						+ at.tugraz.genome.dbutilities.ConnectionManager.class
								.getResource("/Server.properties").getPath());
				FileInputStream in = new FileInputStream(
						at.tugraz.genome.dbutilities.ConnectionManager.class
								.getResource("/Server.properties").getPath());
				properties.load(in);
				in.close();
				log.debug("file is read");
				log.info("URL java.naming.provider.url="
						+ properties.getProperty("java.naming.provider.url"));
			} catch (Exception ex) {
				ex.printStackTrace();
				log.error(ex.getMessage());
				return null;
			}
			return properties;
		} else {
			log.debug("Prop ###not### null try to read file");
			log.debug("URL java.naming.provider.url="
					+ properties.getProperty("java.naming.provider.url"));
			return properties;
		}
	}
}
