package at.tugraz.genome.dbutilities;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

/**
 * <p>Title: MARS EJB</p>
 * <p>Description: Microarray Analysis and Retrieval System</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: genome.tugraz.at</p>
 * @author Robert Molidor
 * @version 1.0
 */

public class DatabaseTableField implements Serializable {
  private String dbTableName_ = null;
  private String dbFieldName_ = null;
  private String dbFieldDisplayName_ = null;
  private boolean isFake_ = false;
  private String fakeTableConnectorFieldName_ = null;
  private String fakeTableName_ = null;
  private String fakeDBTableField_ = null;
  private String fakeOrderByField_ = null;
  private Vector orCombinedFields_ = new Vector();
  private Vector andCombinedFields_ = new Vector();
  private String dbTableAlias_ = null;
  private String fakeTableAlias_ = null;
  private String sqlSubStatement_ = null;
  private String[] fakeTableNames_ = null;
  private String[] fakeTableAliases_ = null;
  private DatabaseTableField dbField = null;
  private String key_ = null;
  protected Vector additionalTables_ = new Vector();


  public DatabaseTableField(String dbTableName,
                            String dbTableAlias,
                            String dbFieldName,
                            String dbFieldDisplayName,
                            boolean fake,
                            String sqlStatement,
                            String[] fakeTableNames,
                            String[] fakeTableAliases,
                            String fakeTableConnectorFieldName) {
    this.dbTableName_ = dbTableName;
    this.dbTableAlias_ = dbTableAlias;
    this.dbFieldName_ = dbFieldName;
    this.dbFieldDisplayName_ = dbFieldDisplayName;
    this.isFake_ = fake;
    this.sqlSubStatement_ = sqlStatement;
    this.fakeTableNames_ = fakeTableNames;
    this.fakeTableAliases_ = fakeTableAliases;
    this.fakeTableConnectorFieldName_ = fakeTableConnectorFieldName;
  }

  public DatabaseTableField(String dbTableName,
                            String dbFieldName,
                            String dbFieldDisplayName,
                            boolean fake) {
    dbTableName_ = dbTableName;
    dbFieldName_ = dbFieldName;
    dbFieldDisplayName_ = dbFieldDisplayName;
    isFake_ = fake;
  }

  public DatabaseTableField(String dbTableName,
                            String dbTableAlias,
                            String dbFieldName,
                            String dbFieldDisplayName,
                            boolean fake) {
    dbTableName_ = dbTableName;
    dbFieldName_ = dbFieldName;
    dbFieldDisplayName_ = dbFieldDisplayName;
    isFake_ = fake;
    this.dbTableAlias_ = dbTableAlias;
  }


  public DatabaseTableField(String dbTableName,
                            String dbFieldName,
                            String dbFieldDisplayName,
                            boolean fake,
                            String fakeDBTableField,
                            String fakeTableName,
                            String fakeTableConnectorFieldName,
                            String fakeOrderByField) {
    this(dbTableName, dbFieldName, dbFieldDisplayName, fake);
    fakeTableConnectorFieldName_ = fakeTableConnectorFieldName;
    fakeTableName_ = fakeTableName;
    fakeDBTableField_ = fakeDBTableField;
    fakeOrderByField_ = fakeOrderByField;
  }
//dbField, "THE_EXPERIMENT_FK", true,"title","experiment","id","experiment"
  public DatabaseTableField(DatabaseTableField dbField,
                            String dbFieldName,
                            boolean fake,
                            String fakeDBTableField,
                            String fakeTableName,
                            String fakeTableConnectorFieldName,
                            String fakeOrderByField) {
    this(dbField.getFakeTableName(),dbFieldName,dbField.getDBFieldDisplayName(),fake);
//    this (dbTableName, dbFieldName, dbFieldDisplayName, fake);
    this.fakeDBTableField_ = fakeDBTableField;
    fakeTableName_ = fakeTableName;
    fakeTableConnectorFieldName_ = fakeTableConnectorFieldName;
    fakeOrderByField_ = fakeOrderByField;
    this.dbField = dbField;
    int count = 0;
    if (dbField.getFakeTableNames()!=null){
      count = dbField.getFakeTableNames().length;
    }
    if (dbField.getFakeTableName()!=null){
      count = count+1;
    }
    if (count!=0){
      String[] newFakeTableNames = new String[count];
      if (dbField.getFakeTableNames()!=null){
        for (int i=0; i!=dbField.getFakeTableNames().length; i++){
          newFakeTableNames[i] = dbField.getFakeTableNames()[i];
        }
      }
      if (dbField.getFakeTableName()!=null){
          newFakeTableNames[count-1] = dbField.getFakeTableName();
      }
      this.fakeTableNames_ = newFakeTableNames;
    }
//    if (this.dbField.getFakeTableName()!=null){
//      Vector newAndCombinedFields = new Vector();
//      if (dbField.getANDCombinedFields()!=null){
//        Iterator it = dbField.getANDCombinedFields().iterator();
//        while (it.hasNext()){
//          newAndCombinedFields.add((SearchableField)it.next());
//        }
//        SearchableField field = new SearchableField());
//      }
//  	}
  }

  public DatabaseTableField(String dbTableName,
                            String dbTableAlias,
                            String dbFieldName,
                            String dbFieldDisplayName,
                            boolean fake,
                            String fakeDBTableField,
                            String fakeTableName,
                            String fakeTableAlias,
                            String fakeTableConnectorFieldName,
                            String fakeOrderByField) {
    this(dbTableName, dbFieldName, dbFieldDisplayName, fake);
    dbTableAlias_ = dbTableAlias;
    fakeTableConnectorFieldName_ = fakeTableConnectorFieldName;
    fakeTableName_ = fakeTableName;
    fakeTableAlias_ = fakeTableAlias;
    fakeDBTableField_ = fakeDBTableField;
    fakeOrderByField_ = fakeOrderByField;
  }

  public DatabaseTableField(String dbTableName,
                            String dbFieldName,
                            String dbFieldDisplayName,
                            boolean fake,
                            String fakeDBTableField,
                            String fakeTableName,
                            String fakeTableConnectorFieldName,
                            String fakeOrderByField,
                            Vector andCombinedFields,
                            Vector orCombinedFields) {
    this(dbTableName, dbFieldName, dbFieldDisplayName, fake);
    fakeTableConnectorFieldName_ = fakeTableConnectorFieldName;
    fakeTableName_ = fakeTableName;
    fakeDBTableField_ = fakeDBTableField;
    fakeOrderByField_ = fakeOrderByField;
    andCombinedFields_ = andCombinedFields;
    orCombinedFields_ = orCombinedFields;
  }

  public DatabaseTableField(String dbTableName,
                            String dbTableAlias,
                            String dbFieldName,
                            String dbFieldDisplayName,
                            boolean fake,
                            String fakeDBTableField,
                            String fakeTableName,
                            String fakeTableAlias,
                            String fakeTableConnectorFieldName,
                            String fakeOrderByField,
                            Vector andCombinedFields,
                            Vector orCombinedFields) {
    this(dbTableName, dbFieldName, dbFieldDisplayName, fake);
    dbTableAlias_ = dbTableAlias;
    fakeTableConnectorFieldName_ = fakeTableConnectorFieldName;
    fakeTableName_ = fakeTableName;
    fakeTableAlias_ = fakeTableAlias;
    fakeDBTableField_ = fakeDBTableField;
    fakeOrderByField_ = fakeOrderByField;
    andCombinedFields_ = andCombinedFields;
    orCombinedFields_ = orCombinedFields;
  }

  public void setDBTableAlias(String dbTableAlias) {
    this.dbTableAlias_ = dbTableAlias;
  }

  public String getDBTableAlias() {
    return this.dbTableAlias_;
  }

  public void setFakeTableAlias(String fakeTableAlias) {
    this.fakeTableAlias_ = fakeTableAlias;
  }

  public String getFakeTableAlias() {
    return this.fakeTableAlias_;
  }


  public void setDBTableName(String dbTableName) {
    dbTableName_ = dbTableName;
  }

  public String getDBTableName() {
    return dbTableName_;
  }

  public void setDBFieldName(String dbFieldName) {
    dbFieldName_ = dbFieldName;
  }

  public String getDBFieldName() {
    return dbFieldName_;
  }

  public void setDBFieldDisplayName(String dbFieldDisplayName) {
    dbFieldDisplayName_ = dbFieldDisplayName;
  }

  public String getDBFieldDisplayName() {
    return dbFieldDisplayName_;
  }

  public void setFake(boolean fake) {
    isFake_ = fake;
  }

  public boolean isFake() {
    return isFake_;
  }

  public void setFakeTableName(String fakeTableName) {
    fakeTableName_ = fakeTableName;
  }

  public String getFakeTableName() {
    return fakeTableName_;
  }

  public void setFakeDBTableField(String fakeDBTableField) {
    fakeDBTableField_ = fakeDBTableField;
  }

  public String getFakeDBTableField() {
    return fakeDBTableField_;
  }

  public void setFakeTableConnectorFieldName(String fakeTableConnectorFieldName) {
    fakeTableConnectorFieldName_ = fakeTableConnectorFieldName;
  }

  public String getFakeTableConnectorFieldName() {
    return fakeTableConnectorFieldName_;
  }

  public void setFakeOrderByField(String fakeOrderByField) {
    fakeOrderByField_ = fakeOrderByField;
  }

  public String getFakeOrderByField() {
    return fakeOrderByField_;
  }

  public void addORCombinedField(SearchableField field) {
    orCombinedFields_.add(field);
  }

  public Collection getORCombinedFields() {
    return orCombinedFields_;
  }

  public void addANDCombinedField(SearchableField field) {
    andCombinedFields_.add(field);
  }

  public Collection getANDCombinedFields() {
    return andCombinedFields_;
  }

  public String getSQLSubStatement() {
    return this.sqlSubStatement_;
  }

  public String[] getFakeTableNames() {
    return this.fakeTableNames_;
  }

  public String[] getFakeTableAliases() {
    return this.fakeTableAliases_;
  }

  public void setFakeTableNames(String[] fakeTableNames) {
    this.fakeTableNames_ = fakeTableNames;
  }

  public void setFakeTableAliases(String[] fakeTableAliases) {
    this.fakeTableAliases_ = fakeTableAliases;
  }

  public void setSQLSubStatement(String sqlSubStatement) {
    this.sqlSubStatement_ = sqlSubStatement;
  }

  public void setKey(String key) {
    key_ = key;
  }

  public String getKey() {
    return this.key_;
  }

  public void addAdditionalTable(String table) {
    this.additionalTables_.add(table);
  }

  public String[] getAdditionalTables() {
    String[] retValue = new String[additionalTables_.size()];
    for (int i=0; i<additionalTables_.size(); i++) {
      retValue[i] = (String)additionalTables_.elementAt(i);
    }
    return retValue;
  }

  public Vector getAdditionalTablesVector() {
    return this.additionalTables_;
  }

  public void setAdditionalTablesVector(Vector vect) {
    this.additionalTables_ = vect;
  }
  public DatabaseTableField getDbField() {
    return dbField;
  }
  public void setDbField(DatabaseTableField dbField) {
    this.dbField = dbField;
  }
}