package at.tugraz.genome.dbutilities;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Collection;
import java.util.Vector;

/**
 * <p>
 * Title: MARS EJB
 * </p>
 * <p>
 * Description: Microarray Analysis and Retrieval System
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * <p>
 * Company: genome.tugraz.at
 * </p>
 * 
 * @author Robert Molidor
 * @version 1.0
 */

public interface GenericDAOInterface {
	public List selectAll(String tableName, String pkFieldName,
			DatabaseTableField orderBy, String direction);

	public List selectCustom(String tableName, String pkFieldName,
			Collection andSearchCriteria, DatabaseTableField orderBy,
			String direction);

	public List selectCustom(String tableName, String tableAlias,
			String pkFieldName, Collection andSearchCriteria,
			DatabaseTableField orderBy, String direction);
	
  /**
   * Allows to query, whereby the tables for the select statement can be explicitely chosen
   * @param tableName name of the database table
   * @param pkFieldName name of the field which will be returned (normally the PK)
   * @param searchCriteria collection of query criteria (SearchableField)
   * @param orderBy entries are sorted by this field
   * @param direction direction of sorting "asc" for ascending or "desc" for descending
   * @param selectTables database table fields for the from statement
   * @author hartler 
   */
    public List selectCustom(String tableName, String pkFieldName, Collection searchCriteria, DatabaseTableField orderBy,
            String direction, Collection selectTables);
    
    /**
     * Allows to query, whereby the tables for the select statement can be explicitely chosen,
     * or even explicitely hard coded with the String fromStatement
     * @param tableName name of the database table
     * @param pkFieldName name of the field which will be returned (normally the PK)
     * @param searchCriteria collection of query criteria (SearchableField)
     * @param orderBy entries are sorted by this field
     * @param direction direction of sorting "asc" for ascending or "desc" for descending
     * @param selectTables database table fields for the from statement
     * @param fromStatement explicit string for the fromStatement 
     */
    public List selectCustom(String tableName, String pkFieldName, Collection searchCriteria, DatabaseTableField orderBy,
        String direction, Collection selectTables,String fromStatement);

	public String[] getTableNames(Collection searchCriteria);

	public String generateWhereClause(Collection searchCriteria);

  /**
   * Inserts an object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * @param object VO to insert
   * @return returns the generated PK for the object
   * @author hartler
   */
	  public java.lang.Object insertVOByJDBC(Object object);
  
  /**
   * Inserts an object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * It is possible to run this method within the same database connection
   * @param object VO to insert
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return returns the generated PK for the object
   * @author hartler
   */
	  public java.lang.Object insertVOByJDBC(Object object, Connection con, PreparedStatement pStmt) throws SQLException;

  /**
   * Removes a VO and the whole underlying tree via JDBC statements
   * @param object object to be removed
   * @return if the operation has been successful
   */
	  public boolean removeVOByJDBC(Object object);
  
  /**
   * Removes a VO and the whole underlying tree via JDBC statements
   * It is possible to run this method within the same database connection
   * @param object object to be removed
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return if the operation has been successful
   * @throws SQLException
   * @author hartler
   */
  public boolean removeVOByJDBC(Object object, Connection con, PreparedStatement pStmt) throws SQLException;

  /**
   * Removes a colection of VOs and the whole underlying tree via JDBC statements
   * @param objects objects to be removed
   * @return if the operation has been successful
   * @author hartler
   */
  public boolean removeVOByJDBC(Collection objects);
  
  /**
   * Removes a colection of VOs and the whole underlying tree via JDBC statements
   * It is possible to run this method within the same database connection
   * @param pks objects to be removed
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return if the operation has been successful
   * @throws SQLException
   * @author hartler
   */  
  public boolean removeVOByJDBC(Collection pks, Connection con, PreparedStatement pStmt) throws SQLException;

  /** not used at all*/
	  public void updateVOByJDBC(Object object);

  /** not used at all*/
	  public void updateVOByJDBC(Collection objects);

  /**
   * Inserts a collection of object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * @param collection collection of VOs to be inserted
   * @return returns collection of PKs for the objects
   * @author hartler
   */
	  public Collection insertVOByJDBC(Collection object);
  
  /**
   * Inserts a collection of object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * It is possible to run this method within the same database connection
   * @param collection collection of VOs to be inserted
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return returns collection of PKs for the objects
   * @author hartler
   */
	  public Collection insertVOByJDBC(Collection coll, Connection con, PreparedStatement pStmt) throws SQLException;
  
  public void setPkValuesAtBeginning(Connection con, String tableName)throws SQLException;
}