package at.tugraz.genome.dbutilities;

import org.apache.log4j.Logger;

import at.tugraz.genome.dbutilities.exception.*;

/**
 * <p>
 * Title: MARS EJB
 * </p>
 * <p>
 * Description: Microarray Analysis and Retrieval System
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * <p>
 * Company: genome.tugraz.at
 * </p>
 * 
 * @author Robert Molidor
 * @version 1.0
 */

public class OracleEJBException extends AbstractEJBException {
    Logger log_ = null;

    public OracleEJBException() {
        log_ = Logger.getLogger(getClass());
    }

    public void throwEJBCreateException(javax.ejb.CreateException createExc)
            throws UniqueException, ForeignKeyException, EJBCreateException {
        log_.info("throwEJBCreateException");
        if (createExc.getMessage().indexOf("ORA-00001") != -1) {
            log_.info("Entry not Unique");
            throw new UniqueException("Entry not Unique "
                    + createExc.getMessage());
        } else {
            if (createExc.getMessage().indexOf("ORA-02291") != -1) {
                log_.info("Superior key not found");
                throw new ForeignKeyException("Superior key not found "
                        + createExc.getMessage());
            } else {
                if (createExc.getMessage().indexOf("ORA-01400") != -1) {
                    log_.info("Insert of NULL not allowed");
                    throw new EJBCreateException("Insert of NULL not allowed "
                            + createExc.getMessage());
                } else {
                    log_.info("UNKNOWN CREATE EXCEPTION: "
                            + createExc.getMessage());
                    throw new EJBCreateException("Could not create entity "
                            + createExc.getMessage());
                }
            }
        }
    }

    public void throwEJBFinderException(javax.ejb.FinderException finderExc)
            throws EJBFinderException {
        log_.info("throwEJBFinderException");
        throw new EJBFinderException(finderExc.getMessage());
    }

    public void throwEJBServerException(javax.naming.NamingException namingExc)
            throws EJBServerException {
        log_.info("throwEJBServerException");
        throw new EJBServerException(namingExc.getMessage());
    }

    public void throwEJBRemoveException(javax.ejb.RemoveException removeExc)
            throws EJBRemoveException {
        log_.info("removeEJBException");
        throw new EJBRemoveException(removeExc.getMessage());
    }
}