package at.tugraz.genome.dbutilities;

import java.lang.reflect.Method;
import java.sql.*;
import java.util.*;

import org.andromda.core.common.StringUtilsHelper;
import org.apache.log4j.Logger;




/**
 * @author Juergen Hartler
 * @version 1.0
 */

public class PostgreSQLGenericDAOImpl extends GenericDAOImpl {

  /**
   * 
   * @param factory holds the parameters for the database connection
   */    
    public PostgreSQLGenericDAOImpl(GenericDAOFactory factory) {
        log_.info("PostgreSQLGenericDAOImpl");
        factory_ = factory;
    }

    /**
     * @return the primary key generator for the Oracle database
     */
    public PKGenerator getPKGenerator(){
      return PostgreSQLPKGenerator.getInstance(factory_);
    }

    /**
     * 
     * @param input column name extracted from VO
     * @return database conform column name
     */
    protected String getDatabaseConformString (String input){
      return input.toLowerCase();
    }

    /**
     * 
     * @param input table name extracted from VO
     * @return database conform table name
     */
    protected String getDatabaseConformTablename(String input){
      return input.toLowerCase();
    }
    
}