package at.tugraz.genome.dbutilities;

import java.sql.*;
import java.util.ArrayList;
import java.util.Hashtable;

import org.apache.log4j.Logger;



/**
 * <p>
 * Title: MARS EJB
 * </p>
 * <p>
 * Description: Microarray Analysis and Retrieval System
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * <p>
 * Company: genome.tugraz.at
 * </p>
 * 
 * @author Robert Molidor
 * @version 1.0
 */

public class PostgreSQLPKGenerator implements PKGenerator {
    private static int cacheSize_ = 50;
    
    private static PostgreSQLPKGenerator instance_ = null;
    private static GenericDAOFactory daoFactory_ = null;
    
    private Hashtable pkCache_ = null;
    private Hashtable existingSequences_ = null;
    
    private static Logger log_ = Logger.getLogger(at.tugraz.genome.dbutilities.GenericDAOImpl.class);
    
    private PostgreSQLPKGenerator() {
        pkCache_ = new Hashtable();
        //find all existing sequences
        existingSequences_ = new Hashtable();
        try {
            Connection con = daoFactory_.createConnection();
            String sql = "SELECT relname FROM pg_class WHERE relname like '%seq'";
            PreparedStatement stmt = con.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String sequence = rs.getString(1);
                existingSequences_.put(sequence.toLowerCase(), sequence.toLowerCase());
            }            
            rs.close();
            stmt.close();
            con.close();
            log_.debug("Number of sequences retrieved: "+existingSequences_.size());
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static PostgreSQLPKGenerator getInstance(GenericDAOFactory daoFactory) {
        daoFactory_ = daoFactory;
        if (instance_ == null) {
            instance_ = new PostgreSQLPKGenerator();
        }
        return instance_;
    }

    /**
     * Returns the primary key for the given table for an ORACLE database.
     * 
     * @param tableName
     *            The name of the table the primary key is used for
     * @return The primary key. A unique number, or NULL if the primary key is
     *         not available.
     */
    public Long getPrimaryKey(String tableName) {
        //check if PKs are in cache
        tableName = tableName.replaceAll("-", "_");        
        ArrayList pkList = (ArrayList)pkCache_.get(tableName);
        if (pkList != null) {
            Long cachedPK = (Long)pkList.remove(0);
            if (pkList.size() == 0) {
                pkCache_.remove(tableName);
            }
            return cachedPK;
        }        
        if ((existingSequences_.get(tableName.toLowerCase()+"seq")) == null) {
            if (createSequence(tableName)) {
                existingSequences_.put(tableName.toLowerCase()+"seq", tableName.toLowerCase()+"seq");
            }            
        }
        Long pk = null;
        Connection con = null;
        try {
            con = daoFactory_.createConnection();
            //String sqlQuery = "select " + tableName + "seq.nextval";            
            String sqlQuery = "select nextval('"+tableName+"seq')";
            PreparedStatement stmt = con.prepareStatement(sqlQuery);
            ArrayList currentPKList = new ArrayList();
            for (int i=0; i<cacheSize_; i++) {
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    pk = new Long(rs.getLong(1));
                    currentPKList.add(pk);
                }
                rs.close();
            }
            pk = (Long)currentPKList.remove(0);  //retrieve first element in order to avoid duplicate PKs            
            pkCache_.put(tableName, currentPKList);
            stmt.close();
        } catch (java.sql.SQLException sqlExc) {
            sqlExc.printStackTrace();            
        } finally {
            try {
                con.close();
            } catch (java.sql.SQLException sqlExc) {
                sqlExc.printStackTrace();
            }
        }       
        return pk;
    }

    public Long getPrimaryKeyWithoutCache(String tableName) {
        tableName = tableName.replaceAll("-", "_");        
        if ((existingSequences_.get(tableName.toLowerCase()+"seq")) == null) {
            if (createSequence(tableName)) {
                existingSequences_.put(tableName.toLowerCase()+"seq", tableName.toLowerCase()+"seq");
            }            
        }                
        Long pk = null;
        Connection con = null;
        try {
            con = daoFactory_.createConnection();
            String sqlQuery = "select nextval('"+tableName+"seq')";
            PreparedStatement stmt = con.prepareStatement(sqlQuery);            
            ResultSet rs = stmt.executeQuery();
            if (rs.next())
                pk = new Long(rs.getLong(1));
            rs.close();
            stmt.close();
        } catch (java.sql.SQLException sqlExc) {
            log_.error("sqlExc: "+sqlExc);
            sqlExc.printStackTrace();
        } finally {
            try {
                con.close();
            } catch (java.sql.SQLException sqlExc) {
                sqlExc.printStackTrace();
            }
        }
        return pk;
    }
    
    private boolean createSequence(String tableName, int startValue) {
        boolean retValue = true;
        Connection con = daoFactory_.createConnection();                
        String sqlQuery = "CREATE SEQUENCE " + tableName + "seq ";
        sqlQuery = sqlQuery + "INCREMENT BY 1 ";
        sqlQuery = sqlQuery + "START WITH "+startValue+" ";
        sqlQuery = sqlQuery + "MINVALUE "+startValue+" ";
        //sqlQuery = sqlQuery + "MAXVALUE 999999999999999999999999999 ";
        sqlQuery = sqlQuery + "CACHE 50";
        try {
            Statement stmt = con.createStatement();
            stmt.execute(sqlQuery);
            stmt.close();
            con.close();
        } catch (java.sql.SQLException createSQLExc) {
            createSQLExc.printStackTrace();
            retValue = false;
        }        
        return retValue;
    }
    
    private boolean createSequence(String tableName) {
        return createSequence(tableName, 100);
    }
    public String toString() {
        return "PostgreSQLPKGenerator";
    }
    
    public void setPkValuesAtBeginning(Connection con, String tableName) throws SQLException{
      tableName = tableName.replaceAll("-", "_");
      if ((existingSequences_.get(tableName.toLowerCase()+"seq")) != null) {
        String sqlQuery = "select nextval('"+tableName+"seq')";
        PreparedStatement stmt = con.prepareStatement(sqlQuery);
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
          rs.getLong(1);
          rs.close();
          stmt.close();
          sqlQuery = "select setval('"+tableName.toLowerCase()+"seq','100')";
          stmt = con.prepareStatement(sqlQuery);
          stmt.execute();
          stmt.close();
        }else{
          rs.close();
          stmt.close();          
        }
      }
    }
}