package at.tugraz.genome.maspectras.chromaviewer;

import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.*;
import java.awt.*;

public class Cg2dGraphicsManager extends Panel implements MouseMotionListener,
    MouseListener, ActionListener
{

  /** the uid */
  private static final long serialVersionUID = 1L;

  private CgChromaViewer m_viewer;

  private Cursor m_crosshair;

  private TextField m_txtMz;

  private TextField m_txtTime;

  private TextField m_txtIntensity;

  private Button m_plusGain;

  private Button m_minusGain;

  private Button m_plusShift;

  private Button m_minusShift;

  private PopupMenu m_popup;

  private MenuItem m_addUserProbe1;

  private MenuItem m_addUserProbe2;

  private MenuItem m_deleteUserProbe;

  public int lastPopupX = 0;

  public int lastPopupY = 0;
  
  public Button requestSpectrum_;

  public Cg2dGraphicsManager(CgChromaViewer myViewer)
  {
    super(null);
    m_viewer = myViewer;
    this.addMouseMotionListener(this);
    this.addMouseListener(this);
    m_crosshair = new Cursor(Cursor.CROSSHAIR_CURSOR);
  }

  public void initialize()
  {
    m_txtMz = new TextField();
    m_txtMz.setBounds(this.getWidth() - 90, 5, 85, 20);
    m_txtMz.setBackground(Color.WHITE);
    m_txtMz.setEnabled(false);
    m_txtMz.setForeground(Color.BLACK);
    m_txtMz.setVisible(true);
    this.add(m_txtMz);

    m_txtTime = new TextField();
    m_txtTime.setBounds(this.getWidth() - 90, 27, 85, 20);
    m_txtTime.setBackground(Color.WHITE);
    m_txtTime.setForeground(Color.BLACK);
    m_txtTime.setEnabled(false);
    m_txtTime.setVisible(true);
    this.add(m_txtTime);

    m_txtIntensity = new TextField();
    m_txtIntensity.setBounds(this.getWidth() - 90, 49, 85, 20);
    m_txtIntensity.setBackground(Color.WHITE);
    m_txtIntensity.setForeground(Color.BLACK);
    m_txtIntensity.setEnabled(false);
    m_txtIntensity.setVisible(true);
    this.add(m_txtIntensity);

    m_plusGain = new Button();
    m_plusGain.setLabel("+ Gain");
    m_plusGain.setBounds(this.getWidth() - 55, m_txtIntensity.getY() + 23, 50,
        24);
    m_plusGain.addActionListener(new CgActionListener(m_viewer, "Plus2dGain"));
    this.add(m_plusGain);
    m_minusGain = new Button();
    m_minusGain.setLabel("- Gain");
    m_minusGain.setBounds(this.getWidth() - 55, m_plusGain.getY() + 25, 50, 24);
    m_minusGain
        .addActionListener(new CgActionListener(m_viewer, "Minus2dGain"));
    this.add(m_minusGain);

    m_plusShift = new Button();
    m_plusShift.setLabel(">>");
    m_plusShift
        .setBounds(this.getWidth() - 30, m_minusGain.getY() + 25, 25, 24);
    m_plusShift
        .addActionListener(new CgActionListener(m_viewer, "Plus2dShift"));
    this.add(m_plusShift);
    m_minusShift = new Button();
    m_minusShift.setLabel("<<");
    m_minusShift.setBounds(this.getWidth() - 55, m_minusGain.getY() + 25, 25,
        24);
    m_minusShift.addActionListener(new CgActionListener(m_viewer,
        "Minus2dShift"));
    this.add(m_minusShift);
    
    requestSpectrum_ = new Button();
    requestSpectrum_.setLabel("Request a spectrum for this charge state");
    requestSpectrum_.setBounds(this.getWidth()/2-150, m_txtIntensity.getY(), 300,
        24);
    requestSpectrum_.addActionListener(new CgActionListener(m_viewer,
        "RequestSpectrum"));
    this.add(requestSpectrum_);
    


    m_popup = new PopupMenu("Peak selection");
    m_addUserProbe1 = new MenuItem("Determine Area");
    m_addUserProbe1.addActionListener(this);
    m_popup.add(m_addUserProbe1);
    m_addUserProbe2 = new MenuItem("Determine Area (Col)");
    m_addUserProbe2.addActionListener(this);
    m_popup.add(m_addUserProbe2);
    m_popup.addSeparator();
    m_deleteUserProbe = new MenuItem("Delete Area");
    m_deleteUserProbe.addActionListener(this);
    m_popup.add(m_deleteUserProbe);
    this .add(m_popup);

    hideFields();
    requestSpectrum_.setVisible(false);
  }

  public void showFields()
  {
    m_txtMz.setVisible(true);
    m_txtTime.setVisible(true);
    m_txtIntensity.setVisible(true);
    m_plusGain.setVisible(true);
    m_minusGain.setVisible(true);
    m_plusShift.setVisible(true);
    m_minusShift.setVisible(true);
    this.requestSpectrum_.setVisible(false);
  }

  public void hideFields()
  {
    m_txtMz.setVisible(false);
    m_txtTime.setVisible(false);
    m_txtIntensity.setVisible(false);
    m_plusGain.setVisible(false);
    m_minusGain.setVisible(false);
    m_plusShift.setVisible(false);
    m_minusShift.setVisible(false);
    this.requestSpectrum_.setVisible(true);
  }

  public void setMz(float newVal)
  {
    m_txtMz.setText("mz = " + CgUtilities.Format(newVal, 2) + "d");
  }

  public void clearMz()
  {
    m_txtMz.setText("");
  }

  public void setRetentionTime(float newVal)
  {
    if (newVal >= 0) {
      int i = (int) newVal;
      String s = Integer.toString(i);
      m_txtTime.setText("t = " + s);
    } else
      m_txtTime.setText("");
  }

  public void clearRetentionTime()
  {
    m_txtTime.setText("");
  }

  public void setIntensity(float newVal)
  {
    if (newVal >= 0) {
      String s = String.format("Int = %4.3e", newVal);
      s = s.replace("+", "").replace("e0", "e");
      m_txtIntensity.setText(s);
    } else
      m_txtIntensity.setText("");
  }

  public void clearIntensity()
  {
    m_txtIntensity.setText("");
  }

  public void preparePaint()
  {
    Graphics g = this.getGraphics();
    g.clearRect(0, 0, this.getWidth(), this.getHeight());
    this.invalidate();
  }

  public void paint(Graphics g)
  {
    g.setColor(new Color(240, 240, 240));
    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    if (m_viewer!=null)
      m_viewer.paint2dGraphics(g);
  }

  public void setCrosshairCursor()
  {
    setCursor(m_crosshair);
  }

  public void setDefaultCursor()
  {
    setCursor(Cursor.getDefaultCursor());
  }

  public void actionPerformed(ActionEvent e)
  {
    m_viewer.popup2dMenuAction(e);
  }

  public void mouseDragged(MouseEvent e)
  {
    m_viewer.mouse2dAction(e);
  }

  public void mouseMoved(MouseEvent e)
  {
    m_viewer.mouse2dAction(e);
  }

  public void mouseClicked(MouseEvent e)
  {
    m_viewer.mouse2dAction(e);
  }

  public void mouseEntered(MouseEvent e)
  {
    m_viewer.mouse2dAction(e);
  }

  public void mouseExited(MouseEvent e)
  {
    m_viewer.mouse2dAction(e);
  }

  public void mousePressed(MouseEvent e)
  {
    m_viewer.mouse2dAction(e);
  }

  public void mouseReleased(MouseEvent e)
  {
    if (e.isPopupTrigger()||e.getButton()==MouseEvent.BUTTON3) {
      if (m_viewer.allow2dPopup(e.getX(), e.getY()) == 0)
        return;
      boolean usrPr = m_viewer.any2dUserCgProbeThere(e.getX());
      boolean sysPr = m_viewer.any2dSystemCgProbeThere(e.getX());
      m_deleteUserProbe.setEnabled(usrPr || sysPr);
      m_addUserProbe1.setEnabled(sysPr == false && usrPr == false);
      m_addUserProbe2.setEnabled(sysPr == false && usrPr == false);

      this.setCursor(Cursor.getDefaultCursor());
      lastPopupX = e.getX();
      lastPopupY = e.getY();
      m_popup.show(e.getComponent(), e.getX(), e.getY());
    }
  }

  public void reshape(int x, int y, int width, int height)
  {
    super.reshape(x, y, width, height);
    if (m_txtMz != null) {
      m_txtMz.setBounds(this.getWidth() - 90, 5, 85, 20);
      m_txtTime.setBounds(this.getWidth() - 90, 27, 85, 20);
      m_txtIntensity.setBounds(this.getWidth() - 90, 49, 85, 20);
      m_plusGain.setBounds(this.getWidth() - 55, m_txtIntensity.getY() + 23,
          50, 24);
      m_minusGain.setBounds(this.getWidth() - 55, m_plusGain.getY() + 25, 50,
          24);
      m_plusShift.setBounds(this.getWidth() - 30, m_minusGain.getY() + 25, 25,
          24);
      m_minusShift.setBounds(this.getWidth() - 55, m_minusGain.getY() + 25, 25,
          24);
    }
  }

  public void destroy2dGraphicsManager()
  {
    this.m_addUserProbe1 = null;
    this.m_addUserProbe2 = null;
    this.m_crosshair = null;
    this.m_deleteUserProbe = null;
    if (this.m_minusGain!=null)
      this.m_minusGain.getGraphics().dispose();
    this.m_minusGain = null;
    if (this.m_minusShift!=null)
      this.m_minusShift.getGraphics().dispose();
    this.m_minusShift = null;
    if (this.m_plusGain!=null)
      this.m_plusGain.getGraphics().dispose();
    this.m_plusGain = null;
    if (this.m_plusShift!=null)
      this.m_plusShift.getGraphics().dispose();
    this.m_plusShift = null;
    this.m_popup = null;
    if (this.m_txtIntensity!=null)
      this.m_txtIntensity.getGraphics().dispose();
    this.m_txtIntensity = null;
    if (this.m_txtMz!=null)
      this.m_txtMz.getGraphics().dispose();
    this.m_txtMz = null;
    if (this.m_txtTime!=null)
      this.m_txtTime.getGraphics().dispose();
    this.m_txtTime = null;
    if (this.m_viewer!=null)
      this.m_viewer.getGraphics().dispose();
    this.m_viewer = null;
//    try {
//      this.finalize();
//    }
//    catch (Throwable e) {
      // TODO Auto-generated catch block
//      e.printStackTrace();
//    }
  }

}
