package at.tugraz.genome.maspectras.chromaviewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

public class CgFooterManager extends Panel
{
  /** the uid */
  private static final long serialVersionUID = 1L;

  private String m_status;

  public CgFooterManager()
  {
    super(null);
    m_status = "Idle.";
  }

  public void setStatus(String newStatus)
  {
    m_status = newStatus;
    Graphics gx = this.getGraphics();
    gx.setColor(new Color(240, 240, 240));
    gx.clearRect(0, 0, this.getWidth(), this.getHeight());
    paint(this.getGraphics());
  }

  public void paint(Graphics gx)
  {
    gx.setColor(Color.BLACK);
    gx.setFont(new Font("SansSerif", Font.PLAIN, 14));
    gx.drawString("Status: " + m_status, 5, 15);
  }
  
  public void destroyFooter(){
    this.getGraphics().dispose();
    this.m_status = null;
  }
  
}
