package at.tugraz.genome.maspectras.chromaviewer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;


import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JCheckBox;

import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.ChromatogramReader;

import com.sun.j3d.utils.applet.MainFrame;




public class MSViewerStandalone extends JApplet implements ActionListener
{

  /**
   * 
   */
  private static final long serialVersionUID = -7243334196488319000L;
  JFileChooser inputFileChooser;
  Panel topMenu;
  JButton jButtonOpen;
  JTextField selectedFile;
  JLabel startMz;
  JLabel stopMz;
  JLabel startTime;
  JLabel stopTime;
  JLabel light;
  JLabel texture;
  JLabel resMz;
  JLabel resTime;
  
  JTextField startText;
  JTextField stopText;
  JTextField startTimeText;
  JTextField stopTimeText;
  JCheckBox lightBox;
  JCheckBox textureBox;
  JTextField resMzText;
  JTextField resTimeText;
  
  JButton startViewer;
  
  MSMapViewer viewer;
  
  public MSViewerStandalone(){
    this.setLayout(new BorderLayout());
    this.topMenu = new Panel();
    this.topMenu.setLayout(new GridBagLayout());

    this.selectedFile = new JTextField(35);
//    selectedFile.setEnabled(false);
    topMenu.add(selectedFile,new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    
    jButtonOpen = new JButton("Open File");
    jButtonOpen.addActionListener(this);
    jButtonOpen.setActionCommand("showFileChooser");
    topMenu.add(jButtonOpen,new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
   
    startMz = new JLabel("start: ");
    topMenu.add(startMz,new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));

    startText = new JTextField(7);
    topMenu.add(startText,new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    
    stopMz = new JLabel("stop: ");
    topMenu.add(stopMz,new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));

    
    stopText = new JTextField(7);
    topMenu.add(stopText,new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    
    lightBox = new JCheckBox("light",true);
    topMenu.add(lightBox,new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    textureBox = new JCheckBox("texture",true);    
    topMenu.add(textureBox,new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    
    resMz = new JLabel("Res-m/z: "); 
    topMenu.add(resMz,new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    resMzText = new JTextField("0.1",6);
    topMenu.add(resMzText,new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));    
    resTime = new JLabel("Res-time: "); 
    topMenu.add(resTime,new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    resTimeText = new JTextField("10",6);
    topMenu.add(resTimeText,new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));    
    startTime = new JLabel("time-start: ");
    topMenu.add(startTime,new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    startTimeText = new JTextField(7);
    topMenu.add(startTimeText,new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    stopTime = new JLabel("time-stop: ");
    topMenu.add(stopTime,new GridBagConstraints(9, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    stopTimeText = new JTextField(7);
    topMenu.add(stopTimeText,new GridBagConstraints(10, 1, 1, 1, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    
    startViewer = new JButton("StartViewer");
    startViewer.addActionListener(this);
    startViewer.setActionCommand("StartViewer");
    topMenu.add(startViewer,new GridBagConstraints(11, 0, 1, 2, 0.0, 0.0
        ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 6, 0, 0), 0, 0));
    
    //FileDialog dialog = new FileDialog(this.inputFileChooser);
/*    this.inputFile = new JFileChooser();
    topMenu.add(inputFile);*/
    this.add(topMenu,BorderLayout.NORTH);
  }
  
  public static void main(String[] args)
  {
    new MainFrame(new MSViewerStandalone(), 1024, 1024);;
  }

  public void actionPerformed(ActionEvent arg0)
  {
    String command = arg0.getActionCommand();
    if (command.equalsIgnoreCase("showFileChooser")){
      this.inputFileChooser = new JFileChooser();
      this.inputFileChooser.setPreferredSize(new Dimension(600,500));
      
      int returnVal = this.inputFileChooser.showOpenDialog(new Frame());;
      if (returnVal == JFileChooser.APPROVE_OPTION) {
         String text = this.inputFileChooser.getSelectedFile().getAbsolutePath();
         this.selectedFile.setText(text);
      } else return;
    }
    if (command.equalsIgnoreCase("StartViewer")){
      if (this.viewer!=null){
        this.remove(this.viewer);
      }
      this.initANewViewer();
    }
    
  }
  
  
  private void initANewViewer(){
    ChromatogramReader reader;
    try {
      reader = new ChromatogramReader(this.selectedFile.getText(),false);
      float startFloat = Float.parseFloat(this.startText.getText());
      float stopFloat = Float.parseFloat(this.stopText.getText());
      
      String[] rawLines = reader.getRawLines(startFloat, stopFloat);
      Hashtable<Integer,Float> rtTimes = reader.getRetentionTimes();
      
      float startTime = 0;
      float stopTime = 0;
      if (this.startTimeText.getText()!=null&&this.startTimeText.getText().length()>0){
        startTime = Float.parseFloat(this.startTimeText.getText());
      }
      if (this.stopTimeText.getText()!=null&&this.stopTimeText.getText().length()>0){
        stopTime = Float.parseFloat(this.stopTimeText.getText());
      }

      this.viewer = MSMapViewerFactory.getMSMapViewer(rawLines, rtTimes,
          startFloat,stopFloat,startTime,stopTime,reader.getMultiplicationFactorForInt_()/reader.getLowestResolution_(),5f,this);
      viewer.setViewerSettings(this.lightBox.isSelected(), this.textureBox.isSelected(), this.resMzText.getText(), this.resTimeText.getText());
      viewer.init();
      this.viewer.removeSaveSettings();
      this.add("Center", viewer);
      this.validate();
      this.repaint();
    }
    catch (CgException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

}
