package at.tugraz.genome.maspectras.parser;

/**
 * <p>
 * Title: MASPECTRAS
 * </p>
 * <p>
 * Description: Reads XML Files into a DOM tree for parsing
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: University of Technology Graz
 * </p>
 * 
 * @author Juergen Hartler
 * @version 1.0
 */

import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.xml.sax.*;

import java.io.*;

public class XMLFileLoader
{

  /** the DOM document*/
  private Document doc = null;

  /**
   * @param stream input stream for the XML file
   * @throws IOException
   */
  public XMLFileLoader(InputStream stream) throws IOException
  {


    boolean validation = false;
    boolean ignoreWhitespace = true;
    boolean ignoreComments = true;
    boolean putCDATAIntoText = false;
    boolean createEntityRefs = false;
    // if (fn.exists()){
    // Step 1: create a DocumentBuilderFactory and configure it
    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    // Optional: set various configuration options
    dbf.setValidating(validation);
    dbf.setIgnoringComments(ignoreComments);
    dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
    dbf.setCoalescing(putCDATAIntoText);
    // dbf.setCoalescing(true);
    // The opposite of creating entity ref nodes is expanding them inline
    dbf.setExpandEntityReferences(!createEntityRefs);
    // Step 2: create a DocumentBuilder that satisfies the constraints
    // specified by the DocumentBuilderFactory
    DocumentBuilder db = null;
    try {
      db = dbf.newDocumentBuilder();
    }
    catch (ParserConfigurationException pce) {
      System.err.println(pce);
      // javax.swing.JOptionPane.showConfirmDialog(null,
      // "Error Initalising Parser! \n Can not start program",
      // "Parser Error", javax.swing.JOptionPane.CLOSED_OPTION,
      // javax.swing.JOptionPane.ERROR_MESSAGE);
      // System.exit(1);
    }
    // Set an ErrorHandler before parsing
    // db.setErrorHandler(new MyErrorHandler());
    doc = null;
    try {
      doc = db.parse(stream);
      db = null;
      stream.close();
    }
    catch (SAXException se) {
      // try{
      stream.close();
      throw new IOException(se.getMessage());
      // } catch (IOException ioe) {
      // System.err.println(ioe);
      // }
      // System.err.println(se.getMessage());

      // } catch (IOException ioe) {
      // System.err.println(ioe);
    }

    /*
     * }else{  }
     */
  }

  // public XMLFileLoader(String input) throws IOException{
  //
  // boolean validation = false;
  // boolean ignoreWhitespace = true;
  // boolean ignoreComments = true;
  // boolean putCDATAIntoText = false;
  // boolean createEntityRefs = false;
  // DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
  // // Optional: set various configuration options
  // dbf.setValidating(validation);
  // dbf.setIgnoringComments(ignoreComments);
  // dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
  // dbf.setCoalescing(putCDATAIntoText);
  // dbf.setExpandEntityReferences(!createEntityRefs);
  // DocumentBuilder db = null;
  // try {
  // db = dbf.newDocumentBuilder();
  // }catch (ParserConfigurationException pce) {
  // System.err.println(pce);
  // javax.swing.JOptionPane.showConfirmDialog(null,
  // "Error Initalising Parser! \n Can not start program",
  // "Parser Error",
  // javax.swing.JOptionPane.CLOSED_OPTION,
  // javax.swing.JOptionPane.ERROR_MESSAGE);
  // System.exit(1);
  // }
  // doc = null;
  // try {
  // doc = db.parse(input);
  // db = null;
  // } catch (SAXException se) {
  // throw new IOException(se.getMessage());
  // }
  //
  // }

  /**
   * @return the parsed DOM document
   */
  public Document getDocument()
  {
    return this.doc;
  }

  // Error handler to report errors and warnings
  // private static class MyErrorHandler implements ErrorHandler {
  // /** Error handler output goes here */
  // private PrintWriter out;

  // public MyErrorHandler() {
  // }
  //
  // /**
  // * Returns a string describing parse exception details
  // */
  // private String getParseExceptionInfo(SAXParseException spe) {
  // String systemId = spe.getSystemId();
  // if (systemId == null) {
  // systemId = "null";
  // }
  // String info = "URI=" + systemId +
  // " Line=" + spe.getLineNumber() +
  // ": " + spe.getMessage();
  // return info;
  // }
  //
  // // The following methods are standard SAX ErrorHandler methods.
  // // See SAX documentation for more info.
  //
  // public void warning(SAXParseException spe) throws SAXException {
  // }
  //
  // public void error(SAXParseException spe) throws SAXException {
  // String message = "Error: " + getParseExceptionInfo(spe);
  // throw new SAXException(message);
  // }
  //
  // public void fatalError(SAXParseException spe) throws SAXException {
  // String message = "Fatal Error: " + getParseExceptionInfo(spe);
  // throw new SAXException(message);
  // }

  // }
}