package at.tugraz.genome.maspectras.quantification.parser;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;
import java.util.StringTokenizer;

import org.apache.log4j.Logger;

import at.tugraz.genome.maspectras.quantification.exception.AnalyzerClusterNodeException;

import at.tugraz.genome.maspectras.quantification.CgParameterSet;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.CgException;

/**
 * Parses the input files created by MASPECTRAS and sent to the JClusterService
 * 
 * @author Juergen Hartler
 */
public class AnalyzerClusterNodeParser
{
  /** path to the input file */
  protected String fileName_;
  /** input string*/
  protected String inputString_;
  /** the line reader */
  protected LineNumberReader reader_;
  /** line where to stop parsing */
  private int stopLine_ = 0;
  /** line where to start parsing */
  private int startLine_ = 0;
  /** the read lines*/
  private String[] lines;
  /** the parameters for the quantification */
  private Vector cgParams_ = new Vector();
  /** the logger*/
  private static Logger log_ = Logger.getLogger(at.tugraz.genome.maspectras.quantification.parser.AnalyzerClusterNodeParser.class);
  
  /**
   * parses the input file for the quantification on a cluster
   * @param fileName the absolute path to the file
   * @param startLine the start line in the file
   * @param stopLine the stop line in the file
   */
  public AnalyzerClusterNodeParser(String fileName, int startLine, int stopLine)
  {
    fileName_ = fileName;
    this.startLine_ = startLine;
    this.stopLine_ = stopLine;
  }

  /**
   * Starts the parsing of the file
   * @throws AnalyzerClusterNodeException
   */
  public void parse() throws AnalyzerClusterNodeException
  {
    openReader();
    readToArray();
    closeReader();
    parseLines();
  }

  /**
   * Parses the lines of the file
   * @throws AnalyzerClusterNodeException
   */
  private void parseLines() throws AnalyzerClusterNodeException
  {
    cgParams_ = new Vector();
    CgParameterSet set = null;
    try {
      for (int i = 0; i != lines.length; i++) {
        if (lines[i].startsWith(">")) {
          if (set != null)
            cgParams_.add(set);
          set = this.parseParameterSetLine(lines[i], i + startLine_ + 1);
        } else {
          if (set == null)
            throw new AnalyzerClusterNodeException("The start line "
                + startLine_ + " is not a header line");
          CgProbe aProbe = this.parseProbeLine(lines[i], i + startLine_ + 1);
          set.AddProbe(aProbe);
        }
      }
      if (set != null)
        cgParams_.add(set);
    }
    catch (CgException cgx) {
      throw new AnalyzerClusterNodeException(cgx);
    }
  }

  /**
   * @return the Parameterset for the quantification
   */
  public Vector getCgParameters()
  {
    return cgParams_;
  }

  /**
   * @param line line that describes one quantification for one peptide
   * @param lineNumber current line number
   * @return the parameters for one quantification in a VO
   * @throws AnalyzerClusterNodeException
   */
  private CgParameterSet parseParameterSetLine(String line, int lineNumber)
      throws AnalyzerClusterNodeException
  {
    StringTokenizer tokenizer = new StringTokenizer(line, "\t");
    if (tokenizer.countTokens() != 3 && tokenizer.countTokens() != 9
        && tokenizer.countTokens() != 12 && tokenizer.countTokens() != 25)
      throw new AnalyzerClusterNodeException("Header element at line "
          + lineNumber + " has not the right format");
    String item = tokenizer.nextToken();
    String peptideHash = item.substring(1);
    item = tokenizer.nextToken();
    float mzTolerance = 0;
    try {
      mzTolerance = Float.parseFloat(item);
    }
    catch (NumberFormatException nfx) {
      throw new AnalyzerClusterNodeException(
          "Item mzTolerance position 2 at line " + lineNumber
              + " is not float format");
    }
    item = tokenizer.nextToken();
    float mass = 0;
    try {
      mass = Float.parseFloat(item);
    }
    catch (NumberFormatException nfx) {
      throw new AnalyzerClusterNodeException("Item mass position 3 at line "
          + lineNumber + " is not float format");
    }
    if (tokenizer.hasMoreTokens()) {
      item = tokenizer.nextToken();
      float massCharge1 = -1;
      try {
        massCharge1 = Float.parseFloat(item);
      }
      catch (NumberFormatException nfx) {
        throw new AnalyzerClusterNodeException(
            "Item mass for charge 1 position 4 at line " + lineNumber
                + " is not float format");
      }
      item = tokenizer.nextToken();
      float massCharge2 = -1;
      try {
        massCharge2 = Float.parseFloat(item);
      }
      catch (NumberFormatException nfx) {
        throw new AnalyzerClusterNodeException(
            "Item mass for charge 2 position 5 at line " + lineNumber
                + " is not float format");
      }
      item = tokenizer.nextToken();
      float massCharge3 = -1;
      try {
        massCharge3 = Float.parseFloat(item);
      }
      catch (NumberFormatException nfx) {
        throw new AnalyzerClusterNodeException(
            "Item mass for charge3 position 6 at line " + lineNumber
                + " is not float format");
      }
      item = tokenizer.nextToken();
      float massCharge4 = -1;
      try {
        massCharge4 = Float.parseFloat(item);
      }
      catch (NumberFormatException nfx) {
        throw new AnalyzerClusterNodeException(
            "Item mass for charge4 position 7 at line " + lineNumber
                + " is not float format");
      }
      item = tokenizer.nextToken();
      float massCharge5 = -1;
      try {
        massCharge5 = Float.parseFloat(item);
      }
      catch (NumberFormatException nfx) {
        throw new AnalyzerClusterNodeException(
            "Item mass for charge5 position 8 at line " + lineNumber
                + " is not float format");
      }
      item = tokenizer.nextToken();
      float massCharge6 = -1;
      try {
        massCharge6 = Float.parseFloat(item);
      }
      catch (NumberFormatException nfx) {
        throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 9 at line " + lineNumber
                + " is not float format");
      }
      float massCharge7 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge7 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge7 position 10 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge8 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge8 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge8 position 11 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge9 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge9 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge10 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge10 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge11 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge11 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge12 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge12 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge13 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge13 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge14 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge14 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge15 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge15 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge16 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge16 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge17 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge17 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge18 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge18 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge19 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge19 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge20 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge20 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge21 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge21 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      float massCharge22 = -1;
      if (tokenizer.hasMoreTokens()){
        item = tokenizer.nextToken();
        try {
          massCharge22 = Float.parseFloat(item);
        }
        catch (NumberFormatException nfx) {
          throw new AnalyzerClusterNodeException(
            "Item mass for charge6 position 12 at line " + lineNumber
                + " is not float format");
        }
      }
      CgParameterSet set = new CgParameterSet(mass, peptideHash, massCharge1,
          massCharge2, massCharge3, massCharge4, massCharge5, massCharge6,
          massCharge7, massCharge8, massCharge9, massCharge10, massCharge11,
          massCharge12, massCharge13, massCharge14, massCharge15, massCharge16,
          massCharge17, massCharge18, massCharge19, massCharge20, massCharge21,
          massCharge22);
      set.LowerMzBand = mzTolerance;
      set.UpperMzBand = mzTolerance;
      return set;
    } else {
      CgParameterSet set = new CgParameterSet(mass, peptideHash);
      set.LowerMzBand = mzTolerance;
      set.UpperMzBand = mzTolerance;
      return set;
    }
  }

  /**
   * @param line describes the scan number and the charge state
   * @param lineNumber current line
   * @return VO containing scan number and charge state
   * @throws AnalyzerClusterNodeException
   */
  private CgProbe parseProbeLine(String line, int lineNumber)
      throws AnalyzerClusterNodeException
  {
    StringTokenizer tokenizer = new StringTokenizer(line, "\t");
    if (tokenizer.countTokens() != 2)
      throw new AnalyzerClusterNodeException("The cgProbeLine " + lineNumber
          + " has not the right format");
    String item = tokenizer.nextToken();
    int charge = 0;
    try {
      charge = Integer.decode(item);
    }
    catch (NumberFormatException nfx) {
      throw new AnalyzerClusterNodeException(
          "Item charge for CgProbe position 1 at line " + lineNumber
              + " is not integer format");
    }
    item = tokenizer.nextToken();
    int scanNumber = 0;
    try {
      scanNumber = Integer.decode(item);
    }
    catch (NumberFormatException nfx) {
      throw new AnalyzerClusterNodeException(
          "Item scanNumber for CgProbe position 2 at line " + lineNumber
              + " is not integer format");
    }
    CgProbe probe = new CgProbe(scanNumber, charge);
    return probe;
  }

  /**
   * reads the whole file into a string array
   */
  private void readToArray()
  {
    String line;
    Vector lineVector = new Vector();
    int count = 0;
    try {
      while ((line = reader_.readLine()) != null && stopLine_ > count) {
        if (count >= startLine_) {
          lineVector.add(line);
        }
        count++;
      }
      lines = new String[lineVector.size()];
      for (int i = 0; i != lineVector.size(); i++) {
        if ((String) lineVector.get(i) != null)
          lines[i] = (String) lineVector.get(i);
        else {
          lines[i] = "";
        }
      }
      lineVector.clear();
    }
    catch (java.io.IOException iox) {
      iox.printStackTrace();
    }
  }

  /**
   * initializes line reader
   */
  protected void openReader()
  {
    try {
      reader_ = new LineNumberReader(new FileReader(fileName_));
    }
    catch (IOException e) {
      log_.error("IO error while opening the file: " + fileName_);
    }
  }


  /**
   * closes the reader
   */
  protected void closeReader()
  {
    try {
      reader_.close();
    }
    catch (IOException e) {
      log_.error("IO error while closing the file: " + fileName_);
    }
  }

}
