package at.tugraz.genome.maspectras.quantification.vos;

import java.io.Serializable;

/**
 * One chromatogram time point
 * @author Juergen Hartler
 *
 */
public class CgChromatogramPointVO implements Serializable
{
  /** scan number*/
  private float scan;
  /** scan intensity */
  private float intensity;
  /** smoothed intensity value */
  private float smoothedIntensity;
  
  /**
   * @param scan scan number
   * @param intensity scan intensity
   * @param smoothedIntensity smoothed intensity value
   */
  public CgChromatogramPointVO(float scan, float intensity, float smoothedIntensity)
  {
    this.intensity = intensity;
    this.scan = scan;
    this.smoothedIntensity = smoothedIntensity;
  }
  /**
   * @return scan intensity
   */
  public float getIntensity()
  {
    return intensity;
  }
  /**
   * @param intensity scan intensity
   */
  public void setIntensity(float intensity)
  {
    this.intensity = intensity;
  }
  /**
   * @return scan number
   */
  public float getScan()
  {
    return scan;
  }
  /**
   * @param scan scan number
   */
  public void setScan(float scan)
  {
    this.scan = scan;
  }
  /**
   * @return smoothed intensity value
   */
  public float getSmoothedIntensity()
  {
    return smoothedIntensity;
  }
  /**
   * @param smoothedIntensity smoothed intensity value
   */
  public void setSmoothedIntensity(float smoothedIntensity)
  {
    this.smoothedIntensity = smoothedIntensity;
  }
  
  
}
