package at.tugraz.genome.maspectras.quantification.vos;

import java.io.Serializable;
import java.util.Vector;
import java.util.Hashtable;

/**
 * Set containing the parameters for the quantification
 * @author Juergen Hartler
 *
 */
public class CgChromatogramSet implements Serializable
{

  /**
   * @param peptidehits the found peptide hits
   * @param probes position of the peak areas selected
   * @param autoProbes position of the automatically selecte peak areas
   * @param chromatograms the chromatograms themselves for one charge state
   * @param step the m/z step to the next chromatogram
   * @param lowerSpan number of chromatograms below the main one
   * @param upperSpan number of chromatograms above the main one
   */
  public CgChromatogramSet (Vector peptidehits, Vector probes, Vector autoProbes, Vector chromatograms, Double step,
      Integer lowerSpan, Integer upperSpan, Integer automaticQuantMethod){
    this.peptidehits = peptidehits;
    this.cgProbes = probes;
    this.oldProbes = autoProbes;
    this.chromatograms = chromatograms;
    this.rawData = null;
    this.retentionTimes = null;
    this.step = step;
    this.lowerSpan = lowerSpan;
    this.upperSpan = upperSpan;
    this.automaticQuantMethod = automaticQuantMethod;
  }
  
  public CgChromatogramSet (Vector peptidehits, Vector probes, Vector autoProbes, Vector chromatograms, String[] rawData,  Hashtable retentionTimes, Integer numberOfScans,Double step,
      Integer lowerSpan, Integer upperSpan,Integer resolutionFactor, Integer automaticQuantMethod){
    this(peptidehits,probes,autoProbes,chromatograms,step,lowerSpan,upperSpan,automaticQuantMethod);
    this.numberOfScans = numberOfScans;
    this.rawData = rawData;
    this.resolutionFactor = resolutionFactor;
    this.retentionTimes = retentionTimes;
  }
  
  /** the found peptide hits*/
  private Vector peptidehits;
  /** the peak areas selected*/
  private Vector cgProbes;
  /** the stored peak areas */
  private Vector oldProbes;
  /** the m/z step to the next chromatogram */
  private Double step;
  /** number of chromatograms below the main one */
  private Integer lowerSpan;
  /** number of chromatograms above the main one*/
  private Integer upperSpan;
  /** chromatograms themselves for one charge state*/
  private Vector chromatograms;
  private Hashtable retentionTimes;
  
  private String[] rawData;
  
  private Integer numberOfScans;
  
  private Integer resolutionFactor;
  
  private Integer automaticQuantMethod;
  
  /**
   * @return position of the peak areas selected
   */
  public Vector getCgProbes()
  {
    return this.cgProbes;
  }
  /**
   * @param cgProbes position of the peak areas selected
   */
  public void setCgProbes(Vector cgProbes)
  {
    this.cgProbes = cgProbes;
  }
  /**
   * @return found peptide hits
   */
  public Vector getPeptidehits()
  {
    return peptidehits;
  }
  /**
   * @param peptidehits found peptide hits
   */
  public void setPeptidehits(Vector peptidehits)
  {
    this.peptidehits = peptidehits;
  }
  /**
   * @return chromatograms for one charge state
   */
  public Vector getChromatograms()
  {
    return chromatograms;
  }
  /**
   * @param chromatograms chromatograms for one charge state
   */
  public void setChromatograms(Vector chromatograms)
  {
    this.chromatograms = chromatograms;
  }
  /**
   * @return position of the automatically selecte peak areas
   */
  public Vector getOldProbes()
  {
    return oldProbes;
  }
  /**
   * @param oldProbes position of the automatically selecte peak areas
   */
  public void setOldProbes(Vector oldProbes)
  {
    this.oldProbes = oldProbes;
  }
  /**
   * @return number of chromatograms below the main one
   */
  public Integer getLowerSpan()
  {
    return lowerSpan;
  }
  /**
   * @param lowerSpan number of chromatograms below the main one
   */
  public void setLowerSpan(Integer lowerSpan)
  {
    this.lowerSpan = lowerSpan;
  }
  /**
   * @return the m/z step to the next chromatogram
   */
  public Double getStep()
  {
    return step;
  }
  /**
   * @param step m/z step to the next chromatogram
   */
  public void setStep(Double step)
  {
    this.step = step;
  }
  /**
   * @return number of chromatograms above the main one
   */
  public Integer getUpperSpan()
  {
    return upperSpan;
  }
  /**
   * @param upperSpan number of chromatograms above the main one
   */
  public void setUpperSpan(Integer upperSpan)
  {
    this.upperSpan = upperSpan;
  }

  public String[] getRawData()
  {
    return rawData;
  }
  
  

  public Integer getNumberOfScans()
  {
    return numberOfScans;
  }

  public Hashtable getRetentionTimes()
  {
    return retentionTimes;
  }

  public Integer getResolutionFactor()
  {
    return resolutionFactor;
  }

  public Integer getAutomaticQuantMethod()
  {
    return automaticQuantMethod;
  }

  public void setAutomaticQuantMethod(Integer automaticQuantMethod)
  {
    this.automaticQuantMethod = automaticQuantMethod;
  }
  
  
}
