package at.tugraz.genome.maspectras.quantification.vos;

/**
 * Indicates the MS level and the m/z range
 * @author Juergen Hartler
 *
 */
public class LevelRangeVO
{

  /** the MS level*/
  private int level;
  /** the lower m/z value*/
  private float lowerMz;
  /** the uper m/z value */
  private float upperMz;
  
  
  /**
   * @param level the MS level
   * @param lowerMz ower m/z value
   * @param upperMz uper m/z value
   */
  public LevelRangeVO(int level, float lowerMz, float upperMz)
  {
    this.level = level;
    this.lowerMz = lowerMz;
    this.upperMz = upperMz;
  }
  /**
   * @return the MS level
   */
  public int getLevel()
  {
    return level;
  }
  /**
   * @param level the MS level
   */
  public void setLevel(int level)
  {
    this.level = level;
  }
  /**
   * @return lower m/z value
   */
  public float getLowerMz()
  {
    return lowerMz;
  }
  /**
   * @param lowerMz lower m/z value
   */
  public void setLowerMz(float lowerMz)
  {
    this.lowerMz = lowerMz;
  }
  /**
   * @return upper m/z value
   */
  public float getUpperMz()
  {
    return upperMz;
  }
  /**
   * @param upperMz upper m/z value
   */
  public void setUpperMz(float upperMz)
  {
    this.upperMz = upperMz;
  }
}
