package at.tugraz.genome.maspectras.rawfilereader;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

/** This class contains about one scan entry. Sequest
 *  seems to combine sometimes scanentries to one spectra,
 *  it drops also scans with less than 25 detector hits.
 */ 
public class MSPrecursorInfo {

  public final static String	ATTRIBUTE_PRECURSOR_INTENSITY="precursor intensity";
  public final static String	ATTRIBUTE_COLLISION_ENERGY="collision energy";
  public final static String	ATTRIBUTE_PRECURSOR_MZ="precursor mz";

/** List of attributes attached to this scan.
 */
  private Hashtable	attributes;

  protected MSPrecursorInfo(Hashtable attributes) {
    this.attributes=attributes;
  }

  public Object getAttribute(String key) {
    return(attributes.get(key));
  }
  public String[] getAttributeNames() {
    Enumeration keyenum=attributes.keys();
    ArrayList list=new ArrayList();
    while(keyenum.hasMoreElements()) {
      list.add(keyenum.nextElement());
    }
    String ret[]=new String[list.size()];
    list.toArray(ret);
    return(ret);
  }
}
