package at.tugraz.genome.util.index;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import at.tugraz.genome.util.BioUtilsConstants;


/**
 * Reads the properties from the header file
 * @author Juergen Hartler
 *
 */
public class IndexedLineNumberHeaderReader
{

  /** file name of the header file*/
  protected String fileName_;
  /** the properties in the file*/
  protected Properties properties_;
  
  /**
   * 
   * @param fileName the header file name
   */
  public IndexedLineNumberHeaderReader(String fileName){
    this.fileName_ = fileName;
  }

  /**
   * Parses the file and reads the properties
   * @throws IndexFileException
   */
  public void readFile() throws IndexFileException{
    try {
      properties_ = new Properties();
      FileInputStream getIt = new FileInputStream(fileName_);
      properties_.load(getIt);
      getIt.close();
    }catch(FileNotFoundException e1) {
      System.err.println(e1);
    }catch (IOException e2) {
      System.err.println(e2);
    }
  }
  
  /**
   * 
   * @return the path to the index file
   * @throws IndexFileException
   */
  public String getIndexFilePath() throws IndexFileException{
    if (properties_==null) throw new IndexFileException("The file must be read first");
    String indexFilePath = (String)properties_.get(BioUtilsConstants.INDEX_HEADER_FILE_INDEX_FILE);
    if (indexFilePath==null) throw new IndexFileException("There is no index file path");
    return indexFilePath;
  }
 
  /**
   * 
   * @return the path to the indexed file
   * @throws IndexFileException
   */
  public String getIndexedFilePath() throws IndexFileException{
    if (properties_==null) throw new IndexFileException("The file must be read first");
    String indexFilePath = (String)properties_.get(BioUtilsConstants.INDEX_HEADER_FILE_INDEXED_FILE);
    if (indexFilePath==null) throw new IndexFileException("There is no file path for the indexed file");
    return indexFilePath;
  }
  
  /**
   * 
   * @return how many lines are used for one index entry
   * @throws IndexFileException
   */
  public int getNumberOfLinesForIndex() throws IndexFileException{
    if (properties_==null) throw new IndexFileException("The file must be read first");
    String numberOfLinesForIndex = (String)properties_.get(BioUtilsConstants.INDEX_HEADER_FILE_NUMBER_OF_ENTRIES_FOR_INDEX);
    if (numberOfLinesForIndex==null) throw new IndexFileException("There is no number of lines");
    return new Integer(numberOfLinesForIndex);
  }
  
  /**
   * 
   * @return the total number of lines from the original file
   * @throws IndexFileException
   */
  public int getNumberOfLinesTotal() throws IndexFileException{
    if (properties_==null) throw new IndexFileException("The file must be read first");
    String numberOfLines = (String)properties_.get(BioUtilsConstants.INDEX_HEADER_FILE_NUMBER_OF_LINES);
    if (numberOfLines==null) throw new IndexFileException("There is no numberOfLines");
    return new Integer(numberOfLines);
  }

}
