/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.jogamp.java3d.AppearanceRetained;
import org.jogamp.java3d.AttributeBin;
import org.jogamp.java3d.AutoOffScreenCanvas3D;
import org.jogamp.java3d.BackgroundRetained;
import org.jogamp.java3d.BehaviorScheduler;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.CachedFrustum;
import org.jogamp.java3d.CanvasViewCache;
import org.jogamp.java3d.CanvasViewEventCatcher;
import org.jogamp.java3d.ColoringAttributesRetained;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.Drawable;
import org.jogamp.java3d.DrawingSurfaceObject;
import org.jogamp.java3d.EnvironmentSet;
import org.jogamp.java3d.EventCatcher;
import org.jogamp.java3d.FogRetained;
import org.jogamp.java3d.GraphicsConfigInfo;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.GraphicsContext3D;
import org.jogamp.java3d.IllegalRenderingStateException;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.ImageComponent2DRetained;
import org.jogamp.java3d.ImageComponentRetained;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.J3DGraphics2DImpl;
import org.jogamp.java3d.J3dDebug;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dQueryProps;
import org.jogamp.java3d.LightBin;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.LineAttributesRetained;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.MaterialRetained;
import org.jogamp.java3d.ModelClipRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.PointAttributesRetained;
import org.jogamp.java3d.PolygonAttributesRetained;
import org.jogamp.java3d.RasterRetained;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.RenderAtomListInfo;
import org.jogamp.java3d.RenderMolecule;
import org.jogamp.java3d.Renderer;
import org.jogamp.java3d.RenderingAttributesRetained;
import org.jogamp.java3d.RestrictedAccessException;
import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.ShaderBin;
import org.jogamp.java3d.ShaderProgramRetained;
import org.jogamp.java3d.TexCoordGenerationRetained;
import org.jogamp.java3d.Texture2DRetained;
import org.jogamp.java3d.TextureAttributesRetained;
import org.jogamp.java3d.TextureBin;
import org.jogamp.java3d.TextureRetained;
import org.jogamp.java3d.TextureUnitStateRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransparencyAttributesRetained;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatform;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector4d;

public class Canvas3D
extends Canvas {
    public static final int FIELD_LEFT = 0;
    public static final int FIELD_RIGHT = 1;
    public static final int FIELD_ALL = 2;
    static final int POLYGONATTRS_DIRTY = 1;
    static final int LINEATTRS_DIRTY = 2;
    static final int POINTATTRS_DIRTY = 4;
    static final int MATERIAL_DIRTY = 8;
    static final int TRANSPARENCYATTRS_DIRTY = 16;
    static final int COLORINGATTRS_DIRTY = 32;
    static final int LIGHTBIN_DIRTY = 64;
    static final int LIGHTENABLES_DIRTY = 128;
    static final int AMBIENTLIGHT_DIRTY = 256;
    static final int ATTRIBUTEBIN_DIRTY = 512;
    static final int TEXTUREBIN_DIRTY = 1024;
    static final int TEXTUREATTRIBUTES_DIRTY = 2048;
    static final int RENDERMOLECULE_DIRTY = 4096;
    static final int FOG_DIRTY = 8192;
    static final int MODELCLIP_DIRTY = 16384;
    static final int VIEW_MATRIX_DIRTY = 32768;
    boolean offScreen = false;
    boolean manualRendering = false;
    Point offScreenCanvasLoc;
    Dimension offScreenCanvasSize;
    volatile boolean offScreenRendering = false;
    volatile boolean offScreenBufferPending = false;
    ImageComponent2D offScreenBuffer = null;
    boolean useSharedCtx = true;
    boolean stereoAvailable;
    boolean stereoEnable = true;
    boolean useStereo;
    boolean rightStereoPass = false;
    int monoscopicViewPolicy = 2;
    int requestedStencilSize;
    int actualStencilSize;
    boolean userStencilAvailable;
    boolean systemStencilAvailable;
    boolean doubleBufferAvailable;
    boolean doubleBufferEnable = true;
    boolean useDoubleBuffer;
    boolean sceneAntialiasingAvailable;
    boolean sceneAntialiasingMultiSamplesAvailable;
    private boolean antialiasingSet = false;
    int textureColorTableSize;
    int numActiveTexUnit = 0;
    int lastActiveTexUnit = -1;
    boolean shadingLanguageGLSL = false;
    J3dQueryProps queryProps;
    private boolean fatalError = false;
    Point3d leftManualEyeInImagePlate = new Point3d(0.142, 0.135, 0.4572);
    Point3d rightManualEyeInImagePlate = new Point3d(0.208, 0.135, 0.4572);
    View view = null;
    View pendingView;
    CanvasViewCache canvasViewCache = null;
    CanvasViewCache canvasViewCacheFrustum = null;
    boolean raIsVisible = false;
    RenderAtom ra = null;
    static final int STEREO_DIRTY = 1;
    static final int MONOSCOPIC_VIEW_POLICY_DIRTY = 2;
    static final int EYE_IN_IMAGE_PLATE_DIRTY = 4;
    static final int MOVED_OR_RESIZED_DIRTY = 8;
    static final int BACKGROUND_DIRTY = 16;
    static final int BACKGROUND_IMAGE_DIRTY = 32;
    static final int VIEW_INFO_DIRTY = 63;
    static final int RENDERER_DIRTY_IDX = 0;
    static final int RENDER_BIN_DIRTY_IDX = 1;
    int[] cvDirtyMask = new int[2];
    boolean resizeGraphics2D = true;
    volatile boolean isRunning = true;
    volatile boolean isRunningStatus = true;
    boolean active = false;
    boolean visible = false;
    boolean ctxReset = true;
    Screen3D screen = null;
    boolean imageReady = false;
    GraphicsContext3D graphicsContext3D = null;
    boolean waiting = false;
    boolean swapDone = false;
    GraphicsConfiguration graphicsConfiguration;
    J3DGraphics2DImpl graphics2D = null;
    Object gfxCreationLock = new Object();
    Transform3D vworldToEc = new Transform3D();
    Transform3D vpcToEc;
    Drawable drawable = null;
    static Hashtable<GraphicsConfiguration, GraphicsConfigInfo> graphicsConfigTable = new Hashtable();
    String nativeGraphicsVersion = "<UNKNOWN>";
    String nativeGraphicsVendor = "<UNKNOWN>";
    String nativeGraphicsRenderer = "<UNKNOWN>";
    boolean firstPaintCalled = false;
    boolean added = false;
    private boolean addNotifyCalled = false;
    Context ctx = null;
    volatile long ctxTimeStamp = 0L;
    boolean ctxEyeLightingEnable = false;
    AppearanceRetained currentAppear = new AppearanceRetained();
    MaterialRetained currentMaterial = new MaterialRetained();
    CachedFrustum viewFrustum = new CachedFrustum();
    LightBin lightBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin attributeBin = null;
    ShaderBin shaderBin = null;
    RenderMolecule renderMolecule = null;
    PolygonAttributesRetained polygonAttributes = null;
    LineAttributesRetained lineAttributes = null;
    PointAttributesRetained pointAttributes = null;
    MaterialRetained material = null;
    boolean enableLighting = false;
    TransparencyAttributesRetained transparency = null;
    ColoringAttributesRetained coloringAttributes = null;
    Transform3D modelMatrix = null;
    Transform3D projTrans = null;
    TextureBin textureBin = null;
    LightRetained[] lights = null;
    int[] frameCount = null;
    long enableMask = -1L;
    FogRetained fog = null;
    ModelClipRetained modelClip = null;
    Color3f sceneAmbient = new Color3f();
    TextureUnitStateRetained[] texUnitState = null;
    TextureRetained texture = null;
    TextureAttributesRetained texAttrs = null;
    TexCoordGenerationRetained texCoordGeneration = null;
    RenderingAttributesRetained renderingAttrs = null;
    AppearanceRetained appearance = null;
    ShaderProgramRetained shaderProgram = null;
    Object appHandle = null;
    int canvasDirty = 65535;
    boolean dirtyDisplayList = false;
    ArrayList<RenderMolecule> dirtyRenderMoleculeList = new ArrayList();
    ArrayList<RenderAtomListInfo> dirtyRenderAtomList = new ArrayList();
    ArrayList<Object[]> dirtyDlistPerRinfoList = new ArrayList();
    ArrayList<Integer> displayListResourceFreeList = new ArrayList();
    ArrayList<Integer> textureIdResourceFreeList = new ArrayList();
    int canvasBit = 0;
    int canvasId = 0;
    private boolean canvasIdAlloc = false;
    Object cvLock = new Object();
    Object evaluateLock = new Object();
    Object dirtyMaskLock = new Object();
    boolean needToRebuildDisplayList = false;
    static final int TEXTURE_3D = 1;
    static final int TEXTURE_COLOR_TABLE = 2;
    static final int TEXTURE_MULTI_TEXTURE = 4;
    static final int TEXTURE_COMBINE = 8;
    static final int TEXTURE_COMBINE_DOT3 = 16;
    static final int TEXTURE_COMBINE_SUBTRACT = 32;
    static final int TEXTURE_REGISTER_COMBINERS = 64;
    static final int TEXTURE_CUBE_MAP = 128;
    static final int TEXTURE_SHARPEN = 256;
    static final int TEXTURE_DETAIL = 512;
    static final int TEXTURE_FILTER4 = 1024;
    static final int TEXTURE_ANISOTROPIC_FILTER = 2048;
    static final int TEXTURE_LOD_RANGE = 4096;
    static final int TEXTURE_LOD_OFFSET = 8192;
    static final int TEXTURE_LERP = 16384;
    static final int TEXTURE_NON_POWER_OF_TWO = 32768;
    static final int TEXTURE_AUTO_MIPMAP_GENERATION = 65536;
    int textureExtendedFeatures = 0;
    static final int EXT_ABGR = 2;
    static final int EXT_BGR = 4;
    static final int MULTISAMPLE = 8;
    int extensionsSupported = 0;
    float anisotropicDegreeMax = 1.0f;
    int textureBoundaryWidthMax = 0;
    boolean multiTexAccelerated = false;
    int maxTexCoordSets = 1;
    int maxTextureUnits = 1;
    int maxTextureImageUnits = 0;
    int maxVertexTextureImageUnits = 0;
    int maxCombinedTextureImageUnits = 0;
    int maxVertexAttrs = 0;
    int maxVaryingVectors = 0;
    int maxAvailableTextureUnits;
    int textureWidthMax = 0;
    int textureHeightMax = 0;
    int texture3DWidthMax = -1;
    int texture3DHeightMax = -1;
    int texture3DDepthMax = -1;
    Point newPosition = new Point();
    Dimension newSize = new Dimension();
    ArrayList<TextureRetained> textureIDResourceTable = new ArrayList(5);
    static final int LIGHTBIN_BIT = 0;
    static final int ENVIRONMENTSET_BIT = 1;
    static final int ATTRIBUTEBIN_BIT = 2;
    static final int TEXTUREBIN_BIT = 3;
    static final int RENDERMOLECULE_BIT = 4;
    static final int TRANSPARENCY_BIT = 5;
    static final int SHADERBIN_BIT = 6;
    int stateUpdateMask = 0;
    Object[] curStateToUpdate = new Object[7];
    LightRetained[] currentLights = null;
    boolean depthBufferWriteEnableOverride = false;
    boolean depthBufferEnableOverride = false;
    boolean depthBufferWriteEnable = true;
    boolean vfPlanesValid = false;
    EventCatcher eventCatcher;
    private CanvasViewEventCatcher canvasViewEventCatcher;
    private Window windowParent;
    private LinkedList<Container> containerParentList = new LinkedList();
    boolean lightChanged = false;
    DrawingSurfaceObject drawingSurfaceObject;
    boolean validCtx = false;
    boolean validCanvas = false;
    boolean ctxChanged = false;
    private static GraphicsConfiguration defaultGcfg = null;
    static int ENV_STATE_MASK;

    private static synchronized GraphicsConfiguration defaultGraphicsConfiguration() {
        if (defaultGcfg == null) {
            GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
            defaultGcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(template);
        }
        return defaultGcfg;
    }

    private static boolean isValidConfig(GraphicsConfiguration gconfig) {
        return graphicsConfigTable.containsKey(gconfig);
    }

    private static synchronized GraphicsConfiguration checkForValidGraphicsConfig(GraphicsConfiguration gconfig, boolean offScreen) {
        if (!offScreen && VirtualUniverse.mc.allowNullGraphicsConfig && gconfig == null) {
            System.err.println(J3dI18N.getString("Canvas3D7"));
            System.err.println("    " + J3dI18N.getString("Canvas3D18"));
            gconfig = Canvas3D.defaultGraphicsConfiguration();
        }
        if (gconfig == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D19"));
        }
        if (!Canvas3D.isValidConfig(gconfig)) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D17"));
        }
        return gconfig;
    }

    private static GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration gconfig) {
        return Pipeline.getPipeline().getGraphicsConfig(gconfig);
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration) {
        this(null, Canvas3D.checkForValidGraphicsConfig(graphicsConfiguration, false), false);
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration, boolean offScreen) {
        this(null, Canvas3D.checkForValidGraphicsConfig(graphicsConfiguration, offScreen), offScreen);
    }

    private Canvas3D(Object dummyObj1, GraphicsConfiguration graphicsConfiguration, boolean offScreen) {
        this(dummyObj1, graphicsConfiguration, Canvas3D.getGraphicsConfig(graphicsConfiguration), offScreen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Canvas3D(Object dummyObj1, GraphicsConfiguration graphicsConfiguration, GraphicsConfiguration graphicsConfiguration2, boolean offScreen) {
        super(graphicsConfiguration2);
        this.offScreen = offScreen;
        this.graphicsConfiguration = graphicsConfiguration;
        boolean autoOffScreenCanvas3D = false;
        if (this instanceof AutoOffScreenCanvas3D) {
            autoOffScreenCanvas3D = true;
        }
        if (autoOffScreenCanvas3D && !offScreen) {
            throw new IllegalArgumentException(J3dI18N.getString("Canvas3D25"));
        }
        this.cvDirtyMask[0] = 63;
        this.cvDirtyMask[1] = 63;
        GraphicsConfigInfo gcInfo = graphicsConfigTable.get(graphicsConfiguration);
        this.requestedStencilSize = gcInfo.getGraphicsConfigTemplate3D().getStencilSize();
        if (offScreen) {
            this.manualRendering = !autoOffScreenCanvas3D;
            this.screen = new Screen3D(graphicsConfiguration, offScreen);
            Object object = this.dirtyMaskLock;
            synchronized (object) {
                this.cvDirtyMask[0] = this.cvDirtyMask[0] | 8;
                this.cvDirtyMask[1] = this.cvDirtyMask[1] | 8;
            }
            this.firstPaintCalled = true;
            if (this.manualRendering) {
                this.added = true;
            }
            this.evaluateActive();
            this.offScreenCanvasLoc = new Point(0, 0);
            this.offScreenCanvasSize = new Dimension(0, 0);
            this.setLocation(this.offScreenCanvasLoc);
            this.setSize(this.offScreenCanvasSize);
            this.newSize = this.offScreenCanvasSize;
            this.newPosition = this.offScreenCanvasLoc;
            if (!this.manualRendering) {
                this.eventCatcher = new EventCatcher(this);
                this.canvasViewEventCatcher = new CanvasViewEventCatcher(this);
            }
        } else {
            GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
            this.eventCatcher = new EventCatcher(this);
            this.canvasViewEventCatcher = new CanvasViewEventCatcher(this);
            Hashtable<GraphicsDevice, Screen3D> hashtable = VirtualUniverse.mc.deviceScreenMap;
            synchronized (hashtable) {
                this.screen = VirtualUniverse.mc.deviceScreenMap.get(graphicsDevice);
                if (this.screen == null) {
                    this.screen = new Screen3D(graphicsConfiguration, offScreen);
                    VirtualUniverse.mc.deviceScreenMap.put(graphicsDevice, this.screen);
                }
            }
        }
        this.lights = new LightRetained[VirtualUniverse.mc.maxLights];
        this.frameCount = new int[VirtualUniverse.mc.maxLights];
        for (int i = 0; i < this.frameCount.length; ++i) {
            this.frameCount[i] = -1;
        }
        this.drawingSurfaceObject = Pipeline.getPipeline().createDrawingSurfaceObject(this);
        GraphicsConfigTemplate3D.getGraphicsConfigFeatures(this);
        this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        this.useSharedCtx = VirtualUniverse.mc.isSharedCtx;
        assert (!(!offScreen && this.manualRendering));
        assert (!(offScreen && this.useStereo));
    }

    void sendEventToBehaviorScheduler(AWTEvent evt) {
        VirtualUniverse univ;
        ViewPlatform vp;
        if (this.view != null && (vp = this.view.getViewPlatform()) != null && (univ = ((ViewPlatformRetained)vp.retained).universe) != null) {
            univ.behaviorStructure.handleAWTEvent(evt);
        }
    }

    private boolean isRecursivelyVisible() {
        Container parent = this.getParent();
        return this.isVisible() && parent != null && parent.isShowing();
    }

    private boolean isIconified() {
        if (this.windowParent instanceof Frame) {
            return (((Frame)this.windowParent).getExtendedState() & 1) != 0;
        }
        return false;
    }

    void evaluateVisiblilty() {
        boolean nowVisible;
        boolean bl = nowVisible = this.isRecursivelyVisible() && !this.isIconified();
        if (this.visible != nowVisible) {
            this.visible = nowVisible;
            this.evaluateActive();
            if (nowVisible && this.view != null) {
                this.view.repaint();
            }
        }
    }

    void redraw() {
        if (this.view != null && this.active && this.isRunning) {
            this.view.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (!this.firstPaintCalled && this.added && this.validCanvas && this.validGraphicsMode()) {
            try {
                this.newSize = this.getSize();
                this.newPosition = this.getLocationOnScreen();
            }
            catch (IllegalComponentStateException e) {
                return;
            }
            DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
            synchronized (drawingSurfaceObject) {
                this.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
            }
            this.firstPaintCalled = true;
            this.visible = true;
            this.evaluateActive();
        }
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        if (this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = true;
        if (this.manualRendering) {
            return;
        }
        Renderer rdr = null;
        if (this.isRunning && this.screen != null && (rdr = this.screen.renderer) != null) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, rdr);
            while (!rdr.userStop) {
                MasterControl.threadYield();
            }
        }
        if (!this.offScreen) {
            super.addNotify();
        }
        this.screen.addUser(this);
        assert (this.containerParentList.isEmpty());
        this.windowParent = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof Window) {
                this.windowParent = (Window)container;
            }
            container.addComponentListener(this.eventCatcher);
            container.addComponentListener(this.canvasViewEventCatcher);
            this.containerParentList.add(container);
        }
        this.addComponentListener(this.eventCatcher);
        this.addComponentListener(this.canvasViewEventCatcher);
        if (this.windowParent != null) {
            this.windowParent.addWindowListener(this.eventCatcher);
        }
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 8;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 8;
        }
        this.allocateCanvasId();
        this.validCanvas = true;
        this.added = true;
        if (this.offScreen) {
            this.firstPaintCalled = true;
            this.visible = true;
            this.evaluateActive();
        }
        if (this.isRunning && !this.fatalError) {
            this.isRunningStatus = true;
        }
        this.ctxTimeStamp = 0L;
        if (this.view != null && this.view.universe != null) {
            this.view.universe.checkForEnableEvents();
        }
        if (rdr != null) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, rdr);
            while (rdr.userStop) {
                MasterControl.threadYield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        if (!this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = false;
        if (this.manualRendering) {
            return;
        }
        Renderer rdr = null;
        if (this.isRunning && this.screen != null && (rdr = this.screen.renderer) != null) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, rdr);
            while (!rdr.userStop) {
                MasterControl.threadYield();
            }
        }
        DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
        synchronized (drawingSurfaceObject) {
            this.validCtx = false;
            this.validCanvas = false;
        }
        this.removeCtx();
        Pipeline.getPipeline().freeDrawingSurface(this, this.drawingSurfaceObject);
        this.firstPaintCalled = false;
        this.visible = false;
        this.screen.removeUser(this);
        this.evaluateActive();
        this.freeCanvasId();
        this.ra = null;
        this.graphicsContext3D = null;
        this.ctx = null;
        this.graphics2D = null;
        super.removeNotify();
        for (Container container : this.containerParentList) {
            container.removeComponentListener(this.eventCatcher);
            container.removeComponentListener(this.canvasViewEventCatcher);
        }
        this.containerParentList.clear();
        this.removeComponentListener(this.eventCatcher);
        this.removeComponentListener(this.canvasViewEventCatcher);
        if (this.eventCatcher != null) {
            this.removeFocusListener(this.eventCatcher);
            this.removeKeyListener(this.eventCatcher);
            this.removeMouseListener(this.eventCatcher);
            this.removeMouseMotionListener(this.eventCatcher);
            this.removeMouseWheelListener(this.eventCatcher);
            this.eventCatcher.reset();
        }
        if (this.windowParent != null) {
            this.windowParent.removeWindowListener(this.eventCatcher);
            this.windowParent.requestFocus();
        }
        this.added = false;
        if (rdr != null) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, rdr);
            while (rdr.userStop) {
                MasterControl.threadYield();
            }
        }
        this.windowParent = null;
    }

    void allocateCanvasId() {
        if (!this.canvasIdAlloc) {
            this.canvasId = VirtualUniverse.mc.getCanvasId();
            this.canvasBit = 1 << this.canvasId;
            this.canvasIdAlloc = true;
        }
    }

    void freeCanvasId() {
        if (this.canvasIdAlloc) {
            VirtualUniverse.mc.freeCanvasId(this.canvasId);
            this.canvasBit = 0;
            this.canvasId = 0;
            this.canvasIdAlloc = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateActive() {
        VirtualUniverse u;
        Object object = this.evaluateLock;
        synchronized (object) {
            if ((this.visible || this.manualRendering) && this.firstPaintCalled) {
                if (!this.active) {
                    this.active = true;
                    if (this.pendingView != null) {
                        this.pendingView.evaluateActive();
                    }
                } else if (this.pendingView != null && !this.pendingView.activeStatus) {
                    this.pendingView.evaluateActive();
                }
            } else if (this.active) {
                this.active = false;
                if (this.view != null) {
                    this.view.evaluateActive();
                }
            }
        }
        if (this.view != null && !this.active && (u = this.view.universe) != null && !u.isSceneGraphLock) {
            u.waitForMC();
        }
    }

    void setFrustumPlanes(Vector4d[] planes) {
        if (VirtualUniverse.mc.viewFrustumCulling) {
            this.viewFrustum.set(planes);
        }
    }

    public Screen3D getScreen3D() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsContext3D getGraphicsContext3D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphicsContext3D == null) {
                this.graphicsContext3D = new GraphicsContext3D(this);
            }
        }
        return this.graphicsContext3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J3DGraphics2D getGraphics2D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphics2D == null) {
                this.graphics2D = new J3DGraphics2DImpl(this);
            }
        }
        if (this.canvasViewCache != null) {
            object = this.canvasViewCache;
            synchronized (object) {
                this.graphics2D.setTransform(new AffineTransform(this.canvasViewCache.getHiDPIXScale(), 0.0, 0.0, this.canvasViewCache.getHiDPIYScale(), 0.0, 0.0));
            }
        }
        return this.graphics2D;
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void postSwap() {
    }

    public void renderField(int fieldDesc) {
    }

    public final void stopRenderer() {
        if (this.manualRendering) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
            this.isRunning = false;
        }
    }

    public final void startRenderer() {
        if (this.fatalError) {
            return;
        }
        if (!this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
            this.isRunning = true;
            this.redraw();
        }
    }

    public final boolean isRendererRunning() {
        return this.isRunning;
    }

    boolean isFatalError() {
        return this.fatalError;
    }

    void setFatalError() {
        this.fatalError = true;
        if (this.isRunning) {
            this.isRunning = false;
            if (!this.manualRendering) {
                VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
            }
        }
    }

    public boolean isOffScreen() {
        return this.offScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenBuffer(ImageComponent2D buffer) {
        int height;
        int width;
        boolean freeCanvasId = false;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        J3dDebug.doAssert(!this.offScreenBufferPending, "!offScreenBufferPending");
        if (this.offScreenBuffer != null && this.offScreenBuffer != buffer) {
            ImageComponent2DRetained i2dRetained = (ImageComponent2DRetained)this.offScreenBuffer.retained;
            i2dRetained.setUsedByOffScreen(false);
        }
        if (buffer != null) {
            ImageComponent2DRetained bufferRetained = (ImageComponent2DRetained)buffer.retained;
            if (bufferRetained.byReference && !(bufferRetained.getRefImage(0) instanceof BufferedImage)) {
                throw new IllegalArgumentException(J3dI18N.getString("Canvas3D15"));
            }
            if (bufferRetained.getNumberOfComponents() < 3) {
                throw new IllegalArgumentException(J3dI18N.getString("Canvas3D16"));
            }
            if (buffer.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("Canvas3D26"));
            }
            if (bufferRetained.getInImmCtx()) {
                throw new IllegalSharingException(J3dI18N.getString("Canvas3D27"));
            }
            if (buffer != this.offScreenBuffer && bufferRetained.getUsedByOffScreen()) {
                throw new IllegalSharingException(J3dI18N.getString("Canvas3D28"));
            }
            bufferRetained.setUsedByOffScreen(true);
            width = bufferRetained.width;
            height = bufferRetained.height;
            if (this.manualRendering) {
                this.sendAllocateCanvasId();
            }
        } else {
            height = 0;
            width = 0;
            if (this.manualRendering) {
                freeCanvasId = true;
            }
        }
        if (this.drawable != null) {
            this.sendDestroyCtxAndOffScreenBuffer();
            this.drawable = null;
        }
        this.ctx = null;
        this.offScreenCanvasSize.setSize(width, height);
        this.setSize(this.offScreenCanvasSize);
        if (width > 0 && height > 0) {
            this.sendCreateOffScreenBuffer();
        }
        if (freeCanvasId) {
            this.sendFreeCanvasId();
        }
        this.offScreenBuffer = buffer;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 8;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 8;
        }
    }

    public ImageComponent2D getOffScreenBuffer() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return this.offScreenBuffer;
    }

    public void renderOffScreenBuffer() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (!this.manualRendering) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D24"));
        }
        if (this.fatalError) {
            throw new IllegalRenderingStateException(J3dI18N.getString("Canvas3D30"));
        }
        if (this.offScreenBuffer == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D10"));
        }
        Dimension screenSize = this.screen.getSize();
        if (screenSize.width <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D8"));
        }
        if (screenSize.height <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D9"));
        }
        if (this.screen.getPhysicalScreenWidth() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D12"));
        }
        if (this.screen.getPhysicalScreenHeight() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D13"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (!this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D11"));
        }
        if (!this.active || this.pendingView == null) {
            return;
        }
        this.offScreenRendering = true;
        boolean inCanvasCallback = false;
        try {
            inCanvasCallback = this.view.inCanvasCallback;
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (inCanvasCallback) {
            if (this.screen.renderer == null) {
                this.screen.renderer = Screen3D.deviceRendererMap.get(this.screen.graphicsDevice);
            }
            if (Thread.currentThread() == this.screen.renderer) {
                J3dMessage createMessage = new J3dMessage();
                createMessage.threads = 16;
                createMessage.type = 42;
                createMessage.universe = this.view.universe;
                createMessage.view = this.view;
                createMessage.args[0] = this;
                this.screen.renderer.rendererStructure.addMessage(createMessage);
                this.screen.renderer.args = new Object[4];
                this.screen.renderer.args[0] = new Integer(2);
                this.screen.renderer.args[1] = this;
                this.screen.renderer.args[2] = this.view;
                this.screen.renderer.args[3] = null;
                this.screen.renderer.doWork(0L);
            } else {
                J3dMessage createMessage = new J3dMessage();
                createMessage.threads = 16;
                createMessage.type = 42;
                createMessage.universe = this.view.universe;
                createMessage.view = this.view;
                createMessage.args[0] = this;
                this.screen.renderer.rendererStructure.addMessage(createMessage);
                VirtualUniverse.mc.setWorkForRequestRenderer();
            }
        } else if (Thread.currentThread() instanceof BehaviorScheduler) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 16;
            createMessage.type = 42;
            createMessage.universe = this.view.universe;
            createMessage.view = this.view;
            createMessage.args[0] = this;
            this.screen.renderer.rendererStructure.addMessage(createMessage);
            VirtualUniverse.mc.setWorkForRequestRenderer();
        } else {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 42;
            createMessage.universe = this.pendingView.universe;
            createMessage.view = this.pendingView;
            createMessage.args[0] = this;
            createMessage.args[1] = this.offScreenBuffer;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    public void waitForOffScreenRendering() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (Thread.currentThread() instanceof Renderer) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D31"));
        }
        while (this.offScreenRendering) {
            MasterControl.threadYield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenLocation(int x, int y) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffScreenLocation(Point p) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(p);
        }
    }

    public Point getOffScreenLocation() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return new Point(this.offScreenCanvasLoc);
    }

    public Point getOffScreenLocation(Point rv) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (rv == null) {
            return new Point(this.offScreenCanvasLoc);
        }
        rv.setLocation(this.offScreenCanvasLoc);
        return rv;
    }

    void endOffScreenRendering() {
        ImageComponent2DRetained icRetained = (ImageComponent2DRetained)this.offScreenBuffer.retained;
        boolean isByRef = icRetained.isByReference();
        ImageComponentRetained.ImageData imageData = icRetained.getImageData(false);
        if (!isByRef) {
            if (imageData == null) {
                assert (!isByRef);
                icRetained.createBlankImageData();
                imageData = icRetained.getImageData(false);
            } else {
                icRetained.evaluateExtensions(this);
            }
            this.readOffScreenBuffer(this.ctx, icRetained.getImageFormatTypeIntValue(false), icRetained.getImageDataTypeIntValue(), imageData.get(), this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
        } else {
            icRetained.geomLock.getLock();
            icRetained.evaluateExtensions(this);
            this.readOffScreenBuffer(this.ctx, icRetained.getImageFormatTypeIntValue(false), icRetained.getImageDataTypeIntValue(), imageData.get(), this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
            if (!imageData.isDataByRef()) {
                if (icRetained.isImageTypeSupported()) {
                    icRetained.copyToRefImage(0);
                } else {
                    icRetained.copyToRefImageWithFormatConversion(0);
                }
            }
            icRetained.geomLock.unLock();
        }
    }

    public void swap() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D0"));
        }
        if (!this.firstPaintCalled) {
            return;
        }
        if (this.view != null && this.graphicsContext3D != null) {
            if (this.view.universe != null && Thread.currentThread() == this.view.universe.behaviorScheduler) {
                this.graphicsContext3D.sendRenderMessage(false, 2, null, null);
            } else {
                this.graphicsContext3D.sendRenderMessage(true, 2, null, null);
            }
            this.graphicsContext3D.runMonitor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSwap() {
        block8: {
            if (this.firstPaintCalled && this.useDoubleBuffer) {
                try {
                    if (!this.validCtx || this.ctx == null || this.view == null) break block8;
                    DrawingSurfaceObject drawingSurfaceObject = this.drawingSurfaceObject;
                    synchronized (drawingSurfaceObject) {
                        if (this.validCtx) {
                            if (!this.drawingSurfaceObject.renderLock()) {
                                this.graphicsContext3D.runMonitor(2);
                                return;
                            }
                            this.syncRender(this.ctx, true);
                            this.swapBuffers(this.ctx, this.drawable);
                            this.drawingSurfaceObject.unLock();
                        }
                    }
                }
                catch (NullPointerException ne) {
                    this.drawingSurfaceObject.unLock();
                }
            }
        }
        this.view.universe.behaviorStructure.incElapsedFrames();
        this.graphicsContext3D.runMonitor(2);
    }

    Context createNewContext(Context shareCtx, boolean isSharedCtx) {
        Context retVal = this.createNewContext(this.drawable, shareCtx, isSharedCtx, this.offScreen);
        this.maxAvailableTextureUnits = Math.max(this.maxTextureUnits, this.maxTextureImageUnits);
        this.antialiasingSet = false;
        return retVal;
    }

    final void makeCtxCurrent() {
        this.makeCtxCurrent(this.ctx, this.drawable);
    }

    final void makeCtxCurrent(Context ctx) {
        this.makeCtxCurrent(ctx, this.drawable);
    }

    final void makeCtxCurrent(Context ctx, Drawable drawable) {
        if (ctx != this.screen.renderer.currentCtx || drawable != this.screen.renderer.currentDrawable) {
            if (!this.drawingSurfaceObject.isLocked()) {
                this.drawingSurfaceObject.renderLock();
                Canvas3D.useCtx(ctx, drawable);
                this.drawingSurfaceObject.unLock();
            } else {
                Canvas3D.useCtx(ctx, drawable);
            }
            this.screen.renderer.currentCtx = ctx;
            this.screen.renderer.currentDrawable = drawable;
        }
    }

    void releaseCtx() {
        if (this.screen.renderer.currentCtx != null) {
            boolean needLock;
            boolean bl = needLock = !this.drawingSurfaceObject.isLocked();
            if (needLock) {
                this.drawingSurfaceObject.renderLock();
            }
            if (this.releaseCtx(this.screen.renderer.currentCtx)) {
                this.screen.renderer.currentCtx = null;
                this.screen.renderer.currentDrawable = null;
            }
            if (needLock) {
                this.drawingSurfaceObject.unLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftManualEyeInImagePlate(Point3d position) {
        this.leftManualEyeInImagePlate.set((Tuple3d)position);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 4;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 4;
        }
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightManualEyeInImagePlate(Point3d position) {
        this.rightManualEyeInImagePlate.set((Tuple3d)position);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 4;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 4;
        }
        this.redraw();
    }

    public void getLeftManualEyeInImagePlate(Point3d position) {
        position.set((Tuple3d)this.leftManualEyeInImagePlate);
    }

    public void getRightManualEyeInImagePlate(Point3d position) {
        position.set((Tuple3d)this.rightManualEyeInImagePlate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLeftEyeInImagePlate(Point3d position) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                position.set((Tuple3d)this.canvasViewCache.getLeftEyeInImagePlate());
            }
        } else {
            position.set((Tuple3d)this.leftManualEyeInImagePlate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRightEyeInImagePlate(Point3d position) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                position.set((Tuple3d)this.canvasViewCache.getRightEyeInImagePlate());
            }
        } else {
            position.set((Tuple3d)this.rightManualEyeInImagePlate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCenterEyeInImagePlate(Point3d position) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                position.set((Tuple3d)this.canvasViewCache.getCenterEyeInImagePlate());
            }
        } else {
            Point3d cenEye = new Point3d();
            cenEye.add((Tuple3d)this.leftManualEyeInImagePlate, (Tuple3d)this.rightManualEyeInImagePlate);
            cenEye.scale(0.5);
            position.set((Tuple3d)cenEye);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImagePlateToVworld(Transform3D t) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                t.set(this.canvasViewCache.getImagePlateToVworld());
            }
        } else {
            t.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationInImagePlate(int x, int y, Point3d imagePlatePoint) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                imagePlatePoint.x = this.canvasViewCache.getWindowXInImagePlate(x);
                imagePlatePoint.y = this.canvasViewCache.getWindowYInImagePlate(y);
                imagePlatePoint.z = 0.0;
            }
        } else {
            imagePlatePoint.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPixelLocationInImagePlate(double x, double y, double z, Point3d imagePlatePoint) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationInImagePlate(x, y, z, imagePlatePoint);
            }
        } else {
            imagePlatePoint.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationInImagePlate(Point2d pixelLocation, Point3d imagePlatePoint) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                imagePlatePoint.x = this.canvasViewCache.getWindowXInImagePlate(pixelLocation.x);
                imagePlatePoint.y = this.canvasViewCache.getWindowYInImagePlate(pixelLocation.y);
                imagePlatePoint.z = 0.0;
            }
        } else {
            imagePlatePoint.set(0.0, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPixelLocationFromImagePlate(Point3d imagePlatePoint, Point2d pixelLocation) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationFromImagePlate(imagePlatePoint, pixelLocation);
            }
        } else {
            pixelLocation.set(0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVworldProjection(Transform3D leftProjection, Transform3D rightProjection) {
        if (this.canvasViewCache != null) {
            ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)this.view.getViewPlatform().retained;
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                leftProjection.mul(this.canvasViewCache.getLeftProjection(), this.canvasViewCache.getLeftVpcToEc());
                leftProjection.mul(viewPlatformRetained.getVworldToVpc());
                if (this.useStereo) {
                    rightProjection.mul(this.canvasViewCache.getRightProjection(), this.canvasViewCache.getRightVpcToEc());
                    rightProjection.mul(viewPlatformRetained.getVworldToVpc());
                } else {
                    rightProjection.set(leftProjection);
                }
            }
        } else {
            leftProjection.setIdentity();
            rightProjection.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInverseVworldProjection(Transform3D leftInverseProjection, Transform3D rightInverseProjection) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                leftInverseProjection.set(this.canvasViewCache.getLeftCcToVworld());
                if (this.useStereo) {
                    rightInverseProjection.set(this.canvasViewCache.getRightCcToVworld());
                } else {
                    rightInverseProjection.set(leftInverseProjection);
                }
            }
        } else {
            leftInverseProjection.setIdentity();
            rightInverseProjection.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPhysicalWidth() {
        double width = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                width = this.canvasViewCache.getPhysicalWindowWidth();
            }
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPhysicalHeight() {
        double height = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                height = this.canvasViewCache.getPhysicalWindowHeight();
            }
        }
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVworldToImagePlate(Transform3D t) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                t.set(this.canvasViewCache.getVworldToImagePlate());
            }
        } else {
            t.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLastVworldToImagePlate(Transform3D t) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                t.set(this.canvasViewCache.getLastVworldToImagePlate());
            }
        } else {
            t.setIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPixelWidth() {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                return (int)((double)this.getWidth() * this.canvasViewCache.getHiDPIXScale());
            }
        }
        return this.getWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPixelHeight() {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                return (int)((double)this.getHeight() * this.canvasViewCache.getHiDPIYScale());
            }
        }
        return this.getHeight();
    }

    void setView(View view) {
        this.pendingView = view;
        VirtualUniverse.mc.postRequest(MasterControl.SET_VIEW, this);
        this.evaluateActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeViewCache() {
        Object object = this.cvLock;
        synchronized (object) {
            if (this.view == null) {
                this.canvasViewCache = null;
                this.canvasViewCacheFrustum = null;
            } else {
                this.canvasViewCache = new CanvasViewCache(this, this.screen.screenViewCache, this.view.viewCache);
                this.canvasViewCacheFrustum = new CanvasViewCache(this, this.screen.screenViewCache, this.view.viewCache);
                Object object2 = this.dirtyMaskLock;
                synchronized (object2) {
                    this.cvDirtyMask[0] = 63;
                    this.cvDirtyMask[1] = 63;
                }
            }
        }
    }

    public View getView() {
        return this.pendingView;
    }

    public boolean getStereoAvailable() {
        return (Boolean)this.queryProperties().get("stereoAvailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStereoEnable(boolean flag) {
        this.stereoEnable = flag;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 1;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 1;
        }
        this.redraw();
    }

    public boolean getStereoEnable() {
        return this.stereoEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonoscopicViewPolicy(int policy) {
        if (this.view != null && this.view.viewPolicy == 1 && this.monoscopicViewPolicy == 2 && !this.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        this.monoscopicViewPolicy = policy;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 2;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 2;
        }
        this.redraw();
    }

    public int getMonoscopicViewPolicy() {
        return this.monoscopicViewPolicy;
    }

    public boolean getDoubleBufferAvailable() {
        return (Boolean)this.queryProperties().get("doubleBufferAvailable");
    }

    public void setDoubleBufferEnable(boolean flag) {
        this.doubleBufferEnable = flag;
        boolean bl = this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        if (Thread.currentThread() == this.screen.renderer) {
            this.setRenderMode(this.ctx, 2, this.useDoubleBuffer);
        }
        this.redraw();
    }

    public boolean getDoubleBufferEnable() {
        return this.doubleBufferEnable;
    }

    public boolean getSceneAntialiasingAvailable() {
        return (Boolean)this.queryProperties().get("sceneAntialiasingAvailable");
    }

    public boolean isShadingLanguageSupported(int shadingLanguage) {
        this.queryProperties();
        if (shadingLanguage == 1) {
            return this.shadingLanguageGLSL;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map queryProperties() {
        if (this.queryProps == null) {
            boolean createDummyCtx = false;
            Object object = VirtualUniverse.mc.contextCreationLock;
            synchronized (object) {
                if (this.ctx == null) {
                    createDummyCtx = true;
                }
            }
            if (createDummyCtx) {
                GraphicsConfigTemplate3D.setQueryProps(this);
            }
            this.createQueryProps();
        }
        if (this.fatalError) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D29"));
        }
        return this.queryProps;
    }

    void createQueryContext() {
        this.createQueryContext(this.drawable, this.offScreen, 1, 1);
        this.maxAvailableTextureUnits = Math.max(this.maxTextureUnits, this.maxTextureImageUnits);
    }

    private void createQueryProps() {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        int pass = 0;
        keys.add("doubleBufferAvailable");
        values.add(new Boolean(this.doubleBufferAvailable));
        keys.add("stereoAvailable");
        values.add(new Boolean(this.stereoAvailable));
        keys.add("sceneAntialiasingAvailable");
        values.add(new Boolean(this.sceneAntialiasingAvailable));
        keys.add("sceneAntialiasingNumPasses");
        if (this.sceneAntialiasingAvailable) {
            pass = this.sceneAntialiasingMultiSamplesAvailable ? 1 : 8;
        }
        values.add(new Integer(pass));
        keys.add("stencilSize");
        if (this.userStencilAvailable) {
            values.add(new Integer(this.actualStencilSize));
        } else {
            values.add(new Integer(0));
        }
        keys.add("compressedGeometry.majorVersionNumber");
        values.add(new Integer(1));
        keys.add("compressedGeometry.minorVersionNumber");
        values.add(new Integer(0));
        keys.add("compressedGeometry.minorMinorVersionNumber");
        values.add(new Integer(2));
        keys.add("texture3DAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 1) != 0));
        keys.add("textureColorTableSize");
        values.add(new Integer(this.textureColorTableSize));
        keys.add("textureEnvCombineAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 8) != 0));
        keys.add("textureCombineDot3Available");
        values.add(new Boolean((this.textureExtendedFeatures & 0x10) != 0));
        keys.add("textureCombineSubtractAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x20) != 0));
        keys.add("textureCubeMapAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x80) != 0));
        keys.add("textureSharpenAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x100) != 0));
        keys.add("textureDetailAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x200) != 0));
        keys.add("textureFilter4Available");
        values.add(new Boolean((this.textureExtendedFeatures & 0x400) != 0));
        keys.add("textureAnisotropicFilterDegreeMax");
        values.add(new Float(this.anisotropicDegreeMax));
        keys.add("textureWidthMax");
        values.add(new Integer(this.textureWidthMax));
        keys.add("textureHeightMax");
        values.add(new Integer(this.textureHeightMax));
        keys.add("texture3DWidthMax");
        values.add(new Integer(this.texture3DWidthMax));
        keys.add("texture3DHeightMax");
        values.add(new Integer(this.texture3DHeightMax));
        keys.add("texture3DDepthMax");
        values.add(new Integer(this.texture3DDepthMax));
        keys.add("textureBoundaryWidthMax");
        values.add(new Integer(this.textureBoundaryWidthMax));
        keys.add("textureLodRangeAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x1000) != 0));
        keys.add("textureLodOffsetAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x2000) != 0));
        keys.add("textureNonPowerOfTwoAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x8000) != 0));
        keys.add("textureAutoMipMapGenerationAvailable");
        values.add(new Boolean((this.textureExtendedFeatures & 0x10000) != 0));
        keys.add("textureCoordSetsMax");
        values.add(new Integer(this.maxTexCoordSets));
        keys.add("textureUnitStateMax");
        values.add(new Integer(this.maxTextureUnits));
        keys.add("textureImageUnitsMax");
        values.add(new Integer(this.maxTextureImageUnits));
        keys.add("textureImageUnitsVertexMax");
        values.add(new Integer(this.maxVertexTextureImageUnits));
        keys.add("textureImageUnitsCombinedMax");
        values.add(new Integer(this.maxCombinedTextureImageUnits));
        keys.add("maxVaryingVectors");
        values.add(new Integer(this.maxVaryingVectors));
        keys.add("vertexAttrsMax");
        values.add(new Integer(this.maxVertexAttrs));
        keys.add("shadingLanguageGLSL");
        values.add(new Boolean(this.shadingLanguageGLSL));
        keys.add("native.version");
        values.add(this.nativeGraphicsVersion);
        keys.add("native.vendor");
        values.add(this.nativeGraphicsVendor);
        keys.add("native.renderer");
        values.add(this.nativeGraphicsRenderer);
        this.queryProps = new J3dQueryProps(keys, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateViewCache(boolean flag, CanvasViewCache cvc, BoundingBox frustumBBox, boolean doInfinite) {
        assert (cvc == null);
        Object object = this.cvLock;
        synchronized (object) {
            if (this.firstPaintCalled && this.canvasViewCache != null) {
                assert (this.canvasViewCacheFrustum != null);
                if (frustumBBox != null) {
                    this.canvasViewCacheFrustum.snapshot(true);
                    this.canvasViewCacheFrustum.computeDerivedData(flag, null, frustumBBox, doInfinite);
                } else {
                    this.canvasViewCache.snapshot(false);
                    this.canvasViewCache.computeDerivedData(flag, null, null, doInfinite);
                }
            }
        }
    }

    void setDepthBufferWriteEnableOverride(boolean flag) {
        this.depthBufferWriteEnableOverride = flag;
    }

    void setDepthBufferEnableOverride(boolean flag) {
        this.depthBufferEnableOverride = flag;
    }

    void resetTexture(Context ctx, int texUnitIndex) {
        this.resetTextureNative(ctx, texUnitIndex);
        if (texUnitIndex < 0) {
            texUnitIndex = 0;
        }
        this.texUnitState[texUnitIndex].mirror = null;
        this.texUnitState[texUnitIndex].texture = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetRendering() {
        this.reset();
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 0x3F;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 0x3F;
        }
    }

    void reset() {
        int i;
        this.currentAppear = new AppearanceRetained();
        this.currentMaterial = new MaterialRetained();
        this.viewFrustum = new CachedFrustum();
        this.canvasDirty = 65535;
        this.lightBin = null;
        this.environmentSet = null;
        this.attributeBin = null;
        this.shaderBin = null;
        this.textureBin = null;
        this.renderMolecule = null;
        this.polygonAttributes = null;
        this.lineAttributes = null;
        this.pointAttributes = null;
        this.material = null;
        this.enableLighting = false;
        this.transparency = null;
        this.coloringAttributes = null;
        this.shaderProgram = null;
        this.texture = null;
        this.texAttrs = null;
        if (this.texUnitState != null) {
            for (i = 0; i < this.texUnitState.length; ++i) {
                TextureUnitStateRetained tus = this.texUnitState[i];
                if (tus == null) continue;
                tus.texAttrs = null;
                tus.texGen = null;
            }
        }
        this.texCoordGeneration = null;
        this.renderingAttrs = null;
        this.appearance = null;
        this.appHandle = null;
        this.dirtyRenderMoleculeList.clear();
        this.displayListResourceFreeList.clear();
        this.dirtyDlistPerRinfoList.clear();
        this.textureIdResourceFreeList.clear();
        this.lightChanged = true;
        this.modelMatrix = null;
        this.modelClip = null;
        this.fog = null;
        this.sceneAmbient = new Color3f();
        for (i = 0; i < this.frameCount.length; ++i) {
            this.frameCount[i] = -1;
        }
        for (i = 0; i < this.lights.length; ++i) {
            this.lights[i] = null;
        }
        if (this.currentLights != null) {
            for (i = 0; i < this.currentLights.length; ++i) {
                this.currentLights[i] = null;
            }
        }
        this.enableMask = -1L;
        this.stateUpdateMask = 0;
        this.depthBufferWriteEnableOverride = false;
        this.depthBufferEnableOverride = false;
        this.depthBufferWriteEnable = true;
        this.vfPlanesValid = false;
        this.lightChanged = false;
        for (i = 0; i < this.curStateToUpdate.length; ++i) {
            this.curStateToUpdate[i] = null;
        }
        this.needToRebuildDisplayList = true;
        this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetImmediateRendering() {
        this.canvasDirty = 65535;
        this.ra = null;
        this.setSceneAmbient(this.ctx, 0.0f, 0.0f, 0.0f);
        this.disableFog(this.ctx);
        this.resetRenderingAttributes(this.ctx, false, false);
        this.resetTexture(this.ctx, -1);
        this.resetTexCoordGeneration(this.ctx);
        this.resetTextureAttributes(this.ctx);
        this.texUnitState[0].texAttrs = null;
        this.texUnitState[0].texGen = null;
        this.resetPolygonAttributes(this.ctx);
        this.resetLineAttributes(this.ctx);
        this.resetPointAttributes(this.ctx);
        this.resetTransparency(this.ctx, 4, 2, false, false);
        this.resetColoringAttributes(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
        this.updateMaterial(this.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
        this.resetRendering();
        this.makeCtxCurrent();
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask[0] = this.cvDirtyMask[0] | 0x3F;
            this.cvDirtyMask[1] = this.cvDirtyMask[1] | 0x3F;
        }
        this.needToRebuildDisplayList = true;
        this.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
    }

    @Override
    public Point getLocationOnScreen() {
        try {
            return super.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return new Point();
        }
    }

    void setProjectionMatrix(Context ctx, Transform3D projTrans) {
        this.projTrans = projTrans;
        this.setProjectionMatrix(ctx, projTrans.mat);
    }

    void setModelViewMatrix(Context ctx, double[] viewMatrix, Transform3D mTrans) {
        this.setModelViewMatrix(ctx, viewMatrix, mTrans.mat);
        if (!this.useStereo) {
            this.modelMatrix = mTrans;
        } else if (this.rightStereoPass) {
            this.modelMatrix = mTrans;
        }
    }

    void setDepthBufferWriteEnable(boolean mode) {
        this.depthBufferWriteEnable = mode;
        this.setDepthBufferWriteEnable(this.ctx, mode);
    }

    void setNumActiveTexUnit(int n) {
        this.numActiveTexUnit = n;
    }

    int getNumActiveTexUnit() {
        return this.numActiveTexUnit;
    }

    void setLastActiveTexUnit(int n) {
        this.lastActiveTexUnit = n;
    }

    int getLastActiveTexUnit() {
        return this.lastActiveTexUnit;
    }

    void createTexUnitState() {
        this.texUnitState = new TextureUnitStateRetained[this.maxAvailableTextureUnits];
        for (int t = 0; t < this.maxAvailableTextureUnits; ++t) {
            this.texUnitState[t] = new TextureUnitStateRetained();
            this.texUnitState[t].texture = null;
            this.texUnitState[t].mirror = null;
        }
    }

    void enableSeparateSpecularColor() {
        boolean enable = !VirtualUniverse.mc.disableSeparateSpecularColor;
        this.updateSeparateSpecularColorEnable(this.ctx, enable);
    }

    private void sendCreateOffScreenBuffer() {
        if (!(Thread.currentThread() instanceof BehaviorScheduler) && !(Thread.currentThread() instanceof Renderer)) {
            this.offScreenBufferPending = true;
        }
        VirtualUniverse.mc.sendCreateOffScreenBuffer(this);
        while (this.offScreenBufferPending) {
            VirtualUniverse.mc.createMasterControlThread();
            MasterControl.threadYield();
        }
    }

    private void sendDestroyCtxAndOffScreenBuffer() {
        Thread currentThread = Thread.currentThread();
        if (!(currentThread instanceof BehaviorScheduler) && !(currentThread instanceof Renderer)) {
            this.offScreenBufferPending = true;
        }
        VirtualUniverse.mc.sendDestroyCtxAndOffScreenBuffer(this);
        while (this.offScreenBufferPending) {
            VirtualUniverse.mc.createMasterControlThread();
            MasterControl.threadYield();
        }
    }

    private void sendAllocateCanvasId() {
        VirtualUniverse.mc.sendAllocateCanvasId(this);
    }

    private void sendFreeCanvasId() {
        VirtualUniverse.mc.sendFreeCanvasId(this);
    }

    private void removeCtx() {
        if (this.screen != null && this.screen.renderer != null && this.ctx != null) {
            VirtualUniverse.mc.postRequest(MasterControl.FREE_CONTEXT, new Object[]{this, 0L, this.drawable, this.ctx});
            Thread currentThread = Thread.currentThread();
            if (!(currentThread instanceof BehaviorScheduler) && !(currentThread instanceof Renderer)) {
                while (this.ctxTimeStamp != 0L) {
                    MasterControl.threadYield();
                }
            }
            this.ctx = null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException(J3dI18N.getString("Canvas3D20"));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(J3dI18N.getString("Canvas3D20"));
    }

    void setStateIsUpdated(int bit) {
        this.stateUpdateMask &= ~(1 << bit);
    }

    void setStateToUpdate(int bit, Object bin) {
        this.stateUpdateMask |= 1 << bit;
        this.curStateToUpdate[bit] = bin;
    }

    void updateEnvState() {
        if ((this.stateUpdateMask & ENV_STATE_MASK) == 0) {
            return;
        }
        if ((this.stateUpdateMask & 1) != 0) {
            ((LightBin)this.curStateToUpdate[0]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 2) != 0) {
            ((EnvironmentSet)this.curStateToUpdate[1]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 4) != 0) {
            ((AttributeBin)this.curStateToUpdate[2]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 0x40) != 0) {
            ((ShaderBin)this.curStateToUpdate[6]).updateAttributes(this);
        }
        this.stateUpdateMask &= ~ENV_STATE_MASK;
    }

    void updateState(int dirtyBits) {
        if (this.stateUpdateMask == 0) {
            return;
        }
        this.updateEnvState();
        if ((this.stateUpdateMask & 8) != 0) {
            ((TextureBin)this.curStateToUpdate[3]).updateAttributes(this);
        }
        if ((this.stateUpdateMask & 0x10) != 0) {
            ((RenderMolecule)this.curStateToUpdate[4]).updateAttributes(this, dirtyBits);
        }
        if ((this.stateUpdateMask & 0x20) != 0) {
            ((RenderMolecule)this.curStateToUpdate[4]).updateTransparencyAttributes(this);
            this.stateUpdateMask &= 0xFFFFFFDF;
        }
        this.stateUpdateMask = 0;
    }

    void updateTextureForRaster(Texture2DRetained texture) {
        Pipeline.getPipeline().updateTextureUnitState(this.ctx, 0, true);
        this.setLastActiveTexUnit(0);
        this.setNumActiveTexUnit(1);
        texture.updateNative(this);
        this.resetTexCoordGeneration(this.ctx);
        this.resetTextureAttributes(this.ctx);
        for (int i = 1; i < this.maxTextureUnits; ++i) {
            this.resetTexture(this.ctx, i);
        }
        this.activeTextureUnit(this.ctx, 0);
        this.canvasDirty |= 0xC00;
    }

    void restoreTextureBin() {
        if (this.textureBin != null && this.textureBin.shaderBin != null) {
            this.textureBin.updateAttributes(this);
        }
    }

    void textureFill(RasterRetained raster, Point2d winCoord, float mapZ, float alpha) {
        int winWidth = this.canvasViewCache.getCanvasWidth();
        int winHeight = this.canvasViewCache.getCanvasHeight();
        int rasterImageWidth = raster.image.width;
        int rasterImageHeight = raster.image.height;
        float texMinU = 0.0f;
        float texMinV = 0.0f;
        float texMaxU = 0.0f;
        float texMaxV = 0.0f;
        float mapMinX = 0.0f;
        float mapMinY = 0.0f;
        float mapMaxX = 0.0f;
        float mapMaxY = 0.0f;
        Point rasterSrcOffset = new Point();
        raster.getSrcOffset(rasterSrcOffset);
        Dimension rasterSize = new Dimension();
        raster.getSize(rasterSize);
        int rasterMinX = rasterSrcOffset.x;
        int rasterMaxX = rasterSrcOffset.x + rasterSize.width;
        int rasterMinY = rasterSrcOffset.y;
        int rasterMaxY = rasterSrcOffset.y + rasterSize.height;
        if (rasterMinX >= rasterImageWidth || rasterMinY >= rasterImageHeight || rasterMaxX <= 0 || rasterMaxY <= 0) {
            return;
        }
        if (rasterMinX < 0) {
            rasterMinX = 0;
        }
        if (rasterMinY < 0) {
            rasterMinY = 0;
        }
        if (rasterMaxX > rasterImageWidth) {
            rasterMaxX = rasterImageWidth;
        }
        if (rasterMaxY > rasterImageHeight) {
            rasterMaxY = rasterImageHeight;
        }
        texMinU = (float)rasterMinX / (float)rasterImageWidth;
        texMaxU = (float)rasterMaxX / (float)rasterImageWidth;
        mapMinX = (float)winCoord.x / (float)winWidth;
        mapMaxX = (float)(winCoord.x + (double)(rasterMaxX - rasterMinX)) / (float)winWidth;
        if (raster.image.isYUp()) {
            texMinV = (float)rasterMinY / (float)rasterImageHeight;
            texMaxV = (float)rasterMaxY / (float)rasterImageHeight;
        } else {
            texMinV = 1.0f - (float)rasterMaxY / (float)rasterImageHeight;
            texMaxV = 1.0f - (float)rasterMinY / (float)rasterImageHeight;
        }
        mapMinY = 1.0f - (float)(winCoord.y + (double)(rasterMaxY - rasterMinY)) / (float)winHeight;
        mapMaxY = 1.0f - (float)winCoord.y / (float)winHeight;
        this.textureFillRaster(this.ctx, texMinU, texMaxU, texMinV, texMaxV, mapMinX, mapMaxX, mapMinY, mapMaxY, mapZ, alpha, raster.image.useBilinearFilter());
    }

    void textureFill(BackgroundRetained bg, int winWidth, int winHeight) {
        int maxX = bg.image.width;
        int maxY = bg.image.height;
        float xzoom = (float)winWidth / (float)maxX;
        float yzoom = (float)winHeight / (float)maxY;
        float zoom = 0.0f;
        float texMinU = 0.0f;
        float texMinV = 0.0f;
        float texMaxU = 0.0f;
        float texMaxV = 0.0f;
        float adjustV = 0.0f;
        float mapMinX = 0.0f;
        float mapMinY = 0.0f;
        float mapMaxX = 0.0f;
        float mapMaxY = 0.0f;
        float halfWidth = 0.0f;
        float halfHeight = 0.0f;
        switch (bg.imageScaleMode) {
            case 0: {
                texMinU = 0.0f;
                texMinV = 0.0f;
                texMaxU = 1.0f;
                texMaxV = 1.0f;
                halfWidth = (float)winWidth / 2.0f;
                halfHeight = (float)winHeight / 2.0f;
                mapMinX = (0.0f - halfWidth) / halfWidth;
                mapMinY = (0.0f - halfHeight) / halfHeight;
                mapMaxX = ((float)maxX - halfWidth) / halfWidth;
                mapMaxY = ((float)maxY - halfHeight) / halfHeight;
                adjustV = ((float)winHeight - (float)maxY) / halfHeight;
                mapMinY += adjustV;
                mapMaxY += adjustV;
                break;
            }
            case 1: {
                zoom = Math.min(xzoom, yzoom);
                texMinU = 0.0f;
                texMinV = 0.0f;
                texMaxU = 1.0f;
                texMaxV = 1.0f;
                mapMinX = -1.0f;
                mapMaxY = 1.0f;
                if (xzoom < yzoom) {
                    mapMaxX = 1.0f;
                    mapMinY = -1.0f + 2.0f * (1.0f - zoom * (float)maxY / (float)winHeight);
                    break;
                }
                mapMaxX = -1.0f + zoom * (float)maxX / (float)winWidth * 2.0f;
                mapMinY = -1.0f;
                break;
            }
            case 2: {
                zoom = Math.max(xzoom, yzoom);
                mapMinX = -1.0f;
                mapMinY = -1.0f;
                mapMaxX = 1.0f;
                mapMaxY = 1.0f;
                if (xzoom < yzoom) {
                    texMinU = 0.0f;
                    texMinV = 0.0f;
                    texMaxU = (float)winWidth / (float)maxX / zoom;
                    texMaxV = 1.0f;
                    break;
                }
                texMinU = 0.0f;
                texMinV = 1.0f - (float)winHeight / (float)maxY / zoom;
                texMaxU = 1.0f;
                texMaxV = 1.0f;
                break;
            }
            case 3: {
                texMinU = 0.0f;
                texMinV = 0.0f;
                texMaxU = 1.0f;
                texMaxV = 1.0f;
                mapMinX = -1.0f;
                mapMinY = -1.0f;
                mapMaxX = 1.0f;
                mapMaxY = 1.0f;
                break;
            }
            case 4: {
                texMinU = 0.0f;
                texMinV = -yzoom;
                texMaxU = xzoom;
                texMaxV = 0.0f;
                mapMinX = -1.0f;
                mapMinY = -1.0f;
                mapMaxX = 1.0f;
                mapMaxY = 1.0f;
                break;
            }
            case 5: {
                if (xzoom >= 1.0f) {
                    texMinU = 0.0f;
                    texMaxU = 1.0f;
                    mapMinX = -((float)maxX) / (float)winWidth;
                    mapMaxX = (float)maxX / (float)winWidth;
                } else {
                    texMinU = 0.5f - (float)winWidth / (float)maxX / 2.0f;
                    texMaxU = 0.5f + (float)winWidth / (float)maxX / 2.0f;
                    mapMinX = -1.0f;
                    mapMaxX = 1.0f;
                }
                if (yzoom >= 1.0f) {
                    texMinV = 0.0f;
                    texMaxV = 1.0f;
                    mapMinY = -((float)maxY) / (float)winHeight;
                    mapMaxY = (float)maxY / (float)winHeight;
                    break;
                }
                texMinV = 0.5f - (float)winHeight / (float)maxY / 2.0f;
                texMaxV = 0.5f + (float)winHeight / (float)maxY / 2.0f;
                mapMinY = -1.0f;
                mapMaxY = 1.0f;
            }
        }
        this.textureFillBackground(this.ctx, texMinU, texMaxU, texMinV, texMaxV, mapMinX, mapMaxX, mapMinY, mapMaxY, bg.image.useBilinearFilter());
    }

    void clear(BackgroundRetained bg, int winWidth, int winHeight) {
        boolean clearStencil = VirtualUniverse.mc.stencilClear && this.userStencilAvailable;
        this.clear(this.ctx, bg.color.x, bg.color.y, bg.color.z, clearStencil);
        if (bg.image != null && bg.image.imageData != null) {
            this.updateTextureForRaster(bg.texture);
            this.textureFill(bg, winWidth, winHeight);
            this.restoreTextureBin();
        }
    }

    void addTextureResource(int id, TextureRetained obj) {
        if (id <= 0) {
            return;
        }
        if (this.useSharedCtx) {
            this.screen.renderer.addTextureResource(id, obj);
        } else if (this.textureIDResourceTable.size() <= id) {
            for (int i = this.textureIDResourceTable.size(); i < id; ++i) {
                this.textureIDResourceTable.add(null);
            }
            this.textureIDResourceTable.add(obj);
        } else {
            this.textureIDResourceTable.set(id, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeResourcesInFreeList(Context ctx) {
        if (this.displayListResourceFreeList.size() > 0) {
            for (int val : this.displayListResourceFreeList) {
                if (val <= 0) continue;
                Canvas3D.freeDisplayList(ctx, val);
            }
            this.displayListResourceFreeList.clear();
        }
        if (this.textureIdResourceFreeList.size() > 0) {
            for (int val : this.textureIdResourceFreeList) {
                if (val <= 0) continue;
                if (val >= this.textureIDResourceTable.size()) {
                    System.err.println("Error in freeResourcesInFreeList : ResourceIDTableSize = " + this.textureIDResourceTable.size() + " val = " + val);
                } else {
                    TextureRetained tex = this.textureIDResourceTable.get(val);
                    if (tex != null) {
                        Object object = tex.resourceLock;
                        synchronized (object) {
                            tex.resourceCreationMask &= ~this.canvasBit;
                            if (tex.resourceCreationMask == 0) {
                                tex.freeTextureId(val);
                            }
                        }
                    }
                    this.textureIDResourceTable.set(val, null);
                }
                Canvas3D.freeTexture(ctx, val);
            }
            this.textureIdResourceFreeList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeContextResources(Renderer rdr, boolean freeBackground, Context ctx) {
        if (rdr == null || ctx == null) {
            return;
        }
        if (freeBackground && this.graphics2D != null) {
            this.graphics2D.dispose();
        }
        for (int id = this.textureIDResourceTable.size() - 1; id >= 0; --id) {
            TextureRetained tex = this.textureIDResourceTable.get(id);
            if (tex == null) continue;
            Canvas3D.freeTexture(ctx, id);
            Object object = tex.resourceLock;
            synchronized (object) {
                tex.resourceCreationMask &= ~this.canvasBit;
                if (tex.resourceCreationMask == 0) {
                    tex.freeTextureId(id);
                }
                continue;
            }
        }
        this.textureIDResourceTable.clear();
        this.freeAllDisplayListResources(ctx);
    }

    void freeAllDisplayListResources(Context ctx) {
        if (this.view != null && this.view.renderBin != null) {
            this.view.renderBin.freeAllDisplayListResources(this, ctx);
            if (this.useSharedCtx && this.screen != null && this.screen.renderer != null) {
                this.screen.renderer.needToRebuildDisplayList = true;
            }
        }
    }

    private Context createNewContext(Drawable drawable, Context shareCtx, boolean isSharedCtx, boolean offScreen) {
        return Pipeline.getPipeline().createNewContext(this, drawable, shareCtx, isSharedCtx, offScreen);
    }

    private void createQueryContext(Drawable drawable, boolean offScreen, int width, int height) {
        Pipeline.getPipeline().createQueryContext(this, drawable, offScreen, width, height);
    }

    Drawable createOffScreenBuffer(Context ctx, int width, int height) {
        return Pipeline.getPipeline().createOffScreenBuffer(this, ctx, width, height);
    }

    void destroyOffScreenBuffer(Context ctx, Drawable drawable) {
        assert (drawable != null);
        Pipeline.getPipeline().destroyOffScreenBuffer(this, ctx, drawable);
    }

    private void readOffScreenBuffer(Context ctx, int format, int type, Object data, int width, int height) {
        Pipeline.getPipeline().readOffScreenBuffer(this, ctx, format, type, data, width, height);
    }

    void swapBuffers(Context ctx, Drawable drawable) {
        Pipeline.getPipeline().swapBuffers(this, ctx, drawable);
    }

    void updateMaterial(Context ctx, float r, float g, float b, float a) {
        Pipeline.getPipeline().updateMaterialColor(ctx, r, g, b, a);
    }

    static void destroyContext(Drawable drawable, Context ctx) {
        Pipeline.getPipeline().destroyContext(drawable, ctx);
    }

    void accum(Context ctx, float value) {
        Pipeline.getPipeline().accum(ctx, value);
    }

    void accumReturn(Context ctx) {
        Pipeline.getPipeline().accumReturn(ctx);
    }

    void clearAccum(Context ctx) {
        Pipeline.getPipeline().clearAccum(ctx);
    }

    int getNumCtxLights(Context ctx) {
        return Pipeline.getPipeline().getNumCtxLights(ctx);
    }

    boolean decal1stChildSetup(Context ctx) {
        return Pipeline.getPipeline().decal1stChildSetup(ctx);
    }

    void decalNthChildSetup(Context ctx) {
        Pipeline.getPipeline().decalNthChildSetup(ctx);
    }

    void decalReset(Context ctx, boolean depthBufferEnable) {
        Pipeline.getPipeline().decalReset(ctx, depthBufferEnable);
    }

    void ctxUpdateEyeLightingEnable(Context ctx, boolean localEyeLightingEnable) {
        Pipeline.getPipeline().ctxUpdateEyeLightingEnable(ctx, localEyeLightingEnable);
    }

    void setBlendColor(Context ctx, float red, float green, float blue, float alpha) {
        Pipeline.getPipeline().setBlendColor(ctx, red, green, blue, alpha);
    }

    void setBlendFunc(Context ctx, int src, int dst) {
        Pipeline.getPipeline().setBlendFunc(ctx, src, dst);
    }

    void setFogEnableFlag(Context ctx, boolean enableFlag) {
        Pipeline.getPipeline().setFogEnableFlag(ctx, enableFlag);
    }

    boolean isAntialiasingSet() {
        return this.antialiasingSet;
    }

    void setFullSceneAntialiasing(Context ctx, boolean enable) {
        Pipeline.getPipeline().setFullSceneAntialiasing(ctx, enable);
        this.antialiasingSet = enable;
    }

    void updateSeparateSpecularColorEnable(Context ctx, boolean control) {
        Pipeline.getPipeline().updateSeparateSpecularColorEnable(ctx, control);
    }

    private boolean validGraphicsMode() {
        return Pipeline.getPipeline().validGraphicsMode();
    }

    void setLightEnables(Context ctx, long enableMask, int maxLights) {
        Pipeline.getPipeline().setLightEnables(ctx, enableMask, maxLights);
    }

    void setSceneAmbient(Context ctx, float red, float green, float blue) {
        Pipeline.getPipeline().setSceneAmbient(ctx, red, green, blue);
    }

    void disableFog(Context ctx) {
        Pipeline.getPipeline().disableFog(ctx);
    }

    void disableModelClip(Context ctx) {
        Pipeline.getPipeline().disableModelClip(ctx);
    }

    void resetRenderingAttributes(Context ctx, boolean depthBufferWriteEnableOverride, boolean depthBufferEnableOverride) {
        Pipeline.getPipeline().resetRenderingAttributes(ctx, depthBufferWriteEnableOverride, depthBufferEnableOverride);
    }

    void resetTextureNative(Context ctx, int texUnitIndex) {
        Pipeline.getPipeline().resetTextureNative(ctx, texUnitIndex);
    }

    void activeTextureUnit(Context ctx, int texUnitIndex) {
        Pipeline.getPipeline().activeTextureUnit(ctx, texUnitIndex);
    }

    void resetTexCoordGeneration(Context ctx) {
        Pipeline.getPipeline().resetTexCoordGeneration(ctx);
    }

    void resetTextureAttributes(Context ctx) {
        Pipeline.getPipeline().resetTextureAttributes(ctx);
    }

    void resetPolygonAttributes(Context ctx) {
        Pipeline.getPipeline().resetPolygonAttributes(ctx);
    }

    void resetLineAttributes(Context ctx) {
        Pipeline.getPipeline().resetLineAttributes(ctx);
    }

    void resetPointAttributes(Context ctx) {
        Pipeline.getPipeline().resetPointAttributes(ctx);
    }

    void resetTransparency(Context ctx, int geometryType, int polygonMode, boolean lineAA, boolean pointAA) {
        Pipeline.getPipeline().resetTransparency(ctx, geometryType, polygonMode, lineAA, pointAA);
    }

    void resetColoringAttributes(Context ctx, float r, float g, float b, float a, boolean enableLight) {
        Pipeline.getPipeline().resetColoringAttributes(ctx, r, g, b, a, enableLight);
    }

    void syncRender(Context ctx, boolean wait) {
        Pipeline.getPipeline().syncRender(ctx, wait);
    }

    static boolean useCtx(Context ctx, Drawable drawable) {
        return Pipeline.getPipeline().useCtx(ctx, drawable);
    }

    private boolean releaseCtx(Context ctx) {
        return Pipeline.getPipeline().releaseCtx(ctx);
    }

    void clear(Context ctx, float r, float g, float b, boolean clearStencil) {
        Pipeline.getPipeline().clear(ctx, r, g, b, clearStencil);
    }

    void textureFillBackground(Context ctx, float texMinU, float texMaxU, float texMinV, float texMaxV, float mapMinX, float mapMaxX, float mapMinY, float mapMaxY, boolean useBiliearFilter) {
        Pipeline.getPipeline().textureFillBackground(ctx, texMinU, texMaxU, texMinV, texMaxV, mapMinX, mapMaxX, mapMinY, mapMaxY, useBiliearFilter);
    }

    void textureFillRaster(Context ctx, float texMinU, float texMaxU, float texMinV, float texMaxV, float mapMinX, float mapMaxX, float mapMinY, float mapMaxY, float mapZ, float alpha, boolean useBiliearFilter) {
        Pipeline.getPipeline().textureFillRaster(ctx, texMinU, texMaxU, texMinV, texMaxV, mapMinX, mapMaxX, mapMinY, mapMaxY, mapZ, alpha, useBiliearFilter);
    }

    void executeRasterDepth(Context ctx, float posX, float posY, float posZ, int srcOffsetX, int srcOffsetY, int rasterWidth, int rasterHeight, int depthWidth, int depthHeight, int depthType, Object depthData) {
        Pipeline.getPipeline().executeRasterDepth(ctx, posX, posY, posZ, srcOffsetX, srcOffsetY, rasterWidth, rasterHeight, depthWidth, depthHeight, depthType, depthData);
    }

    void setModelViewMatrix(Context ctx, double[] viewMatrix, double[] modelMatrix) {
        Pipeline.getPipeline().setModelViewMatrix(ctx, viewMatrix, modelMatrix);
    }

    void setProjectionMatrix(Context ctx, double[] projMatrix) {
        Pipeline.getPipeline().setProjectionMatrix(ctx, projMatrix);
    }

    void setViewport(Context ctx, int x, int y, int width, int height) {
        Pipeline.getPipeline().resizeOffscreenLayer(this, width, height);
        Pipeline.getPipeline().setViewport(ctx, x, y, width, height);
    }

    void newDisplayList(Context ctx, int displayListId) {
        Pipeline.getPipeline().newDisplayList(ctx, displayListId);
    }

    void endDisplayList(Context ctx) {
        Pipeline.getPipeline().endDisplayList(ctx);
    }

    void callDisplayList(Context ctx, int id, boolean isNonUniformScale) {
        Pipeline.getPipeline().callDisplayList(ctx, id, isNonUniformScale);
    }

    static void freeDisplayList(Context ctx, int id) {
        Pipeline.getPipeline().freeDisplayList(ctx, id);
    }

    static void freeTexture(Context ctx, int id) {
        Pipeline.getPipeline().freeTexture(ctx, id);
    }

    static int generateTexID(Context ctx) {
        return Pipeline.getPipeline().generateTexID(ctx);
    }

    void texturemapping(Context ctx, int px, int py, int xmin, int ymin, int xmax, int ymax, int texWidth, int texHeight, int rasWidth, int format, int objectId, byte[] image, int winWidth, int winHeight) {
        Pipeline.getPipeline().texturemapping(ctx, px, py, xmin, ymin, xmax, ymax, texWidth, texHeight, rasWidth, format, objectId, image, winWidth, winHeight);
    }

    boolean initTexturemapping(Context ctx, int texWidth, int texHeight, int objectId) {
        return Pipeline.getPipeline().initTexturemapping(ctx, texWidth, texHeight, objectId);
    }

    void setRenderMode(Context ctx, int mode, boolean doubleBuffer) {
        Pipeline.getPipeline().setRenderMode(ctx, mode, doubleBuffer);
    }

    void setDepthBufferWriteEnable(Context ctx, boolean mode) {
        Pipeline.getPipeline().setDepthBufferWriteEnable(ctx, mode);
    }

    boolean hasDoubleBuffer() {
        return Pipeline.getPipeline().hasDoubleBuffer(this);
    }

    boolean hasStereo() {
        return Pipeline.getPipeline().hasStereo(this);
    }

    int getStencilSize() {
        return Pipeline.getPipeline().getStencilSize(this);
    }

    boolean hasSceneAntialiasingMultisample() {
        return Pipeline.getPipeline().hasSceneAntialiasingMultisample(this);
    }

    boolean hasSceneAntialiasingAccum() {
        return Pipeline.getPipeline().hasSceneAntialiasingAccum(this);
    }

    static {
        VirtualUniverse.loadLibraries();
        ENV_STATE_MASK = 71;
    }
}

