/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import org.jogamp.java3d.ImageComponent3D;
import org.jogamp.java3d.ImageComponentRetained;
import org.jogamp.java3d.ImageComponentUpdateInfo;
import org.jogamp.java3d.J3dI18N;

class ImageComponent3DRetained
extends ImageComponentRetained {
    ImageComponent3DRetained() {
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    int getDepth() {
        return this.depth;
    }

    void set(int index, BufferedImage image) {
        this.geomLock.getLock();
        if (this.byReference) {
            this.setRefImage(image, index);
        }
        if (this.imageData == null) {
            this.abgrSupported = true;
            this.imageTypeIsSupported = this.isImageTypeSupported(image);
            this.imageData = this.createRenderedImageDataObject(null);
        } else if (this.getImageType() != this.evaluateImageType(image)) {
            // empty if block
        }
        if (this.imageTypeIsSupported) {
            this.copySupportedImageToImageData(image, index, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(image, index, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            this.sendMessage(1, null);
        }
    }

    void set(int index, RenderedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (width != this.width) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D2"));
        }
        if (height != this.height) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D4"));
        }
        if (image instanceof BufferedImage) {
            this.set(index, (BufferedImage)image);
        } else {
            ColorModel cm = image.getColorModel();
            WritableRaster wRaster = image.copyData(null);
            BufferedImage bi = new BufferedImage(cm, wRaster, cm.isAlphaPremultiplied(), null);
            this.set(index, bi);
        }
    }

    RenderedImage[] getRenderedImage() {
        RenderedImage[] bi = new RenderedImage[this.depth];
        if (!this.byReference) {
            for (int i = 0; i < this.depth; ++i) {
                bi[i] = this.imageData.createBufferedImage(i);
            }
        } else {
            for (int i = 0; i < this.depth; ++i) {
                bi[i] = this.imageData.createBufferedImage(i);
            }
        }
        return bi;
    }

    BufferedImage[] getImage() {
        BufferedImage[] bi = new BufferedImage[this.depth];
        if (!this.byReference) {
            for (int i = 0; i < this.depth; ++i) {
                bi[i] = this.imageData.createBufferedImage(i);
            }
        } else {
            for (int i = 0; i < this.depth; ++i) {
                bi[i] = this.imageData.createBufferedImage(i);
                if (bi[i] != null) continue;
                throw new IllegalStateException(J3dI18N.getString("ImageComponent3DRetained0"));
            }
        }
        return bi;
    }

    RenderedImage getImage(int index) {
        if (!this.byReference) {
            return this.imageData.createBufferedImage(index);
        }
        return (RenderedImage)this.getRefImage(index);
    }

    void updateData(ImageComponent3D.Updater updater, int index, int x, int y, int width, int height) {
        this.geomLock.getLock();
        updater.updateData((ImageComponent3D)this.source, index, x, y, width, height);
        RenderedImage refImage = (RenderedImage)this.getRefImage(index);
        assert (refImage != null);
        assert (this.imageData != null);
        int srcX = x + refImage.getMinX();
        int srcY = y + refImage.getMinY();
        if (this.imageTypeIsSupported) {
            if (refImage instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)refImage, srcX, srcY, x, y, index, width, height, this.imageData);
            } else {
                this.copySupportedImageToImageData(refImage, srcX, srcY, x, y, index, width, height, this.imageData);
            }
        } else if (refImage instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)refImage, srcX, srcY, x, y, index, width, height, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(refImage, srcX, srcY, x, y, index, width, height, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo info = new ImageComponentUpdateInfo();
            info.x = x;
            info.y = y;
            info.z = index;
            info.width = width;
            info.height = height;
            this.sendMessage(2, info);
        }
    }

    void setSubImage(int index, RenderedImage image, int width, int height, int srcX, int srcY, int dstX, int dstY) {
        if (!this.isSubImageTypeEqual(image)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent2D6"));
        }
        assert (!this.byReference);
        assert (this.imageData != null);
        this.geomLock.getLock();
        if (this.imageTypeIsSupported) {
            if (image instanceof BufferedImage) {
                this.copyImageLineByLine((BufferedImage)image, srcX, srcY, dstX, dstY, index, width, height, this.imageData);
            } else {
                this.copySupportedImageToImageData(image, srcX, srcY, dstX, dstY, index, width, height, this.imageData);
            }
        } else if (image instanceof BufferedImage) {
            this.copyUnsupportedImageToImageData((BufferedImage)image, srcX, srcY, dstX, dstY, index, width, height, this.imageData);
        } else {
            this.copyUnsupportedImageToImageData(image, srcX, srcY, dstX, dstY, index, width, height, this.imageData);
        }
        this.geomLock.unLock();
        if (this.source.isLive()) {
            ImageComponentUpdateInfo info = new ImageComponentUpdateInfo();
            info.x = dstX;
            info.y = dstY;
            info.z = index;
            info.width = width;
            info.height = height;
            this.sendMessage(2, info);
        }
    }
}

