/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineArrayRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.PointArrayRetained;
import org.jogamp.java3d.QuadArrayRetained;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TriangleArrayRetained;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;

abstract class IndexedGeometryArrayRetained
extends GeometryArrayRetained {
    int[] indexCoord;
    int[] indexColor;
    int[] indexNormal;
    int[][] indexTexCoord;
    int[][] indexVertexAttr;
    int indexCount = 0;
    int initialIndexIndex = 0;
    int validIndexCount = 0;
    int[] compileIndexCount;
    int[] compileIndexOffset;
    int maxCoordIndex = 0;
    int maxColorIndex = 0;
    int maxNormalIndex = 0;
    int[] maxTexCoordIndices = null;
    int[] maxVertexAttrIndices = null;

    IndexedGeometryArrayRetained() {
    }

    void createIndexedGeometryArrayData(int indexCount) {
        int i;
        boolean notUCIO;
        this.indexCount = indexCount;
        this.validIndexCount = indexCount;
        boolean bl = notUCIO = (this.vertexFormat & 0x200) == 0;
        if ((this.vertexFormat & 1) != 0 && (this.vertexFormat & 0x2000) == 0) {
            this.indexCoord = new int[indexCount];
        }
        if ((this.vertexFormat & 2) != 0 && notUCIO) {
            this.indexNormal = new int[indexCount];
        }
        if ((this.vertexFormat & 4) != 0 && notUCIO) {
            this.indexColor = new int[indexCount];
        }
        if ((this.vertexFormat & 0x460) != 0) {
            this.indexTexCoord = new int[this.texCoordSetCount][];
            if (notUCIO) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.indexTexCoord[i] = new int[indexCount];
                }
            }
            this.maxTexCoordIndices = new int[this.texCoordSetCount];
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            this.indexVertexAttr = new int[this.vertexAttrCount][];
            if (notUCIO) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.indexVertexAttr[i] = new int[indexCount];
                }
            }
            this.maxVertexAttrIndices = new int[this.vertexAttrCount];
        }
    }

    GeometryArrayRetained cloneNonIndexedGeometry() {
        GeometryArrayRetained obj = null;
        switch (this.geoType) {
            case 11: {
                obj = new LineArrayRetained();
                break;
            }
            case 10: {
                obj = new PointArrayRetained();
                break;
            }
            case 8: {
                obj = new QuadArrayRetained();
                break;
            }
            case 9: {
                obj = new TriangleArrayRetained();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        obj.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
        obj.cloneSourceArray = this;
        obj.unIndexify(this);
        obj.source = this.source;
        return obj;
    }

    int getIndexCount() {
        return this.indexCount;
    }

    void doErrorCheck(int newMax) {
        this.doCoordCheck(newMax);
        if ((this.vertexFormat & 0x200) != 0) {
            int i;
            if ((this.vertexFormat & 4) != 0) {
                this.doColorCheck(newMax);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.doTexCoordCheck(newMax, i);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.doVertexAttrCheck(newMax, i);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.doNormalCheck(newMax);
            }
        }
    }

    void doCoordCheck(int newMax) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        if ((this.vertexFormat & 0x80) != 0) break block19;
                        if (newMax >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block21;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xF) {
                            case 1: {
                                if (this.floatBufferRefCoords == null || 3 * newMax < this.floatBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                            case 2: {
                                if (this.doubleBufferRefCoords == null || 3 * newMax < this.doubleBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * newMax >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                    }
                    break block20;
                }
                if ((this.vertexFormat & 0x100) != 0) break block22;
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords != null && 3 * newMax >= this.floatRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 2: {
                        if (this.doubleRefCoords != null && 3 * newMax >= this.doubleRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 4: {
                        if (this.p3fRefCoords != null && newMax >= this.p3fRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 8: {
                        if (this.p3dRefCoords != null && newMax >= this.p3dRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (this.interLeavedVertexData != null && this.stride * newMax >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
            }
        }
    }

    void doColorCheck(int newMax) {
        block25: {
            block27: {
                int multiplier;
                block26: {
                    block24: {
                        if ((this.vertexFormat & 4) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block24;
                        if (newMax >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    multiplier = this.getColorStride();
                    if ((this.vertexFormat & 0x800) == 0) break block26;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x3F0) {
                            case 16: {
                                if (this.floatBufferRefColors == null || multiplier * newMax < this.floatBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                            case 32: {
                                if (this.byteBufferRefColors == null || multiplier * newMax < this.byteBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * newMax >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                    }
                    break block25;
                }
                if ((this.vertexFormat & 0x100) != 0) break block27;
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (this.floatRefColors != null && multiplier * newMax >= this.floatRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 32: {
                        if (this.byteRefColors != null && multiplier * newMax >= this.byteRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 64: {
                        if (this.c3fRefColors != null && newMax >= this.c3fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 128: {
                        if (this.c4fRefColors != null && newMax >= this.c4fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 256: {
                        if (this.c3bRefColors != null && newMax >= this.c3bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 512: {
                        if (this.c4bRefColors != null && newMax >= this.c4bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                }
                break block25;
            }
            if (this.interLeavedVertexData != null && this.stride * newMax >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
            }
        }
    }

    void doNormalCheck(int newMax) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        if ((this.vertexFormat & 2) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block15;
                        if (newMax >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block17;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xC00) {
                            case 1024: {
                                if (this.floatBufferRefNormals == null || 3 * newMax < this.floatBufferRefNormals.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * newMax >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                    }
                    break block16;
                }
                if ((this.vertexFormat & 0x100) != 0) break block18;
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals != null && 3 * newMax >= this.floatRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    case 2048: {
                        if (this.v3fRefNormals != null && newMax >= this.v3fRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (this.interLeavedVertexData != null && this.stride * newMax >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
            }
        }
    }

    void doTexCoordCheck(int newMax, int texCoordSet) {
        block18: {
            block20: {
                int multiplier;
                block19: {
                    block17: {
                        if ((this.vertexFormat & 0x460) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block17;
                        if (newMax >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    multiplier = this.getTexStride();
                    if ((this.vertexFormat & 0x800) == 0) break block19;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x7000) {
                            case 4096: {
                                FloatBuffer texBuffer = (FloatBuffer)this.refTexCoordsBuffer[texCoordSet].getROBuffer();
                                if (this.refTexCoords[texCoordSet] == null || multiplier * newMax < texBuffer.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * newMax >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                    break block18;
                }
                if ((this.vertexFormat & 0x100) != 0) break block20;
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        if (this.refTexCoords[texCoordSet] != null && multiplier * newMax >= ((float[])this.refTexCoords[texCoordSet]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 8192: {
                        if (this.refTexCoords[texCoordSet] != null && newMax >= ((TexCoord2f[])this.refTexCoords[texCoordSet]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 16384: {
                        if (this.refTexCoords[texCoordSet] != null && newMax >= ((TexCoord3f[])this.refTexCoords[texCoordSet]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (this.interLeavedVertexData != null && this.stride * newMax >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
            }
        }
    }

    void doVertexAttrCheck(int newMax, int vertexAttrNum) {
        if ((this.vertexFormat & 0x1000) == 0) {
            return;
        }
        assert ((this.vertexFormat & 0x100) == 0);
        if ((this.vertexFormat & 0x80) == 0) {
            if (newMax >= this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
            }
        } else {
            int multiplier = this.vertexAttrSizes[vertexAttrNum];
            if ((this.vertexFormat & 0x800) != 0) {
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        if (multiplier * newMax < this.floatBufferRefVertexAttrs[vertexAttrNum].limit()) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                    }
                }
            } else {
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        if (multiplier * newMax < this.floatRefVertexAttrs[vertexAttrNum].length) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                    }
                }
            }
        }
    }

    final void setCoordinateIndex(int index, int coordinateIndex) {
        boolean isLive;
        int newMax = this.doIndexCheck(index, this.maxCoordIndex, this.indexCoord, coordinateIndex);
        if (newMax > this.maxCoordIndex) {
            this.doErrorCheck(newMax);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            int i;
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = newMax;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = newMax;
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.indexCoord[index] = coordinateIndex;
        this.maxCoordIndex = newMax;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(true);
        }
    }

    int doIndexCheck(int index, int maxIndex, int[] indices, int dataValue) {
        int newMax = maxIndex;
        if (index < this.initialIndexIndex) {
            return newMax;
        }
        if (index >= this.initialIndexIndex + this.validIndexCount) {
            return newMax;
        }
        if (dataValue < 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
        }
        if (newMax == indices[index]) {
            if (dataValue >= newMax) {
                newMax = dataValue;
            } else {
                for (int i = 0; i < indices.length; ++i) {
                    if (indices[i] <= newMax) continue;
                    newMax = indices[i];
                }
            }
        } else if (dataValue > newMax) {
            newMax = dataValue;
        }
        return newMax;
    }

    int doIndicesCheck(int index, int maxIndex, int[] indices, int[] newIndices) {
        int newMax = maxIndex;
        boolean computeNewMax = false;
        int num = newIndices.length;
        boolean maxReset = false;
        for (int j = 0; j < num; ++j) {
            if (index + j < this.initialIndexIndex || index + j >= this.initialIndexIndex + this.validIndexCount) continue;
            if (newIndices[j] < 0) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
            }
            if (indices[index + j] == maxIndex) {
                if (newIndices[j] >= newMax) {
                    newMax = newIndices[j];
                    computeNewMax = false;
                    maxReset = true;
                    continue;
                }
                if (maxReset) continue;
                computeNewMax = true;
                continue;
            }
            if (newIndices[j] < newMax) continue;
            newMax = newIndices[j];
            computeNewMax = false;
            maxReset = true;
        }
        if (computeNewMax) {
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] <= newMax) continue;
                newMax = indices[i];
            }
        }
        return newMax;
    }

    final void setCoordinateIndices(int index, int[] coordinateIndices) {
        boolean isLive;
        int i;
        int num = coordinateIndices.length;
        int newMax = this.doIndicesCheck(index, this.maxCoordIndex, this.indexCoord, coordinateIndices);
        if (newMax > this.maxCoordIndex) {
            this.doErrorCheck(newMax);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = newMax;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = newMax;
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = newMax;
        i = 0;
        int j = index;
        while (i < num) {
            this.indexCoord[j] = coordinateIndices[i];
            ++i;
            ++j;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(true);
        }
    }

    final void setCoordIndicesRef(int[] coordinateIndices) {
        boolean isLive;
        int newMax = 0;
        if (coordinateIndices != null) {
            if (coordinateIndices.length < this.initialIndexIndex + this.validIndexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
            }
            newMax = this.computeMaxIndexWithCheck(this.initialIndexIndex, this.validIndexCount, coordinateIndices);
            if (newMax > this.maxCoordIndex) {
                this.doErrorCheck(newMax);
            }
        }
        if ((this.vertexFormat & 0x200) != 0) {
            int i;
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = newMax;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = newMax;
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = newMax;
        this.indexCoord = coordinateIndices;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(true);
        }
    }

    final void doPostUpdaterUpdate() {
        int newMax = 0;
        if (this.indexCoord != null && (newMax = this.computeMaxIndexWithCheck(this.initialIndexIndex, this.validIndexCount, this.indexCoord)) > this.maxCoordIndex) {
            this.doErrorCheck(newMax);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            int i;
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = newMax;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = newMax;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = newMax;
            }
        }
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = newMax;
    }

    final void setColorIndex(int index, int colorIndex) {
        boolean isLive;
        int newMax = this.maxColorIndex;
        newMax = this.doIndexCheck(index, this.maxColorIndex, this.indexColor, colorIndex);
        if (newMax > this.maxColorIndex) {
            this.doColorCheck(newMax);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.indexColor[index] = colorIndex;
        this.maxColorIndex = newMax;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setColorIndices(int index, int[] colorIndices) {
        boolean isLive;
        int num = colorIndices.length;
        int newMax = this.doIndicesCheck(index, this.maxColorIndex, this.indexColor, colorIndices);
        if (newMax > this.maxColorIndex) {
            this.doColorCheck(newMax);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.maxColorIndex = newMax;
        int i = 0;
        int j = index;
        while (i < num) {
            this.indexColor[j] = colorIndices[i];
            ++i;
            ++j;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setNormalIndex(int index, int normalIndex) {
        boolean isLive;
        int newMax = this.doIndexCheck(index, this.maxNormalIndex, this.indexNormal, normalIndex);
        if (newMax > this.maxNormalIndex) {
            this.doNormalCheck(newMax);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.maxNormalIndex = newMax;
        this.indexNormal[index] = normalIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setNormalIndices(int index, int[] normalIndices) {
        boolean isLive;
        int num = normalIndices.length;
        int newMax = this.doIndicesCheck(index, this.maxNormalIndex, this.indexNormal, normalIndices);
        if (newMax > this.maxNormalIndex) {
            this.doNormalCheck(newMax);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        int i = 0;
        int j = index;
        while (i < num) {
            this.indexNormal[j] = normalIndices[i];
            ++i;
            ++j;
        }
        this.maxNormalIndex = newMax;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setTextureCoordinateIndex(int texCoordSet, int index, int texCoordIndex) {
        boolean isLive;
        int[] indices = this.indexTexCoord[texCoordSet];
        int newMax = this.doIndexCheck(index, this.maxTexCoordIndices[texCoordSet], indices, texCoordIndex);
        if (newMax > this.maxTexCoordIndices[texCoordSet]) {
            this.doTexCoordCheck(newMax, texCoordSet);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.maxTexCoordIndices[texCoordSet] = newMax;
        indices[index] = texCoordIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setTextureCoordinateIndices(int texCoordSet, int index, int[] texCoordIndices) {
        boolean isLive;
        int num = texCoordIndices.length;
        int[] indices = this.indexTexCoord[texCoordSet];
        int newMax = this.doIndicesCheck(index, this.maxTexCoordIndices[texCoordSet], indices, texCoordIndices);
        if (newMax > this.maxTexCoordIndices[texCoordSet]) {
            this.doTexCoordCheck(newMax, texCoordSet);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.maxTexCoordIndices[texCoordSet] = newMax;
        int i = 0;
        int j = index;
        while (i < num) {
            indices[j] = texCoordIndices[i];
            ++i;
            ++j;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrIndex(int vertexAttrNum, int index, int vertexAttrIndex) {
        boolean isLive;
        int[] indices = this.indexVertexAttr[vertexAttrNum];
        int newMax = this.doIndexCheck(index, this.maxVertexAttrIndices[vertexAttrNum], indices, vertexAttrIndex);
        if (newMax > this.maxVertexAttrIndices[vertexAttrNum]) {
            this.doVertexAttrCheck(newMax, vertexAttrNum);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.maxVertexAttrIndices[vertexAttrNum] = newMax;
        indices[index] = vertexAttrIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrIndices(int vertexAttrNum, int index, int[] vertexAttrIndices) {
        boolean isLive;
        int num = vertexAttrIndices.length;
        int[] indices = this.indexVertexAttr[vertexAttrNum];
        int newMax = this.doIndicesCheck(index, this.maxVertexAttrIndices[vertexAttrNum], indices, vertexAttrIndices);
        if (newMax > this.maxVertexAttrIndices[vertexAttrNum]) {
            this.doVertexAttrCheck(newMax, vertexAttrNum);
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.maxVertexAttrIndices[vertexAttrNum] = newMax;
        int i = 0;
        int j = index;
        while (i < num) {
            indices[j] = vertexAttrIndices[i];
            ++i;
            ++j;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    final int getCoordinateIndex(int index) {
        return this.indexCoord[index];
    }

    final void getCoordinateIndices(int index, int[] coordinateIndices) {
        int num = coordinateIndices.length;
        int i = 0;
        int j = index;
        while (i < num) {
            coordinateIndices[i] = this.indexCoord[j];
            ++i;
            ++j;
        }
    }

    final int[] getCoordIndicesRef() {
        return this.indexCoord;
    }

    final int getColorIndex(int index) {
        return this.indexColor[index];
    }

    final void getColorIndices(int index, int[] colorIndices) {
        int num = colorIndices.length;
        int i = 0;
        int j = index;
        while (i < num) {
            colorIndices[i] = this.indexColor[j];
            ++i;
            ++j;
        }
    }

    final int getNormalIndex(int index) {
        return this.indexNormal[index];
    }

    final void getNormalIndices(int index, int[] normalIndices) {
        int num = normalIndices.length;
        int i = 0;
        int j = index;
        while (i < num) {
            normalIndices[i] = this.indexNormal[j];
            ++i;
            ++j;
        }
    }

    final int getTextureCoordinateIndex(int texCoordSet, int index) {
        int[] indices = this.indexTexCoord[texCoordSet];
        return indices[index];
    }

    final void getTextureCoordinateIndices(int texCoordSet, int index, int[] texCoordIndices) {
        int num = texCoordIndices.length;
        int[] indices = this.indexTexCoord[texCoordSet];
        int i = 0;
        int j = index;
        while (i < num) {
            texCoordIndices[i] = indices[j];
            ++i;
            ++j;
        }
    }

    int getVertexAttrIndex(int vertexAttrNum, int index) {
        int[] indices = this.indexVertexAttr[vertexAttrNum];
        return indices[index];
    }

    void getVertexAttrIndices(int vertexAttrNum, int index, int[] vertexAttrIndices) {
        int num = vertexAttrIndices.length;
        int[] indices = this.indexVertexAttr[vertexAttrNum];
        int i = 0;
        int j = index;
        while (i < num) {
            vertexAttrIndices[i] = indices[j];
            ++i;
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, int screen, boolean ignoreVertexColors) {
        if (cv.ctx != this.prevContext) {
            this.ctxExecutedOn.add(cv.ctx);
            this.prevContext = cv.ctx;
        }
        boolean useAlpha = false;
        if (this.mirrorGeometry != null) {
            this.mirrorGeometry.execute(cv, ra, isNonUniformScale, updateAlpha, alpha, screen, ignoreVertexColors);
            return;
        }
        if (this.indexCoord == null) {
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                float[] vdata;
                int cdirty;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    cdirty = this.dirtyFlag;
                    if (updateAlpha && !ignoreVertexColors) {
                        Object[] retVal = this.updateAlphaInVertexData(cv, screen, alpha);
                        useAlpha = retVal[0] == Boolean.TRUE;
                        vdata = (float[])retVal[1];
                        if (alpha != this.lastScreenAlpha) {
                            this.lastScreenAlpha = alpha;
                            cdirty |= 4;
                        }
                    } else {
                        vdata = this.vertexData;
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            cdirty |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().executeIndexedGeometry(cv.ctx, this, this.geoType, isNonUniformScale, useAlpha, ignoreVertexColors, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, cv.numActiveTexUnit, vdata, null, cdirty, this.indexCoord);
            } else if ((this.vertexFormat & 0x100) != 0) {
                int cdirty;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] cdata = null;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    cdirty = this.dirtyFlag;
                    if (updateAlpha && !ignoreVertexColors) {
                        Object[] retVal = this.updateAlphaInInterLeavedData(cv, screen, alpha);
                        useAlpha = retVal[0] == Boolean.TRUE;
                        cdata = (float[])retVal[1];
                        if (alpha != this.lastScreenAlpha) {
                            this.lastScreenAlpha = alpha;
                            cdirty |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        cdirty |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().executeIndexedGeometry(cv.ctx, this, this.geoType, isNonUniformScale, useAlpha, ignoreVertexColors, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, cv.numActiveTexUnit, this.interLeavedVertexData, cdata, cdirty, this.indexCoord);
            } else {
                int cdirty;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] cbdata = null;
                float[] cfdata = null;
                if ((this.vertexType & 0xD0) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        cdirty = this.dirtyFlag;
                        if (updateAlpha && !ignoreVertexColors) {
                            cfdata = this.updateAlphaInFloatRefColors(cv, screen, alpha);
                            if (alpha != this.lastScreenAlpha) {
                                this.lastScreenAlpha = alpha;
                                cdirty |= 4;
                            }
                        } else {
                            cfdata = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                cdirty |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        cdirty = this.dirtyFlag;
                        if (updateAlpha && !ignoreVertexColors) {
                            cbdata = this.updateAlphaInByteRefColors(cv, screen, alpha);
                            if (alpha != this.lastScreenAlpha) {
                                this.lastScreenAlpha = alpha;
                                cdirty |= 4;
                            }
                        } else {
                            cbdata = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                cdirty |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    cdirty = this.dirtyFlag;
                }
                int vdefined = 0;
                if ((this.vertexType & 5) != 0) {
                    vdefined |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    vdefined |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    vdefined |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    vdefined |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    vdefined |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    vdefined |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    vdefined |= 0x20;
                }
                Pipeline.getPipeline().executeIndexedGeometryVA(cv.ctx, this, this.geoType, isNonUniformScale, ignoreVertexColors, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, vdefined, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, cfdata, cbdata, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, cv.numActiveTexUnit, this.texCoordStride, this.mirrorRefTexCoords, cdirty, this.indexCoord);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int cdirty;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] cdata = null;
            IndexedGeometryArrayRetained cfdata = this;
            synchronized (cfdata) {
                cdirty = this.dirtyFlag;
                if (updateAlpha && !ignoreVertexColors) {
                    Object[] retVal = this.updateAlphaInInterLeavedData(cv, screen, alpha);
                    useAlpha = retVal[0] == Boolean.TRUE;
                    cdata = (float[])retVal[1];
                    if (alpha != this.lastScreenAlpha) {
                        this.lastScreenAlpha = alpha;
                        cdirty |= 4;
                    }
                } else if (this.lastScreenAlpha != -1.0f) {
                    this.lastScreenAlpha = -1.0f;
                    cdirty |= 4;
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().executeIndexedGeometryBuffer(cv.ctx, this, this.geoType, isNonUniformScale, useAlpha, ignoreVertexColors, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, cv.numActiveTexUnit, this.interleavedFloatBufferImpl, cdata, cdirty, this.indexCoord);
        } else {
            int cdirty;
            IndexedGeometryArrayRetained vdefined;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] cbdata = null;
            float[] cfdata = null;
            if ((this.vertexType & 0x10) != 0) {
                vdefined = this;
                synchronized (vdefined) {
                    cdirty = this.dirtyFlag;
                    if (updateAlpha && !ignoreVertexColors) {
                        cfdata = this.updateAlphaInFloatRefColors(cv, screen, alpha);
                        if (alpha != this.lastScreenAlpha) {
                            this.lastScreenAlpha = alpha;
                            cdirty |= 4;
                        }
                    } else {
                        cfdata = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            cdirty |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                vdefined = this;
                synchronized (vdefined) {
                    cdirty = this.dirtyFlag;
                    if (updateAlpha && !ignoreVertexColors) {
                        cbdata = this.updateAlphaInByteRefColors(cv, screen, alpha);
                        if (alpha != this.lastScreenAlpha) {
                            this.lastScreenAlpha = alpha;
                            cdirty |= 4;
                        }
                    } else {
                        cbdata = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            cdirty |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                cdirty = this.dirtyFlag;
            }
            Buffer vcoord = null;
            Buffer cdataBuffer = null;
            FloatBuffer normal = null;
            int vdefined2 = 0;
            if ((this.vertexType & 1) != 0) {
                vdefined2 |= 1;
                vcoord = this.floatBufferRefCoords;
            } else if ((this.vertexType & 2) != 0) {
                vdefined2 |= 2;
                vcoord = this.doubleBufferRefCoords;
            }
            if ((this.vertexType & 0x10) != 0) {
                vdefined2 |= 4;
                cdataBuffer = this.floatBufferRefColors;
            } else if ((this.vertexType & 0x20) != 0) {
                vdefined2 |= 8;
                cdataBuffer = this.byteBufferRefColors;
            }
            if ((this.vertexType & 0xC00) != 0) {
                vdefined2 |= 0x10;
                normal = this.floatBufferRefNormals;
            }
            if ((this.vertexType & 0x8000) != 0) {
                vdefined2 |= 0x40;
            }
            if ((this.vertexType & 0x7000) != 0) {
                vdefined2 |= 0x20;
            }
            Pipeline.getPipeline().executeIndexedGeometryVABuffer(cv.ctx, this, this.geoType, isNonUniformScale, ignoreVertexColors, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, vdefined2, vcoord, cdataBuffer, cfdata, cbdata, normal, this.vertexAttrCount, this.vertexAttrSizes, this.floatBufferRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, cv.numActiveTexUnit, this.texCoordStride, this.refTexCoords, cdirty, this.indexCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void buildGA(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, boolean ignoreVertexColors, Transform3D xform, Transform3D nxform) {
        boolean useAlpha = false;
        if (this.mirrorGeometry != null) {
            ((GeometryArrayRetained)this.mirrorGeometry).buildGA(cv, ra, isNonUniformScale, updateAlpha, alpha, ignoreVertexColors, xform, nxform);
        } else if ((this.vertexFormat & 0x80) == 0) {
            float[] vdata;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
            synchronized (indexedGeometryArrayRetained) {
                int cdirty = this.dirtyFlag;
                if (updateAlpha && !ignoreVertexColors) {
                    Object[] retVal = this.updateAlphaInVertexData(cv, cv.screen.screen, alpha);
                    useAlpha = retVal[0] == Boolean.TRUE;
                    vdata = (float[])retVal[1];
                    if (alpha != this.lastScreenAlpha) {
                        this.lastScreenAlpha = alpha;
                        cdirty |= 4;
                    }
                } else {
                    vdata = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        cdirty |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().buildIndexedGeometry(cv.ctx, this, this.geoType, isNonUniformScale, updateAlpha, alpha, ignoreVertexColors, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, xform == null ? null : xform.mat, nxform == null ? null : nxform.mat, vdata, this.indexCoord);
        }
    }

    @Override
    void mergeGeometryArrays(ArrayList list) {
        boolean notUCIO;
        int numMerge = list.size();
        int[] texCoord = null;
        this.indexCount = 0;
        for (int i = 0; i < numMerge; ++i) {
            IndexedGeometryArrayRetained geo = (IndexedGeometryArrayRetained)list.get(i);
            this.indexCount += geo.validIndexCount;
        }
        this.validIndexCount = this.indexCount;
        this.initialIndexIndex = 0;
        this.compileIndexCount = new int[numMerge];
        this.compileIndexOffset = new int[numMerge];
        this.indexCoord = new int[this.indexCount];
        boolean bl = notUCIO = (this.vertexFormat & 0x200) == 0;
        if (notUCIO) {
            if ((this.vertexFormat & 4) != 0) {
                this.indexColor = new int[this.indexCount];
            }
            if ((this.vertexFormat & 2) != 0) {
                this.indexNormal = new int[this.indexCount];
            }
            if ((this.vertexFormat & 0x460) != 0) {
                this.indexTexCoord = new int[1][];
                this.indexTexCoord[0] = new int[this.indexCount];
                texCoord = this.indexTexCoord[0];
            }
        }
        int curDataOffset = 0;
        int curIndexOffset = 0;
        for (int i = 0; i < numMerge; ++i) {
            int curIndexCount;
            IndexedGeometryArrayRetained geo = (IndexedGeometryArrayRetained)list.get(i);
            this.compileIndexCount[i] = curIndexCount = geo.validIndexCount;
            for (int j = 0; j < curIndexCount; ++j) {
                this.indexCoord[j + curIndexOffset] = geo.indexCoord[j + geo.initialIndexIndex] + curDataOffset;
                if (!notUCIO) continue;
                if ((this.vertexFormat & 4) != 0) {
                    this.indexColor[j + curIndexOffset] = geo.indexColor[j + geo.initialIndexIndex] + curDataOffset;
                }
                if ((this.vertexFormat & 2) != 0) {
                    this.indexNormal[j + curIndexOffset] = geo.indexNormal[j + geo.initialIndexIndex] + curDataOffset;
                }
                if ((this.vertexFormat & 0x460) == 0) continue;
                texCoord[j + curIndexOffset] = geo.indexTexCoord[0][j + geo.initialIndexIndex] + curDataOffset;
            }
            this.maxCoordIndex = geo.maxCoordIndex + curDataOffset;
            this.compileIndexOffset[i] = curIndexOffset;
            curDataOffset += geo.vertexCount;
            curIndexOffset += curIndexCount;
        }
        super.mergeGeometryArrays(list);
    }

    @Override
    boolean isWriteStatic() {
        return super.isWriteStatic() && !this.source.getCapability(10) && !this.source.getCapability(12) && !this.source.getCapability(14) && !this.source.getCapability(25) && !this.source.getCapability(16);
    }

    int getIndexCount(int id) {
        return this.compileIndexCount[id];
    }

    int computeMaxIndex(int initial, int count, int[] indices) {
        int maxIndex = 0;
        if (indices != null) {
            for (int i = initial; i < initial + count; ++i) {
                if (indices[i] <= maxIndex) continue;
                maxIndex = indices[i];
            }
        }
        return maxIndex;
    }

    int computeMaxIndexWithCheck(int initial, int count, int[] indices) {
        int maxIndex = 0;
        for (int i = initial; i < initial + count; ++i) {
            if (indices[i] < 0) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
            }
            if (indices[i] <= maxIndex) continue;
            maxIndex = indices[i];
        }
        return maxIndex;
    }

    void setValidIndexCount(int validIndexCount) {
        boolean isLive;
        if (validIndexCount < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray21"));
        }
        if (this.initialIndexIndex + validIndexCount > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        if ((this.vertexFormat & 0x2000) != 0 && this.indexCoord != null && this.indexCoord.length < this.initialIndexIndex + validIndexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
        }
        int newCoordMax = 0;
        int newColorIndex = 0;
        int newNormalIndex = 0;
        int[] newTexCoordIndex = null;
        int[] newVertexAttrIndex = null;
        newCoordMax = this.computeMaxIndex(this.initialIndexIndex, validIndexCount, this.indexCoord);
        this.doErrorCheck(newCoordMax);
        if ((this.vertexFormat & 0x200) == 0) {
            int i;
            if ((this.vertexFormat & 4) != 0) {
                newColorIndex = this.computeMaxIndex(this.initialIndexIndex, validIndexCount, this.indexColor);
                this.doColorCheck(newColorIndex);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                newTexCoordIndex = new int[this.texCoordSetCount];
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    newTexCoordIndex[i] = this.computeMaxIndex(this.initialIndexIndex, validIndexCount, this.indexTexCoord[i]);
                    this.doTexCoordCheck(newTexCoordIndex[i], i);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                newVertexAttrIndex = new int[this.vertexAttrCount];
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    newVertexAttrIndex[i] = this.computeMaxIndex(this.initialIndexIndex, validIndexCount, this.indexVertexAttr[i]);
                    this.doVertexAttrCheck(newVertexAttrIndex[i], i);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                newNormalIndex = this.computeMaxIndex(this.initialIndexIndex, validIndexCount, this.indexNormal);
                this.doNormalCheck(newNormalIndex);
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.validIndexCount = validIndexCount;
        this.maxCoordIndex = newCoordMax;
        if ((this.vertexFormat & 0x200) == 0) {
            int i;
            this.maxColorIndex = newColorIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = newTexCoordIndex[i];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = newVertexAttrIndex[i];
                }
            }
            this.maxNormalIndex = newNormalIndex;
        } else {
            int i;
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = this.maxCoordIndex;
                }
            }
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(true);
        }
    }

    void setInitialIndexIndex(int initialIndexIndex) {
        boolean isLive;
        if (initialIndexIndex + this.validIndexCount > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        if ((this.vertexFormat & 0x2000) != 0 && this.indexCoord != null && this.indexCoord.length < initialIndexIndex + this.validIndexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
        }
        int newCoordMax = 0;
        int newColorIndex = 0;
        int newNormalIndex = 0;
        int[] newTexCoordIndex = null;
        int[] newVertexAttrIndex = null;
        newCoordMax = this.computeMaxIndex(initialIndexIndex, this.validIndexCount, this.indexCoord);
        this.doErrorCheck(newCoordMax);
        if ((this.vertexFormat & 0x200) == 0) {
            int i;
            if ((this.vertexFormat & 4) != 0) {
                newColorIndex = this.computeMaxIndex(initialIndexIndex, this.validIndexCount, this.indexColor);
                this.doColorCheck(newColorIndex);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                newTexCoordIndex = new int[this.texCoordSetCount];
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    newTexCoordIndex[i] = this.computeMaxIndex(initialIndexIndex, this.validIndexCount, this.indexTexCoord[i]);
                    this.doTexCoordCheck(newTexCoordIndex[i], i);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                newVertexAttrIndex = new int[this.vertexAttrCount];
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    newVertexAttrIndex[i] = this.computeMaxIndex(initialIndexIndex, this.validIndexCount, this.indexVertexAttr[i]);
                    this.doVertexAttrCheck(newVertexAttrIndex[i], i);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                newNormalIndex = this.computeMaxIndex(initialIndexIndex, this.validIndexCount, this.indexNormal);
                this.doNormalCheck(newNormalIndex);
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.initialIndexIndex = initialIndexIndex;
        this.maxCoordIndex = newCoordMax;
        if ((this.vertexFormat & 0x200) == 0) {
            int i;
            this.maxColorIndex = newColorIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = newTexCoordIndex[i];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = newVertexAttrIndex[i];
                }
            }
            this.maxNormalIndex = newNormalIndex;
        } else {
            int i;
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = this.maxCoordIndex;
                }
            }
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialIndexIndex() {
        return this.initialIndexIndex;
    }

    int getValidIndexCount() {
        return this.validIndexCount;
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 10 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 4) != 0 && bit == 12 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 2) != 0 && bit == 14 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 0x1000) != 0 && bit == 25 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 0x460) != 0 && bit == 16) {
            this.setFrequencyChangeMask(bit, 1);
        } else {
            super.handleFrequencyChange(bit);
        }
    }
}

